/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.layoutmgr.ChemistryExtensions;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.pdf.PDFTextUtil;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.AbstractIFPainter;
import org.apache.fop.render.intermediate.BorderPainter;
import org.apache.fop.render.intermediate.GraphicsPainter;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFDocumentHandler;
import org.apache.fop.render.pdf.PDFEventProducer;
import org.apache.fop.render.pdf.PDFGraphicsPainter;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.CharUtilities;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.w3c.dom.Document;

public class PDFPainter
extends AbstractIFPainter<PDFDocumentHandler> {
    protected PDFContentGenerator generator;
    private final GraphicsPainter graphicsPainter;
    private final BorderPainter borderPainter;
    private boolean accessEnabled;
    private boolean simulatedBold;
    private PDFLogicalStructureHandler.MarkedContentInfo imageMCI;
    private PDFLogicalStructureHandler logicalStructureHandler;
    private final LanguageAvailabilityChecker languageAvailabilityChecker;
    private static final Log LOG = LogFactory.getLog(PDFPainter.class);
    private static int[] paZero = new int[4];

    public PDFPainter(PDFDocumentHandler pDFDocumentHandler, PDFLogicalStructureHandler pDFLogicalStructureHandler) {
        super((IFDocumentHandler)pDFDocumentHandler);
        this.logicalStructureHandler = pDFLogicalStructureHandler;
        this.generator = pDFDocumentHandler.getGenerator();
        this.graphicsPainter = new PDFGraphicsPainter(this.generator);
        this.borderPainter = new BorderPainter(this.graphicsPainter);
        this.state = IFState.create();
        this.accessEnabled = this.getUserAgent().isAccessibilityEnabled();
        this.languageAvailabilityChecker = this.accessEnabled ? new LanguageAvailabilityChecker(pDFDocumentHandler.getContext()) : null;
    }

    public void startViewport(AffineTransform affineTransform, Dimension dimension, Rectangle rectangle) throws IFException {
        this.generator.saveGraphicsState();
        this.generator.concatenate(PDFPainter.toPoints((AffineTransform)affineTransform));
        if (rectangle != null) {
            this.clipRect(rectangle);
        }
    }

    public void endViewport() throws IFException {
        this.generator.restoreGraphicsState();
    }

    public void startGroup(AffineTransform affineTransform, String string) throws IFException {
        this.generator.saveGraphicsState(string);
        this.generator.concatenate(PDFPainter.toPoints((AffineTransform)affineTransform));
    }

    public void endGroup() throws IFException {
        this.generator.restoreGraphicsState();
    }

    public void drawImage(String string, Rectangle rectangle) throws IFException {
        PDFXObject pDFXObject = ((PDFDocumentHandler)this.getDocumentHandler()).getPDFDocument().getXObject(string);
        this.addStructTreeBBox(rectangle);
        String string2 = (String)this.getContext().getForeignAttribute(ChemistryExtensions.ATT_QNAME_VIDEO_SRC);
        if (pDFXObject != null && string2 == null) {
            if (this.accessEnabled) {
                PDFStructElem pDFStructElem = (PDFStructElem)this.getContext().getStructureTreeElement();
                this.prepareImageMCID(pDFStructElem);
                this.placeImageAccess(rectangle, pDFXObject);
            } else {
                this.placeImage(rectangle, pDFXObject);
            }
        } else {
            this.drawImageUsingURI(string, rectangle);
            if (!((PDFDocumentHandler)this.getDocumentHandler()).getPDFDocument().isLinearizationEnabled()) {
                this.flushPDFDoc();
            }
        }
    }

    private void addStructTreeBBox(Rectangle rectangle) {
        PDFStructElem pDFStructElem;
        if (this.accessEnabled && ((PDFDocumentHandler)this.getDocumentHandler()).getPDFDocument().getProfile().getPDFUAMode().isEnabled() && (pDFStructElem = (PDFStructElem)this.getContext().getStructureTreeElement()) != null) {
            PDFDictionary pDFDictionary = new PDFDictionary();
            int n2 = rectangle.x / 1000;
            int n3 = rectangle.y / 1000;
            int n4 = rectangle.width / 1000;
            int n5 = rectangle.height / 1000;
            pDFDictionary.put("BBox", (Object)new PDFArray(new Object[]{n2, n3, n4, n5}));
            pDFDictionary.put("O", (Object)new PDFName("Layout"));
            pDFStructElem.put("A", pDFDictionary);
        }
    }

    protected void drawImageUsingURI(String string, Rectangle rectangle) {
        ImageManager imageManager = this.getUserAgent().getImageManager();
        ImageInfo imageInfo = null;
        try {
            String string2;
            Object object;
            ImageSessionContext imageSessionContext = this.getUserAgent().getImageSessionContext();
            imageInfo = imageManager.getImageInfo(string, imageSessionContext);
            if (this.accessEnabled) {
                object = (PDFStructElem)this.getContext().getStructureTreeElement();
                string2 = imageInfo.getMimeType();
                if (!string2.equalsIgnoreCase("application/pdf")) {
                    this.prepareImageMCID((PDFStructElem)object);
                }
            }
            this.drawImageUsingImageHandler(imageInfo, rectangle);
            object = (String)this.getContext().getForeignAttribute(ChemistryExtensions.ATT_QNAME_VIDEO_SRC);
            if (object != null) {
                string2 = null;
                try {
                    string2 = imageManager.getImageInfo((String)object, imageSessionContext);
                    this.drawImageUsingImageHandler((ImageInfo)string2, rectangle);
                }
                catch (ImageException imageException) {
                    LOG.error((Object)MessageFormat.format("Video not available. URI: {0}. Reason: {1}", new Object[]{object, imageException}), (Throwable)imageException);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    LOG.error((Object)MessageFormat.format("Video not found. URI: {0}.", object), (Throwable)fileNotFoundException);
                }
                catch (IOException iOException) {
                    LOG.error((Object)MessageFormat.format("I/O error while loading video. URI: {0}. Reason: {1}}", object, iOException), (Throwable)iOException);
                }
            }
        }
        catch (ImageException imageException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageError((Object)this, imageInfo != null ? imageInfo.toString() : string, imageException, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageNotFound((Object)this, imageInfo != null ? imageInfo.toString() : string, fileNotFoundException, null);
        }
        catch (IOException iOException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            resourceEventProducer.imageIOError((Object)this, imageInfo != null ? imageInfo.toString() : string, iOException, null);
        }
    }

    private void prepareImageMCID(PDFStructElem pDFStructElem) {
        this.imageMCI = this.logicalStructureHandler.addImageContentItem(pDFStructElem);
        if (pDFStructElem != null) {
            this.languageAvailabilityChecker.checkLanguageAvailability((String)pDFStructElem.get("Alt"));
        }
    }

    protected RenderingContext createRenderingContext() {
        PDFRenderingContext pDFRenderingContext = new PDFRenderingContext(this.getUserAgent(), this.generator, ((PDFDocumentHandler)this.getDocumentHandler()).getCurrentPage(), this.getFontInfo());
        pDFRenderingContext.setMarkedContentInfo(this.imageMCI);
        pDFRenderingContext.setUsedFieldNames(((PDFDocumentHandler)this.getDocumentHandler()).getUsedFieldNames());
        pDFRenderingContext.setPageNumbers(((PDFDocumentHandler)this.getDocumentHandler()).getPageNumbers());
        pDFRenderingContext.setPdfLogicalStructureHandler(this.logicalStructureHandler);
        pDFRenderingContext.setCurrentSessionStructElem((PDFStructElem)this.getContext().getStructureTreeElement());
        return pDFRenderingContext;
    }

    private void placeImage(Rectangle rectangle, PDFXObject pDFXObject) {
        this.generator.saveGraphicsState();
        this.generator.add(PDFPainter.format(rectangle.width) + " 0 0 " + PDFPainter.format(-rectangle.height) + " " + PDFPainter.format(rectangle.x) + " " + PDFPainter.format(rectangle.y + rectangle.height) + " cm " + pDFXObject.getName() + " Do\n");
        this.generator.restoreGraphicsState();
    }

    private void placeImageAccess(Rectangle rectangle, PDFXObject pDFXObject) {
        this.generator.saveGraphicsState(this.imageMCI.tag, this.imageMCI.mcid);
        this.generator.add(PDFPainter.format(rectangle.width) + " 0 0 " + PDFPainter.format(-rectangle.height) + " " + PDFPainter.format(rectangle.x) + " " + PDFPainter.format(rectangle.y + rectangle.height) + " cm " + pDFXObject.getName() + " Do\n");
        this.generator.restoreGraphicsStateAccess();
    }

    public void drawImage(Document document, Rectangle rectangle) throws IFException {
        if (this.accessEnabled) {
            PDFStructElem pDFStructElem = (PDFStructElem)this.getContext().getStructureTreeElement();
            this.prepareImageMCID(pDFStructElem);
            this.addStructTreeBBox(rectangle);
        }
        this.drawImageUsingDocument(document, rectangle);
        if (!((PDFDocumentHandler)this.getDocumentHandler()).getPDFDocument().isLinearizationEnabled()) {
            this.flushPDFDoc();
        }
    }

    private void flushPDFDoc() throws IFException {
        try {
            this.generator.flushPDFDoc();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error flushing the PDF document", (Exception)iOException);
        }
    }

    protected static String format(int n2) {
        return PDFNumber.doubleOut((double)((float)n2 / 1000.0f));
    }

    public void clipRect(Rectangle rectangle) throws IFException {
        this.generator.endTextObject();
        this.generator.clipRect(rectangle);
    }

    public void clipBackground(Rectangle rectangle, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) throws IFException {
        try {
            this.borderPainter.clipBackground(rectangle, borderProps, borderProps2, borderProps3, borderProps4);
        }
        catch (IOException iOException) {
            throw new IFException("I/O error while clipping background", (Exception)iOException);
        }
    }

    public void fillRect(Rectangle rectangle, Paint paint) throws IFException {
        if (paint == null) {
            return;
        }
        if (rectangle.width != 0 && rectangle.height != 0) {
            this.generator.endTextObject();
            if (this.accessEnabled && this.getUserAgent().isPdfUAEnabled()) {
                this.generator.beginMarkedContentSequence(null, 0, null);
            }
            if (paint != null) {
                if (paint instanceof Color) {
                    this.generator.updateColor((Color)paint, true, null);
                } else {
                    throw new UnsupportedOperationException("Non-Color paints NYI");
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(PDFPainter.format(rectangle.x)).append(' ');
            stringBuffer.append(PDFPainter.format(rectangle.y)).append(' ');
            stringBuffer.append(PDFPainter.format(rectangle.width)).append(' ');
            stringBuffer.append(PDFPainter.format(rectangle.height)).append(" re");
            if (paint != null) {
                stringBuffer.append(" f");
            }
            stringBuffer.append('\n');
            this.generator.add(stringBuffer.toString());
            if (this.accessEnabled && this.getUserAgent().isPdfUAEnabled()) {
                this.generator.endMarkedContentSequence();
            }
        }
    }

    public void drawBorderRect(Rectangle rectangle, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4, Color color) throws IFException {
        if (borderProps != null || borderProps2 != null || borderProps3 != null || borderProps4 != null) {
            this.generator.endTextObject();
            if (this.accessEnabled && this.getUserAgent().isPdfUAEnabled()) {
                this.generator.beginMarkedContentSequence(null, 0, null);
            }
            this.borderPainter.drawBorders(rectangle, borderProps, borderProps2, borderProps3, borderProps4, color);
            if (this.accessEnabled && this.getUserAgent().isPdfUAEnabled()) {
                this.generator.endMarkedContentSequence();
            }
        }
    }

    public void drawLine(Point point, Point point2, int n2, Color color, RuleStyle ruleStyle) throws IFException {
        this.generator.endTextObject();
        if (this.accessEnabled && this.getUserAgent().isPdfUAEnabled()) {
            this.generator.beginMarkedContentSequence(null, 0, null);
        }
        try {
            this.graphicsPainter.drawLine(point, point2, n2, color, ruleStyle);
        }
        catch (IOException iOException) {
            throw new IFException("Cannot draw line", (Exception)iOException);
        }
        if (this.accessEnabled && this.getUserAgent().isPdfUAEnabled()) {
            this.generator.endMarkedContentSequence();
        }
    }

    private Typeface getTypeface(String string) {
        if (string == null) {
            throw new NullPointerException("fontName must not be null");
        }
        Typeface typeface = this.getFontInfo().getFonts().get(string);
        if (typeface instanceof LazyFont) {
            typeface = ((LazyFont)typeface).getRealFont();
        }
        return typeface;
    }

    public void drawText(int n2, int n3, int n4, int n5, int[][] nArray, String string) throws IFException {
        boolean bl;
        Typeface typeface;
        Object object;
        PDFStructElem pDFStructElem;
        if (this.accessEnabled) {
            pDFStructElem = (PDFStructElem)this.getContext().getStructureTreeElement();
            this.languageAvailabilityChecker.checkLanguageAvailability(string);
            object = this.logicalStructureHandler.addTextContentItem(pDFStructElem);
            typeface = null;
            this.generator.endTextObject();
            this.generator.updateColor(this.state.getTextColor(), true, null);
            this.generator.beginTextObject(object.tag, object.mcid, (String)typeface);
        } else {
            this.generator.updateColor(this.state.getTextColor(), true, null);
            this.generator.beginTextObject();
        }
        pDFStructElem = new FontTriplet(this.state.getFontFamily(), this.state.getFontStyle(), this.state.getFontWeight());
        object = this.getFontInfo().getInternalFontKey((FontTriplet)pDFStructElem);
        typeface = this.getTypeface((String)object);
        if (typeface instanceof MultiByteFont && ((MultiByteFont)typeface).hasSVG() && (bl = this.drawSVGText((MultiByteFont)typeface, (FontTriplet)pDFStructElem, n2, n3, string, this.state))) {
            return;
        }
        if (nArray == null || IFUtil.isDPOnlyDX((int[][])nArray)) {
            this.drawTextWithDX(n2, n3, string, (FontTriplet)pDFStructElem, n4, n5, IFUtil.convertDPToDX((int[][])nArray));
        } else {
            this.drawTextWithDP(n2, n3, string, (FontTriplet)pDFStructElem, n4, n5, nArray);
        }
    }

    public void drawText(int n2, int n3, int n4, int n5, int[][] nArray, String object, boolean bl) throws IFException {
        if (this.accessEnabled && bl) {
            object = (String)object + " ";
        }
        this.drawText(n2, n3, n4, n5, nArray, (String)object);
    }

    private void drawTextWithDX(int n2, int n3, String string, FontTriplet fontTriplet, int n4, int n5, int[] nArray) throws IFException {
        int n6;
        String string2 = this.getFontKey(fontTriplet);
        int n7 = this.state.getFontSize();
        float f2 = (float)n7 / 1000.0f;
        Typeface typeface = this.getTypeface(string2);
        Font font = this.getFontInfo().getFontInstance(fontTriplet, n7);
        String string3 = font.getFontName();
        PDFTextUtil pDFTextUtil = this.generator.getTextUtil();
        pDFTextUtil.updateTf(string2, (double)f2, typeface.isMultiByte(), typeface.isCID());
        double d2 = this.startSimulateStyle(typeface, fontTriplet);
        this.generator.updateCharacterSpacing((float)n4 / 1000.0f);
        pDFTextUtil.writeTextMatrix(new AffineTransform(1.0, 0.0, d2, -1.0, (double)((float)n2 / 1000.0f), (double)((float)n3 / 1000.0f)));
        int n8 = string.length();
        int n9 = n6 = nArray != null ? nArray.length : 0;
        if (nArray != null && n6 > 0 && nArray[0] != 0) {
            pDFTextUtil.adjustGlyphTJ((double)((float)(-nArray[0]) / f2));
        }
        for (int i2 = 0; i2 < n8; ++i2) {
            int n10;
            int n11 = string.charAt(i2);
            if (CharUtilities.containsSurrogatePairAt((CharSequence)string, (int)i2)) {
                n11 = Character.toCodePoint((char)n11, string.charAt(++i2));
            }
            float f3 = 0.0f;
            if (font.hasCodePoint(n11)) {
                n10 = font.mapCodePoint(n11);
                if (n11 == 173 && n10 == 45) {
                    n10 = n11;
                }
                n10 = this.selectAndMapSingleByteFont(typeface, string3, f2, pDFTextUtil, n10);
                if (n5 != 0 && CharUtilities.isAdjustableSpace((int)n11)) {
                    f3 += (float)n5;
                }
            } else {
                if (CharUtilities.isFixedWidthSpace((int)n11)) {
                    n10 = font.mapChar(' ');
                    int n12 = font.getCharWidth(' ') - font.getCharWidth(n11);
                    f3 = -n12;
                } else {
                    n10 = font.mapCodePoint(n11);
                    if (n5 != 0 && CharUtilities.isAdjustableSpace((int)n11)) {
                        f3 += (float)n5;
                    }
                }
                n10 = this.selectAndMapSingleByteFont(typeface, string3, f2, pDFTextUtil, n10);
            }
            pDFTextUtil.writeTJMappedCodePoint(n10);
            if (nArray != null && i2 < n6 - 1) {
                f3 += (float)nArray[i2 + 1];
            }
            if (f3 == 0.0f) continue;
            pDFTextUtil.adjustGlyphTJ((double)(-f3 / f2));
        }
        pDFTextUtil.writeTJ();
        this.generator.resetCharacterSpacing();
        if (this.simulatedBold) {
            this.endSimulateStyle(typeface, fontTriplet);
        }
    }

    private double startSimulateStyle(Typeface typeface, FontTriplet fontTriplet) {
        boolean bl;
        double d2 = 0.0;
        boolean bl2 = bl = typeface instanceof CustomFont && ((CustomFont)typeface).getSimulateStyle();
        if (bl) {
            if (fontTriplet.getWeight() == 700) {
                this.generator.add("2 Tr 0.31543 w\n");
                this.simulatedBold = true;
            }
            if (fontTriplet.getStyle().equals("italic")) {
                d2 = 0.3333;
            }
        }
        return d2;
    }

    private void endSimulateStyle(Typeface typeface, FontTriplet fontTriplet) {
        boolean bl;
        boolean bl2 = bl = typeface instanceof CustomFont && ((CustomFont)typeface).getSimulateStyle();
        if (bl && fontTriplet.getWeight() == 700) {
            this.generator.add("0 Tr\n");
        }
    }

    private void drawTextWithDP(int n2, int n3, String string, FontTriplet fontTriplet, int n4, int n5, int[][] nArray) {
        assert (string != null);
        assert (fontTriplet != null);
        assert (nArray != null);
        String string2 = this.getFontInfo().getInternalFontKey(fontTriplet);
        Typeface typeface = this.getTypeface(string2);
        if (typeface.isMultiByte() || typeface.isCID()) {
            int n6 = this.state.getFontSize();
            float f2 = (float)n6 / 1000.0f;
            Font font = this.getFontInfo().getFontInstance(fontTriplet, n6);
            PDFTextUtil pDFTextUtil = this.generator.getTextUtil();
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = n5;
            double d7 = this.startSimulateStyle(typeface, fontTriplet);
            pDFTextUtil.writeTextMatrix(new AffineTransform(1.0, 0.0, d7, -1.0, (double)((float)n2 / 1000.0f), (double)((float)n3 / 1000.0f)));
            pDFTextUtil.updateTf(string2, (double)f2, typeface.isMultiByte(), true);
            this.generator.updateCharacterSpacing((float)n4 / 1000.0f);
            int n7 = string.length();
            for (int i2 = 0; i2 < n7; ++i2) {
                int n8;
                int n9 = string.charAt(i2);
                if (CharUtilities.containsSurrogatePairAt((CharSequence)string, (int)i2)) {
                    n9 = Character.toCodePoint((char)n9, string.charAt(++i2));
                    n8 = font.mapCodePoint(n9);
                } else {
                    n8 = font.mapChar((char)n9);
                }
                int[] nArray2 = i2 >= nArray.length || nArray[i2] == null ? paZero : nArray[i2];
                double d8 = d2 + (double)nArray2[0];
                double d9 = d3 + (double)nArray2[1];
                double d10 = (double)font.getCharWidth(n9) + this.maybeWordOffsetX(d6, n9, null);
                double d11 = 0.0;
                double d12 = (d8 - d4) / 1000.0;
                double d13 = (d9 - d5) / 1000.0;
                pDFTextUtil.writeTd(d12, d13);
                pDFTextUtil.writeTj(n8, typeface.isMultiByte(), true);
                d2 += d10 + (double)nArray2[2];
                d3 += d11 + (double)nArray2[3];
                d4 = d8;
                d5 = d9;
            }
            this.generator.resetCharacterSpacing();
            if (this.simulatedBold) {
                this.endSimulateStyle(typeface, fontTriplet);
            }
        }
    }

    private double maybeWordOffsetX(double d2, int n2, Direction direction) {
        if (d2 != 0.0 && CharUtilities.isAdjustableSpace((int)n2) && (direction == null || direction.isHorizontal())) {
            return d2;
        }
        return 0.0;
    }

    private int selectAndMapSingleByteFont(Typeface typeface, String string, float f2, PDFTextUtil pDFTextUtil, int n2) {
        if (typeface instanceof SingleByteFont && ((SingleByteFont)typeface).hasAdditionalEncodings() || typeface.isCID()) {
            int n3 = n2 / 256;
            if (n3 == 0) {
                pDFTextUtil.updateTf(string, (double)f2, typeface.isMultiByte(), typeface.isCID());
            } else {
                pDFTextUtil.updateTf(string + "_" + Integer.toString(n3), (double)f2, typeface.isMultiByte(), typeface.isCID());
                n2 = (char)(n2 % 256);
            }
        }
        return n2;
    }

    private static class LanguageAvailabilityChecker {
        private final IFContext context;
        private final Set<String> reportedLocations = new HashSet<String>();

        LanguageAvailabilityChecker(IFContext iFContext) {
            this.context = iFContext;
        }

        private void checkLanguageAvailability(String string) {
            String string2;
            Locale locale = this.context.getLanguage();
            if (locale == null && this.containsLettersOrDigits(string) && !this.reportedLocations.contains(string2 = this.context.getLocation())) {
                PDFEventProducer.Provider.get((EventBroadcaster)this.context.getUserAgent().getEventBroadcaster()).unknownLanguage((Object)this, string2);
                this.reportedLocations.add(string2);
            }
        }

        private boolean containsLettersOrDigits(String string) {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (!Character.isLetterOrDigit(string.charAt(i2))) continue;
                return true;
            }
            return false;
        }
    }
}

