/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.image.loader.batik.BatikImageFlavors;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.pdf.TransparencyDisallowedException;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pdf.CTMHelper;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.fop.render.ps.PSImageHandlerSVG;
import org.apache.fop.svg.PDFAElementBridge;
import org.apache.fop.svg.PDFBridgeContext;
import org.apache.fop.svg.PDFGraphics2D;
import org.apache.fop.svg.SVGEventProducer;
import org.apache.fop.svg.SVGUserAgent;
import org.apache.fop.svg.font.FOPFontFamilyResolverImpl;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageXMLDOM;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class PDFImageHandlerSVG
implements ImageHandler {
    private static Log log = LogFactory.getLog(PDFImageHandlerSVG.class);

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        Object object;
        GraphicsNode graphicsNode;
        PDFRenderingContext pDFRenderingContext = (PDFRenderingContext)renderingContext;
        PDFContentGenerator pDFContentGenerator = pDFRenderingContext.getGenerator();
        ImageXMLDOM imageXMLDOM = (ImageXMLDOM)image;
        FOUserAgent fOUserAgent = renderingContext.getUserAgent();
        float f2 = fOUserAgent.getTargetResolution();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating SVG at " + f2 + "dpi."));
        }
        float f3 = fOUserAgent.getSourceResolution();
        SVGUserAgent sVGUserAgent = new SVGUserAgent(fOUserAgent, new FOPFontFamilyResolverImpl(pDFRenderingContext.getFontInfo()), new AffineTransform(), imageXMLDOM.getInfo().getOriginalURI() == null);
        GVTBuilder gVTBuilder = new GVTBuilder();
        boolean bl = PSImageHandlerSVG.shouldStrokeText((NodeList)imageXMLDOM.getDocument().getChildNodes());
        PDFBridgeContext pDFBridgeContext = new PDFBridgeContext(sVGUserAgent, bl ? null : pDFRenderingContext.getFontInfo(), fOUserAgent.getImageManager(), fOUserAgent.getImageSessionContext(), new AffineTransform());
        Document document = BatikUtil.cloneSVGDocument((Document)imageXMLDOM.getDocument());
        try {
            graphicsNode = gVTBuilder.build((BridgeContext)pDFBridgeContext, document);
        }
        catch (Exception exception) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get((EventBroadcaster)renderingContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.svgNotBuilt((Object)this, exception, image.getInfo().getOriginalURI());
            return;
        }
        float f4 = image.getSize().getWidthMpt();
        float f5 = image.getSize().getHeightMpt();
        float f6 = (float)rectangle.width / f4;
        float f7 = (float)rectangle.height / f5;
        AffineTransform affineTransform = new AffineTransform(f6, 0.0f, 0.0f, f7, (float)rectangle.x / 1000.0f, (float)rectangle.y / 1000.0f);
        double d2 = 72.0f / f3;
        affineTransform.scale(d2, d2);
        AffineTransform affineTransform2 = new AffineTransform();
        double d3 = f3 / f2;
        affineTransform2.scale(d3, d3);
        affineTransform2.scale(1.0 / (double)f6, 1.0 / (double)f7);
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.concatenate(affineTransform);
        affineTransform3.concatenate(affineTransform2);
        if (log.isTraceEnabled()) {
            log.trace((Object)("nat size: " + f4 + "/" + f5));
            log.trace((Object)("req size: " + rectangle.width + "/" + rectangle.height));
            log.trace((Object)("source res: " + f3 + ", targetRes: " + f2 + " --> target scaling: " + d3));
            log.trace((Object)image.getSize());
            log.trace((Object)("sx: " + f6 + ", sy: " + f7));
            log.trace((Object)("scaling: " + affineTransform));
            log.trace((Object)("resolution scaling: " + affineTransform2));
            log.trace((Object)("image transform: " + affineTransform2));
        }
        if (log.isTraceEnabled()) {
            pDFContentGenerator.comment("SVG setup");
        }
        pDFContentGenerator.saveGraphicsState();
        if (renderingContext.getUserAgent().isAccessibilityEnabled()) {
            object = pDFRenderingContext.getMarkedContentInfo();
            pDFContentGenerator.beginMarkedContentSequence(((PDFLogicalStructureHandler.MarkedContentInfo)object).tag, ((PDFLogicalStructureHandler.MarkedContentInfo)object).mcid);
        }
        pDFContentGenerator.updateColor(Color.black, false, null);
        pDFContentGenerator.updateColor(Color.black, true, null);
        if (!affineTransform.isIdentity()) {
            if (log.isTraceEnabled()) {
                pDFContentGenerator.comment("viewbox");
            }
            pDFContentGenerator.add(CTMHelper.toPDFString((AffineTransform)affineTransform, (boolean)false) + " cm\n");
        }
        object = new PDFGraphics2D(true, pDFRenderingContext.getFontInfo(), pDFContentGenerator.getDocument(), pDFContentGenerator.getResourceContext(), pDFRenderingContext.getPage().makeReference(), "", 0.0f, new TransparencyIgnoredEventListener((RenderingContext)pDFRenderingContext, (Image)imageXMLDOM));
        ((PDFGraphics2D)((Object)object)).setGraphicContext(new GraphicContext());
        if (!affineTransform2.isIdentity()) {
            if (log.isTraceEnabled()) {
                pDFContentGenerator.comment("resolution scaling for " + f3 + " -> " + f2);
            }
            pDFContentGenerator.add(CTMHelper.toPDFString((AffineTransform)affineTransform2, (boolean)false) + " cm\n");
            object.scale(1.0 / affineTransform2.getScaleX(), 1.0 / affineTransform2.getScaleY());
        }
        if (log.isTraceEnabled()) {
            pDFContentGenerator.comment("SVG start");
        }
        pDFContentGenerator.getState().save();
        pDFContentGenerator.getState().concatenate(affineTransform3);
        PDFAElementBridge pDFAElementBridge = (PDFAElementBridge)pDFBridgeContext.getBridge("http://www.w3.org/2000/svg", "a");
        pDFAElementBridge.getCurrentTransform().setTransform(pDFContentGenerator.getState().getTransform());
        ((PDFGraphics2D)((Object)object)).setPaintingState(pDFContentGenerator.getState());
        ((PDFGraphics2D)((Object)object)).setOutputStream(pDFContentGenerator.getOutputStream());
        try {
            graphicsNode.paint((Graphics2D)object);
            pDFBridgeContext.dispose();
            pDFContentGenerator.add(((PDFGraphics2D)((Object)object)).getString());
        }
        catch (TransparencyDisallowedException transparencyDisallowedException) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get((EventBroadcaster)renderingContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.bitmapWithTransparency((Object)this, transparencyDisallowedException.getProfile(), image.getInfo().getOriginalURI());
        }
        catch (Exception exception) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get((EventBroadcaster)renderingContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.svgRenderingError((Object)this, exception, image.getInfo().getOriginalURI());
        }
        pDFContentGenerator.getState().restore();
        if (renderingContext.getUserAgent().isAccessibilityEnabled()) {
            pDFContentGenerator.restoreGraphicsStateAccess();
        } else {
            pDFContentGenerator.restoreGraphicsState();
        }
        if (log.isTraceEnabled()) {
            pDFContentGenerator.comment("SVG end");
        }
    }

    public int getPriority() {
        return 400;
    }

    public Class getSupportedImageClass() {
        return ImageXMLDOM.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return new ImageFlavor[]{BatikImageFlavors.SVG_DOM};
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        String string;
        boolean bl;
        boolean bl2 = bl = (image == null || image instanceof ImageXMLDOM && image.getFlavor().isCompatible((ImageFlavor)BatikImageFlavors.SVG_DOM)) && renderingContext instanceof PDFRenderingContext;
        if (bl && ImageHandlerUtil.isConversionModeBitmap((String)(string = (String)renderingContext.getHint((Object)ImageHandlerUtil.CONVERSION_MODE)))) {
            return false;
        }
        return bl;
    }

    private static class TransparencyIgnoredEventListener
    implements PDFGraphics2D.TransparencyIgnoredEventListener {
        private final RenderingContext context;
        private final Image image;
        private boolean warningIssued;

        public TransparencyIgnoredEventListener(RenderingContext renderingContext, Image image) {
            this.context = renderingContext;
            this.image = image;
        }

        @Override
        public void transparencyIgnored(Object object) {
            if (!this.warningIssued) {
                EventBroadcaster eventBroadcaster = this.context.getUserAgent().getEventBroadcaster();
                SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get((EventBroadcaster)eventBroadcaster);
                sVGEventProducer.transparencyIgnored((Object)this, object, this.image.getInfo().getOriginalURI());
                this.warningIssued = true;
            }
        }
    }
}

