/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.loader.batik.PreloaderSVG;
import org.apache.fop.layoutmgr.ChemistryExtensions;
import org.apache.fop.render.intermediate.IFException;
import org.apache.xmlgraphics.util.QName;
import org.w3c.dom.svg.SVGDocument;

public class ImageMapIFRenderer {
    protected static final Log log = LogFactory.getLog(ImageMapIFRenderer.class);
    private static ThreadLocal<Boolean> showImageMapsAreaNo = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static ThreadLocal<Boolean> showImageMapsAreaShapes = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private Painter painter;

    public ImageMapIFRenderer(Painter painter) {
        this.painter = painter;
    }

    protected void drawImageMap(Rectangle2D rectangle2D, Map<QName, String> map) {
        String string;
        if (map != null && (string = map.get(ChemistryExtensions.ATT_QNAME_MAP_AREAS_COUNT)) != null) {
            try {
                int n2 = Integer.parseInt(string);
                for (int i2 = 1; i2 < n2 + 1; ++i2) {
                    String string2 = map.get(this.getQName("map-area-shape-" + i2));
                    String string3 = map.get(this.getQName("map-area-coords-" + i2));
                    String string4 = map.get(this.getQName("map-area-href-" + i2));
                    String string5 = map.get(this.getQName("map-area-alt-" + i2));
                    this.drawImageMapArea(i2, string4, rectangle2D, string2, string3, string5);
                }
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException runtimeException) {
                log.error((Object)("Cannot handle image map data " + map + " exception was: " + runtimeException), (Throwable)runtimeException);
            }
        }
    }

    private QName getQName(String string) {
        return new QName("http://www.oxygenxml.com/chemistry/extensions/fop", "chfox", string);
    }

    private void drawImageMapArea(int n2, String string, Rectangle2D rectangle2D, String string2, String string3, String string4) {
        if ("circle".equals(string2)) {
            this.drawImageMapAreaCircle(n2, string, rectangle2D, string3, string4);
        } else if ("poly".equals(string2)) {
            this.drawImageMapAreaPolygon(n2, string, rectangle2D, string3, string4);
        } else if ("default".equals(string2)) {
            this.drawImageMapAreaDefault(n2, string, rectangle2D, string4);
        } else {
            this.drawImageMapAreaRectangle(n2, string, rectangle2D, string3, string4);
        }
    }

    private void drawImageMapAreaCircle(int n2, String string, Rectangle2D rectangle2D, String string2, String string3) {
        String[] stringArray = this.getArray(string2);
        if (stringArray.length >= 3) {
            String string4 = stringArray[0];
            String string5 = stringArray[1];
            String string6 = stringArray[2];
            String string7 = "<svg height='" + rectangle2D.getHeight() / 1000.0 + "pt' width='" + rectangle2D.getWidth() / 1000.0 + "pt' " + this.getRootClassAttribute() + " xmlns='http://www.w3.org/2000/svg'>\n  <a xlink:href='" + string + "'  xmlns:xlink='http://www.w3.org/1999/xlink'>\n" + this.getImageMapNumber(n2, string4, string5) + "  </a>\n  <a xlink:href='" + string + "'  xmlns:xlink='http://www.w3.org/1999/xlink'>\n     <circle class='image-map-shape' \n           cx='" + string4 + "' \n           cy='" + string5 + "' \n            r='" + string6 + "'>\n" + this.getTitleAndDesc(string3) + "     </circle>  </a>\n</svg>\n";
            this.drawImageMapAreaSVGShape(rectangle2D, string7);
        } else {
            log.warn((Object)("Cannot draw shape with coordinates " + string2 + " not enough data for a circle"));
        }
    }

    private String getTitleAndDesc(String string) {
        return string != null ? "<title>" + string + "</title>" : "";
    }

    private String getRootClassAttribute() {
        StringBuilder stringBuilder = new StringBuilder();
        if (showImageMapsAreaNo.get().booleanValue() || showImageMapsAreaShapes.get().booleanValue()) {
            stringBuilder.append("class='");
            if (showImageMapsAreaNo.get().booleanValue()) {
                stringBuilder.append(" show-image-map-numbers ");
            }
            if (showImageMapsAreaShapes.get().booleanValue()) {
                stringBuilder.append(" show-image-map-shapes ");
            }
            stringBuilder.append("'");
        }
        return stringBuilder.toString();
    }

    private void drawImageMapAreaPolygon(int n2, String string, Rectangle2D rectangle2D, String string2, String string3) {
        String[] stringArray = this.getArray(string2);
        if (stringArray.length > 2) {
            String string4 = stringArray[0];
            String string5 = stringArray[1];
            String string6 = "<svg height='" + rectangle2D.getHeight() / 1000.0 + "pt' width='" + rectangle2D.getWidth() / 1000.0 + "pt' " + this.getRootClassAttribute() + " xmlns='http://www.w3.org/2000/svg'>\n  <a xlink:href='" + string + "'  xmlns:xlink='http://www.w3.org/1999/xlink'>\n" + this.getImageMapNumber(n2, string4, string5) + "  </a>\n  <a xlink:href='" + string + "'  xmlns:xlink='http://www.w3.org/1999/xlink'>\n    <polygon class='image-map-shape' points='" + string2 + "'>\n" + this.getTitleAndDesc(string3) + "    </polygon>  </a>\n</svg>\n";
            this.drawImageMapAreaSVGShape(rectangle2D, string6);
        } else {
            log.warn((Object)("Cannot draw shape with coordinates " + string2 + " not enough data for a polygon"));
        }
    }

    private void drawImageMapAreaRectangle(int n2, String string, Rectangle2D rectangle2D, String string2, String string3) {
        String[] stringArray = this.getArray(string2);
        if (stringArray.length >= 4) {
            String string4 = stringArray[0];
            String string5 = stringArray[1];
            String string6 = stringArray[2];
            String string7 = stringArray[3];
            String string8 = string4 + ", " + string5 + ", " + string6 + ", " + string5 + ", " + string6 + ", " + string7 + ", " + string4 + ", " + string7;
            this.drawImageMapAreaPolygon(n2, string, rectangle2D, string8, string3);
        } else {
            log.warn((Object)("Cannot draw shape with coordinates " + string2 + " not enough data for a rectangle"));
        }
    }

    private void drawImageMapAreaDefault(int n2, String string, Rectangle2D rectangle2D, String string2) {
        String string3 = "<svg height='" + rectangle2D.getHeight() / 1000.0 + "pt' width='" + rectangle2D.getWidth() / 1000.0 + "pt' " + this.getRootClassAttribute() + " xmlns='http://www.w3.org/2000/svg'>\n  <a xlink:href='" + string + "'  xmlns:xlink='http://www.w3.org/1999/xlink'>\n" + this.getImageMapNumber(n2, "50%", "50%") + "  </a>\n  <a xlink:href='" + string + "'  xmlns:xlink='http://www.w3.org/1999/xlink'>\n    <rect class='image-map-shape' x='0' y='0' width='100%' height='100%'>\n" + this.getTitleAndDesc(string2) + "    </rect>  </a>\n</svg>\n";
        this.drawImageMapAreaSVGShape(rectangle2D, string3);
    }

    private void drawImageMapAreaSVGShape(Rectangle2D rectangle2D, String string) {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)string);
            }
            SAXSVGDocumentFactory sAXSVGDocumentFactory = new SAXSVGDocumentFactory(PreloaderSVG.getParserName());
            SVGDocument sVGDocument = sAXSVGDocumentFactory.createSVGDocument("area.svg", (InputStream)new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
            this.painter.drawImage(sVGDocument, rectangle2D.getBounds());
        }
        catch (IOException | IFException throwable) {
            log.error((Object)throwable, throwable);
        }
    }

    private String getImageMapNumber(int n2, String string, String string2) {
        int n3 = 10;
        return "    <circle class='image-map-number' r='" + n3 + "' cx='" + string + "' cy='" + string2 + "' />\n    <g transform='translate(0, " + n3 / 3 + ")'>\n       <text text-anchor='middle' font-size='" + n3 + "' class='image-map-number-text' x='" + string + "' y='" + string2 + "'>" + n2 + "</text>\n    </g>\n";
    }

    private String[] getArray(String string) {
        String[] stringArray = string.split(",");
        String[] stringArray2 = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray2[i2] = stringArray[i2].trim();
        }
        return stringArray2;
    }

    public static void setShowImageMapsAreaNo(boolean bl) {
        showImageMapsAreaNo.set(bl);
    }

    public static void setShowImageMapsAreaShapes(boolean bl) {
        showImageMapsAreaShapes.set(bl);
    }

    public static interface Painter {
        public void drawImage(SVGDocument var1, Rectangle var2) throws IFException;
    }
}

