/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFEmbeddedFile;
import org.apache.fop.pdf.PDFFormXObject;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.StreamCache;
import org.apache.fop.pdf.VideoStreamCache;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.fop.render.pdf.VideoMP4ImageAdapter;

public class PDFVideoAnnot {
    private static Log log = LogFactory.getLog(PDFVideoAnnot.class);
    private PDFRenderingContext context;
    private PDFPage page;
    private VideoMP4ImageAdapter video;
    private Rectangle pos;

    public PDFVideoAnnot(PDFRenderingContext pDFRenderingContext, VideoMP4ImageAdapter videoMP4ImageAdapter, Rectangle rectangle, PDFPage pDFPage) {
        this.context = pDFRenderingContext;
        this.video = videoMP4ImageAdapter;
        this.pos = rectangle;
        this.page = pDFPage;
    }

    public PDFDictionary createAnnot() throws IOException {
        String string = this.video.getImage().getInfo().getOriginalURI();
        PDFDictionary pDFDictionary = this.getAppearanceDictionary(string);
        PDFArray pDFArray = this.drawAnnotRectangle();
        PDFDictionary pDFDictionary2 = this.getFilespec(string);
        PDFDictionary pDFDictionary3 = this.getConfiguration(pDFDictionary2);
        PDFDictionary pDFDictionary4 = this.getRichMediaContent(pDFDictionary3, pDFDictionary2);
        PDFDictionary pDFDictionary5 = this.getRichMediaSettings(pDFDictionary3);
        PDFDictionary pDFDictionary6 = new PDFDictionary();
        pDFDictionary6.put("AP", (Object)pDFDictionary);
        pDFDictionary6.put("P", (Object)this.page);
        pDFDictionary6.put("Rect", (Object)pDFArray);
        pDFDictionary6.put("RichMediaContent", (Object)pDFDictionary4);
        pDFDictionary6.put("RichMediaSettings", (Object)pDFDictionary5);
        pDFDictionary6.put("Subtype", (Object)new PDFName("RichMedia"));
        pDFDictionary6.put("Type", (Object)new PDFName("Annot"));
        this.page.getDocument().registerObject((PDFObject)pDFDictionary6);
        return pDFDictionary6;
    }

    private PDFDictionary getAppearanceDictionary(String string) {
        PDFArray pDFArray;
        PDFArray pDFArray2 = new PDFArray();
        pDFArray2.add((Object)new PDFName("PDF"));
        pDFArray2.add((Object)new PDFName("ImageC"));
        PDFDictionary pDFDictionary = new PDFDictionary();
        pDFDictionary.put("ProcSet", (Object)pDFArray2);
        this.page.getDocument().registerObject((PDFObject)pDFDictionary);
        PDFDictionary pDFDictionary2 = new PDFDictionary();
        pDFDictionary2.put("Filter", (Object)new PDFName("FlateDecode"));
        PDFStream pDFStream = new PDFStream(pDFDictionary2);
        PDFFormXObject pDFFormXObject = this.page.getDocument().addFormXObject(null, pDFStream, new PDFReference((PDFObject)pDFDictionary), string);
        PDFArray pDFArray3 = (PDFArray)this.page.get("CropBox");
        PDFArray pDFArray4 = (PDFArray)this.page.get("MediaBox");
        PDFArray pDFArray5 = pDFArray = pDFArray3 != null ? pDFArray3 : pDFArray4;
        if (pDFArray != null) {
            pDFFormXObject.setBBox((Rectangle2D)new Rectangle2D.Double((Double)pDFArray.get(0), (Double)pDFArray.get(1), (Double)pDFArray.get(2), (Double)pDFArray.get(3)));
        } else {
            log.error((Object)"Cannot create video annotation FormXObject!");
        }
        pDFFormXObject.setMatrix(this.context.getGenerator().getState().getTransform());
        PDFDictionary pDFDictionary3 = new PDFDictionary();
        pDFDictionary3.put("N", (Object)pDFFormXObject);
        return pDFDictionary3;
    }

    private PDFArray drawAnnotRectangle() {
        float f2 = (float)this.pos.getX() / 1000.0f;
        float f3 = (float)this.pos.getY() / 1000.0f;
        float f4 = (float)this.pos.getWidth() / 1000.0f;
        float f5 = (float)this.pos.getHeight() / 1000.0f;
        PDFArray pDFArray = new PDFArray();
        AffineTransform affineTransform = this.context.getGenerator().getState().getTransform();
        if (affineTransform != null) {
            double d2 = affineTransform.getTranslateX();
            double d3 = affineTransform.getTranslateY();
            pDFArray.add((double)f2 + d2);
            pDFArray.add(d3 - (double)f3 - (double)f5);
            pDFArray.add((double)(f2 + f4) + d2);
            pDFArray.add(d3 - (double)f3);
        } else {
            log.error((Object)"Cannot create video annotation Rectangle!");
        }
        return pDFArray;
    }

    private PDFDictionary getFilespec(String string) {
        String string2 = string.substring(string.lastIndexOf(47) + 1, string.length());
        PDFEmbeddedFile pDFEmbeddedFile = new PDFEmbeddedFile(){

            protected StreamCache getData() throws IOException {
                return new VideoStreamCache(PDFVideoAnnot.this.video.getImage());
            }
        };
        this.page.getDocument().registerObject((PDFObject)pDFEmbeddedFile);
        PDFDictionary pDFDictionary = new PDFDictionary();
        pDFDictionary.put("F", (Object)pDFEmbeddedFile);
        pDFDictionary.put("UF", (Object)pDFEmbeddedFile);
        PDFDictionary pDFDictionary2 = new PDFDictionary();
        pDFDictionary2.put("EF", (Object)pDFDictionary);
        pDFDictionary2.put("F", (Object)string2);
        pDFDictionary2.put("Type", (Object)new PDFName("Filespec"));
        pDFDictionary2.put("UF", (Object)string2);
        return pDFDictionary2;
    }

    private PDFDictionary getConfiguration(PDFDictionary pDFDictionary) {
        PDFDictionary pDFDictionary2 = new PDFDictionary();
        pDFDictionary2.put("Asset", (Object)pDFDictionary);
        PDFArray pDFArray = new PDFArray();
        pDFArray.add((Object)pDFDictionary2);
        PDFDictionary pDFDictionary3 = new PDFDictionary();
        pDFDictionary3.put("Instances", (Object)pDFArray);
        pDFDictionary3.put("Subtype", (Object)new PDFName("Video"));
        return pDFDictionary3;
    }

    private PDFDictionary getRichMediaContent(PDFDictionary pDFDictionary, PDFDictionary pDFDictionary2) {
        PDFArray pDFArray = new PDFArray();
        pDFArray.add((Object)pDFDictionary);
        PDFArray pDFArray2 = new PDFArray();
        pDFArray2.add(pDFDictionary2.get("F"));
        pDFArray2.add((Object)pDFDictionary2);
        PDFDictionary pDFDictionary3 = new PDFDictionary();
        pDFDictionary3.put("Names", (Object)pDFArray2);
        PDFDictionary pDFDictionary4 = new PDFDictionary();
        pDFDictionary4.put("Assets", (Object)pDFDictionary3);
        pDFDictionary4.put("Configurations", (Object)pDFArray);
        return pDFDictionary4;
    }

    private PDFDictionary getRichMediaSettings(PDFDictionary pDFDictionary) {
        PDFDictionary pDFDictionary2 = new PDFDictionary();
        pDFDictionary2.put("NavigationPane", (Object)false);
        pDFDictionary2.put("PassContextClick", (Object)false);
        pDFDictionary2.put("Style", (Object)new PDFName("Embedded"));
        pDFDictionary2.put("Toolbar", (Object)false);
        pDFDictionary2.put("Transparent", (Object)false);
        PDFDictionary pDFDictionary3 = new PDFDictionary();
        pDFDictionary3.put("Condition", (Object)new PDFName("XA"));
        pDFDictionary3.put("Configuration", (Object)pDFDictionary);
        pDFDictionary3.put("Presentation", (Object)pDFDictionary2);
        pDFDictionary3.put("Type", (Object)new PDFName("RichMediaActivation"));
        PDFDictionary pDFDictionary4 = new PDFDictionary();
        pDFDictionary4.put("Activation", (Object)pDFDictionary3);
        return pDFDictionary4;
    }
}

