/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.pdf.CMapBuilder;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFCMap;
import org.apache.fop.render.pdf.PDFEventProducer;

public class PDFToUnicodeCMap
extends PDFCMap {
    protected char[] unicodeCharMap;
    private boolean singleByte;
    private EventBroadcaster eventBroadcaster;
    private Map<Character, CharSequence> substitutions;

    public PDFToUnicodeCMap(char[] cArray, String string, PDFCIDSystemInfo pDFCIDSystemInfo, boolean bl, EventBroadcaster eventBroadcaster, Map<Character, CharSequence> map) {
        super(string, pDFCIDSystemInfo);
        Map<Object, Object> map2 = this.substitutions = map == null ? Collections.emptyMap() : map;
        if (bl && cArray.length > 256) {
            throw new IllegalArgumentException("unicodeCharMap may not contain more than 256 characters for single-byte encodings");
        }
        this.unicodeCharMap = cArray;
        this.singleByte = bl;
        this.eventBroadcaster = eventBroadcaster;
    }

    protected CMapBuilder createCMapBuilder(Writer writer) {
        return new ToUnicodeCMapBuilder(writer);
    }

    class ToUnicodeCMapBuilder
    extends CMapBuilder {
        public ToUnicodeCMapBuilder(Writer writer) {
            super(writer, null);
        }

        public void writeCMap() throws IOException {
            this.writeCIDInit();
            this.writeCIDSystemInfo("Adobe", "UCS", 0);
            this.writeName("Adobe-Identity-UCS");
            this.writeType("2");
            this.writeCodeSpaceRange(PDFToUnicodeCMap.this.singleByte);
            this.writeBFEntries();
            this.writeWrapUp();
        }

        protected void writeBFEntries() throws IOException {
            if (PDFToUnicodeCMap.this.unicodeCharMap != null) {
                this.writeBFCharEntries(PDFToUnicodeCMap.this.unicodeCharMap);
                this.writeBFRangeEntries(PDFToUnicodeCMap.this.unicodeCharMap);
            }
        }

        protected void writeBFCharEntries(char[] cArray) throws IOException {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (cArray.length > 0) {
                do {
                    if (!this.partOfRange(cArray, n4)) {
                        ++n3;
                    }
                    if (!Character.isHighSurrogate(cArray[n4])) continue;
                    ++n4;
                } while (++n4 < cArray.length);
            }
            if (n3 < 1) {
                return;
            }
            int n5 = n3;
            n4 = 0;
            do {
                n2 = Math.min(n5, 100);
                this.writer.write(n2 + " beginbfchar\n");
                int n6 = 0;
                while (true) {
                    if (this.partOfRange(cArray, n4)) {
                        if (Character.isHighSurrogate(cArray[n4])) {
                            ++n4;
                        }
                        ++n4;
                        continue;
                    }
                    this.writer.write("<" + this.padCharIndex(n4) + "> ");
                    if (PDFToUnicodeCMap.this.substitutions.containsKey(Character.valueOf(cArray[n4]))) {
                        this.writer.write("<");
                        CharSequence charSequence = PDFToUnicodeCMap.this.substitutions.get(Character.valueOf(cArray[n4]));
                        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                            this.writer.write(this.padHexString(Integer.toHexString(charSequence.charAt(i2)), 4));
                        }
                        this.writer.write(">\n");
                    } else if (Character.isHighSurrogate(cArray[n4])) {
                        char c2 = '\u0000';
                        if (n4 + 1 < cArray.length) {
                            c2 = cArray[n4 + 1];
                        } else if (PDFToUnicodeCMap.this.eventBroadcaster != null) {
                            PDFEventProducer pDFEventProducer = PDFEventProducer.Provider.get((EventBroadcaster)PDFToUnicodeCMap.this.eventBroadcaster);
                            pDFEventProducer.unpairedSurrogate((Object)this);
                        }
                        this.writer.write("<" + this.padHexString(Integer.toHexString(cArray[n4]), 4) + this.padHexString(Integer.toHexString(c2), 4) + ">\n");
                        ++n4;
                    } else {
                        this.writer.write("<" + this.padHexString(Integer.toHexString(cArray[n4]), 4) + ">\n");
                    }
                    ++n4;
                    if (++n6 >= n2) break;
                }
                this.writer.write("endbfchar\n");
            } while ((n5 -= n2) > 0);
        }

        private String padCharIndex(int n2) {
            return this.padHexString(Integer.toHexString(n2), PDFToUnicodeCMap.this.singleByte ? 2 : 4);
        }

        protected void writeBFRangeEntries(char[] cArray) throws IOException {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (cArray.length > 0) {
                do {
                    if (this.startOfRange(cArray, n4)) {
                        ++n3;
                    }
                    if (!Character.isHighSurrogate(cArray[n4])) continue;
                    ++n4;
                } while (++n4 < cArray.length);
            }
            if (n3 < 1) {
                return;
            }
            int n5 = n3;
            n4 = 0;
            do {
                n2 = Math.min(n5, 100);
                this.writer.write(n2 + " beginbfrange\n");
                int n6 = 0;
                while (true) {
                    if (!this.startOfRange(cArray, n4)) {
                        if (Character.isHighSurrogate(cArray[n4])) {
                            ++n4;
                        }
                        ++n4;
                        continue;
                    }
                    this.writer.write("<" + this.padCharIndex(n4) + "> ");
                    this.writer.write("<" + this.padCharIndex(this.endOfRange(cArray, n4)) + "> ");
                    if (Character.isHighSurrogate(cArray[n4])) {
                        char c2 = '\u0000';
                        if (n4 + 1 < cArray.length) {
                            c2 = cArray[n4 + 1];
                        } else if (PDFToUnicodeCMap.this.eventBroadcaster != null) {
                            PDFEventProducer pDFEventProducer = PDFEventProducer.Provider.get((EventBroadcaster)PDFToUnicodeCMap.this.eventBroadcaster);
                            pDFEventProducer.unpairedSurrogate((Object)this);
                        }
                        this.writer.write("<" + this.padHexString(Integer.toHexString(cArray[n4]), 4) + this.padHexString(Integer.toHexString(c2), 4) + ">\n");
                    } else {
                        this.writer.write("<" + this.padHexString(Integer.toHexString(cArray[n4]), 4) + ">\n");
                    }
                    ++n4;
                    if (++n6 >= n2) break;
                }
                this.writer.write("endbfrange\n");
            } while ((n5 -= n2) > 0);
        }

        private int endOfRange(char[] cArray, int n2) {
            int n3 = n2;
            if (Character.isHighSurrogate(cArray[n3])) {
                while (n3 < cArray.length - 3 && this.sameRangeEntryAsNext(cArray, n3)) {
                    n3 += 2;
                }
            } else {
                while (n3 < cArray.length - 1 && this.sameRangeEntryAsNext(cArray, n3)) {
                    ++n3;
                }
            }
            return n3;
        }

        private boolean partOfRange(char[] cArray, int n2) {
            if (PDFToUnicodeCMap.this.substitutions.containsKey(Character.valueOf(cArray[n2]))) {
                return false;
            }
            int n3 = 2;
            if (Character.isHighSurrogate(cArray[n2])) {
                n3 = 4;
            }
            if (cArray.length < n3) {
                return false;
            }
            if (n2 == 0) {
                return this.sameRangeEntryAsNext(cArray, 0);
            }
            if (Character.isHighSurrogate(cArray[n2]) && n2 == cArray.length - 2) {
                return this.sameRangeEntryAsNext(cArray, n2 - 2);
            }
            if (n2 == cArray.length - 1) {
                return this.sameRangeEntryAsNext(cArray, n2 - 1);
            }
            if (Character.isHighSurrogate(cArray[n2]) && this.sameRangeEntryAsNext(cArray, n2 - 2)) {
                return true;
            }
            if (this.sameRangeEntryAsNext(cArray, n2 - 1)) {
                return true;
            }
            return this.sameRangeEntryAsNext(cArray, n2);
        }

        private boolean sameRangeEntryAsNext(char[] cArray, int n2) {
            boolean bl = false;
            if (n2 >= 0 && n2 < cArray.length - 1) {
                if (PDFToUnicodeCMap.this.substitutions.containsKey(Character.valueOf(cArray[n2])) || PDFToUnicodeCMap.this.substitutions.containsKey(Character.valueOf(cArray[n2 + 1]))) {
                    return false;
                }
                if (Character.isHighSurrogate(cArray[n2])) {
                    if (n2 < cArray.length - 3 && cArray[n2 + 2] == cArray[n2] && cArray[n2 + 3] == cArray[n2 + 1] + '\u0001' && n2 / 256 == (n2 + 2) / 256) {
                        bl = true;
                    }
                } else if (cArray[n2] + '\u0001' == cArray[n2 + 1] && n2 / 256 == (n2 + 1) / 256) {
                    bl = true;
                }
            }
            return bl;
        }

        private boolean startOfRange(char[] cArray, int n2) {
            if (!this.partOfRange(cArray, n2)) {
                return false;
            }
            if (n2 == 0) {
                return true;
            }
            if (Character.isHighSurrogate(cArray[n2]) && n2 == cArray.length - 2) {
                return false;
            }
            if (n2 == cArray.length - 1) {
                return false;
            }
            if (Character.isHighSurrogate(cArray[n2]) && this.sameRangeEntryAsNext(cArray, n2 - 2)) {
                return false;
            }
            return !this.sameRangeEntryAsNext(cArray, n2 - 1);
        }

        private String padHexString(String string, int n2) {
            int n3 = string.length();
            if (n3 >= n2) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 1; i2 <= n2 - n3; ++i2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
    }
}

