/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.pdf.CompressedObject;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.StandardStructureAttributes;
import org.apache.fop.pdf.StandardStructureTypes;
import org.apache.fop.pdf.StructureHierarchyMember;
import org.apache.fop.pdf.StructureType;
import org.apache.fop.util.LanguageTags;

public class PDFStructElem
extends StructureHierarchyMember
implements StructureTreeElement,
CompressedObject,
Serializable {
    private static final List<StructureType> BLSE = Arrays.asList(StandardStructureTypes.Table.TABLE, StandardStructureTypes.List.L, StandardStructureTypes.Paragraphlike.P);
    private static final long serialVersionUID = -3055241807589202532L;
    private StructureType structureType;
    protected PDFStructElem parentElement;
    private static ThreadLocal<Boolean> isEncryptStructureElement = ThreadLocal.withInitial(() -> Boolean.FALSE);
    protected List<PDFObject> kids;
    private List<PDFDictionary> attributes;
    private PDFObject parent;

    public PDFStructElem() {
    }

    public PDFStructElem(PDFObject pDFObject, StructureType structureType) {
        this(pDFObject);
        this.structureType = structureType;
        this.put("S", structureType.getName());
        if (pDFObject != null) {
            this.put("P", null);
        }
    }

    private PDFStructElem(PDFObject pDFObject) {
        if (pDFObject instanceof PDFStructElem) {
            this.parentElement = (PDFStructElem)pDFObject;
        }
        this.parent = pDFObject;
        if (pDFObject != null) {
            this.setDocument(pDFObject.getDocument());
        }
    }

    public PDFStructElem getParentStructElem() {
        return this.parentElement;
    }

    public void setParent(PDFObject pDFObject) {
        if (pDFObject != null && pDFObject.hasObjectNumber()) {
            this.put("P", new PDFReference(pDFObject));
        }
    }

    public void addKid(PDFObject pDFObject) {
        if (this.kids == null) {
            this.assignObjectNumber();
            this.kids = new ArrayList<PDFObject>();
        }
        this.kids.add(pDFObject);
    }

    private void assignObjectNumber() {
        if (this.parentElement != null) {
            this.parentElement.assignObjectNumber();
        }
        if (this.getDocument() != null && !this.hasObjectNumber()) {
            this.getDocument().assignObjectNumber((PDFObject)this);
        }
        this.setParent(this.parent);
    }

    public void setMCIDKid(int n2) {
        this.put("K", n2);
    }

    public void setPage(PDFPage pDFPage) {
        this.put("Pg", pDFPage);
    }

    public StructureType getStructureType() {
        return this.structureType;
    }

    private void setLanguage(String string) {
        this.put("Lang", string);
    }

    public void setLanguage(Locale locale) {
        this.setLanguage(LanguageTags.toLanguageTag((Locale)locale));
    }

    public String getLanguage() {
        return (String)this.get("Lang");
    }

    protected void writeDictionary(OutputStream outputStream, StringBuilder stringBuilder) throws IOException {
        this.attachKids();
        this.attachAttributes();
        super.writeDictionary(outputStream, stringBuilder);
    }

    private void attachAttributes() {
        if (this.attributes != null) {
            if (this.attributes.size() == 1) {
                this.put("A", this.attributes.get(0));
            } else {
                PDFArray pDFArray = new PDFArray(this.attributes);
                this.put("A", pDFArray);
            }
        }
    }

    public void addKidInSpecificOrder(int n2, PDFStructElem pDFStructElem) {
        if (this.kids == null) {
            this.addKid((PDFObject)pDFStructElem);
        } else if (this.kids.size() - 1 < n2) {
            this.kids.add((PDFObject)pDFStructElem);
        } else if (this.kids.get(n2) == null) {
            this.kids.set(n2, (PDFObject)pDFStructElem);
        } else if (!this.kids.contains(pDFStructElem)) {
            this.kids.add(n2, (PDFObject)pDFStructElem);
        }
    }

    protected boolean attachKids() {
        boolean bl;
        ArrayList<PDFObject> arrayList = new ArrayList<PDFObject>();
        if (this.kids != null) {
            for (PDFObject pDFObject : this.kids) {
                if (pDFObject instanceof Placeholder) {
                    if (!((Placeholder)pDFObject).attachKids()) continue;
                    arrayList.add(pDFObject);
                    continue;
                }
                arrayList.add(pDFObject);
            }
        }
        boolean bl2 = bl = !arrayList.isEmpty();
        if (bl) {
            PDFObject pDFObject;
            pDFObject = new PDFArray();
            for (PDFObject pDFObject2 : arrayList) {
                pDFObject.add((Object)pDFObject2);
            }
            this.put("K", pDFObject);
        }
        return bl;
    }

    public void setTableAttributeColSpan(int n2) {
        this.setTableAttributeRowColumnSpan("ColSpan", n2);
    }

    public void setTableAttributeRowSpan(int n2) {
        this.setTableAttributeRowColumnSpan("RowSpan", n2);
    }

    private void setTableAttributeRowColumnSpan(String string, int n2) {
        PDFDictionary pDFDictionary = new PDFDictionary();
        pDFDictionary.put("O", (Object)StandardStructureAttributes.Table.NAME);
        pDFDictionary.put(string, n2);
        if (this.attributes == null) {
            this.attributes = new ArrayList<PDFDictionary>(2);
        }
        this.attributes.add(pDFDictionary);
    }

    public List<PDFObject> getKids() {
        return this.kids;
    }

    public int output(OutputStream outputStream) throws IOException {
        if (this.getDocument() != null && this.getDocument().getProfile().getPDFUAMode().isEnabled()) {
            if (this.entries.containsKey("Alt") && "".equals(this.get("Alt"))) {
                this.put("Alt", "No alternate text specified");
            } else if (this.kids != null) {
                for (PDFObject pDFObject : this.kids) {
                    if (!(pDFObject instanceof PDFStructElem) || !this.isBSLE((PDFStructElem)pDFObject)) continue;
                    this.structureType = StandardStructureTypes.Grouping.DIV;
                    this.put("S", this.structureType.getName());
                    break;
                }
            }
        }
        return super.output(outputStream);
    }

    private boolean isBSLE(PDFStructElem pDFStructElem) {
        boolean bl = !(pDFStructElem instanceof Placeholder) && this.structureType == StandardStructureTypes.Paragraphlike.P;
        return bl && BLSE.contains(pDFStructElem.getStructureType());
    }

    protected byte[] encodeText(String string) {
        if (this.getDocumentSafely().isEncryptionActive() && isEncryptStructureElement.get().booleanValue()) {
            byte[] byArray = PDFText.toUTF16((String)string);
            return PDFText.escapeByteArray((byte[])this.getDocument().getEncryption().encrypt(byArray, (PDFObject)this));
        }
        return PDFStructElem.encode((String)PDFText.escapeText((String)string, (boolean)false));
    }

    public static void setIsEncryptStructureElement(boolean bl) {
        isEncryptStructureElement.set(bl);
    }

    public static class Placeholder
    extends PDFStructElem {
        private static final long serialVersionUID = -2397980642558372068L;

        public void outputInline(OutputStream outputStream, StringBuilder stringBuilder) throws IOException {
            if (this.kids != null) {
                assert (this.kids.size() > 0);
                for (int i2 = 0; i2 < this.kids.size(); ++i2) {
                    Object e2;
                    if (i2 > 0) {
                        stringBuilder.append(' ');
                    }
                    if ((e2 = this.kids.get(i2)) instanceof PDFStructElem) {
                        ((PDFStructElem)e2).setParent((PDFObject)this.parentElement);
                    }
                    this.formatObject(e2, outputStream, stringBuilder);
                }
            }
        }

        public Placeholder(PDFObject pDFObject) {
            super(pDFObject);
        }
    }
}

