/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.fo.flow.AbstractRetrieveMarker;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.flow.Markers;
import org.apache.fop.fo.flow.RetrieveTableMarker;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.BreakOpportunity;
import org.apache.fop.layoutmgr.ChemistryExtensions;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpacedBorderedPaddedBlockLayoutManager;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.ColumnSetup;
import org.apache.fop.layoutmgr.table.OverPaintBorders;
import org.apache.fop.layoutmgr.table.TableAndCaptionLayoutManager;
import org.apache.fop.layoutmgr.table.TableCellLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.BreakUtil;

public class TableLayoutManager
extends SpacedBorderedPaddedBlockLayoutManager
implements BreakOpportunity {
    private static Log log = LogFactory.getLog(TableLayoutManager.class);
    private TableContentLayoutManager contentLM;
    private ColumnSetup columns;
    private Block curBlockArea;
    private double tableUnit;
    private double oldTableUnit;
    private boolean autoLayout = true;
    private int halfBorderSeparationBPD;
    private int halfBorderSeparationIPD;
    private List<ColumnBackgroundInfo> columnBackgroundAreas;
    private Position auxiliaryPosition;
    private List<TableCellLayoutManager> savedTCLMs;
    private boolean areAllTCLMsSaved;
    private Markers tableMarkers;
    private Markers tableFragmentMarkers;
    private boolean hasRetrieveTableMarker;
    private boolean repeatedHeader;
    private List<List<KnuthElement>> headerFootnotes = Collections.emptyList();
    private List<List<KnuthElement>> footerFootnotes = Collections.emptyList();

    public TableLayoutManager(Table table) {
        super((FObj)table);
        this.columns = new ColumnSetup(table);
    }

    protected CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.getTable().getCommonBorderPaddingBackground();
    }

    public Table getTable() {
        return (Table)this.fobj;
    }

    public ColumnSetup getColumns() {
        return this.columns;
    }

    public void initialize() {
        this.foSpaceBefore = new SpaceVal(this.getTable().getCommonMarginBlock().spaceBefore, (PercentBaseContext)this).getSpace();
        this.foSpaceAfter = new SpaceVal(this.getTable().getCommonMarginBlock().spaceAfter, (PercentBaseContext)this).getSpace();
        this.startIndent = this.getTable().getCommonMarginBlock().startIndent.getValue((PercentBaseContext)this);
        this.endIndent = this.getTable().getCommonMarginBlock().endIndent.getValue((PercentBaseContext)this);
        if (this.getParent() instanceof TableAndCaptionLayoutManager) {
            this.startIndent = this.getTable().getCommonBorderPaddingBackground().getPaddingStart(false, (PercentBaseContext)this) + this.getTable().getCommonBorderPaddingBackground().getBorderStartWidth(false);
            this.endIndent = this.getTable().getCommonBorderPaddingBackground().getPaddingEnd(false, (PercentBaseContext)this) + this.getTable().getCommonBorderPaddingBackground().getBorderEndWidth(false);
        } else {
            this.startIndent = this.getTable().getCommonMarginBlock().startIndent.getValue((PercentBaseContext)this);
            this.endIndent = this.getTable().getCommonMarginBlock().endIndent.getValue((PercentBaseContext)this);
        }
        if (this.getTable().isSeparateBorderModel()) {
            this.halfBorderSeparationBPD = this.getTable().getBorderSeparation().getBPD().getLength().getValue((PercentBaseContext)this) / 2;
            this.halfBorderSeparationIPD = this.getTable().getBorderSeparation().getIPD().getLength().getValue((PercentBaseContext)this) / 2;
        } else {
            this.halfBorderSeparationBPD = 0;
            this.halfBorderSeparationIPD = 0;
        }
        if (!this.getTable().isAutoLayout() && this.getTable().getInlineProgressionDimension().getOptimum((PercentBaseContext)this).getEnum() != 9) {
            this.autoLayout = false;
        }
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    public int getHalfBorderSeparationBPD() {
        return this.halfBorderSeparationBPD;
    }

    public int getHalfBorderSeparationIPD() {
        return this.halfBorderSeparationIPD;
    }

    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2) {
        int n3;
        int n4;
        Object object;
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        this.referenceIPD = layoutContext.getRefIPD();
        if (this.getTable().getInlineProgressionDimension().getOptimum((PercentBaseContext)this).getEnum() != 9) {
            int n5 = this.getTable().getInlineProgressionDimension().getOptimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this);
            n5 = this.applyHTMLTablePolicyForBordersAndPadding(n5);
            this.updateContentAreaIPDwithOverconstrainedAdjust(layoutContext, n5);
        } else {
            if (!this.getTable().isAutoLayout()) {
                BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getTable().getUserAgent().getEventBroadcaster());
                blockLevelEventProducer.tableFixedAutoWidthNotSupported((Object)this, this.getTable().getLocator());
            }
            this.updateContentAreaIPDwithOverconstrainedAdjust(layoutContext);
        }
        int n6 = this.columns.getSumOfColumnWidths((PercentBaseContext)this);
        if (!this.autoLayout && n6 > this.getContentAreaIPD()) {
            log.debug((Object)FONode.decorateWithContextInfo("The sum of all column widths is larger than the specified table width.", (FONode)((Object)this.getTable())));
            this.updateContentAreaIPDwithOverconstrainedAdjust(layoutContext, n6);
        }
        int n7 = this.referenceIPD - this.getIPIndents();
        if (this.getContentAreaIPD() > n7) {
            object = BlockLevelEventProducer.Provider.get(this.getTable().getUserAgent().getEventBroadcaster());
            object.objectTooWide((Object)this, this.getTable().getName(), this.getContentAreaIPD(), layoutContext.getRefIPD(), this.getTable().getLocator());
        }
        if (this.tableUnit == 0.0) {
            this.tableUnit = this.columns.computeTableUnit(this, layoutContext);
            if (this.oldTableUnit > this.tableUnit && this.supportResize((FONode)this.fobj)) {
                this.tableUnit = this.oldTableUnit;
            }
        }
        if (!this.firstVisibleMarkServed) {
            this.addKnuthElementsForSpaceBefore(linkedList, n2);
        }
        if (this.getTable().isSeparateBorderModel()) {
            this.addKnuthElementsForBorderPaddingBefore(linkedList, !this.firstVisibleMarkServed);
            this.firstVisibleMarkServed = true;
            this.addPendingMarks(layoutContext);
        }
        this.contentLM = new TableContentLayoutManager(this);
        LayoutContext layoutContext2 = LayoutContext.newInstance();
        layoutContext2.setRefIPD(layoutContext.getRefIPD());
        layoutContext2.copyPendingMarksFrom(layoutContext);
        if (this.isAutoLayout() || layoutContext.isChildOfAutoLayoutElement()) {
            int n8;
            layoutContext2.setChildOfAutoLayoutElement(true);
            layoutContext2.setInAutoLayoutDeterminationMode(true);
            this.contentLM.determineMinMaxWidths(layoutContext2, n2, TableContentLayoutManager.Pass.ONE_UNIT_CELLS);
            this.contentLM.determineMinMaxWidths(layoutContext2, n2, TableContentLayoutManager.Pass.ALL_CELLS);
            if (!layoutContext.isInAutoLayoutDeterminationMode()) {
                layoutContext2.setInAutoLayoutDeterminationMode(false);
            }
            if ((n8 = this.columns.computeOptimalColumnWidthsForAutoLayout(this, layoutContext)) != -1) {
                if (log.isDebugEnabled()) {
                    log.info((Object)("Setting ref IPD " + n8));
                }
                this.setContentAreaIPD(n8);
                layoutContext.setRefIPD(n8);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)">>>>>> START Get Next Knuth Elements ");
        }
        object = this.contentLM.getNextKnuthElements(layoutContext2, n2);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            ListElement listElement = (ListElement)e2;
            this.notifyPos(listElement.getPosition());
        }
        log.debug(object);
        this.wrapPositionElements((List)object, linkedList);
        layoutContext.updateKeepWithPreviousPending(this.getKeepWithPrevious());
        layoutContext.updateKeepWithPreviousPending(layoutContext2.getKeepWithPreviousPending());
        layoutContext.updateKeepWithNextPending(this.getKeepWithNext());
        layoutContext.updateKeepWithNextPending(layoutContext2.getKeepWithNextPending());
        if (this.getTable().isSeparateBorderModel()) {
            this.addKnuthElementsForBorderPaddingAfter(linkedList, true);
        }
        this.addKnuthElementsForSpaceAfter(linkedList, n2);
        if (!layoutContext.suppressBreakBefore() && (n4 = BreakUtil.compareBreakClasses((int)this.getTable().getBreakBefore(), (int)layoutContext2.getBreakBefore())) != 9) {
            linkedList.add(0, (ListElement)new BreakElement((Position)new LeafPosition(this.getParent(), 0), 0, -1000, n4, layoutContext));
        }
        if ((n3 = BreakUtil.compareBreakClasses((int)this.getTable().getBreakAfter(), (int)layoutContext2.getBreakAfter())) != 9) {
            linkedList.add((ListElement)new BreakElement((Position)new LeafPosition(this.getParent(), 0), 0, -1000, n3, layoutContext));
        }
        this.setFinished(true);
        this.resetSpaces();
        return linkedList;
    }

    private boolean supportResize(FONode fONode) {
        if (fONode instanceof AbstractGraphics || this.getPSLM().getPageProvider().getCurrentColumnCount() == 1) {
            return false;
        }
        FONode.FONodeIterator fONodeIterator = fONode.getChildNodes();
        while (fONodeIterator != null && fONodeIterator.hasNext()) {
            FONode fONode2 = fONodeIterator.next();
            if (this.supportResize(fONode2)) continue;
            return false;
        }
        return true;
    }

    private int applyHTMLTablePolicyForBordersAndPadding(int n2) {
        if ("yes".equals(this.getTable().getForeignAttributes().get(ChemistryExtensions.ATT_QNAME_HTML_TABLE_WIDTH_POLICY))) {
            n2 -= this.startIndent + this.endIndent;
        }
        return n2;
    }

    public Position getAuxiliaryPosition() {
        if (this.auxiliaryPosition == null) {
            this.auxiliaryPosition = new LeafPosition((LayoutManager)((Object)this), 0);
        }
        return this.auxiliaryPosition;
    }

    void registerColumnBackgroundArea(TableColumn tableColumn, Block block, int n2) {
        this.addBackgroundArea(block);
        if (this.columnBackgroundAreas == null) {
            this.columnBackgroundAreas = new ArrayList<ColumnBackgroundInfo>();
        }
        this.columnBackgroundAreas.add(new ColumnBackgroundInfo(tableColumn, block, n2));
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        this.getParentArea(null);
        this.addId();
        if (layoutContext.getSpaceBefore() != 0) {
            this.addBlockSpacing(0.0, MinOptMax.getInstance((int)layoutContext.getSpaceBefore()));
        }
        int n2 = this.getParent() instanceof TableAndCaptionLayoutManager ? this.startIndent : this.getTable().getCommonMarginBlock().startIndent.getValue((PercentBaseContext)this);
        int n3 = 0;
        LayoutContext layoutContext2 = LayoutContext.offspringOf(layoutContext);
        layoutContext2.setRefIPD(this.getContentAreaIPD());
        this.contentLM.setStartXOffset(n2);
        this.contentLM.addAreas(positionIterator, layoutContext2);
        if (this.fobj.getUserAgent().isTableBorderOverpaint()) {
            new OverPaintBorders(this.curBlockArea);
        }
        this.curBlockArea.setBPD(n3 += this.contentLM.getUsedBPD());
        if (this.columnBackgroundAreas != null) {
            Iterator<ColumnBackgroundInfo> iterator = this.columnBackgroundAreas.iterator();
            while (iterator.hasNext()) {
                ColumnBackgroundInfo columnBackgroundInfo;
                ColumnBackgroundInfo columnBackgroundInfo2 = columnBackgroundInfo = iterator.next();
                TraitSetter.addBackground((Area)columnBackgroundInfo2.backgroundArea, columnBackgroundInfo2.column.getCommonBorderPaddingBackground(), (PercentBaseContext)this, columnBackgroundInfo2.xShift, -columnBackgroundInfo2.backgroundArea.getYOffset(), columnBackgroundInfo2.column.getColumnWidth().getValue((PercentBaseContext)this), n3, 0, columnBackgroundInfo2.backgroundArea.getYOffset());
            }
            this.columnBackgroundAreas.clear();
        }
        if (this.getTable().isSeparateBorderModel()) {
            TraitSetter.addBorders((Area)this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, (PercentBaseContext)this);
            TraitSetter.addPadding((Area)this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, (PercentBaseContext)this);
        }
        TraitSetter.addBackground((Area)this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), (PercentBaseContext)this);
        TraitSetter.addMargins((Area)this.curBlockArea, this.getTable().getCommonBorderPaddingBackground(), this.startIndent, this.endIndent, (PercentBaseContext)this);
        TraitSetter.addBreaks((Area)this.curBlockArea, this.getTable().getBreakBefore(), this.getTable().getBreakAfter());
        TraitSetter.addSpaceBeforeAfter((Area)this.curBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        this.resetSpaces();
        this.curBlockArea = null;
        this.notifyEndOfLayout();
    }

    public Area getParentArea(Area area) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.setChangeBarList(this.getChangeBarList());
            this.parentLayoutManager.getParentArea((Area)this.curBlockArea);
            TraitSetter.setProducerID((Area)this.curBlockArea, this.getTable().getId());
            this.curBlockArea.setIPD(this.getContentAreaIPD());
            this.transferForeignAttributes((AreaTreeObject)this.curBlockArea);
            this.setCurrentArea((BlockParent)this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area area) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)area);
        }
    }

    void addBackgroundArea(Block block) {
        this.curBlockArea.addChildArea((Area)block);
    }

    public int negotiateBPDAdjustment(int n2, KnuthElement knuthElement) {
        return 0;
    }

    public void discardSpace(KnuthGlue knuthGlue) {
    }

    public KeepProperty getKeepTogetherProperty() {
        return this.getTable().getKeepTogether();
    }

    public KeepProperty getKeepWithPreviousProperty() {
        return this.getTable().getKeepWithPrevious();
    }

    public KeepProperty getKeepWithNextProperty() {
        return this.getTable().getKeepWithNext();
    }

    public MinOptMax getPossibleWidths(TableColumn tableColumn, LayoutContext layoutContext) {
        if (this.contentLM != null && (this.isAutoLayout() || layoutContext.isChildOfAutoLayoutElement())) {
            if (tableColumn.isAutoLayout()) {
                MinOptMax minOptMax = this.contentLM.getBaseLength((FObj)tableColumn);
                if (minOptMax != null) {
                    return minOptMax;
                }
            } else {
                return null;
            }
        }
        return null;
    }

    final boolean isAutoLayout() {
        return this.getTable().isAutoLayout();
    }

    public int getMinimumIPD() {
        int n2 = -1;
        int n3 = 0;
        if (this.contentLM != null) {
            n3 = this.isAutoLayout() ? this.getMinimumIPDforAutoLayout() : this.getMinimumIPDforFixedLayout();
            n2 = Math.max(n2, n3 += this.getMBP());
        }
        return n2;
    }

    public int getMaximumIPD() {
        int n2 = 0;
        int n3 = 0;
        if (this.contentLM != null) {
            n3 = this.isAutoLayout() ? this.getMaximumIPDforAutoLayout() : this.getMaximumIPDforFixedLayout();
            n2 = Math.max(n2, n3 += this.getMBP());
        }
        return n2;
    }

    private int getMinimumIPDforFixedLayout() {
        return this.getMinMaxIPDforFixedLayout(false);
    }

    private int getMaximumIPDforFixedLayout() {
        return this.getMinMaxIPDforFixedLayout(true);
    }

    private int getMinimumIPDforAutoLayout() {
        return this.getMinMaxIPDforAutoLayout(false);
    }

    private int getMaximumIPDforAutoLayout() {
        return this.getMinMaxIPDforAutoLayout(true);
    }

    private int getMinMaxIPDforFixedLayout(boolean bl) {
        int n2 = 0;
        Iterator iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            TableColumn tableColumn = (TableColumn)((Object)iterator.next());
            if (tableColumn.isAutoLayout()) continue;
            n2 += tableColumn.getColumnWidth().getValue((PercentBaseContext)this);
        }
        return n2;
    }

    private int getMinMaxIPDforAutoLayout(boolean bl) {
        int n2 = 0;
        Iterator iterator = this.columns.iterator();
        while (iterator.hasNext()) {
            TableColumn tableColumn = (TableColumn)((Object)iterator.next());
            MinOptMax minOptMax = this.contentLM.getBaseLength((FObj)tableColumn);
            if (minOptMax == null) continue;
            n2 += bl ? minOptMax.getMax() : minOptMax.getMin();
        }
        return n2;
    }

    public void setPossibleWidths(TableColumn tableColumn, MinOptMax minOptMax) {
        assert (this.contentLM != null);
        if (tableColumn.isAutoLayout()) {
            this.contentLM.setBaseLength(tableColumn, minOptMax);
        }
    }

    public int getBaseLength(int n2, FObj fObj) {
        if (fObj instanceof TableColumn && fObj.getParent() == this.getFObj()) {
            switch (n2) {
                case 5: {
                    return this.getContentAreaIPD();
                }
                case 11: {
                    int n3 = 0;
                    if (this.contentLM != null && this.isAutoLayout()) {
                        if (((TableColumn)fObj).isAutoLayout()) {
                            MinOptMax minOptMax = this.contentLM.getBaseLength(fObj);
                            n3 = minOptMax == null ? 0 : minOptMax.getOpt();
                        }
                    } else {
                        n3 = (int)this.tableUnit;
                    }
                    return n3;
                }
            }
            log.error((Object)"Unknown base type for LengthBase.");
            return 0;
        }
        switch (n2) {
            case 11: {
                return (int)this.tableUnit;
            }
        }
        return super.getBaseLength(n2, fObj);
    }

    public void reset() {
        super.reset();
        this.curBlockArea = null;
        this.oldTableUnit = this.tableUnit;
        this.tableUnit = 0.0;
    }

    protected void saveTableHeaderTableCellLayoutManagers(TableCellLayoutManager tableCellLayoutManager) {
        if (this.savedTCLMs == null) {
            this.savedTCLMs = new ArrayList<TableCellLayoutManager>();
        }
        if (!this.areAllTCLMsSaved) {
            this.savedTCLMs.add(tableCellLayoutManager);
        }
    }

    protected void repeatAddAreasForSavedTableHeaderTableCellLayoutManagers() {
        if (this.savedTCLMs == null) {
            return;
        }
        this.areAllTCLMsSaved = true;
        for (TableCellLayoutManager tableCellLayoutManager : this.savedTCLMs) {
            if (this.repeatedHeader) {
                tableCellLayoutManager.setHasRepeatedHeader(true);
            }
            tableCellLayoutManager.repeatAddAreas();
        }
    }

    public RetrieveTableMarker resolveRetrieveTableMarker(RetrieveTableMarker retrieveTableMarker) {
        String string = retrieveTableMarker.getRetrieveClassName();
        int n2 = retrieveTableMarker.getPosition();
        boolean bl = false;
        Marker marker = null;
        Marker marker2 = marker = this.tableFragmentMarkers == null ? null : this.tableFragmentMarkers.resolve((AbstractRetrieveMarker)retrieveTableMarker);
        if (marker == null && retrieveTableMarker.getBoundary() != 193) {
            retrieveTableMarker.changePositionTo(191);
            bl = true;
            marker = this.getCurrentPV().resolveMarker((AbstractRetrieveMarker)retrieveTableMarker);
            if (marker == null && retrieveTableMarker.getBoundary() != 104) {
                Marker marker3 = marker = this.tableMarkers == null ? null : this.tableMarkers.resolve((AbstractRetrieveMarker)retrieveTableMarker);
            }
        }
        if (bl) {
            retrieveTableMarker.changePositionTo(n2);
        }
        if (marker == null) {
            log.debug((Object)("found no marker with name: " + string));
            return null;
        }
        retrieveTableMarker.bindMarker(marker);
        return retrieveTableMarker;
    }

    public void registerMarkers(Map<String, Marker> map, boolean bl, boolean bl2, boolean bl3) {
        if (this.tableMarkers == null) {
            this.tableMarkers = new Markers();
        }
        this.tableMarkers.register(map, bl, bl2, bl3);
        if (this.tableFragmentMarkers == null) {
            this.tableFragmentMarkers = new Markers();
        }
        this.tableFragmentMarkers.register(map, bl, bl2, bl3);
    }

    protected void clearTableFragmentMarkers() {
        this.tableFragmentMarkers = null;
    }

    public void flagAsHavingRetrieveTableMarker() {
        this.hasRetrieveTableMarker = true;
    }

    protected void possiblyRegisterMarkersForTables(Map<String, Marker> map, boolean bl, boolean bl2, boolean bl3) {
        if (this.hasRetrieveTableMarker) {
            this.registerMarkers(map, bl, bl2, bl3);
        }
        super.possiblyRegisterMarkersForTables(map, bl, bl2, bl3);
    }

    void setHeaderFootnotes(List<List<KnuthElement>> list) {
        this.headerFootnotes = list;
    }

    List<List<KnuthElement>> getHeaderFootnotes() {
        return this.headerFootnotes;
    }

    void setFooterFootnotes(List<List<KnuthElement>> list) {
        this.footerFootnotes = list;
    }

    public void setRepeateHeader(boolean bl) {
        this.repeatedHeader = bl;
    }

    List<List<KnuthElement>> getFooterFootnotes() {
        return this.footerFootnotes;
    }

    protected int getMBP() {
        Table table = this.getTable();
        CommonMarginBlock commonMarginBlock = table.getCommonMarginBlock();
        CommonBorderPaddingBackground commonBorderPaddingBackground = table.getCommonBorderPaddingBackground();
        int n2 = (int)Math.ceil(commonMarginBlock.marginLeft.getNumericValue((PercentBaseContext)this) + commonMarginBlock.marginRight.getNumericValue((PercentBaseContext)this) + (double)commonBorderPaddingBackground.getPaddingStart(false, (PercentBaseContext)this) + (double)commonBorderPaddingBackground.getPaddingEnd(false, (PercentBaseContext)this) + (double)commonBorderPaddingBackground.getBorderStartWidth(false) + (double)commonBorderPaddingBackground.getBorderEndWidth(false));
        return n2;
    }

    public int getBaselineOffset() {
        int n2 = this.contentLM.getBaselineOffset();
        if (this.effSpaceBefore != null) {
            n2 += this.effSpaceBefore.getOpt();
        }
        if (!this.discardBorderBefore) {
            n2 += this.getCommonBorderPaddingBackground().getBorderBeforeWidth(false);
        }
        if (!this.discardPaddingBefore) {
            n2 += this.getCommonBorderPaddingBackground().getPaddingBefore(false, (PercentBaseContext)this);
        }
        return n2;
    }

    public boolean hasLineAreaDescendant() {
        return this.contentLM.hasLineAreaDescendant();
    }

    public int getStartIndent() {
        return this.startIndent;
    }

    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        log.error((Object)"getContentAreaBPD called on unknown BPD");
        return -1;
    }

    private static final class ColumnBackgroundInfo {
        private TableColumn column;
        private Block backgroundArea;
        private int xShift;

        private ColumnBackgroundInfo(TableColumn tableColumn, Block block, int n2) {
            this.column = tableColumn;
            this.backgroundArea = block;
            this.xShift = n2;
        }
    }
}

