/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.LocalBreaker;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RetrieveTableMarkerLayoutManager;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.RowPainter;
import org.apache.fop.layoutmgr.table.TableLayoutManager;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.ListUtil;

public class TableCellLayoutManager
extends BlockStackingLayoutManager {
    private static Log log = LogFactory.getLog(TableCellLayoutManager.class);
    private PrimaryGridUnit primaryGridUnit;
    private Block curBlockArea;
    private int xoffset;
    private int yoffset;
    private int cellIPD;
    private int totalHeight;
    private int usedBPD;
    private boolean emptyCell = true;
    private boolean isDescendantOfTableFooter;
    private boolean isDescendantOfTableHeader;
    private boolean hasRetrieveTableMarker;
    private boolean hasRepeatedHeader;
    private boolean savedAddAreasArguments;
    private PositionIterator savedParentIter;
    private LayoutContext savedLayoutContext;
    private int[] savedSpannedGridRowHeights;
    private int savedStartRow;
    private int savedEndRow;
    private int savedBorderBeforeWhich;
    private int savedBorderAfterWhich;
    private boolean savedFirstOnPage;
    private boolean savedLastOnPage;
    private RowPainter savedPainter;
    private int savedFirstRowHeight;
    private boolean flushArea = true;
    private boolean isLastTrait;
    private Length width;
    private int baselineAdjustment;

    public TableCellLayoutManager(TableCell tableCell, PrimaryGridUnit primaryGridUnit) {
        super((FObj)tableCell);
        this.setGeneratesBlockArea(true);
        this.primaryGridUnit = primaryGridUnit;
        this.isDescendantOfTableHeader = tableCell.getParent().getParent() instanceof TableHeader || tableCell.getParent() instanceof TableHeader;
        this.isDescendantOfTableFooter = tableCell.getParent().getParent() instanceof TableFooter || tableCell.getParent() instanceof TableFooter;
        this.hasRetrieveTableMarker = tableCell.hasRetrieveTableMarker();
        this.width = tableCell.getWidth();
    }

    public TableCell getTableCell() {
        return (TableCell)this.fobj;
    }

    private boolean isSeparateBorderModel() {
        return this.getTable().isSeparateBorderModel();
    }

    public Table getTable() {
        return this.getTableCell().getTable();
    }

    public void setHasRepeatedHeader(boolean bl) {
        this.hasRepeatedHeader = bl;
    }

    @Override
    protected int getIPIndents() {
        int[] nArray = this.primaryGridUnit.getStartEndBorderWidths();
        this.startIndent = nArray[0];
        this.endIndent = nArray[1];
        if (this.isSeparateBorderModel()) {
            int n2 = this.getTable().getBorderSeparation().getLengthPair().getIPD().getLength().getValue((PercentBaseContext)this);
            this.startIndent += n2 / 2;
            this.endIndent += n2 / 2;
        } else {
            this.startIndent /= 2;
            this.endIndent /= 2;
        }
        this.startIndent += this.getTableCell().getCommonBorderPaddingBackground().getPaddingStart(false, this);
        this.endIndent += this.getTableCell().getCommonBorderPaddingBackground().getPaddingEnd(false, this);
        return this.startIndent + this.endIndent;
    }

    @Override
    public int getMinimumIPD() {
        int n2 = super.getMinimumIPD();
        int n3 = this.getCurrentWidthTakingIntoAccountAuto();
        int n4 = Math.max(n2, n3);
        return n4 += this.getIPIndents();
    }

    private int getCurrentWidthTakingIntoAccountAuto() {
        int n2 = 0;
        if (this.width.getEnum() != 9) {
            n2 = this.width.getValue((PercentBaseContext)this);
        }
        return n2;
    }

    final int getRefIPD() {
        return this.referenceIPD;
    }

    final boolean isAutoLayout() {
        Table table = this.getTable();
        if (table.isAutoLayout()) {
            int n2 = this.primaryGridUnit.getColIndex();
            TableColumn tableColumn = table.getColumn(n2);
            return tableColumn.isAutoLayout();
        }
        return false;
    }

    @Override
    public int getMaximumIPD() {
        int n2 = super.getMaximumIPD();
        int n3 = this.getCurrentWidthTakingIntoAccountAuto();
        int n4 = Math.max(n2, n3);
        return n4 += this.getIPIndents();
    }

    @Override
    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2) {
        List list;
        Object object;
        LayoutManager layoutManager;
        MinOptMax minOptMax = layoutContext.getStackLimitBP();
        this.cellIPD = this.referenceIPD = layoutContext.getRefIPD();
        this.cellIPD -= this.getIPIndents();
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        LinkedList<ListElement> linkedList2 = new LinkedList<ListElement>();
        LayoutManager layoutManager2 = null;
        while ((layoutManager = this.getChildLM()) != null) {
            object = LayoutContext.offspringOf(layoutContext);
            ((LayoutContext)object).setStackLimitBP(layoutContext.getStackLimitBP().minus(minOptMax));
            ((LayoutContext)object).setRefIPD(this.cellIPD);
            list = layoutManager.getNextKnuthElements((LayoutContext)object, n2);
            int n3 = ((LayoutContext)object).getRefIPD() + this.getIPIndents();
            if (this.referenceIPD < n3 && (this.isAutoLayout() || layoutContext.isChildOfAutoLayoutElement())) {
                this.referenceIPD = n3;
                this.cellIPD = ((LayoutContext)object).getRefIPD();
                layoutContext.setRefIPD(n3);
            }
            if (((LayoutContext)object).isKeepWithNextPending()) {
                log.debug((Object)"child LM signals pending keep with next");
            }
            if (linkedList.isEmpty() && ((LayoutContext)object).isKeepWithPreviousPending()) {
                this.primaryGridUnit.setKeepWithPrevious(((LayoutContext)object).getKeepWithPreviousPending());
                ((LayoutContext)object).clearKeepWithPreviousPending();
            }
            if (layoutManager2 != null && !ElementListUtils.endsWithForcedBreak(linkedList)) {
                this.addInBetweenBreak(linkedList, layoutContext, (LayoutContext)object);
            }
            linkedList.addAll(list);
            if (list.isEmpty()) continue;
            if (((LayoutContext)object).isKeepWithNextPending()) {
                layoutContext.updateKeepWithNextPending(((LayoutContext)object).getKeepWithNextPending());
                ((LayoutContext)object).clearKeepWithNextPending();
            }
            layoutManager2 = layoutManager;
        }
        this.primaryGridUnit.setKeepWithNext(layoutContext.getKeepWithNextPending());
        list = new LinkedList();
        if (!linkedList.isEmpty()) {
            this.wrapPositionElements(linkedList, linkedList2);
        } else {
            linkedList2.add((ListElement)new KnuthBox(0, this.notifyPos(new Position((LayoutManager)this)), true));
        }
        SpaceResolver.resolveElementList(linkedList2);
        if (((ListElement)linkedList2.get(0)).isForcedBreak()) {
            this.primaryGridUnit.setBreakBefore(((KnuthPenalty)linkedList2.get(0)).getBreakClass());
            linkedList2.remove(0);
            assert (!linkedList2.isEmpty());
        }
        if ((object = (KnuthElement)((Object)ListUtil.getLast(linkedList2))).isForcedBreak()) {
            KnuthPenalty knuthPenalty = (KnuthPenalty)object;
            this.primaryGridUnit.setBreakAfter(knuthPenalty.getBreakClass());
            knuthPenalty.setPenalty(0);
        }
        this.setFinished(true);
        return linkedList2;
    }

    public void setYOffset(int n2) {
        this.yoffset = n2;
    }

    public void setXOffset(int n2) {
        this.xoffset = n2;
    }

    public void setContentHeight(int n2) {
        this.usedBPD = n2;
    }

    public void setTotalHeight(int n2) {
        this.totalHeight = n2;
    }

    private void clearRetrieveTableMarkerChildNodes(List<LayoutManager> list) {
        if (list == null) {
            return;
        }
        int n2 = list.size();
        for (LayoutManager layoutManager : list) {
            if (layoutManager == null) {
                return;
            }
            if (layoutManager instanceof RetrieveTableMarkerLayoutManager) {
                ((AbstractLayoutManager)layoutManager).getFObj().clearChildNodes();
                continue;
            }
            List<LayoutManager> list2 = layoutManager.getChildLMs();
            this.clearRetrieveTableMarkerChildNodes(list2);
        }
    }

    private boolean isDescendantOfTableHeaderOrFooter() {
        return this.isDescendantOfTableFooter || this.isDescendantOfTableHeader;
    }

    private void saveAddAreasArguments(PositionIterator positionIterator, LayoutContext layoutContext, int[] nArray, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, RowPainter rowPainter, int n6) {
        if (this.savedAddAreasArguments) {
            return;
        }
        if (this.isDescendantOfTableHeader) {
            this.savedAddAreasArguments = true;
            this.savedParentIter = null;
            this.savedLayoutContext = null;
            this.savedSpannedGridRowHeights = nArray;
            this.savedStartRow = n2;
            this.savedEndRow = n3;
            this.savedBorderBeforeWhich = n4;
            this.savedBorderAfterWhich = n5;
            this.savedFirstOnPage = bl;
            this.savedLastOnPage = bl2;
            this.savedPainter = rowPainter;
            this.savedFirstRowHeight = n6;
            TableLayoutManager tableLayoutManager = this.getTableLayoutManager();
            tableLayoutManager.saveTableHeaderTableCellLayoutManagers(this);
            this.flushArea = false;
        }
    }

    private TableLayoutManager getTableLayoutManager() {
        LayoutManager layoutManager = this.getParent();
        while (!(layoutManager instanceof TableLayoutManager)) {
            layoutManager = layoutManager.getParent();
        }
        TableLayoutManager tableLayoutManager = (TableLayoutManager)((Object)layoutManager);
        return tableLayoutManager;
    }

    protected void repeatAddAreas() {
        if (this.savedAddAreasArguments) {
            this.addAreas(this.savedParentIter, this.savedLayoutContext, this.savedSpannedGridRowHeights, this.savedStartRow, this.savedEndRow, this.savedBorderBeforeWhich, this.savedBorderAfterWhich, this.savedFirstOnPage, this.savedLastOnPage, this.savedPainter, this.savedFirstRowHeight);
            this.savedAddAreasArguments = false;
        }
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext, int[] nArray, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, RowPainter rowPainter, int n6) {
        int n7;
        this.getParentArea(null);
        this.addId();
        int n8 = this.primaryGridUnit.getBeforeBorderWidth(n2, n4);
        int n9 = this.primaryGridUnit.getAfterBorderWidth(n3, n5);
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.primaryGridUnit.getCell().getCommonBorderPaddingBackground();
        int n10 = n7 = this.totalHeight - n8 - n9;
        n10 -= commonBorderPaddingBackground.getPaddingBefore(n4 == 2, this);
        n10 -= commonBorderPaddingBackground.getPaddingAfter(n5 == 2, this);
        this.addBackgroundAreas(rowPainter, n6, n8, n7);
        if (this.isSeparateBorderModel()) {
            if (!this.emptyCell || this.getTableCell().showEmptyCells()) {
                if (n8 > 0) {
                    int bl3 = this.getTableCell().getTable().getBorderSeparation().getBPD().getLength().getValue() / 2;
                    TableCellLayoutManager.adjustYOffset(this.curBlockArea, bl3);
                }
                TraitSetter.addBorders((Area)this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), n8 == 0, n9 == 0, false, false, this);
            }
        } else {
            boolean bl3;
            boolean block = this.primaryGridUnit.getColIndex() == 0;
            boolean bl4 = bl3 = this.primaryGridUnit.getColIndex() + this.getTableCell().getNumberColumnsSpanned() == this.getTable().getNumberOfColumns();
            if (!this.primaryGridUnit.hasSpanning()) {
                TableCellLayoutManager.adjustYOffset(this.curBlockArea, -n8);
                boolean[] blArray = new boolean[]{bl, bl2, block, bl3};
                TraitSetter.addCollapsingBorders((Area)this.curBlockArea, this.primaryGridUnit.getBorderBefore(n4), this.primaryGridUnit.getBorderAfter(n5), this.primaryGridUnit.getBorderStart(), this.primaryGridUnit.getBorderEnd(), blArray);
            } else {
                int n11;
                CommonBorderPaddingBackground.BorderInfo n15;
                Object object;
                int n12;
                TableCellLayoutManager.adjustYOffset(this.curBlockArea, n8);
                Block[][] blockArray = new Block[this.getTableCell().getNumberRowsSpanned()][this.getTableCell().getNumberColumnsSpanned()];
                GridUnit[] gridUnitArray = this.primaryGridUnit.getRows().get(n2);
                int n13 = this.getTableCell().getBidiLevelRecursive();
                for (n12 = 0; n12 < this.getTableCell().getNumberColumnsSpanned(); ++n12) {
                    object = gridUnitArray[n12];
                    n15 = object.getBorderBefore(n4);
                    n11 = n15.getRetainedWidth() / 2;
                    if (n11 <= 0) continue;
                    this.addBorder(blockArray, n2, n12, Trait.BORDER_BEFORE, n15, bl, n13);
                    TableCellLayoutManager.adjustYOffset(blockArray[n2][n12], -n11);
                    TableCellLayoutManager.adjustBPD(blockArray[n2][n12], -n11);
                }
                gridUnitArray = this.primaryGridUnit.getRows().get(n3);
                for (n12 = 0; n12 < this.getTableCell().getNumberColumnsSpanned(); ++n12) {
                    object = gridUnitArray[n12];
                    n15 = object.getBorderAfter(n5);
                    n11 = n15.getRetainedWidth() / 2;
                    if (n11 <= 0) continue;
                    this.addBorder(blockArray, n3, n12, Trait.BORDER_AFTER, n15, bl2, n13);
                    TableCellLayoutManager.adjustBPD(blockArray[n3][n12], -n11);
                }
                for (n12 = n2; n12 <= n3; ++n12) {
                    gridUnitArray = this.primaryGridUnit.getRows().get(n12);
                    object = gridUnitArray[0].getBorderStart();
                    int n14 = ((CommonBorderPaddingBackground.BorderInfo)object).getRetainedWidth() / 2;
                    if (n14 > 0) {
                        if (n13 == 1) {
                            this.addBorder(blockArray, n12, gridUnitArray.length - 1, Trait.BORDER_START, (CommonBorderPaddingBackground.BorderInfo)object, block, n13);
                            TableCellLayoutManager.adjustIPD(blockArray[n12][gridUnitArray.length - 1], -n14);
                        } else {
                            this.addBorder(blockArray, n12, 0, Trait.BORDER_START, (CommonBorderPaddingBackground.BorderInfo)object, block, n13);
                            TableCellLayoutManager.adjustXOffset(blockArray[n12][0], n14);
                            TableCellLayoutManager.adjustIPD(blockArray[n12][0], -n14);
                        }
                    }
                    if ((n14 = ((CommonBorderPaddingBackground.BorderInfo)(object = gridUnitArray[gridUnitArray.length - 1].getBorderEnd())).getRetainedWidth() / 2) <= 0) continue;
                    if (n13 == 1) {
                        this.addBorder(blockArray, n12, 0, Trait.BORDER_END, (CommonBorderPaddingBackground.BorderInfo)object, bl3, n13);
                        TableCellLayoutManager.adjustXOffset(blockArray[n12][0], n14);
                        TableCellLayoutManager.adjustIPD(blockArray[n12][0], -n14);
                        continue;
                    }
                    this.addBorder(blockArray, n12, gridUnitArray.length - 1, Trait.BORDER_END, (CommonBorderPaddingBackground.BorderInfo)object, bl3, n13);
                    TableCellLayoutManager.adjustIPD(blockArray[n12][gridUnitArray.length - 1], -n14);
                }
                n12 = this.yoffset;
                for (int i2 = n2; i2 <= n3; ++i2) {
                    int n16 = nArray[i2 - n2];
                    n11 = this.xoffset;
                    for (int i3 = 0; i3 < gridUnitArray.length; ++i3) {
                        int n17 = this.getTable().getColumn(this.primaryGridUnit.getColIndex() + i3).getColumnWidth().getValue((PercentBaseContext)this.getParent());
                        if (blockArray[i2][i3] != null) {
                            Block block2 = blockArray[i2][i3];
                            TableCellLayoutManager.adjustYOffset(block2, n12);
                            TableCellLayoutManager.adjustXOffset(block2, n11);
                            TableCellLayoutManager.adjustIPD(block2, n17);
                            TableCellLayoutManager.adjustBPD(block2, n16);
                            this.parentLayoutManager.addChildArea((Area)block2);
                        }
                        n11 += n17;
                    }
                    n12 += n16;
                }
            }
        }
        TraitSetter.addPadding((Area)this.curBlockArea, commonBorderPaddingBackground, n4 == 2, n5 == 2, false, false, this);
        if (this.usedBPD < n10) {
            if (this.getTableCell().getDisplayAlign() == 23) {
                Block block = new Block();
                block.setChangeBarList(this.getChangeBarList());
                block.setBPD((n10 - this.usedBPD) / 2);
                block.setBidiLevel(this.getTableCell().getBidiLevelRecursive());
                this.curBlockArea.addBlock(block);
            } else if (this.getTableCell().getDisplayAlign() == 3) {
                Block n17 = new Block();
                n17.setChangeBarList(this.getChangeBarList());
                n17.setBPD(n10 - this.usedBPD);
                n17.setBidiLevel(this.getTableCell().getBidiLevelRecursive());
                this.curBlockArea.addBlock(n17);
            } else if (this.baselineAdjustment != 0) {
                Block block = new Block();
                block.setChangeBarList(this.getChangeBarList());
                block.setBPD(this.baselineAdjustment);
                block.setBidiLevel(this.getTableCell().getBidiLevelRecursive());
                this.curBlockArea.addBlock(block);
            }
        }
        if (this.isDescendantOfTableHeaderOrFooter() && this.hasRetrieveTableMarker) {
            if (this.isDescendantOfTableHeader && !this.savedAddAreasArguments) {
                this.saveAddAreasArguments(positionIterator, layoutContext, nArray, n2, n3, n4, n5, bl, bl2, rowPainter, n6);
            }
            this.recreateChildrenLMs();
            int n18 = ((TableCell)this.getFObj()).getDisplayAlign();
            TableCellBreaker tableCellBreaker = new TableCellBreaker(this, this.cellIPD, n18);
            tableCellBreaker.setDescendantOfTableFooter(this.isDescendantOfTableHeader);
            if (this.isDescendantOfTableHeader) {
                tableCellBreaker.setRepeatedHeader(this.hasRepeatedHeader);
            } else {
                tableCellBreaker.setRepeatedFooter(layoutContext.treatAsArtifact());
            }
            tableCellBreaker.doLayout(this.usedBPD, false);
            this.clearRetrieveTableMarkerChildNodes(this.getChildLMs());
        }
        if (!this.hasRetrieveTableMarker) {
            AreaAdditionUtil.addAreas((AbstractLayoutManager)this, (PositionIterator)positionIterator, (LayoutContext)layoutContext);
        }
        this.curBlockArea.setBPD(n10);
        if (!this.isSeparateBorderModel() || !this.emptyCell || this.getTableCell().showEmptyCells()) {
            TraitSetter.addBackground((Area)this.curBlockArea, this.getTableCell().getCommonBorderPaddingBackground(), this);
        }
        if (this.flushArea) {
            this.flush();
        } else {
            this.flushArea = true;
        }
        this.curBlockArea = null;
        this.notifyEndOfLayout();
    }

    private void addBackgroundAreas(RowPainter rowPainter, int n2, int n3, int n4) {
        TableRow tableRow;
        TablePart tablePart;
        TableColumn tableColumn = this.getTable().getColumn(this.primaryGridUnit.getColIndex());
        if (tableColumn.getCommonBorderPaddingBackground().hasBackground()) {
            tablePart = this.getBackgroundArea(n4, n3);
            ((TableLayoutManager)((Object)this.parentLayoutManager)).registerColumnBackgroundArea(tableColumn, (Block)tablePart, -this.startIndent);
        }
        if ((tablePart = this.primaryGridUnit.getTablePart()).getCommonBorderPaddingBackground().hasBackground()) {
            rowPainter.registerPartBackgroundArea(this.getBackgroundArea(n4, n3));
        }
        if ((tableRow = this.primaryGridUnit.getRow()) != null && tableRow.getCommonBorderPaddingBackground().hasBackground()) {
            Block block = this.getBackgroundArea(n4, n3);
            ((TableLayoutManager)((Object)this.parentLayoutManager)).addBackgroundArea(block);
            TraitSetter.addBackground((Area)block, tableRow.getCommonBorderPaddingBackground(), this.parentLayoutManager, -this.xoffset - this.startIndent, -n3, this.parentLayoutManager.getContentAreaIPD(), n2, ((TableLayoutManager)((Object)this.parentLayoutManager)).getStartIndent(), this.startIndent);
        }
    }

    private void addBorder(Block[][] blockArray, int n2, int n3, Integer n4, CommonBorderPaddingBackground.BorderInfo borderInfo, boolean bl, int n5) {
        if (blockArray[n2][n3] == null) {
            blockArray[n2][n3] = new Block();
            blockArray[n2][n3].setChangeBarList(this.getChangeBarList());
            blockArray[n2][n3].addTrait(Trait.IS_REFERENCE_AREA, (Object)Boolean.TRUE);
            blockArray[n2][n3].setPositioning(2);
            blockArray[n2][n3].setBidiLevel(n5);
        }
        blockArray[n2][n3].addTrait(n4, (Object)BorderProps.makeRectangular((int)borderInfo.getStyle(), (int)borderInfo.getRetainedWidth(), (Color)borderInfo.getColor(), (BorderProps.Mode)(bl ? BorderProps.Mode.COLLAPSE_OUTER : BorderProps.Mode.COLLAPSE_INNER)));
    }

    private static void adjustXOffset(Block block, int n2) {
        block.setXOffset(block.getXOffset() + n2);
    }

    private static void adjustYOffset(Block block, int n2) {
        block.setYOffset(block.getYOffset() + n2);
    }

    private static void adjustIPD(Block block, int n2) {
        block.setIPD(block.getIPD() + n2);
    }

    private static void adjustBPD(Block block, int n2) {
        block.setBPD(block.getBPD() + n2);
    }

    private Block getBackgroundArea(int n2, int n3) {
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.getTableCell().getCommonBorderPaddingBackground();
        int n4 = commonBorderPaddingBackground.getPaddingStart(false, this);
        int n5 = commonBorderPaddingBackground.getPaddingEnd(false, this);
        Block block = new Block();
        block.setChangeBarList(this.getChangeBarList());
        TraitSetter.setProducerID((Area)block, this.getTable().getId());
        block.setPositioning(2);
        block.setIPD(this.cellIPD + n4 + n5);
        block.setBPD(n2);
        block.setXOffset(this.xoffset + this.startIndent - n4);
        block.setYOffset(this.yoffset + n3);
        block.setBidiLevel(this.getTableCell().getBidiLevelRecursive());
        return block;
    }

    @Override
    public Area getParentArea(Area area) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.setChangeBarList(this.getChangeBarList());
            this.curBlockArea.addTrait(Trait.IS_REFERENCE_AREA, (Object)Boolean.TRUE);
            TraitSetter.setProducerID((Area)this.curBlockArea, this.getTableCell().getId());
            this.curBlockArea.setPositioning(2);
            this.curBlockArea.setXOffset(this.xoffset + this.startIndent);
            this.curBlockArea.setYOffset(this.yoffset);
            this.curBlockArea.setIPD(this.cellIPD);
            this.curBlockArea.setBidiLevel(this.getTableCell().getBidiLevelRecursive());
            this.transferForeignAttributes((AreaTreeObject)this.curBlockArea);
            this.parentLayoutManager.getParentArea((Area)this.curBlockArea);
            this.setCurrentArea((BlockParent)this.curBlockArea);
        }
        return this.curBlockArea;
    }

    @Override
    public void addChildArea(Area area) {
        if (this.curBlockArea != null && area instanceof Block) {
            this.curBlockArea.addBlock((Block)area);
        }
    }

    @Override
    public int negotiateBPDAdjustment(int n2, KnuthElement knuthElement) {
        return 0;
    }

    @Override
    public void discardSpace(KnuthGlue knuthGlue) {
    }

    @Override
    public Keep getKeepTogether() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public int getContentAreaIPD() {
        return this.cellIPD;
    }

    @Override
    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        log.error((Object)"getContentAreaBPD called on unknown BPD");
        return -1;
    }

    @Override
    public boolean getGeneratesReferenceArea() {
        return true;
    }

    @Override
    public boolean getGeneratesBlockArea() {
        return true;
    }

    @Override
    protected void registerMarkers(boolean bl, boolean bl2, boolean bl3) {
        Map map = this.getTableCell().getMarkers();
        if (map != null) {
            this.getCurrentPV().registerMarkers(map, bl, bl2, bl3 && this.isLastTrait);
            if (!this.isDescendantOfTableHeaderOrFooter()) {
                this.getTableLayoutManager().registerMarkers(map, bl, bl2, bl3 && this.isLastTrait);
            }
        }
    }

    void setLastTrait(boolean bl) {
        this.isLastTrait = bl;
    }

    @Override
    public void setParent(LayoutManager layoutManager) {
        this.parentLayoutManager = layoutManager;
        if (this.hasRetrieveTableMarker) {
            this.getTableLayoutManager().flagAsHavingRetrieveTableMarker();
        }
    }

    public void setBaselineAjustment(int n2) {
        this.baselineAdjustment = n2;
    }

    @Override
    public int getBaselineOffset() {
        int n2 = super.getBaselineOffset();
        return n2 += ((TableCell)this.getFObj()).getCommonBorderPaddingBackground().getPaddingBefore(false, this);
    }

    private static class TableCellBreaker
    extends LocalBreaker {
        public TableCellBreaker(TableCellLayoutManager tableCellLayoutManager, int n2, int n3) {
            super((BlockStackingLayoutManager)tableCellLayoutManager, n2, n3);
        }

        protected void observeElementList(List list) {
            String string = this.lm.getParent().getFObj().getId() + "-" + this.lm.getFObj().getId();
            ElementListObserver.observe((List)list, (String)"table-cell", (String)string);
        }
    }
}

