/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.flow.table.EffRow;
import org.apache.fop.fo.flow.table.EmptyGridUnit;
import org.apache.fop.fo.flow.table.GridUnit;
import org.apache.fop.fo.flow.table.PrimaryGridUnit;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.table.ActiveCell;
import org.apache.fop.layoutmgr.table.CellPart;
import org.apache.fop.layoutmgr.table.TableCellLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentPosition;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

class RowPainter {
    private static Log log = LogFactory.getLog(RowPainter.class);
    private int colCount;
    private int currentRowOffset;
    private EffRow currentRow;
    private LayoutContext layoutContext;
    private int firstRowIndex;
    private int firstRowOnPageIndex;
    private List<Integer> rowOffsets = new ArrayList<Integer>();
    private int[] cellHeights;
    private boolean[] firstCellOnPage;
    private CellPart[] firstCellParts;
    private CellPart[] lastCellParts;
    private int tablePartOffset;
    private CommonBorderPaddingBackground tablePartBackground;
    private List<Block> tablePartBackgroundAreas;
    private TableContentLayoutManager tclm;
    private HashMap<Integer, int[]> recordedBaselineAdjustments = new HashMap(0);

    private void recordBaselineAdjustments(int n2, int[] nArray) {
        this.recordedBaselineAdjustments.put(n2, nArray);
    }

    RowPainter(TableContentLayoutManager tableContentLayoutManager, LayoutContext layoutContext) {
        this.tclm = tableContentLayoutManager;
        this.layoutContext = layoutContext;
        this.colCount = tableContentLayoutManager.getColumns().getColumnCount();
        this.cellHeights = new int[this.colCount];
        this.firstCellOnPage = new boolean[this.colCount];
        this.firstCellParts = new CellPart[this.colCount];
        this.lastCellParts = new CellPart[this.colCount];
        this.firstRowIndex = -1;
        this.firstRowOnPageIndex = -1;
    }

    void startTablePart(TablePart tablePart) {
        CommonBorderPaddingBackground commonBorderPaddingBackground = tablePart.getCommonBorderPaddingBackground();
        if (commonBorderPaddingBackground.hasBackground()) {
            this.tablePartBackground = commonBorderPaddingBackground;
            if (this.tablePartBackgroundAreas == null) {
                this.tablePartBackgroundAreas = new ArrayList<Block>();
            }
        }
        this.tablePartOffset = this.currentRowOffset;
    }

    void endTablePart(boolean bl, boolean bl2) {
        this.addAreasAndFlushRow(bl, bl2);
        if (this.tablePartBackground != null) {
            TableLayoutManager tableLayoutManager = this.tclm.getTableLM();
            Iterator<Block> iterator = this.tablePartBackgroundAreas.iterator();
            while (iterator.hasNext()) {
                Block block;
                Block block2 = block = iterator.next();
                TraitSetter.addBackground((Area)block2, this.tablePartBackground, (PercentBaseContext)tableLayoutManager, -block2.getXOffset(), this.tablePartOffset - block2.getYOffset(), tableLayoutManager.getContentAreaIPD(), this.currentRowOffset - this.tablePartOffset, tableLayoutManager.getStartIndent(), this.tablePartOffset);
            }
            this.tablePartBackground = null;
            this.tablePartBackgroundAreas.clear();
        }
    }

    int getAccumulatedBPD() {
        return this.currentRowOffset;
    }

    void handleTableContentPosition(TableContentPosition tableContentPosition) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("===handleTableContentPosition(" + tableContentPosition));
        }
        if (this.currentRow == null) {
            this.currentRow = tableContentPosition.getNewPageRow();
        } else {
            EffRow effRow = tableContentPosition.getRow();
            if (effRow.getIndex() > this.currentRow.getIndex()) {
                this.addAreasAndFlushRow(false, false);
                this.currentRow = effRow;
            }
        }
        if (this.firstRowIndex < 0) {
            this.firstRowIndex = this.currentRow.getIndex();
            if (this.firstRowOnPageIndex < 0) {
                this.firstRowOnPageIndex = this.firstRowIndex;
            }
        }
        for (Object e2 : tableContentPosition.cellParts) {
            int n2;
            CellPart cellPart = (CellPart)e2;
            if (log.isDebugEnabled()) {
                log.debug((Object)(">" + cellPart));
            }
            if (this.firstCellParts[n2 = cellPart.pgu.getColIndex()] == null) {
                this.firstCellParts[n2] = cellPart;
                this.cellHeights[n2] = cellPart.getBorderPaddingBefore(this.firstCellOnPage[n2]);
            } else {
                assert (this.firstCellParts[n2].pgu == cellPart.pgu);
                int n3 = n2;
                this.cellHeights[n3] = this.cellHeights[n3] + cellPart.getConditionalBeforeContentLength();
            }
            int n4 = n2;
            this.cellHeights[n4] = this.cellHeights[n4] + cellPart.getLength();
            this.lastCellParts[n2] = cellPart;
        }
    }

    private void addAreasAndFlushRow(boolean bl, boolean bl2) {
        int n2;
        int n3;
        GridUnit gridUnit;
        int n4;
        if (this.currentRow == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remembering yoffset for row " + this.currentRow.getIndex() + ": " + this.currentRowOffset));
        }
        this.recordRowOffset(this.currentRow.getIndex(), this.currentRowOffset);
        int[] nArray = RowPainter.computeBaselineAdjustments(this.colCount, this.currentRow);
        this.recordBaselineAdjustments(this.currentRow.getIndex(), nArray);
        boolean bl3 = true;
        boolean bl4 = true;
        int n5 = 0;
        for (n4 = 0; n4 < this.colCount; ++n4) {
            gridUnit = this.currentRow.getGridUnit(n4);
            if (gridUnit.isEmpty()) continue;
            if (gridUnit.getColSpanIndex() == 0 && (bl || gridUnit.isLastGridUnitRowSpan()) && this.firstCellParts[n4] != null) {
                n3 = this.cellHeights[n4];
                n3 += this.lastCellParts[n4].getConditionalAfterContentLength();
                n2 = this.getRowOffset(Math.max(this.firstCellParts[n4].pgu.getRowIndex(), this.firstRowIndex));
                n5 = Math.max(n5, n2 + (n3 += this.lastCellParts[n4].getBorderPaddingAfter(bl)) + nArray[n4] - this.currentRowOffset);
            }
            if (this.firstCellParts[n4] != null && !this.firstCellParts[n4].isFirstPart()) {
                bl3 = false;
            }
            if (this.lastCellParts[n4] == null || this.lastCellParts[n4].isLastPart()) continue;
            bl4 = false;
        }
        for (n4 = 0; n4 < this.colCount; ++n4) {
            gridUnit = this.currentRow.getGridUnit(n4);
            if (gridUnit.isEmpty() && !this.tclm.isSeparateBorderModel()) {
                n3 = bl3 ? (this.firstCellOnPage[n4] ? 1 : 0) : 2;
                n2 = bl4 ? (bl ? 1 : 0) : 2;
                assert (gridUnit instanceof EmptyGridUnit);
                this.addAreaForEmptyGridUnit((EmptyGridUnit)gridUnit, this.currentRow.getIndex(), n4, n5, n3, n2, bl2);
                this.firstCellOnPage[n4] = false;
                continue;
            }
            if (gridUnit.getColSpanIndex() != 0 || !bl && !gridUnit.isLastGridUnitRowSpan() || this.firstCellParts[n4] == null) continue;
            assert (this.firstCellParts[n4].pgu == gridUnit.getPrimary());
            if (this.firstCellParts[n4].isFirstPart()) {
                n3 = this.firstCellOnPage[n4] ? 1 : 0;
            } else {
                assert (this.firstCellOnPage[n4]);
                n3 = 2;
            }
            n2 = this.lastCellParts[n4].isLastPart() ? (bl ? 1 : 0) : 2;
            this.lastCellParts[n4].pgu.getCellLM().setLastTrait(this.lastCellParts[n4].isLastPart());
            int n6 = 0;
            int[] nArray2 = this.recordedBaselineAdjustments.get(this.firstCellParts[n4].pgu.getRowIndex());
            if (nArray2 != null) {
                n6 = nArray2[n4];
            }
            this.addAreasForCell(this.firstCellParts[n4].pgu, this.firstCellParts[n4].start, this.lastCellParts[n4].end, n5, n3, n2, bl2, n6);
            this.firstCellParts[n4] = null;
            Arrays.fill(this.firstCellOnPage, n4, n4 + gridUnit.getCell().getNumberColumnsSpanned(), false);
        }
        this.currentRowOffset += n5;
        if (bl) {
            this.currentRow = null;
            this.firstRowIndex = -1;
            this.rowOffsets.clear();
            this.recordedBaselineAdjustments.clear();
            this.firstRowOnPageIndex = Integer.MAX_VALUE;
        }
    }

    static int[] computeBaselineAdjustments(int n2, EffRow effRow) {
        int[] nArray = new int[n2];
        TableRow tableRow = effRow.getTableRow();
        if (tableRow != null && tableRow.getRelativeAlign() == 12) {
            int n3;
            int[] nArray2 = new int[n2];
            int n4 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                nArray2[n3] = 0;
                GridUnit gridUnit = effRow.getGridUnit(n3);
                if (!gridUnit.isEmpty() && gridUnit.isPrimary()) {
                    TableCellLayoutManager tableCellLayoutManager = gridUnit.getPrimary().getCellLM();
                    TableCell tableCell = (TableCell)tableCellLayoutManager.getFObj();
                    if (tableCell.getDisplayAlign() == 9) {
                        if (tableCellLayoutManager.hasLineAreaDescendant()) {
                            nArray2[n3] = tableCellLayoutManager.getBaselineOffset();
                        }
                    } else {
                        nArray2[n3] = -1;
                    }
                }
                n4 = Math.max(n4, nArray2[n3]);
            }
            if (n4 != 0) {
                for (n3 = 0; n3 < n2; ++n3) {
                    if (nArray2[n3] == -1) continue;
                    int n5 = n4 - nArray2[n3];
                    if (nArray == null) continue;
                    nArray[n3] = n5;
                }
            }
        }
        return nArray;
    }

    private int computeContentLength(PrimaryGridUnit primaryGridUnit, int n2, int n3) {
        if (n2 > n3) {
            return 0;
        }
        ListIterator listIterator = primaryGridUnit.getElements().listIterator(n2);
        boolean bl = false;
        while (listIterator.nextIndex() <= n3 && !bl) {
            bl = ((KnuthElement)((Object)listIterator.next())).isBox();
        }
        int n4 = 0;
        if (((KnuthElement)((Object)listIterator.previous())).isBox()) {
            while (listIterator.nextIndex() < n3) {
                KnuthElement knuthElement = (KnuthElement)((Object)listIterator.next());
                if (!knuthElement.isBox() && !knuthElement.isGlue()) continue;
                n4 += knuthElement.getWidth();
            }
            n4 += ActiveCell.getElementContentLength((KnuthElement)((KnuthElement)((Object)listIterator.next())));
        }
        return n4;
    }

    private void addAreasForCell(PrimaryGridUnit primaryGridUnit, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12 = this.currentRow.getIndex();
        if (primaryGridUnit.getRowIndex() >= this.firstRowIndex) {
            n11 = primaryGridUnit.getRowIndex();
            n10 = n11 < n12 ? this.getRowOffset(n11 + 1) - this.getRowOffset(n11) : n4;
        } else {
            n11 = this.firstRowIndex;
            n10 = 0;
        }
        int[] nArray = null;
        if (!this.tclm.getTableLM().getTable().isSeparateBorderModel() && primaryGridUnit.hasSpanning()) {
            nArray = new int[n12 - n11 + 1];
            n9 = this.getRowOffset(n11);
            for (n8 = 0; n8 < n12 - n11; ++n8) {
                int n13 = this.getRowOffset(n11 + n8 + 1);
                nArray[n8] = n13 - n9;
                n9 = n13;
            }
            nArray[n12 - n11] = n4;
        }
        n9 = this.getRowOffset(n11);
        n8 = n4 + this.currentRowOffset - n9;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating area for cell:");
            log.debug((Object)("  start row: " + primaryGridUnit.getRowIndex() + " " + this.currentRowOffset + " " + n9));
            log.debug((Object)(" rowHeight=" + n4 + " cellTotalHeight=" + n8));
        }
        TableCellLayoutManager tableCellLayoutManager = primaryGridUnit.getCellLM();
        tableCellLayoutManager.setBaselineAjustment(n7);
        tableCellLayoutManager.setXOffset(this.tclm.getXOffsetOfGridUnit(primaryGridUnit));
        tableCellLayoutManager.setYOffset(n9);
        tableCellLayoutManager.setContentHeight(this.computeContentLength(primaryGridUnit, n2, n3));
        tableCellLayoutManager.setTotalHeight(n8);
        int n14 = ElementListUtils.determinePreviousBreak((List)primaryGridUnit.getElements(), (int)n2);
        if (n3 >= 0) {
            SpaceResolver.performConditionalsNotification(primaryGridUnit.getElements(), n2, n3, n14);
        }
        tableCellLayoutManager.addAreas((PositionIterator)new KnuthPossPosIter(primaryGridUnit.getElements(), n2, n3 + 1), this.layoutContext, nArray, n11 - primaryGridUnit.getRowIndex(), n12 - primaryGridUnit.getRowIndex(), n5, n6, n11 == this.firstRowOnPageIndex, bl, this, n10);
    }

    private void addAreaForEmptyGridUnit(EmptyGridUnit emptyGridUnit, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        CommonBorderPaddingBackground.BorderInfo borderInfo = emptyGridUnit.getBorderBefore(n5);
        CommonBorderPaddingBackground.BorderInfo borderInfo2 = emptyGridUnit.getBorderAfter(n6);
        CommonBorderPaddingBackground.BorderInfo borderInfo3 = emptyGridUnit.getBorderStart();
        CommonBorderPaddingBackground.BorderInfo borderInfo4 = emptyGridUnit.getBorderEnd();
        if (borderInfo.getRetainedWidth() == 0 && borderInfo2.getRetainedWidth() == 0 && borderInfo3.getRetainedWidth() == 0 && borderInfo4.getRetainedWidth() == 0) {
            return;
        }
        TableLayoutManager tableLayoutManager = this.tclm.getTableLM();
        Table table = tableLayoutManager.getTable();
        TableColumn tableColumn = this.tclm.getColumns().getColumn(n3 + 1);
        boolean bl2 = n2 == this.firstRowOnPageIndex;
        boolean bl3 = n3 == 0;
        boolean bl4 = n3 == table.getNumberOfColumns() - 1;
        int n7 = tableColumn.getColumnWidth().getValue((PercentBaseContext)tableLayoutManager);
        n7 -= (borderInfo3.getRetainedWidth() + borderInfo4.getRetainedWidth()) / 2;
        int n8 = n4;
        n8 -= (borderInfo.getRetainedWidth() + borderInfo2.getRetainedWidth()) / 2;
        Block block = new Block();
        block.setChangeBarList(this.tclm.getTableLM().getFObj().getChangeBarList());
        block.setPositioning(2);
        block.addTrait(Trait.IS_REFERENCE_AREA, (Object)Boolean.TRUE);
        block.setIPD(n7);
        block.setBPD(n8);
        block.setXOffset(this.tclm.getXOffsetOfGridUnit(n3, 1) + borderInfo3.getRetainedWidth() / 2);
        block.setYOffset(this.getRowOffset(n2) - borderInfo.getRetainedWidth() / 2);
        boolean[] blArray = new boolean[]{bl2, bl, bl3, bl4};
        TraitSetter.addCollapsingBorders((Area)block, borderInfo, borderInfo2, borderInfo3, borderInfo4, blArray);
        tableLayoutManager.addChildArea((Area)block);
    }

    void registerPartBackgroundArea(Block block) {
        this.tclm.getTableLM().addBackgroundArea(block);
        this.tablePartBackgroundAreas.add(block);
    }

    private void recordRowOffset(int n2, int n3) {
        for (int i2 = this.rowOffsets.size(); i2 <= n2 - this.firstRowIndex; ++i2) {
            this.rowOffsets.add(n3);
        }
    }

    private int getRowOffset(int n2) {
        return this.rowOffsets.get(n2 - this.firstRowIndex);
    }

    void startBody() {
        Arrays.fill(this.firstCellOnPage, true);
    }

    void endBody() {
        Arrays.fill(this.firstCellOnPage, false);
    }
}

