/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.list;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpacedBorderedPaddedBlockLayoutManager;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class ListBlockLayoutManager
extends SpacedBorderedPaddedBlockLayoutManager {
    private static Log log = LogFactory.getLog(ListBlockLayoutManager.class);
    private Block curBlockArea;

    public ListBlockLayoutManager(ListBlock listBlock) {
        super((FObj)listBlock);
    }

    protected CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.getListBlockFO().getCommonBorderPaddingBackground();
    }

    protected ListBlock getListBlockFO() {
        return (ListBlock)this.fobj;
    }

    public void initialize() {
        this.foSpaceBefore = new SpaceVal(this.getListBlockFO().getCommonMarginBlock().spaceBefore, (PercentBaseContext)this).getSpace();
        this.foSpaceAfter = new SpaceVal(this.getListBlockFO().getCommonMarginBlock().spaceAfter, (PercentBaseContext)this).getSpace();
        this.startIndent = this.getListBlockFO().getCommonMarginBlock().startIndent.getValue((PercentBaseContext)this);
        this.endIndent = this.getListBlockFO().getCommonMarginBlock().endIndent.getValue((PercentBaseContext)this);
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2, Stack stack, Position position, LayoutManager layoutManager) {
        int n3;
        this.resetSpaces();
        List list = super.getNextKnuthElements(layoutContext, n2, stack, position, layoutManager);
        int n4 = this.getListBlockFO().getWidowContentLimit().getValue();
        if (n4 != 0) {
            ElementListUtils.removeLegalBreaks((List)list, (int)n4);
        }
        if ((n3 = this.getListBlockFO().getOrphanContentLimit().getValue()) != 0) {
            ElementListUtils.removeLegalBreaksFromEnd((List)list, (int)n3);
        }
        return list;
    }

    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        LayoutManager layoutManager;
        this.getParentArea(null);
        if (layoutContext.getSpaceBefore() > 0) {
            this.addBlockSpacing(0.0, MinOptMax.getInstance((int)layoutContext.getSpaceBefore()));
        }
        this.addId();
        LayoutContext layoutContext2 = LayoutContext.offspringOf(layoutContext);
        LayoutManager layoutManager2 = null;
        LayoutManager layoutManager3 = null;
        Position position = null;
        Position position2 = null;
        LinkedList<Position> linkedList = new LinkedList<Position>();
        while (positionIterator.hasNext()) {
            Position position3 = positionIterator.next();
            if (position3.getIndex() >= 0) {
                if (position == null) {
                    position = position3;
                }
                position2 = position3;
            }
            if (!(position3 instanceof NonLeafPosition) || position3.getPosition() == null || position3.getPosition().getLM() == this) continue;
            linkedList.add(position3.getPosition());
            layoutManager3 = position3.getPosition().getLM();
            if (layoutManager2 != null) continue;
            layoutManager2 = layoutManager3;
        }
        this.registerMarkers(true, this.isFirst(position), this.isLast(position2));
        PositionIterator positionIterator2 = new PositionIterator(linkedList.listIterator());
        while ((layoutManager = positionIterator2.getNextChildLM()) != null) {
            layoutContext2.setSpaceAdjust(layoutContext.getSpaceAdjust());
            layoutContext2.setFlags(4, layoutManager == layoutManager2);
            layoutContext2.setFlags(8, layoutManager == layoutManager3);
            layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
            layoutManager.addAreas(positionIterator2, layoutContext2);
        }
        this.registerMarkers(false, this.isFirst(position), this.isLast(position2));
        TraitSetter.addBackground((Area)this.curBlockArea, this.getListBlockFO().getCommonBorderPaddingBackground(), (PercentBaseContext)this);
        TraitSetter.addSpaceBeforeAfter((Area)this.curBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        TraitSetter.addBorders((Area)this.curBlockArea, this.getListBlockFO().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, (PercentBaseContext)this);
        this.flush();
        this.curBlockArea = null;
        this.resetSpaces();
        this.checkEndOfLayout(position2);
    }

    public Area getParentArea(Area area) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.setChangeBarList(this.getChangeBarList());
            this.parentLayoutManager.getParentArea((Area)this.curBlockArea);
            TraitSetter.setProducerID((Area)this.curBlockArea, this.getListBlockFO().getId());
            TraitSetter.addPadding((Area)this.curBlockArea, this.getListBlockFO().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, (PercentBaseContext)this);
            TraitSetter.addMargins((Area)this.curBlockArea, this.getListBlockFO().getCommonBorderPaddingBackground(), this.getListBlockFO().getCommonMarginBlock(), (PercentBaseContext)this);
            TraitSetter.addBreaks((Area)this.curBlockArea, this.getListBlockFO().getBreakBefore(), this.getListBlockFO().getBreakAfter());
            int n2 = this.referenceIPD - this.getIPIndents();
            this.curBlockArea.setIPD(n2);
            this.curBlockArea.setBidiLevel(this.getListBlockFO().getBidiLevel());
            this.transferForeignAttributes((AreaTreeObject)this.curBlockArea);
            this.setCurrentArea((BlockParent)this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area area) {
        if (this.curBlockArea != null) {
            this.curBlockArea.addBlock((Block)area);
        }
    }

    public KeepProperty getKeepTogetherProperty() {
        return this.getListBlockFO().getKeepTogether();
    }

    public KeepProperty getKeepWithPreviousProperty() {
        return this.getListBlockFO().getKeepWithPrevious();
    }

    public KeepProperty getKeepWithNextProperty() {
        return this.getListBlockFO().getKeepWithNext();
    }

    public boolean isRestartable() {
        return true;
    }

    public int getMinimumIPD() {
        return super.getMinimumIPD() + this.getMBP();
    }

    public int getMaximumIPD() {
        return super.getMaximumIPD() + this.getMBP();
    }

    protected int getMBP() {
        ListBlock listBlock = this.getListBlockFO();
        CommonMarginBlock commonMarginBlock = listBlock.getCommonMarginBlock();
        CommonBorderPaddingBackground commonBorderPaddingBackground = listBlock.getCommonBorderPaddingBackground();
        int n2 = (int)Math.ceil(commonMarginBlock.marginLeft.getNumericValue((PercentBaseContext)this) + commonMarginBlock.marginRight.getNumericValue((PercentBaseContext)this) + (double)commonBorderPaddingBackground.getPaddingStart(false, (PercentBaseContext)this) + (double)commonBorderPaddingBackground.getPaddingEnd(false, (PercentBaseContext)this) + (double)commonBorderPaddingBackground.getBorderStartWidth(false) + (double)commonBorderPaddingBackground.getBorderEndWidth(false));
        return n2;
    }

    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        log.error((Object)"getContentAreaBPD called on unknown BPD");
        return -1;
    }
}

