/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.area.Area;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.complexscripts.bidi.BidiResolver;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.InlineContainer;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.Hyphenator;
import org.apache.fop.layoutmgr.Adjustment;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.BreakingAlgorithm;
import org.apache.fop.layoutmgr.ChemistryExtensions;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.FloatContentLayoutManager;
import org.apache.fop.layoutmgr.FootenoteUtil;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceSpecifier;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelEventProducer;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineStackingLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LineLayoutPossibilities;
import org.apache.fop.layoutmgr.inline.TextLayoutManager;
import org.apache.fop.text.linebreak.LineBreakStatus;
import org.apache.fop.traits.MinOptMax;

public class LineLayoutManager
extends InlineStackingLayoutManager
implements BlockLevelLayoutManager {
    public static final int DEFAULT_SPACE_WIDTH = 3336;
    private static final int MIN_WORD_LENGTH_DOT_AGGRESSIVE_HYPH = 15;
    private static boolean aggressiveHyphenation = true;
    private static Log log = LogFactory.getLog(LineLayoutManager.class);
    private final Block fobj;
    private boolean isFirstInBlock;
    private int bidiLevel = -1;
    private int textAlignment = 70;
    private int textAlignmentLast;
    private int effectiveAlignment;
    private Length textIndent;
    private Length lastLineEndIndent;
    private CommonHyphenation hyphenationProperties;
    private Numeric hyphenationLadderCount;
    private int wrapOption = 161;
    private int whiteSpaceTreament;
    private final Length lineHeight;
    private final int lead;
    private final int follow;
    private AlignmentContext alignmentContext;
    private int baselineOffset = -1;
    private List<KnuthSequence> knuthParagraphs;
    private LineLayoutPossibilities lineLayouts;
    private LineLayoutPossibilities[] lineLayoutsList;
    private MinOptMax ipd = null;
    private boolean hyphenationPerformed;
    private int constantLineHeight = 12000;
    private boolean useBaselineOfLastLine;
    private boolean inAutoLayoutDeterminationMode;
    private static final int[] NO_HYPHENATION_POINTS = new int[0];

    public static void setAggressiveHyphenation(boolean bl) {
        aggressiveHyphenation = bl;
    }

    public LineLayoutManager(Block block, Length length, int n2, int n3) {
        super((FObj)block);
        this.fobj = block;
        this.fobjIter = null;
        this.lineHeight = length;
        this.lead = n2;
        this.follow = n3;
        this.useBaselineOfLastLine = this.isUseBaselineOfLastLine(block);
    }

    private boolean isUseBaselineOfLastLine(Block block) {
        String string = "inline-container";
        FONode fONode = block.getParent();
        if (fONode != null && !string.equals(fONode.getLocalName())) {
            fONode = fONode.getParent();
        }
        boolean bl = false;
        if (fONode != null && string.equals(fONode.getLocalName())) {
            bl = !((InlineContainer)((Object)fONode)).isUseFirstLineBaseline();
        }
        return bl;
    }

    @Override
    public void initialize() {
        this.bidiLevel = this.fobj.getBidiLevel();
        this.textAlignment = this.fobj.getTextAlign();
        this.textAlignmentLast = this.fobj.getTextAlignLast();
        this.textIndent = this.fobj.getTextIndent();
        this.lastLineEndIndent = this.fobj.getLastLineEndIndent();
        this.hyphenationProperties = this.fobj.getCommonHyphenation();
        this.hyphenationLadderCount = this.fobj.getHyphenationLadderCount();
        this.wrapOption = this.fobj.getWrapOption();
        this.whiteSpaceTreament = this.fobj.getWhitespaceTreatment();
        this.effectiveAlignment = this.getEffectiveAlignment(this.textAlignment, this.textAlignmentLast);
        this.isFirstInBlock = this == this.getParent().getChildLMs().get(0);
    }

    private int getEffectiveAlignment(int n2, int n3) {
        if (this.textAlignment != 70 && this.textAlignmentLast == 70) {
            return 0;
        }
        return this.textAlignment;
    }

    @Override
    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2) {
        if (this.alignmentContext == null) {
            FontInfo fontInfo = this.fobj.getFOEventHandler().getFontInfo();
            FontTriplet[] fontTripletArray = this.fobj.getCommonFont().getFontState(fontInfo);
            Font font = fontInfo.getFontInstance(fontTripletArray[0], this.fobj.getCommonFont().fontSize.getValue((PercentBaseContext)this));
            this.alignmentContext = new AlignmentContext(font, this.lineHeight.getValue((PercentBaseContext)this), layoutContext.getWritingMode());
        }
        layoutContext.setAlignmentContext(this.alignmentContext);
        this.ipd = MinOptMax.getInstance((int)layoutContext.getRefIPD());
        this.inAutoLayoutDeterminationMode = layoutContext.isInAutoLayoutDeterminationMode();
        if (this.knuthParagraphs == null) {
            this.knuthParagraphs = new ArrayList<KnuthSequence>();
            this.collectInlineKnuthElements(layoutContext);
        }
        if (this.knuthParagraphs.size() == 0) {
            this.setFinished(true);
            return null;
        }
        return this.createLineBreaks(layoutContext.getBPAlignment(), layoutContext);
    }

    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2, LeafPosition leafPosition) {
        int n3 = 0;
        int n4 = 0;
        if (leafPosition != null) {
            log.trace((Object)("Restarting line breaking from index " + leafPosition.getIndex()));
            n3 = leafPosition.getLeafPos();
            n4 = leafPosition.getIndex();
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.knuthParagraphs.size() <= 1) continue;
            this.knuthParagraphs.remove(0);
        }
        n3 = 0;
        KnuthSequence knuthSequence = this.knuthParagraphs.get(n3);
        if (knuthSequence instanceof Paragraph) {
            ((Paragraph)knuthSequence).ignoreAtStart = 0;
            this.isFirstInBlock = false;
        }
        knuthSequence.subList(0, n4 + 1).clear();
        Iterator iterator = knuthSequence.iterator();
        while (iterator.hasNext() && !((KnuthElement)((Object)iterator.next())).isBox()) {
            iterator.remove();
        }
        if (!iterator.hasNext()) {
            this.knuthParagraphs.remove(n3);
        }
        if (this.knuthParagraphs.size() == 0) {
            this.setFinished(true);
            return null;
        }
        this.ipd = MinOptMax.getInstance((int)layoutContext.getRefIPD());
        return this.createLineBreaks(layoutContext.getBPAlignment(), layoutContext);
    }

    private void collectInlineKnuthElements(LayoutContext layoutContext) {
        Object object2;
        MinOptMax minOptMax;
        InlineLevelLayoutManager inlineLevelLayoutManager;
        LayoutContext layoutContext2 = LayoutContext.copyOf(layoutContext);
        boolean bl = this.hyphenationProperties.breakLineAtHyphens.getEnum() == 176 || this.hyphenationProperties.avoidBreakingLineAtHyphens.getEnum() == 149;
        boolean bl2 = this.hyphenationProperties.breakLineAtHyphens.getEnum() == 7;
        LineBreakStatus lineBreakStatus = new LineBreakStatus(bl, bl2);
        layoutContext2.setLineBreakStatus(lineBreakStatus);
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer("LineLM:");
        Paragraph paragraph = null;
        int n2 = 0;
        int n3 = 0;
        while ((inlineLevelLayoutManager = (InlineLevelLayoutManager)this.getChildLM()) != null) {
            minOptMax = inlineLevelLayoutManager.getNextKnuthElements(layoutContext2, this.effectiveAlignment);
            if (minOptMax == null || minOptMax.size() == 0) continue;
            minOptMax = this.supplementalBreakOfSequences((List<KnuthSequence>)minOptMax);
            if (paragraph != null) {
                KnuthSequence knuthSequence = (KnuthSequence)minOptMax.get(0);
                if (!knuthSequence.isInlineSequence()) {
                    paragraph.endParagraph();
                    ElementListObserver.observe((List)((Object)paragraph), (String)"line", null);
                    paragraph = null;
                    if (log.isTraceEnabled()) {
                        stringBuffer.append(" ]");
                    }
                    bl3 = false;
                }
                if (paragraph != null && (object2 = (KnuthElement)((Object)knuthSequence.get(0))).isBox() && !((KnuthElement)((Object)object2)).isAuxiliary() && bl3) {
                    paragraph.addALetterSpace();
                }
            }
            for (Object object2 : minOptMax) {
                KnuthSequence knuthSequence = (KnuthSequence)object2;
                if (knuthSequence.isInlineSequence()) {
                    ListElement listElement = knuthSequence.getLast();
                    assert (listElement != null);
                    boolean bl4 = bl3 = listElement.isBox() && !((KnuthElement)listElement).isAuxiliary() && ((KnuthElement)listElement).getWidth() != 0;
                    if (paragraph == null) {
                        paragraph = new Paragraph(this, this.textAlignment, this.textAlignmentLast, this.textIndent.getValue((PercentBaseContext)this), this.lastLineEndIndent.getValue((PercentBaseContext)this));
                        paragraph.startSequence();
                        if (log.isTraceEnabled()) {
                            stringBuffer.append(" [");
                        }
                    } else if (log.isTraceEnabled()) {
                        stringBuffer.append(" +");
                    }
                    paragraph.addAll((Collection)knuthSequence);
                    if (log.isTraceEnabled()) {
                        stringBuffer.append(" I");
                    }
                    if (!listElement.isPenalty() || ((KnuthPenalty)listElement).getPenalty() != -1000) continue;
                    paragraph.removeLast();
                    if (!paragraph.containsBox()) {
                        paragraph.add(new KnuthGlue(this.ipd.getOpt(), 0, this.ipd.getOpt(), null, true));
                    }
                    paragraph.endParagraph();
                    ElementListObserver.observe((List)((Object)paragraph), (String)"line", null);
                    paragraph = null;
                    if (log.isTraceEnabled()) {
                        stringBuffer.append(" ]");
                    }
                    bl3 = false;
                    continue;
                }
                this.knuthParagraphs.add(knuthSequence);
                if (!log.isTraceEnabled()) continue;
                stringBuffer.append(" B");
            }
        }
        if (paragraph != null) {
            paragraph.endParagraph();
            ElementListObserver.observe((List)((Object)paragraph), (String)"line", (String)this.fobj.getId());
            if (log.isTraceEnabled()) {
                stringBuffer.append(" ]");
            }
        }
        if (this.ipd.getMax() < n3 && layoutContext.isInAutoLayoutDeterminationMode()) {
            this.ipd = MinOptMax.getInstance((int)n2, (int)n3, (int)n3);
            minOptMax = layoutContext.getStackLimitBP();
            int n4 = minOptMax.getMax();
            if (n4 < n3) {
                n4 = n3;
            }
            object2 = MinOptMax.getInstance((int)minOptMax.getMin(), (int)n3, (int)n4);
            layoutContext.setStackLimitBP((MinOptMax)object2);
            layoutContext.setRefIPD(this.ipd.getOpt());
        }
        log.trace((Object)stringBuffer);
        this.addSpaceThatFollowsToInlineEndingWords();
    }

    private void addSpaceThatFollowsToInlineEndingWords() {
        for (KnuthSequence knuthSequence : this.knuthParagraphs) {
            this.addSpaceThatFollowsToInlineEndingWords(knuthSequence);
        }
    }

    private void addSpaceThatFollowsToInlineEndingWords(KnuthSequence knuthSequence) {
        ListElement listElement = null;
        for (int i2 = 0; i2 < knuthSequence.size(); ++i2) {
            LeafPosition leafPosition;
            boolean bl;
            ListElement listElement2 = (ListElement)knuthSequence.get(i2);
            boolean bl2 = listElement2.isGlue() && listElement2.getPosition() != null;
            boolean bl3 = bl = listElement != null && listElement.isBox();
            if (bl2 && bl && (leafPosition = this.getLeafPosition(listElement)) != null && leafPosition.getLM() instanceof TextLayoutManager) {
                TextLayoutManager textLayoutManager = (TextLayoutManager)((Object)leafPosition.getLM());
                textLayoutManager.addSpaceThatFollowsIfLastMapping(leafPosition);
            }
            listElement = listElement2;
        }
    }

    private LeafPosition getLeafPosition(ListElement listElement) {
        Position position;
        for (position = listElement.getPosition(); position != null && !(position instanceof LeafPosition); position = position.getPosition()) {
        }
        return (LeafPosition)position;
    }

    private List<KnuthSequence> supplementalBreakOfSequences(List<KnuthSequence> list) {
        ArrayList<KnuthSequence> arrayList = new ArrayList<KnuthSequence>();
        block0: for (KnuthSequence knuthSequence : list) {
            if (knuthSequence.isInlineSequence()) {
                while (!knuthSequence.isEmpty()) {
                    int n2 = this.findNextLineBreakIndex(0, knuthSequence);
                    if (n2 != -1 && n2 != knuthSequence.size() - 1) {
                        arrayList.add((KnuthSequence)new InlineKnuthSequence(knuthSequence.subList(0, n2 + 1)));
                        knuthSequence = new InlineKnuthSequence(knuthSequence.subList(n2 + 1, knuthSequence.size()));
                        continue;
                    }
                    arrayList.add(knuthSequence);
                    continue block0;
                }
                continue;
            }
            arrayList.add(knuthSequence);
        }
        return arrayList;
    }

    private int findNextLineBreakIndex(int n2, KnuthSequence knuthSequence) {
        int n3 = -1;
        boolean bl = false;
        for (int i2 = 0; i2 < knuthSequence.size() - 1; ++i2) {
            ListElement listElement = (ListElement)knuthSequence.get(i2);
            if (bl && listElement.isForcedBreak()) {
                n3 = i2;
                break;
            }
            bl = listElement.isBox() && !((KnuthElement)listElement).isAuxiliary() && ((KnuthElement)listElement).getWidth() != 0;
        }
        return n3;
    }

    private List<ListElement> createLineBreaks(int n2, LayoutContext layoutContext) {
        Iterator<KnuthSequence> iterator = this.knuthParagraphs.iterator();
        this.lineLayoutsList = new LineLayoutPossibilities[this.knuthParagraphs.size()];
        int n3 = 0;
        while (iterator.hasNext()) {
            KnuthSequence knuthSequence = iterator.next();
            LineLayoutPossibilities lineLayoutPossibilities = !knuthSequence.isInlineSequence() ? new LineLayoutPossibilities() : this.findOptimalBreakingPoints(n2, (Paragraph)knuthSequence, !iterator.hasNext());
            this.lineLayoutsList[n3] = lineLayoutPossibilities;
            ++n3;
        }
        this.setFinished(true);
        return this.postProcessLineBreaks(n2, layoutContext);
    }

    private LineLayoutPossibilities findOptimalBreakingPoints(int n2, Paragraph paragraph, boolean bl) {
        int n3;
        int n4;
        boolean bl2;
        this.lineLayouts = new LineLayoutPossibilities();
        double d2 = 1.0;
        LineBreakingAlgorithm lineBreakingAlgorithm = new LineBreakingAlgorithm(n2, this.textAlignment, this.textAlignmentLast, this.textIndent.getValue((PercentBaseContext)this), paragraph.lineFiller.getOpt(), this.lineHeight.getValue((PercentBaseContext)this), this.lead, this.follow, this.knuthParagraphs.indexOf((Object)paragraph) == 0, this.hyphenationLadderCount.getEnum() == 89 ? 0 : this.hyphenationLadderCount.getValue(), this);
        lineBreakingAlgorithm.setConstantLineWidth(this.ipd.getOpt());
        boolean bl3 = this.wrapOption != 93;
        boolean bl4 = this.isOverflowWrap();
        boolean bl5 = bl2 = bl3 && (this.hyphenationProperties.hyphenate.getEnum() == 149 || bl4);
        if (bl2 && !this.hyphenationPerformed) {
            this.hyphenationPerformed = bl;
            this.findHyphenationPoints(paragraph, bl4);
        }
        if ((n4 = lineBreakingAlgorithm.findBreakingPoints((KnuthSequence)paragraph, d2, false, n3 = bl3 ? 1 : 2)) == 0 || n2 == 70) {
            if (n4 > 0) {
                lineBreakingAlgorithm.resetAlgorithm();
                this.lineLayouts.savePossibilities(false);
            } else {
                log.debug((Object)("No set of breaking points found with maxAdjustment = " + d2));
            }
            log.debug((Object)("Hyphenation possible? " + bl2));
            boolean bl6 = this.fobj.getUserAgent().isSimpleLineBreaking();
            if (bl2 && n3 != 2) {
                n3 = 0;
            } else if (!bl6) {
                d2 = 5.0;
            }
            n4 = lineBreakingAlgorithm.findBreakingPoints((KnuthSequence)paragraph, d2, false, n3);
            if (n4 == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No set of breaking points found with maxAdjustment = " + d2 + (bl2 ? " and hyphenation" : "")));
                }
                if (!bl6) {
                    d2 = 20.0;
                }
                lineBreakingAlgorithm.findBreakingPoints((KnuthSequence)paragraph, d2, true, n3);
            }
            this.lineLayouts.restorePossibilities();
        }
        return this.lineLayouts;
    }

    private List<ListElement> postProcessLineBreaks(int n2, LayoutContext layoutContext) {
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        int n3 = this.fobj.getOrphans();
        int n4 = this.fobj.getWidows();
        int n5 = -1;
        for (int i2 = 0; i2 < this.knuthParagraphs.size(); ++i2) {
            Object object;
            Object object2;
            Keep keep;
            if (i2 > 0) {
                boolean bl;
                keep = this.getKeepTogether();
                boolean bl2 = bl = i2 >= n3 && i2 <= this.knuthParagraphs.size() - n4;
                if (bl || keep.getPenalty() != 0) {
                    linkedList.add((ListElement)new BreakElement(new Position((LayoutManager)this), keep.getPenalty(), keep.getContext(), layoutContext));
                }
            }
            keep = this.lineLayoutsList[i2];
            KnuthSequence knuthSequence = this.knuthParagraphs.get(i2);
            if (!knuthSequence.isInlineSequence()) {
                LinkedList<ListElement> linkedList2 = new LinkedList<ListElement>();
                LayoutManager layoutManager = null;
                for (Object e2 : knuthSequence) {
                    object2 = (ListElement)e2;
                    object = object2.getLayoutManager();
                    if (this.baselineOffset < 0 && object != null && object.hasLineAreaDescendant()) {
                        if (!this.useBaselineOfLastLine) {
                            this.baselineOffset = object.getBaselineOffset();
                        } else {
                            layoutManager = object;
                        }
                    }
                    if (object != this) {
                        object2.setPosition(this.notifyPos((Position)new NonLeafPosition((LayoutManager)this, object2.getPosition())));
                    }
                    linkedList2.add((ListElement)object2);
                }
                if (this.useBaselineOfLastLine && layoutManager != null) {
                    this.baselineOffset = layoutManager.getBaselineOffset();
                }
                linkedList.addAll(linkedList2);
                continue;
            }
            if (knuthSequence.isInlineSequence() && n2 == 70) {
                LeafPosition leafPosition = new LeafPosition((LayoutManager)this, i2);
                this.createElements(linkedList, (LineLayoutPossibilities)keep, (Position)leafPosition);
                continue;
            }
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (int i3 = 0; i3 < keep.getChosenLineCount(); ++i3) {
                if (this.handlingFloat()) {
                    n3 = 1;
                    n4 = 1;
                }
                if (linkedList.size() > 0 && i3 > 0 && i3 >= n3 && i3 <= keep.getChosenLineCount() - n4) {
                    object2 = this.getKeepTogether();
                    linkedList.add((ListElement)new BreakElement((Position)new LeafPosition((LayoutManager)this, i2, n5), object2.getPenalty(), object2.getContext(), layoutContext));
                }
                n5 = keep.getChosenPosition(i3).getLeafPos();
                object2 = FootenoteUtil.getFootnotes((List<ListElement>)knuthSequence, n6, n5);
                object = FloatContentLayoutManager.checkForFloats((List)knuthSequence, (int)n6, (int)n5);
                n6 = n5 + 1;
                LineBreakPosition lineBreakPosition = keep.getChosenPosition(i3);
                if (this.useBaselineOfLastLine) {
                    this.baselineOffset = n8 + lineBreakPosition.spaceBefore + lineBreakPosition.baseline;
                } else if (this.baselineOffset < 0) {
                    this.baselineOffset = lineBreakPosition.spaceBefore + lineBreakPosition.baseline;
                }
                if (object.isEmpty()) {
                    linkedList.add((ListElement)new KnuthBlockBox(lineBreakPosition.lineHeight + lineBreakPosition.spaceBefore + lineBreakPosition.spaceAfter, (List)object2, (Position)lineBreakPosition, false));
                } else {
                    linkedList.add((ListElement)new KnuthBlockBox(0, Collections.emptyList(), null, false, (List)object));
                    Keep keep2 = this.getKeepTogether();
                    linkedList.add((ListElement)new BreakElement((Position)new LeafPosition((LayoutManager)this, i2, n7), keep2.getPenalty(), keep2.getContext(), layoutContext));
                    linkedList.add((ListElement)new KnuthBlockBox(lineBreakPosition.lineHeight + lineBreakPosition.spaceBefore + lineBreakPosition.spaceAfter, (List)object2, (Position)lineBreakPosition, false));
                }
                n7 = n5;
                if (!this.useBaselineOfLastLine) continue;
                n8 += lineBreakPosition.lineHeight + lineBreakPosition.spaceBefore + lineBreakPosition.spaceAfter;
            }
        }
        return linkedList;
    }

    private void createElements(List<ListElement> list, LineLayoutPossibilities lineLayoutPossibilities, Position position) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.fobj.getOrphans();
        int n9 = this.fobj.getWidows();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (this.fobj.getOrphans() + this.fobj.getWidows() <= lineLayoutPossibilities.getMinLineCount()) {
            n3 = lineLayoutPossibilities.getMinLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            n4 = lineLayoutPossibilities.getMaxLineCount() - lineLayoutPossibilities.getOptLineCount();
            n6 = lineLayoutPossibilities.getOptLineCount() - lineLayoutPossibilities.getMinLineCount();
        } else if (this.fobj.getOrphans() + this.fobj.getWidows() <= lineLayoutPossibilities.getOptLineCount()) {
            n4 = lineLayoutPossibilities.getMaxLineCount() - lineLayoutPossibilities.getOptLineCount();
            n6 = lineLayoutPossibilities.getOptLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            n7 = this.fobj.getOrphans() + this.fobj.getWidows() - lineLayoutPossibilities.getMinLineCount();
        } else if (this.fobj.getOrphans() + this.fobj.getWidows() <= lineLayoutPossibilities.getMaxLineCount()) {
            n4 = lineLayoutPossibilities.getMaxLineCount() - (this.fobj.getOrphans() + this.fobj.getWidows());
            n5 = this.fobj.getOrphans() + this.fobj.getWidows() - lineLayoutPossibilities.getOptLineCount();
            n7 = lineLayoutPossibilities.getOptLineCount() - lineLayoutPossibilities.getMinLineCount();
            n8 -= n5;
        } else {
            n5 = lineLayoutPossibilities.getMaxLineCount() - lineLayoutPossibilities.getOptLineCount();
            n7 = lineLayoutPossibilities.getOptLineCount() - lineLayoutPossibilities.getMinLineCount();
            n8 = lineLayoutPossibilities.getOptLineCount();
            n9 = 0;
        }
        if (n9 != 0 && (n5 > 0 || n7 > 0)) {
            linkedList.add(new KnuthPenalty(0, 1000, false, position, false));
            linkedList.add(new KnuthGlue(0, -n5 * this.constantLineHeight, -n7 * this.constantLineHeight, Adjustment.LINE_NUMBER_ADJUSTMENT, position, false));
            linkedList.add(new KnuthPenalty(n5 * this.constantLineHeight, 0, false, position, false));
            linkedList.add(new KnuthGlue(0, n5 * this.constantLineHeight, n7 * this.constantLineHeight, Adjustment.LINE_NUMBER_ADJUSTMENT, position, false));
        } else if (n9 != 0) {
            linkedList.add(new KnuthPenalty(0, 0, false, position, false));
        }
        list.add((ListElement)new KnuthBox(n8 * this.constantLineHeight, position, n9 == 0 && n5 == 0 && n7 == 0));
        if (n5 > 0 || n7 > 0) {
            list.add((ListElement)new KnuthPenalty(0, 1000, false, position, false));
            list.add((ListElement)new KnuthGlue(0, n5 * this.constantLineHeight, n7 * this.constantLineHeight, Adjustment.LINE_NUMBER_ADJUSTMENT, position, false));
            list.add((ListElement)new KnuthBox(0, position, n9 == 0));
        }
        for (n2 = 0; n2 < n4; ++n2) {
            list.addAll(linkedList);
            list.add((ListElement)new KnuthBox(0, position, false));
            list.add((ListElement)new KnuthPenalty(0, 1000, false, position, false));
            list.add((ListElement)new KnuthGlue(0, this.constantLineHeight, 0, Adjustment.LINE_NUMBER_ADJUSTMENT, position, false));
            list.add((ListElement)new KnuthBox(0, position, false));
        }
        for (n2 = 0; n2 < n6; ++n2) {
            list.addAll(linkedList);
            list.add((ListElement)new KnuthBox(this.constantLineHeight, position, false));
            list.add((ListElement)new KnuthPenalty(0, 1000, false, position, false));
            list.add((ListElement)new KnuthGlue(0, 0, this.constantLineHeight, Adjustment.LINE_NUMBER_ADJUSTMENT, position, false));
            list.add((ListElement)new KnuthBox(0, position, false));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            list.addAll(linkedList);
            list.add((ListElement)new KnuthBox(this.constantLineHeight, position, false));
        }
        if (n9 > 0) {
            list.addAll(linkedList);
            list.add((ListElement)new KnuthBox(n9 * this.constantLineHeight, position, true));
        }
    }

    public boolean mustKeepTogether() {
        return ((BlockLevelLayoutManager)this.getParent()).mustKeepTogether();
    }

    public KeepProperty getKeepTogetherProperty() {
        return ((BlockLevelLayoutManager)this.getParent()).getKeepTogetherProperty();
    }

    public KeepProperty getKeepWithPreviousProperty() {
        return ((BlockLevelLayoutManager)this.getParent()).getKeepWithPreviousProperty();
    }

    public KeepProperty getKeepWithNextProperty() {
        return ((BlockLevelLayoutManager)this.getParent()).getKeepWithNextProperty();
    }

    public Keep getKeepTogether() {
        return ((BlockLevelLayoutManager)this.getParent()).getKeepTogether();
    }

    public boolean mustKeepWithPrevious() {
        return !this.getKeepWithPrevious().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.getKeepWithNext().isAuto();
    }

    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    public Keep getKeepWithPrevious() {
        return Keep.KEEP_AUTO;
    }

    public int negotiateBPDAdjustment(int n2, KnuthElement knuthElement) {
        Position position = knuthElement.getPosition();
        assert (position instanceof LeafPosition);
        LeafPosition leafPosition = (LeafPosition)position;
        int n3 = (int)Math.round((double)n2 / (double)this.constantLineHeight + (n2 > 0 ? -0.4 : 0.4));
        LineLayoutPossibilities lineLayoutPossibilities = this.lineLayoutsList[leafPosition.getLeafPos()];
        n3 = lineLayoutPossibilities.applyLineCountAdjustment(n3);
        return n3 * this.constantLineHeight;
    }

    public void discardSpace(KnuthGlue knuthGlue) {
    }

    @Override
    public List<ListElement> getChangedKnuthElements(List<ListElement> list, int n2, int n3) {
        return this.getChangedKnuthElements(list, n2);
    }

    @Override
    public List<ListElement> getChangedKnuthElements(List<ListElement> list, int n2) {
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        for (int i2 = 0; i2 < this.knuthParagraphs.size(); ++i2) {
            LineLayoutPossibilities lineLayoutPossibilities = this.lineLayoutsList[i2];
            int n3 = this.fobj.getOrphans();
            int n4 = this.fobj.getWidows();
            if (this.handlingFloat()) {
                n3 = 1;
                n4 = 1;
            }
            for (int i3 = 0; i3 < lineLayoutPossibilities.getChosenLineCount(); ++i3) {
                if (!((BlockLevelLayoutManager)this.parentLayoutManager).mustKeepTogether() && i3 >= n3 && i3 <= lineLayoutPossibilities.getChosenLineCount() - n4) {
                    linkedList.add((ListElement)new KnuthPenalty(0, 0, false, new Position((LayoutManager)this), false));
                }
                LineBreakPosition lineBreakPosition = lineLayoutPossibilities.getChosenPosition(i3);
                MinOptMax minOptMax = n2 == 70 ? MinOptMax.getInstance((int)(lineBreakPosition.lineWidth - lineBreakPosition.difference - lineBreakPosition.availableShrink), (int)(lineBreakPosition.lineWidth - lineBreakPosition.difference), (int)(lineBreakPosition.lineWidth - lineBreakPosition.difference + lineBreakPosition.availableStretch)) : (n2 == 23 ? MinOptMax.getInstance((int)(lineBreakPosition.lineWidth - 2 * lineBreakPosition.startIndent)) : (n2 == 39 ? MinOptMax.getInstance((int)(lineBreakPosition.lineWidth - lineBreakPosition.startIndent)) : MinOptMax.getInstance((int)(lineBreakPosition.lineWidth - lineBreakPosition.difference + lineBreakPosition.startIndent))));
                linkedList.add((ListElement)new KnuthBlockBox(lineBreakPosition.lineHeight, minOptMax, lineBreakPosition.ipdAdjust != 0.0 ? lineBreakPosition.lineWidth - lineBreakPosition.difference : 0, (Position)lineBreakPosition, false));
            }
        }
        return linkedList;
    }

    private void findHyphenationPoints(Paragraph paragraph, boolean bl) {
        ListIterator listIterator = paragraph.listIterator(paragraph.ignoreAtStart);
        LinkedList<Update> linkedList = new LinkedList<Update>();
        InlineLevelLayoutManager inlineLevelLayoutManager = null;
        while (listIterator.hasNext()) {
            int n2;
            HyphContext hyphContext;
            KnuthElement knuthElement = (KnuthElement)((Object)listIterator.next());
            if (knuthElement.getLayoutManager() != inlineLevelLayoutManager) {
                inlineLevelLayoutManager = (InlineLevelLayoutManager)knuthElement.getLayoutManager();
                if (inlineLevelLayoutManager == null) break;
                linkedList.add(new Update(inlineLevelLayoutManager, listIterator.previousIndex()));
            } else if (inlineLevelLayoutManager == null) break;
            if (!knuthElement.isBox() || knuthElement.isAuxiliary()) continue;
            int n3 = 1;
            int n4 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(inlineLevelLayoutManager.getWordChars(knuthElement.getPosition()));
            while (listIterator.hasNext()) {
                KnuthElement knuthElement2 = (KnuthElement)((Object)listIterator.next());
                if (knuthElement2.isBox() && !knuthElement2.isAuxiliary()) {
                    if (inlineLevelLayoutManager != knuthElement2.getLayoutManager()) {
                        inlineLevelLayoutManager = (InlineLevelLayoutManager)knuthElement2.getLayoutManager();
                        linkedList.add(new Update(inlineLevelLayoutManager, listIterator.previousIndex()));
                    }
                    ++n3;
                    stringBuffer.append(inlineLevelLayoutManager.getWordChars(knuthElement2.getPosition()));
                    continue;
                }
                if (!knuthElement2.isAuxiliary()) {
                    listIterator.previous();
                    break;
                }
                if (inlineLevelLayoutManager != knuthElement2.getLayoutManager()) {
                    inlineLevelLayoutManager = (InlineLevelLayoutManager)knuthElement2.getLayoutManager();
                    linkedList.add(new Update(inlineLevelLayoutManager, listIterator.previousIndex()));
                }
                ++n4;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)(" Word to hyphenate: " + stringBuffer));
            }
            if ((hyphContext = this.getHyphenContext(stringBuffer, bl)) == null) continue;
            KnuthElement knuthElement3 = null;
            for (n2 = 0; n2 < n3 + n4; ++n2) {
                listIterator.previous();
            }
            for (n2 = 0; n2 < n3 + n4; ++n2) {
                knuthElement3 = (KnuthElement)((Object)listIterator.next());
                if (!knuthElement3.isBox() || knuthElement3.isAuxiliary()) continue;
                ((InlineLevelLayoutManager)knuthElement3.getLayoutManager()).hyphenate(knuthElement3.getPosition(), hyphContext);
            }
        }
        this.processUpdates(paragraph, linkedList);
    }

    private void processUpdates(Paragraph paragraph, List<Update> list) {
        ListIterator<Update> listIterator = list.listIterator();
        int n2 = 0;
        while (listIterator.hasNext()) {
            int n3;
            Object object;
            Update update = listIterator.next();
            int n4 = update.firstIndex;
            if (listIterator.hasNext()) {
                object = listIterator.next();
                n3 = ((Update)object).firstIndex;
                listIterator.previous();
            } else {
                n3 = paragraph.size() - paragraph.ignoreAtEnd - n2;
            }
            if (!update.inlineLM.applyChanges(paragraph.subList(n4 + n2, n3 + n2))) continue;
            object = update.inlineLM.getChangedKnuthElements(paragraph.subList(n4 + n2, n3 + n2), this.effectiveAlignment);
            paragraph.subList(n4 + n2, n3 + n2).clear();
            paragraph.addAll(n4 + n2, (Collection)object);
            n2 += object.size() - (n3 - n4);
        }
        list.clear();
    }

    @Override
    protected boolean hasLeadingFence(boolean bl) {
        return true;
    }

    @Override
    protected boolean hasTrailingFence(boolean bl) {
        return true;
    }

    private HyphContext getHyphenContext(StringBuffer stringBuffer, boolean bl) {
        HyphContext hyphContext = null;
        if (this.hyphenationProperties.hyphenate.getEnum() == 149) {
            Hyphenation hyphenation = Hyphenator.hyphenate((String)this.hyphenationProperties.language.getString(), (String)this.hyphenationProperties.country.getString(), (InternalResourceResolver)this.getFObj().getUserAgent().getHyphenationResourceResolver(), (Map)this.getFObj().getUserAgent().getHyphenationPatternNames(), (String)stringBuffer.toString(), (int)this.hyphenationProperties.hyphenationRemainCharacterCount.getValue(), (int)this.hyphenationProperties.hyphenationPushCharacterCount.getValue(), (FOUserAgent)this.getFObj().getUserAgent());
            if (hyphenation != null) {
                int[] nArray;
                int[] nArray2 = hyphenation.getHyphenationPoints();
                if (aggressiveHyphenation && (nArray = this.getExtendedHyphenationPoints(stringBuffer)) != null) {
                    nArray2 = LineLayoutManager.mergeArrays(nArray2, nArray);
                }
                hyphContext = new HyphContext(nArray2);
            }
        } else {
            hyphContext = new HyphContext(this.getOverflowWrapHyphenationPoints(stringBuffer));
            hyphContext.setOverflowWrapBreakWord(true);
        }
        return hyphContext;
    }

    private int[] getOverflowWrapHyphenationPoints(StringBuffer stringBuffer) {
        int[] nArray;
        int n2 = stringBuffer.length() - 3;
        if (n2 > 0) {
            nArray = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = i2 + 1;
            }
        } else {
            nArray = NO_HYPHENATION_POINTS;
        }
        return nArray;
    }

    private boolean isOverflowWrap() {
        boolean bl = false;
        for (Object object = this.getFObj(); object != null; object = object.getParent()) {
            Map map;
            String string;
            if (!(object instanceof FObj) || (string = (String)(map = object.getForeignAttributes()).get(ChemistryExtensions.ATT_QNAME_OVERFLOW_WRAP)) == null) continue;
            bl = "break-word".equals(string);
            break;
        }
        if (bl && this.textAlignment == 70) {
            log.warn((Object)"Cannot apply overflow-wrap:break-word when having text-align:justified. Ignoring overflow-wrap.");
            bl = false;
        }
        if (bl && this.hyphenationProperties.hyphenate.getEnum() == 149) {
            log.warn((Object)"Cannot apply overflow-wrap:break-word when having hyphenation on. Ignoring overflow-wrap.");
            bl = false;
        }
        return bl;
    }

    private int[] getExtendedHyphenationPoints(StringBuffer stringBuffer) {
        int n2;
        ArrayList<Integer> arrayList = null;
        int n3 = 0;
        int n4 = stringBuffer.length();
        for (int i2 = 0; i2 < n4; ++i2) {
            n2 = -1;
            if (n4 > 15 && stringBuffer.charAt(i2) == '.') {
                if (++n3 > 1) {
                    n2 = i2;
                }
            } else if (i2 < n4 - 1 && (stringBuffer.charAt(i2) == '_' || Character.isLowerCase(stringBuffer.charAt(i2)) && Character.isUpperCase(stringBuffer.charAt(i2 + 1)))) {
                n2 = i2 + 1;
            }
            if (n2 == -1) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
            }
            arrayList.add(n2);
        }
        int[] nArray = null;
        if (arrayList != null) {
            nArray = new int[arrayList.size()];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = (Integer)arrayList.get(n2);
            }
        }
        return nArray;
    }

    public static int[] mergeArrays(int[] nArray, int[] nArray2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray.length;
        int n6 = nArray2.length;
        int[] nArray3 = new int[n5 + n6];
        while (n2 < n5 && n3 < n6) {
            if (nArray[n2] < nArray2[n3]) {
                nArray3[n4++] = nArray[n2++];
                continue;
            }
            nArray3[n4++] = nArray2[n3++];
        }
        while (n2 < n5) {
            nArray3[n4++] = nArray[n2++];
        }
        while (n3 < n6) {
            nArray3[n4++] = nArray2[n3++];
        }
        return nArray3;
    }

    @Override
    public boolean hasLineAreaDescendant() {
        return true;
    }

    @Override
    public int getBaselineOffset() {
        return this.baselineOffset;
    }

    @Override
    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        while (positionIterator.hasNext()) {
            boolean bl;
            Position position = positionIterator.next();
            boolean bl2 = bl = !positionIterator.hasNext();
            if (position instanceof LineBreakPosition) {
                this.addInlineArea(layoutContext, (LineBreakPosition)position, bl);
                continue;
            }
            if (!(position instanceof NonLeafPosition) || !position.generatesAreas()) continue;
            this.addBlockArea(layoutContext, position, bl);
        }
        this.setCurrentArea(null);
    }

    private void addInlineArea(LayoutContext layoutContext, LineBreakPosition lineBreakPosition, boolean bl) {
        LayoutManager layoutManager;
        Object object;
        KnuthSequence knuthSequence = this.knuthParagraphs.get(lineBreakPosition.parIndex);
        int n2 = lineBreakPosition.startIndex;
        int n3 = lineBreakPosition.getLeafPos();
        LineArea lineArea = new LineArea(lineBreakPosition.getLeafPos() < knuthSequence.size() - 1 ? this.textAlignment : this.textAlignmentLast, lineBreakPosition.difference, lineBreakPosition.availableStretch, lineBreakPosition.availableShrink);
        lineArea.setChangeBarList(this.getChangeBarList());
        if (lineBreakPosition.startIndent != 0) {
            lineArea.addTrait(Trait.START_INDENT, (Object)lineBreakPosition.startIndent);
        }
        if (lineBreakPosition.endIndent != 0) {
            lineArea.addTrait(Trait.END_INDENT, (Object)lineBreakPosition.endIndent);
        }
        lineArea.setBPD(lineBreakPosition.lineHeight);
        lineArea.setIPD(lineBreakPosition.lineWidth);
        lineArea.setBidiLevel(this.bidiLevel);
        lineArea.addTrait(Trait.SPACE_BEFORE, (Object)lineBreakPosition.spaceBefore);
        lineArea.addTrait(Trait.SPACE_AFTER, (Object)lineBreakPosition.spaceAfter);
        this.alignmentContext.resizeLine(lineBreakPosition.lineHeight, lineBreakPosition.baseline);
        if (knuthSequence instanceof Paragraph) {
            object = (Paragraph)knuthSequence;
            n2 += n2 == 0 ? ((Paragraph)((Object)object)).ignoreAtStart : 0;
            if (n3 == object.size() - 1) {
                n3 -= ((Paragraph)((Object)object)).ignoreAtEnd;
                lineArea.setIPD(lineArea.getIPD() - this.lastLineEndIndent.getValue((PercentBaseContext)this));
            }
        }
        object = knuthSequence.listIterator(n3);
        KnuthElement knuthElement = (KnuthElement)((Object)object.next());
        LayoutManager layoutManager2 = knuthElement.getLayoutManager();
        if (knuthElement.isGlue() && (this.whiteSpaceTreament == 63 || this.whiteSpaceTreament == 60 || this.whiteSpaceTreament == 62)) {
            --n3;
            object.previous();
            if (object.hasPrevious()) {
                layoutManager2 = ((KnuthElement)((Object)object.previous())).getLayoutManager();
            }
        }
        if (this.whiteSpaceTreament == 63 || this.whiteSpaceTreament == 60 || this.whiteSpaceTreament == 61) {
            object = knuthSequence.listIterator(n2);
            while (object.hasNext() && !((KnuthElement)((Object)object.next())).isBox()) {
                ++n2;
            }
        }
        KnuthPossPosIter knuthPossPosIter = new KnuthPossPosIter((List)knuthSequence, n2, n3 + 1);
        LayoutContext layoutContext2 = LayoutContext.offspringOf(layoutContext);
        layoutContext2.setAlignmentContext(this.alignmentContext);
        layoutContext2.setSpaceAdjust(lineBreakPosition.dAdjust);
        layoutContext2.setIPDAdjust(lineBreakPosition.ipdAdjust);
        layoutContext2.setLeadingSpace(new SpaceSpecifier(true));
        layoutContext2.setTrailingSpace(new SpaceSpecifier(false));
        layoutContext2.setFlags(16, true);
        this.setCurrentArea((Area)lineArea);
        this.setChildContext(layoutContext2);
        while ((layoutManager = knuthPossPosIter.getNextChildLM()) != null) {
            layoutContext2.setFlags(8, layoutManager == layoutManager2);
            layoutManager.addAreas((PositionIterator)knuthPossPosIter, layoutContext2);
            layoutContext2.setLeadingSpace(layoutContext2.getTrailingSpace());
            layoutContext2.setTrailingSpace(new SpaceSpecifier(false));
        }
        if (!(layoutContext.getSpaceAfter() <= 0 || layoutContext.isLastArea() && bl)) {
            lineArea.setBPD(lineArea.getBPD() + layoutContext.getSpaceAfter());
        }
        lineArea.finish();
        if (lineArea.getBidiLevel() >= 0) {
            BidiResolver.reorder(lineArea);
        }
        this.parentLayoutManager.addChildArea((Area)lineArea);
    }

    private void addBlockArea(LayoutContext layoutContext, Position position, boolean bl) {
        LayoutManager layoutManager;
        ArrayList<Position> arrayList = new ArrayList<Position>(1);
        Position position2 = position.getPosition();
        arrayList.add(position2);
        LayoutManager layoutManager2 = null;
        if (bl) {
            layoutManager2 = position2.getLM();
        }
        LineArea lineArea = new LineArea();
        lineArea.setChangeBarList(this.getChangeBarList());
        this.setCurrentArea((Area)lineArea);
        LayoutContext layoutContext2 = LayoutContext.newInstance();
        layoutContext2.setAlignmentContext(this.alignmentContext);
        this.setChildContext(layoutContext2);
        PositionIterator positionIterator = new PositionIterator(arrayList.listIterator());
        LayoutContext layoutContext3 = LayoutContext.offspringOf(layoutContext);
        layoutContext3.setLeadingSpace(new SpaceSpecifier(true));
        layoutContext3.setTrailingSpace(new SpaceSpecifier(false));
        layoutContext3.setFlags(16, true);
        while ((layoutManager = positionIterator.getNextChildLM()) != null) {
            layoutContext3.setFlags(8, layoutContext.isLastArea() && layoutManager == layoutManager2);
            layoutContext3.setStackLimitBP(layoutContext.getStackLimitBP());
            layoutManager.addAreas(positionIterator, layoutContext3);
            layoutContext3.setLeadingSpace(layoutContext3.getTrailingSpace());
            layoutContext3.setTrailingSpace(new SpaceSpecifier(false));
        }
        lineArea.updateExtentsFromChildren();
        if (lineArea.getBidiLevel() >= 0) {
            BidiResolver.reorder(lineArea);
        }
        this.parentLayoutManager.addChildArea((Area)lineArea);
    }

    @Override
    public void addChildArea(Area area) {
        if (area instanceof InlineArea) {
            Area area2 = this.getCurrentArea();
            if (this.getContext().resolveLeadingSpace()) {
                this.addSpace(area2, this.getContext().getLeadingSpace().resolve(false), this.getContext().getSpaceAdjust());
            }
            area2.addChildArea(area);
        }
    }

    @Override
    public boolean getGeneratesBlockArea() {
        return true;
    }

    @Override
    public boolean getGeneratesLineArea() {
        return true;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    public boolean handleOverflow(int n2) {
        if (this.inAutoLayoutDeterminationMode) {
            return true;
        }
        if (this.getParent() instanceof BlockLayoutManager) {
            return ((BlockLayoutManager)((Object)this.getParent())).handleOverflow(n2);
        }
        return false;
    }

    @Override
    public int getMinimumIPD() {
        int n2 = 0;
        n2 = this.wrapOption == 93 ? this.getMaximumIPD() : super.getMinimumIPD();
        return n2;
    }

    @Override
    public int getMaximumIPD() {
        int n2 = 0;
        for (LayoutManager layoutManager : this.getChildLMs()) {
            int n3 = layoutManager.getMaximumIPD();
            if (n3 <= 0) continue;
            n2 += n3;
        }
        return n2;
    }

    private static class Paragraph
    extends InlineKnuthSequence {
        private static final long serialVersionUID = 5862072380375189105L;
        private int ignoreAtStart;
        private int ignoreAtEnd;
        private MinOptMax lineFiller;
        private final int textAlignment;
        private final int textAlignmentLast;
        private final int textIndent;
        private final int lastLineEndIndent;
        private final LineLayoutManager layoutManager;

        Paragraph(LineLayoutManager lineLayoutManager, int n2, int n3, int n4, int n5) {
            this.layoutManager = lineLayoutManager;
            this.textAlignment = n2;
            this.textAlignmentLast = n3;
            this.textIndent = n4;
            this.lastLineEndIndent = n5;
        }

        public void startSequence() {
            this.lineFiller = this.textAlignment == 23 ? MinOptMax.getInstance((int)this.lastLineEndIndent) : (this.layoutManager.ipd.getOpt() < this.lastLineEndIndent ? MinOptMax.getInstance((int)this.lastLineEndIndent) : MinOptMax.getInstance((int)this.lastLineEndIndent, (int)this.lastLineEndIndent, (int)this.layoutManager.ipd.getOpt()));
            if (this.textAlignment == 23 && this.textAlignmentLast != 70) {
                this.add(new KnuthGlue(0, 10008, 0, null, false));
                ++this.ignoreAtStart;
            }
            if (this.layoutManager.isFirstInBlock && this.layoutManager.knuthParagraphs.size() == 0 && this.textIndent != 0) {
                this.add((Object)new KnuthInlineBox(this.textIndent, null, null, false));
                ++this.ignoreAtStart;
            }
        }

        public void endParagraph() {
            KnuthSequence knuthSequence = this.endSequence();
            if (knuthSequence != null) {
                this.layoutManager.knuthParagraphs.add(knuthSequence);
            }
        }

        public KnuthSequence endSequence() {
            if (this.size() > this.ignoreAtStart) {
                if (this.textAlignment == 23 && this.textAlignmentLast != 70) {
                    this.add(new KnuthGlue(0, 10008, 0, null, false));
                    this.add(new KnuthPenalty(this.lineFiller.getOpt(), -1000, false, null, false));
                    this.ignoreAtEnd = 2;
                } else if (this.textAlignmentLast != 70) {
                    this.add(new KnuthPenalty(0, 1000, false, null, false));
                    this.add(new KnuthGlue(0, this.lineFiller.getStretch(), this.lineFiller.getShrink(), null, false));
                    this.add(new KnuthPenalty(this.lineFiller.getOpt(), -1000, false, null, false));
                    this.ignoreAtEnd = 3;
                } else {
                    this.add(new KnuthPenalty(this.lineFiller.getOpt(), -1000, false, null, false));
                    this.ignoreAtEnd = 1;
                }
                return this;
            }
            this.clear();
            return null;
        }

        public boolean containsBox() {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                KnuthElement knuthElement = (KnuthElement)((Object)e2);
                if (!knuthElement.isBox()) continue;
                return true;
            }
            return false;
        }
    }

    private class LineBreakingAlgorithm
    extends BreakingAlgorithm {
        private final LineLayoutManager thisLLM;
        private final int pageAlignment;
        private int activePossibility;
        private int addedPositions;
        private final int textIndent;
        private final int lineHeight;
        private final int lead;
        private final int follow;
        private static final double MAX_DEMERITS = 1.0E7;

        public LineBreakingAlgorithm(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl, int n10, LineLayoutManager lineLayoutManager2) {
            super(n3, n4, bl, false, n10);
            this.pageAlignment = n2;
            this.textIndent = n5;
            this.lineHeight = n7;
            this.lead = n8;
            this.follow = n9;
            this.thisLLM = lineLayoutManager2;
            this.activePossibility = -1;
        }

        public void updateData1(int n2, double d2) {
            LineLayoutManager.this.lineLayouts.addPossibility(n2, d2);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Layout possibility in " + n2 + " lines; break at position:"));
            }
        }

        public void updateData2(BreakingAlgorithm.KnuthNode knuthNode, KnuthSequence knuthSequence, int n2) {
            int n3;
            double d2;
            int n4;
            int n5;
            int n6 = knuthNode.difference;
            int n7 = knuthNode.line < n2 ? this.alignment : this.alignmentLast;
            switch (n7) {
                case 135: {
                    n5 = 0;
                    n4 = n6 > 0 ? n6 : 0;
                    break;
                }
                case 39: {
                    n5 = n6;
                    n4 = 0;
                    break;
                }
                case 23: {
                    n4 = n5 = n6 / 2;
                    break;
                }
                default: {
                    n5 = 0;
                    n4 = 0;
                }
            }
            n5 += knuthNode.line == 1 && this.indentFirstPart && LineLayoutManager.this.isFirstInBlock ? this.textIndent : 0;
            double d3 = d2 = n7 == 70 || n6 < 0 && -n6 <= knuthNode.availableShrink ? knuthNode.adjustRatio : 0.0;
            if (this.activePossibility == -1) {
                this.activePossibility = 0;
                this.addedPositions = 0;
            }
            if (this.addedPositions == LineLayoutManager.this.lineLayouts.getLineCount(this.activePossibility)) {
                ++this.activePossibility;
                this.addedPositions = 0;
            }
            if ((n3 = n6 + knuthNode.availableShrink) < 0 && !LineLayoutManager.this.handleOverflow(-n3)) {
                InlineLevelEventProducer inlineLevelEventProducer = InlineLevelEventProducer.Provider.get((EventBroadcaster)LineLayoutManager.this.getFObj().getUserAgent().getEventBroadcaster());
                if (LineLayoutManager.this.curChildLM.getFObj() == null) {
                    inlineLevelEventProducer.lineOverflows((Object)this, LineLayoutManager.this.getFObj().getName(), knuthNode.line, -n3, LineLayoutManager.this.getFObj().getLocator());
                } else {
                    inlineLevelEventProducer.lineOverflows((Object)this, LineLayoutManager.this.curChildLM.getFObj().getName(), knuthNode.line, -n3, LineLayoutManager.this.curChildLM.getFObj().getLocator());
                }
            }
            LineLayoutManager.this.lineLayouts.addBreakPosition(this.makeLineBreakPosition(knuthSequence, knuthNode.line > 1 ? knuthNode.previous.position + 1 : 0, knuthNode.position, knuthNode.availableShrink - (this.addedPositions > 0 ? 0 : ((Paragraph)knuthSequence).lineFiller.getShrink()), knuthNode.availableStretch, n6, d2, n5, n4), this.activePossibility);
            ++this.addedPositions;
        }

        public void resetAlgorithm() {
            this.activePossibility = -1;
        }

        private LineBreakPosition makeLineBreakPosition(KnuthSequence knuthSequence, int n2, int n3, int n4, int n5, int n6, double d2, int n7, int n8) {
            boolean bl;
            int n9 = (this.lineHeight - this.lead - this.follow) / 2;
            int n10 = this.lineHeight - this.lead - this.follow - n9;
            int n11 = this.lead;
            int n12 = this.follow;
            boolean bl2 = bl = n6 == LineLayoutManager.this.ipd.getOpt();
            if (LineLayoutManager.this.fobj.getLineStackingStrategy() != 52) {
                ListIterator listIterator = knuthSequence.listIterator(n2);
                AlignmentContext alignmentContext = null;
                int n13 = 0;
                for (int i2 = n2; i2 <= n3; ++i2) {
                    KnuthElement knuthElement = (KnuthElement)((Object)listIterator.next());
                    if (!(knuthElement instanceof KnuthInlineBox)) continue;
                    AlignmentContext alignmentContext2 = ((KnuthInlineBox)((Object)knuthElement)).getAlignmentContext();
                    if (alignmentContext2 != null && alignmentContext != alignmentContext2) {
                        if (!alignmentContext2.usesInitialBaselineTable() || alignmentContext2.getAlignmentBaselineIdentifier() != 14 && alignmentContext2.getAlignmentBaselineIdentifier() != 4) {
                            if (LineLayoutManager.this.fobj.getLineHeightShiftAdjustment() == 30 || alignmentContext2.getBaselineShiftValue() == 0) {
                                int n14 = alignmentContext2.getTotalAlignmentBaselineOffset();
                                if (n14 + alignmentContext2.getAltitude() > n11) {
                                    n11 = n14 + alignmentContext2.getAltitude();
                                }
                                if (alignmentContext2.getDepth() - n14 > n12) {
                                    n12 = alignmentContext2.getDepth() - n14;
                                }
                            }
                        } else if (alignmentContext2.getHeight() > n13) {
                            n13 = alignmentContext2.getHeight();
                        }
                        alignmentContext = alignmentContext2;
                    }
                    if (!bl || knuthElement.isAuxiliary() && (alignmentContext2 == null || alignmentContext2.getHeight() <= 0)) continue;
                    bl = false;
                }
                if (n12 < n13 - n11) {
                    n12 = n13 - n11;
                }
            }
            LineLayoutManager.this.constantLineHeight = n11 + n12;
            if (bl) {
                return new LineBreakPosition(this.thisLLM, LineLayoutManager.this.knuthParagraphs.indexOf(knuthSequence), n2, n3, n4, n5, n6, d2, 0.0, n7, n8, 0, LineLayoutManager.this.ipd.getOpt(), 0, 0, 0);
            }
            return new LineBreakPosition(this.thisLLM, LineLayoutManager.this.knuthParagraphs.indexOf(knuthSequence), n2, n3, n4, n5, n6, d2, 0.0, n7, n8, n11 + n12, LineLayoutManager.this.ipd.getOpt(), n9, n10, n11);
        }

        protected int filterActiveNodes() {
            BreakingAlgorithm.KnuthNode knuthNode = null;
            if (this.pageAlignment == 70) {
                BreakingAlgorithm.KnuthNode knuthNode2;
                int n2;
                for (n2 = this.startLine; n2 < this.endLine; ++n2) {
                    knuthNode2 = this.getNode(n2);
                    while (knuthNode2 != null) {
                        knuthNode = this.compareNodes(knuthNode, knuthNode2);
                        knuthNode2 = knuthNode2.next;
                    }
                }
                for (n2 = this.startLine; n2 < this.endLine; ++n2) {
                    knuthNode2 = this.getNode(n2);
                    while (knuthNode2 != null) {
                        if (knuthNode2.line != knuthNode.line && knuthNode2.totalDemerits > 1.0E7) {
                            this.removeNode(n2, knuthNode2);
                        }
                        knuthNode2 = knuthNode2.next;
                    }
                }
            } else {
                for (int i2 = this.startLine; i2 < this.endLine; ++i2) {
                    BreakingAlgorithm.KnuthNode knuthNode3 = this.getNode(i2);
                    while (knuthNode3 != null) {
                        if (knuthNode3 != (knuthNode = this.compareNodes(knuthNode, knuthNode3))) {
                            this.removeNode(i2, knuthNode3);
                        }
                        knuthNode3 = knuthNode3.next;
                    }
                }
            }
            return knuthNode.line;
        }
    }

    public static class LineBreakPosition
    extends LeafPosition {
        private final int parIndex;
        private final int startIndex;
        private final int availableShrink;
        private final int availableStretch;
        private final int difference;
        private final double dAdjust;
        private final double ipdAdjust;
        private final int startIndent;
        private final int endIndent;
        private final int lineHeight;
        private final int lineWidth;
        private final int spaceBefore;
        private final int spaceAfter;
        private final int baseline;

        LineBreakPosition(LayoutManager layoutManager, int n2, int n3, int n4, int n5, int n6, int n7, double d2, double d3, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
            super(layoutManager, n4);
            this.availableShrink = n5;
            this.availableStretch = n6;
            this.difference = n7;
            this.parIndex = n2;
            this.startIndex = n3;
            this.ipdAdjust = d2;
            this.dAdjust = d3;
            this.startIndent = n8;
            this.endIndent = n9;
            this.lineHeight = n10;
            this.lineWidth = n11;
            this.spaceBefore = n12;
            this.spaceAfter = n13;
            this.baseline = n14;
        }
    }

    private final class Update {
        private final InlineLevelLayoutManager inlineLM;
        private final int firstIndex;

        private Update(InlineLevelLayoutManager inlineLevelLayoutManager, int n2) {
            this.inlineLM = inlineLevelLayoutManager;
            this.firstIndex = n2;
        }
    }
}

