/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Container;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.datatypes.SimplePercentBaseContext;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fo.flow.InlineContainer;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.InlineLevelEventProducer;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;

public class InlineContainerLayoutManager
extends AbstractLayoutManager
implements InlineLevelLayoutManager {
    private CommonBorderPaddingBackground borderProps;
    private int contentAreaIPD;
    private int contentAreaBPD;
    private List<ListElement> childElements;
    private int ipdOverflow;
    private AlignmentContext alignmentContext;
    private InlineViewport currentViewport;
    private Container referenceArea;

    public InlineContainerLayoutManager(InlineContainer inlineContainer) {
        super(inlineContainer);
        this.setGeneratesReferenceArea(true);
    }

    @Override
    public void initialize() {
        InlineContainer inlineContainer = (InlineContainer)this.fobj;
        this.borderProps = inlineContainer.getCommonBorderPaddingBackground();
    }

    private InlineContainer getInlineContainer() {
        assert (this.fobj instanceof InlineContainer);
        return (InlineContainer)this.fobj;
    }

    @Override
    public List<KnuthSequence> getNextKnuthElements(LayoutContext layoutContext, int n2) {
        this.determineIPD(layoutContext);
        this.childElements = this.getChildKnuthElements(layoutContext, n2);
        this.determineBPD();
        this.alignmentContext = this.makeAlignmentContext(layoutContext);
        Position position = new Position((LayoutManager)this, 0);
        InlineKnuthSequence inlineKnuthSequence = new InlineKnuthSequence();
        inlineKnuthSequence.add((Object)this.getKnuthInlineBox(position));
        ArrayList<KnuthSequence> arrayList = new ArrayList<KnuthSequence>(1);
        arrayList.add((KnuthSequence)inlineKnuthSequence);
        this.setFinished(true);
        return arrayList;
    }

    private KnuthInlineBox getKnuthInlineBox(Position position) {
        KnuthInlineBox knuthInlineBox = new KnuthInlineBox(this.contentAreaIPD, this.alignmentContext, position, false);
        List<FootnoteBodyLayoutManager> list = knuthInlineBox.getFootnoteBodyLMs();
        if (!this.childElements.isEmpty()) {
            for (ListElement listElement : this.childElements) {
                if (!(listElement instanceof KnuthBlockBox) || !((KnuthBlockBox)listElement).hasAnchors()) continue;
                List list2 = ((KnuthBlockBox)listElement).getFootnoteBodyLMs();
                list.addAll(list2);
            }
            knuthInlineBox = new KnuthInlineBox(this.contentAreaIPD, list, this.alignmentContext, position, false);
        }
        return knuthInlineBox;
    }

    private void determineIPD(LayoutContext layoutContext) {
        LengthRangeProperty lengthRangeProperty = this.getInlineContainer().getInlineProgressionDimension();
        Property property = lengthRangeProperty.getOptimum((PercentBaseContext)this);
        if (property.isAuto()) {
            this.contentAreaIPD = layoutContext.getRefIPD();
            InlineLevelEventProducer inlineLevelEventProducer = InlineLevelEventProducer.Provider.get((EventBroadcaster)this.fobj.getUserAgent().getEventBroadcaster());
            inlineLevelEventProducer.inlineContainerAutoIPDNotSupported((Object)this, (float)this.contentAreaIPD / 1000.0f);
        } else {
            this.contentAreaIPD = property.getLength().getValue((PercentBaseContext)this);
        }
    }

    private List<ListElement> getChildKnuthElements(LayoutContext layoutContext, int n2) {
        LayoutManager layoutManager;
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        while ((layoutManager = this.getChildLM()) != null) {
            LayoutContext layoutContext2 = LayoutContext.offspringOf(layoutContext);
            layoutContext2.setRefIPD(this.contentAreaIPD);
            List list = layoutManager.getNextKnuthElements(layoutContext2, n2);
            linkedList.addAll(list);
        }
        this.handleIPDOverflow();
        this.wrapPositions(linkedList);
        SpaceResolver.resolveElementList(linkedList);
        SpaceResolver.performConditionalsNotification(linkedList, 0, linkedList.size() - 1, -1);
        return linkedList;
    }

    private void determineBPD() {
        LengthRangeProperty lengthRangeProperty = this.getInlineContainer().getBlockProgressionDimension();
        Property property = lengthRangeProperty.getOptimum((PercentBaseContext)this);
        int n2 = ElementListUtils.calcContentLength(this.childElements);
        if (property.isAuto()) {
            this.contentAreaBPD = n2;
        } else {
            double d2 = property.getLength().getNumericValue((PercentBaseContext)this);
            if (d2 < 0.0) {
                this.contentAreaBPD = n2;
            } else {
                this.contentAreaBPD = (int)Math.round(d2);
                if (this.contentAreaBPD < n2) {
                    BlockLevelEventProducer blockLevelEventProducer = this.getBlockLevelEventProducer();
                    blockLevelEventProducer.viewportBPDOverflow(this, this.fobj.getName(), n2 - this.contentAreaBPD, this.needClip(), this.canRecoverFromOverflow(), this.fobj.getLocator());
                }
            }
        }
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext layoutContext) {
        InlineContainer inlineContainer = (InlineContainer)this.fobj;
        AlignmentContext alignmentContext = new AlignmentContext(this.contentAreaBPD, inlineContainer.getAlignmentAdjust(), inlineContainer.getAlignmentBaseline(), inlineContainer.getBaselineShift(), inlineContainer.getDominantBaseline(), layoutContext.getAlignmentContext());
        int n2 = this.getAlignmentPoint(alignmentContext.getDominantBaselineIdentifier());
        alignmentContext.resizeLine(this.contentAreaBPD, n2);
        return alignmentContext;
    }

    private void handleIPDOverflow() {
        if (this.ipdOverflow > 0) {
            BlockLevelEventProducer blockLevelEventProducer = this.getBlockLevelEventProducer();
            blockLevelEventProducer.viewportIPDOverflow(this, this.fobj.getName(), this.ipdOverflow, this.needClip(), this.canRecoverFromOverflow(), this.fobj.getLocator());
        }
    }

    private void wrapPositions(List<ListElement> list) {
        for (ListElement listElement : list) {
            NonLeafPosition nonLeafPosition = new NonLeafPosition((LayoutManager)this, listElement.getPosition());
            this.notifyPos((Position)nonLeafPosition);
            listElement.setPosition((Position)nonLeafPosition);
        }
    }

    private BlockLevelEventProducer getBlockLevelEventProducer() {
        return BlockLevelEventProducer.Provider.get(this.fobj.getUserAgent().getEventBroadcaster());
    }

    private boolean canRecoverFromOverflow() {
        return this.getInlineContainer().getOverflow() != 42;
    }

    private int getAlignmentPoint(int n2) {
        Length length = this.getInlineContainer().getAlignmentAdjust();
        int n3 = length.getEnum();
        if (n3 == 9) {
            return this.getInlineContainerBaselineOffset(this.getInlineContainer().getAlignmentBaseline());
        }
        if (n3 == 12) {
            return this.getInlineContainerBaselineOffset(n2);
        }
        if (n3 != 0) {
            return this.getInlineContainerBaselineOffset(n3);
        }
        int n4 = this.getInlineContainerBaselineOffset(n2);
        int n5 = this.getInlineContainer().getLineHeight().getOptimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this);
        int n6 = length.getValue((PercentBaseContext)new SimplePercentBaseContext(null, 12, n5));
        return n4 + n6;
    }

    private int getInlineContainerBaselineOffset(int n2) {
        switch (n2) {
            case 14: 
            case 142: {
                return 0;
            }
            case 4: 
            case 141: {
                return this.contentAreaBPD;
            }
            case 24: 
            case 82: 
            case 84: {
                return this.contentAreaBPD / 2;
            }
            case 59: {
                return this.contentAreaBPD * 7 / 10;
            }
            case 6: {
                return this.contentAreaBPD * 6 / 10;
            }
            case 56: {
                return this.contentAreaBPD * 2 / 10;
            }
            case 9: 
            case 12: {
                return this.hasLineAreaDescendant() ? this.getBaselineOffset() : this.contentAreaBPD;
            }
        }
        throw new AssertionError((Object)("Unknown baseline value: " + n2));
    }

    @Override
    public void addAreas(PositionIterator positionIterator, LayoutContext layoutContext) {
        Position position = null;
        while (positionIterator.hasNext()) {
            assert (position == null);
            position = positionIterator.next();
            assert (position.getLM() == this);
        }
        assert (position != null);
        KnuthPossPosIter knuthPossPosIter = new KnuthPossPosIter(this.childElements);
        AreaAdditionUtil.addAreas((AbstractLayoutManager)this, (PositionIterator)knuthPossPosIter, (LayoutContext)layoutContext);
        this.referenceArea = null;
        this.notifyEndOfLayout();
    }

    @Override
    public Area getParentArea(Area area) {
        if (this.referenceArea == null) {
            this.referenceArea = new Container();
            this.referenceArea.addTrait(Trait.IS_REFERENCE_AREA, (Object)Boolean.TRUE);
            TraitSetter.setProducerID((Area)this.referenceArea, this.fobj.getId());
            this.referenceArea.setIPD(this.contentAreaIPD);
            this.currentViewport = new InlineViewport((Area)this.referenceArea);
            this.currentViewport.addTrait(Trait.IS_VIEWPORT_AREA, (Object)Boolean.TRUE);
            TraitSetter.setProducerID((Area)this.currentViewport, this.fobj.getId());
            this.currentViewport.setBlockProgressionOffset(this.alignmentContext.getOffset());
            this.currentViewport.setIPD(this.getContentAreaIPD());
            this.currentViewport.setBPD(this.getContentAreaBPD());
            TraitSetter.addBackground((Area)this.currentViewport, this.borderProps, this);
            this.currentViewport.setClip(this.needClip());
            this.currentViewport.setContentPosition((Rectangle2D)new Rectangle2D.Float(0.0f, 0.0f, this.getContentAreaIPD(), this.getContentAreaBPD()));
            this.getParent().addChildArea((Area)this.currentViewport);
        }
        return this.referenceArea;
    }

    @Override
    public int getContentAreaIPD() {
        return this.contentAreaIPD;
    }

    @Override
    public int getContentAreaBPD() {
        return this.contentAreaBPD;
    }

    @Override
    public void addChildArea(Area area) {
        this.referenceArea.addChildArea(area);
    }

    private boolean needClip() {
        int n2 = this.getInlineContainer().getOverflow();
        return n2 == 57 || n2 == 42;
    }

    public boolean handleOverflow(int n2) {
        this.ipdOverflow = Math.max(this.ipdOverflow, n2);
        return true;
    }

    public List<ListElement> addALetterSpaceTo(List<ListElement> list) {
        return list;
    }

    public List<ListElement> addALetterSpaceTo(List<ListElement> list, int n2) {
        return list;
    }

    public String getWordChars(Position position) {
        return "";
    }

    public void hyphenate(Position position, HyphContext hyphContext) {
    }

    public boolean applyChanges(List<ListElement> list) {
        return false;
    }

    public boolean applyChanges(List<ListElement> list, int n2) {
        return false;
    }

    public List<ListElement> getChangedKnuthElements(List<ListElement> list, int n2, int n3) {
        return list;
    }
}

