/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.awt.Dimension;
import java.awt.Rectangle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.GraphicsProperties;
import org.apache.fop.fo.extensions.ExternalDocument;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.layoutmgr.AbstractLayoutManager;

public class ImageLayout
implements Constants {
    protected static final Log log = LogFactory.getLog(ImageLayout.class);
    private GraphicsProperties props;
    private PercentBaseContext percentBaseContext;
    private Dimension intrinsicSize;
    private Rectangle placement;
    private Dimension viewportSize = new Dimension(-1, -1);
    private boolean clip;
    private int owmax = -1;
    private int ohmax = -1;
    private boolean owminSpecified;
    private boolean ohminSpecified;
    private boolean disableMinMaxPatches = false;

    public ImageLayout(GraphicsProperties graphicsProperties, PercentBaseContext percentBaseContext, Dimension dimension) {
        this.props = graphicsProperties;
        this.percentBaseContext = percentBaseContext;
        this.intrinsicSize = dimension;
        boolean bl = this.isTemporaryLayoutForMinMaxTableComputation((AbstractLayoutManager)percentBaseContext);
        if (graphicsProperties instanceof ExternalDocument) {
            this.disableMinMaxPatches = true;
        }
        if (!this.disableMinMaxPatches) {
            Property property;
            Length length;
            Length length2 = graphicsProperties.getInlineProgressionDimension().getMaximum(null).getLength();
            if (length2.getEnum() != 9 && (length2.isAbsolute() || !bl)) {
                this.owmax = length2.getValue(percentBaseContext);
            }
            if ((length = graphicsProperties.getBlockProgressionDimension().getMaximum(null).getLength()).getEnum() != 9 && (length.isAbsolute() || !bl)) {
                this.ohmax = length.getValue(percentBaseContext);
            }
            if ((property = graphicsProperties.getInlineProgressionDimension().getMinimum(null)).getSpecifiedValue() != null) {
                this.owminSpecified = true;
            }
            if ((property = graphicsProperties.getBlockProgressionDimension().getMinimum(null)).getSpecifiedValue() != null) {
                this.ohminSpecified = true;
            }
        }
        this.doLayout();
    }

    protected void doLayout() {
        int n2;
        int n3;
        int n4 = -1;
        int n5 = -1;
        Length length = this.props.getBlockProgressionDimension().getOptimum(this.percentBaseContext).getLength();
        if (length.getEnum() != 9) {
            n4 = this.evaluateLength(length, this.intrinsicSize.height);
        }
        if ((length = this.props.getBlockProgressionDimension().getMinimum(this.percentBaseContext).getLength()).getEnum() != 9) {
            n3 = this.evaluateLength(length, this.intrinsicSize.height);
            n2 = this.intrinsicSize.height;
            if (n4 != -1) {
                n2 = n4;
            }
            if (n2 < n3) {
                n4 = n3;
            }
        }
        if ((length = this.props.getInlineProgressionDimension().getOptimum(this.percentBaseContext).getLength()).getEnum() != 9) {
            n5 = length.getValue(this.percentBaseContext);
        }
        if ((length = this.props.getInlineProgressionDimension().getMinimum(this.percentBaseContext).getLength()).getEnum() != 9) {
            n3 = this.evaluateLength(length, this.intrinsicSize.width);
            n2 = this.intrinsicSize.width;
            if (n5 != -1) {
                n2 = n5;
            }
            if (n2 < n3) {
                n5 = n3;
            }
        }
        if (!this.disableMinMaxPatches) {
            if (this.owmax != -1 && n5 > this.owmax) {
                n5 = this.owmax;
            }
            if (this.ohmax != -1 && n4 > this.ohmax) {
                n4 = this.ohmax;
            }
        }
        n3 = 0;
        n2 = -1;
        int n6 = -1;
        length = this.props.getContentWidth();
        if (length.getEnum() != 9) {
            switch (length.getEnum()) {
                case 125: {
                    if (n5 != -1) {
                        n2 = n5;
                    }
                    n3 = 1;
                    break;
                }
                case 185: {
                    if (n5 != -1 && this.intrinsicSize.width > n5) {
                        n2 = n5;
                    }
                    n3 = 1;
                    break;
                }
                case 186: {
                    if (n5 != -1 && this.intrinsicSize.width < n5) {
                        n2 = n5;
                    }
                    n3 = 1;
                    break;
                }
                default: {
                    n2 = length.getValue(this.percentBaseContext);
                }
            }
        }
        if ((length = this.props.getContentHeight()).getEnum() != 9) {
            switch (length.getEnum()) {
                case 125: {
                    if (n4 != -1) {
                        n6 = n4;
                    }
                    n3 = 1;
                    break;
                }
                case 185: {
                    if (n4 != -1 && this.intrinsicSize.height > n4) {
                        n6 = n4;
                    }
                    n3 = 1;
                    break;
                }
                case 186: {
                    if (n4 != -1 && this.intrinsicSize.height < n4) {
                        n6 = n4;
                    }
                    n3 = 1;
                    break;
                }
                default: {
                    n6 = length.getValue(this.percentBaseContext);
                }
            }
        }
        Dimension dimension = n3 != 0 ? this.constrain(this.intrinsicSize) : this.intrinsicSize;
        Dimension dimension2 = this.adjustContentSize(n2, n6, dimension);
        n2 = dimension2.width;
        n6 = dimension2.height;
        if (!this.disableMinMaxPatches) {
            if (this.owmax != -1) {
                n2 = n5 = Math.min(this.owmax, this.constrainExtent(true, n2, this.props.getInlineProgressionDimension(), this.props.getContentWidth()));
            }
            if (this.ohmax != -1) {
                n6 = n4 = Math.min(this.ohmax, this.constrainExtent(false, n6, this.props.getBlockProgressionDimension(), this.props.getContentHeight()));
            }
        }
        if (n5 == -1) {
            n5 = this.constrainExtent(true, n2, this.props.getInlineProgressionDimension(), this.props.getContentWidth());
        }
        if (n4 == -1) {
            n4 = this.constrainExtent(false, n6, this.props.getBlockProgressionDimension(), this.props.getContentHeight());
        }
        this.clip = false;
        int n7 = this.props.getOverflow();
        if (n7 == 57) {
            this.clip = true;
        } else if (n7 == 42) {
            if (n2 > n5 || n6 > n4) {
                log.error((Object)"Object overflows the viewport: clipping");
            }
            this.clip = true;
        }
        int n8 = this.computeXOffset(n5, n2);
        int n9 = this.computeYOffset(n4, n6);
        this.viewportSize.setSize(n5, n4);
        this.placement = new Rectangle(n8, n9, n2, n6);
    }

    private int constrainExtent(boolean bl, int n2, LengthRangeProperty lengthRangeProperty, Length length) {
        int n3;
        boolean bl2 = length.getEnum() != 185;
        boolean bl3 = length.getEnum() != 186;
        Length length2 = lengthRangeProperty.getMaximum(this.percentBaseContext).getLength();
        if (length2.getEnum() != 9) {
            n3 = this.evaluateLength(length2);
            if (bl && this.owmax != -1) {
                n3 = this.owmax;
            }
            if (!bl && this.ohmax != -1) {
                n3 = this.ohmax;
            }
            if (n3 != -1 && bl3) {
                n2 = Math.min(n2, n3);
            }
        }
        if ((length2 = lengthRangeProperty.getMinimum(this.percentBaseContext).getLength()).getEnum() != 9) {
            n3 = this.evaluateLength(length2);
            if (!(bl && this.owminSpecified || !bl && this.ohminSpecified)) {
                n3 = -1;
            }
            if (n3 != -1 && bl2) {
                n2 = Math.max(n2, n3);
            }
        }
        return n2;
    }

    private Dimension constrain(Dimension dimension) {
        Dimension dimension2 = new Dimension(dimension);
        int n2 = this.constrainExtent(true, dimension.width, this.props.getInlineProgressionDimension(), this.props.getContentWidth());
        int n3 = this.constrainExtent(false, dimension.height, this.props.getBlockProgressionDimension(), this.props.getContentHeight());
        int n4 = this.props.getScaling();
        if (n4 == 154) {
            double d2 = (double)n2 / (double)dimension.width;
            double d3 = (double)n3 / (double)dimension.height;
            if (d2 < d3) {
                dimension2.width = n2;
                dimension2.height = (int)(d2 * (double)dimension.height);
            } else if (d2 > d3) {
                dimension2.width = (int)(d3 * (double)dimension.width);
                dimension2.height = n3;
            } else {
                dimension2.width = n2;
                dimension2.height = n3;
            }
        } else {
            dimension2.width = n2;
            dimension2.height = n3;
        }
        return dimension2;
    }

    private Dimension adjustContentSize(int n2, int n3, Dimension dimension) {
        Dimension dimension2 = new Dimension(n2, n3);
        int n4 = this.props.getScaling();
        if (n4 == 154 || n2 == -1 || n3 == -1) {
            if (n2 == -1 && n3 == -1) {
                dimension2.width = dimension.width;
                dimension2.height = dimension.height;
            } else if (n2 == -1) {
                dimension2.width = dimension.height == 0 ? 0 : (int)((double)dimension.width * (double)n3 / (double)dimension.height);
            } else if (n3 == -1) {
                dimension2.height = dimension.width == 0 ? 0 : (int)((double)dimension.height * (double)n2 / (double)dimension.width);
            } else if (dimension.width == 0 || dimension.height == 0) {
                dimension2.width = 0;
                dimension2.height = 0;
            } else {
                double d2 = (double)n2 / (double)dimension.width;
                double d3 = (double)n3 / (double)dimension.height;
                if (d2 < d3) {
                    dimension2.height = (int)(d2 * (double)dimension.height);
                } else if (d2 > d3) {
                    dimension2.width = (int)(d3 * (double)dimension.width);
                }
            }
        }
        return dimension2;
    }

    public int computeXOffset(int n2, int n3) {
        int n4 = 0;
        switch (this.props.getTextAlign()) {
            case 23: {
                n4 = (n2 - n3) / 2;
                break;
            }
            case 39: {
                n4 = n2 - n3;
                break;
            }
            case 135: {
                break;
            }
        }
        return n4;
    }

    public int computeYOffset(int n2, int n3) {
        int n4 = 0;
        switch (this.props.getDisplayAlign()) {
            case 13: {
                break;
            }
            case 3: {
                n4 = n2 - n3;
                break;
            }
            case 23: {
                n4 = (n2 - n3) / 2;
                break;
            }
        }
        return n4;
    }

    public Rectangle getPlacement() {
        return this.placement;
    }

    public Dimension getViewportSize() {
        return this.viewportSize;
    }

    public Dimension getIntrinsicSize() {
        return this.intrinsicSize;
    }

    public boolean isClipped() {
        return this.clip;
    }

    private int evaluateLength(Length length, int n2) {
        double d2 = length.getNumericValue(this.percentBaseContext);
        int n3 = d2 < 0.0 ? n2 : (int)Math.round(d2);
        return n3;
    }

    private int evaluateLength(Length length) {
        return this.evaluateLength(length, -1);
    }

    private boolean isTemporaryLayoutForMinMaxTableComputation(AbstractLayoutManager abstractLayoutManager) {
        AbstractLayoutManager abstractLayoutManager2 = abstractLayoutManager;
        int n2 = 0;
        while (n2 == 0 && abstractLayoutManager2 != null) {
            n2 = abstractLayoutManager2.getAncestorBlockAreaIPD();
            if (abstractLayoutManager2.getParent() instanceof AbstractLayoutManager) {
                abstractLayoutManager2 = (AbstractLayoutManager)abstractLayoutManager2.getParent();
                continue;
            }
            abstractLayoutManager2 = null;
        }
        return n2 <= 0;
    }
}

