/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.ImageLayout;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;

public abstract class AbstractGraphicsLayoutManager
extends LeafNodeLayoutManager {
    public AbstractGraphicsLayoutManager(AbstractGraphics abstractGraphics) {
        super((FObj)abstractGraphics);
    }

    private InlineViewport getInlineArea(LayoutContext layoutContext) {
        int n2;
        AbstractGraphics abstractGraphics = (AbstractGraphics)this.fobj;
        int n3 = layoutContext.getRefIPD();
        Dimension dimension = new Dimension(abstractGraphics.getIntrinsicWidth(n3), abstractGraphics.getIntrinsicHeight(n3));
        int n4 = abstractGraphics.getBidiLevel();
        ImageLayout imageLayout = new ImageLayout(abstractGraphics, (PercentBaseContext)this, dimension);
        Rectangle rectangle = imageLayout.getPlacement();
        CommonBorderPaddingBackground commonBorderPaddingBackground = abstractGraphics.getCommonBorderPaddingBackground();
        this.setCommonBorderPaddingBackground(commonBorderPaddingBackground);
        int n5 = commonBorderPaddingBackground.getPadding(0, false, (PercentBaseContext)this);
        rectangle.y += (n5 += commonBorderPaddingBackground.getBorderWidth(0, false));
        if (n4 == -1 || (n4 & 1) == 0) {
            n2 = commonBorderPaddingBackground.getPadding(2, false, (PercentBaseContext)this);
            rectangle.x += (n2 += commonBorderPaddingBackground.getBorderWidth(2, false));
        } else {
            n2 = commonBorderPaddingBackground.getPadding(3, false, (PercentBaseContext)this);
            rectangle.x += (n2 += commonBorderPaddingBackground.getBorderWidth(3, false));
        }
        Area area = this.getChildArea();
        TraitSetter.setProducerID(area, abstractGraphics.getId());
        this.transferForeignAttributes((AreaTreeObject)area);
        InlineViewport inlineViewport = new InlineViewport(area, n4);
        TraitSetter.setProducerID((Area)inlineViewport, abstractGraphics.getId());
        inlineViewport.setIPD(imageLayout.getViewportSize().width);
        inlineViewport.setBPD(imageLayout.getViewportSize().height);
        inlineViewport.setContentPosition((Rectangle2D)rectangle);
        inlineViewport.setClip(imageLayout.isClipped());
        inlineViewport.setBlockProgressionOffset(0);
        TraitSetter.addBorders((Area)inlineViewport, commonBorderPaddingBackground, false, false, false, false, (PercentBaseContext)this);
        TraitSetter.addPadding((Area)inlineViewport, commonBorderPaddingBackground, false, false, false, false, (PercentBaseContext)this);
        TraitSetter.addBackground((Area)inlineViewport, commonBorderPaddingBackground, (PercentBaseContext)this);
        return inlineViewport;
    }

    public List<KnuthSequence> getNextKnuthElements(LayoutContext layoutContext, int n2) {
        InlineViewport inlineViewport = this.getInlineArea(layoutContext);
        this.setCurrentArea((InlineArea)inlineViewport);
        return super.getNextKnuthElements(layoutContext, n2);
    }

    protected InlineArea getEffectiveArea(LayoutContext layoutContext) {
        InlineArea inlineArea = this.curArea != null ? this.curArea : this.getInlineArea(layoutContext);
        this.curArea = null;
        if (!layoutContext.treatAsArtifact()) {
            TraitSetter.addStructureTreeElement(inlineArea, ((AbstractGraphics)this.fobj).getStructureTreeElement());
        }
        return inlineArea;
    }

    protected AlignmentContext makeAlignmentContext(LayoutContext layoutContext) {
        AbstractGraphics abstractGraphics = (AbstractGraphics)this.fobj;
        return new AlignmentContext(this.get(layoutContext).getAllocBPD(), abstractGraphics.getAlignmentAdjust(layoutContext.getRefIPD()), abstractGraphics.getAlignmentBaseline(), abstractGraphics.getBaselineShift(), abstractGraphics.getDominantBaseline(), layoutContext.getAlignmentContext());
    }

    protected abstract Area getChildArea();

    public int getBaseLength(int n2, FObj fObj) {
        switch (n2) {
            case 7: {
                return ((AbstractGraphics)fObj).getIntrinsicWidth(100000);
            }
            case 8: {
                return ((AbstractGraphics)fObj).getIntrinsicHeight(100000);
            }
            case 12: {
                return this.get(null).getBPD();
            }
        }
        return super.getBaseLength(n2, fObj);
    }

    public int getMinimumIPD() {
        if (this.curArea instanceof InlineViewport) {
            InlineViewport inlineViewport = (InlineViewport)this.curArea;
            return (int)inlineViewport.getContentPosition().getWidth();
        }
        log.warn((Object)"this type does not provide its dimensions, yet.");
        return 0;
    }

    public int getMaximumIPD() {
        if (this.curArea instanceof InlineViewport) {
            InlineViewport inlineViewport = (InlineViewport)this.curArea;
            return (int)inlineViewport.getContentPosition().getWidth();
        }
        log.warn((Object)"this type does not provide its dimensions, yet.");
        return 0;
    }
}

