/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.awt.Color;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.datatypes.SimplePercentBaseContext;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.fonts.Font;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.Visibility;

public final class TraitSetter {
    private static final Log LOG = LogFactory.getLog(TraitSetter.class);

    private TraitSetter() {
    }

    public static void setBorderPaddingTraits(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, boolean bl, boolean bl2, PercentBaseContext percentBaseContext) {
        int n2 = commonBorderPaddingBackground.getPadding(2, bl, percentBaseContext);
        if (n2 > 0) {
            area.addTrait(Trait.PADDING_START, (Object)n2);
        }
        if ((n2 = commonBorderPaddingBackground.getPadding(3, bl2, percentBaseContext)) > 0) {
            area.addTrait(Trait.PADDING_END, (Object)n2);
        }
        if ((n2 = commonBorderPaddingBackground.getPadding(0, false, percentBaseContext)) > 0) {
            area.addTrait(Trait.PADDING_BEFORE, (Object)n2);
        }
        if ((n2 = commonBorderPaddingBackground.getPadding(1, false, percentBaseContext)) > 0) {
            area.addTrait(Trait.PADDING_AFTER, (Object)n2);
        }
        TraitSetter.addBorderTrait(area, commonBorderPaddingBackground, bl, 2, BorderProps.Mode.SEPARATE, Trait.BORDER_START, percentBaseContext);
        TraitSetter.addBorderTrait(area, commonBorderPaddingBackground, bl2, 3, BorderProps.Mode.SEPARATE, Trait.BORDER_END, percentBaseContext);
        TraitSetter.addBorderTrait(area, commonBorderPaddingBackground, false, 0, BorderProps.Mode.SEPARATE, Trait.BORDER_BEFORE, percentBaseContext);
        TraitSetter.addBorderTrait(area, commonBorderPaddingBackground, false, 1, BorderProps.Mode.SEPARATE, Trait.BORDER_AFTER, percentBaseContext);
    }

    private static void addBorderTrait(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, boolean bl, int n2, BorderProps.Mode mode, Integer n3, PercentBaseContext percentBaseContext) {
        int n4 = commonBorderPaddingBackground.getBorderWidth(n2, bl);
        int n5 = commonBorderPaddingBackground.getBorderRadiusStart(n2, bl, percentBaseContext);
        int n6 = commonBorderPaddingBackground.getBorderRadiusEnd(n2, bl, percentBaseContext);
        if (n4 > 0 || n5 > 0 || n6 > 0) {
            area.addTrait(n3, (Object)new BorderProps(commonBorderPaddingBackground.getBorderStyle(n2), n4, n5, n6, commonBorderPaddingBackground.getBorderColor(n2), mode));
        }
    }

    public static void addBorders(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, PercentBaseContext percentBaseContext) {
        BorderProps borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 0, percentBaseContext);
        if (borderProps != null) {
            area.addTrait(Trait.BORDER_BEFORE, (Object)borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 1, percentBaseContext)) != null) {
            area.addTrait(Trait.BORDER_AFTER, (Object)borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 2, percentBaseContext)) != null) {
            area.addTrait(Trait.BORDER_START, (Object)borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 3, percentBaseContext)) != null) {
            area.addTrait(Trait.BORDER_END, (Object)borderProps);
        }
        TraitSetter.addPadding(area, commonBorderPaddingBackground, percentBaseContext);
    }

    public static void addBorders(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, boolean bl, boolean bl2, boolean bl3, boolean bl4, PercentBaseContext percentBaseContext) {
        BorderProps borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 0, percentBaseContext);
        if (borderProps != null && !bl) {
            area.addTrait(Trait.BORDER_BEFORE, (Object)borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 1, percentBaseContext)) != null && !bl2) {
            area.addTrait(Trait.BORDER_AFTER, (Object)borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 2, percentBaseContext)) != null && !bl3) {
            area.addTrait(Trait.BORDER_START, (Object)borderProps);
        }
        if ((borderProps = TraitSetter.getBorderProps(commonBorderPaddingBackground, 3, percentBaseContext)) != null && !bl4) {
            area.addTrait(Trait.BORDER_END, (Object)borderProps);
        }
    }

    public static void addCollapsingBorders(Area area, CommonBorderPaddingBackground.BorderInfo borderInfo, CommonBorderPaddingBackground.BorderInfo borderInfo2, CommonBorderPaddingBackground.BorderInfo borderInfo3, CommonBorderPaddingBackground.BorderInfo borderInfo4, boolean[] blArray) {
        BorderProps borderProps = TraitSetter.getCollapsingBorderProps(borderInfo, blArray[0]);
        if (borderProps != null) {
            area.addTrait(Trait.BORDER_BEFORE, (Object)borderProps);
        }
        if ((borderProps = TraitSetter.getCollapsingBorderProps(borderInfo2, blArray[1])) != null) {
            area.addTrait(Trait.BORDER_AFTER, (Object)borderProps);
        }
        if ((borderProps = TraitSetter.getCollapsingBorderProps(borderInfo3, blArray[2])) != null) {
            area.addTrait(Trait.BORDER_START, (Object)borderProps);
        }
        if ((borderProps = TraitSetter.getCollapsingBorderProps(borderInfo4, blArray[3])) != null) {
            area.addTrait(Trait.BORDER_END, (Object)borderProps);
        }
    }

    private static void addPadding(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, PercentBaseContext percentBaseContext) {
        TraitSetter.addPadding(area, commonBorderPaddingBackground, false, false, false, false, percentBaseContext);
    }

    public static void addPadding(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, boolean bl, boolean bl2, boolean bl3, boolean bl4, PercentBaseContext percentBaseContext) {
        int n2 = commonBorderPaddingBackground.getPadding(0, bl, percentBaseContext);
        if (n2 != 0) {
            area.addTrait(Trait.PADDING_BEFORE, (Object)n2);
        }
        if ((n2 = commonBorderPaddingBackground.getPadding(1, bl2, percentBaseContext)) != 0) {
            area.addTrait(Trait.PADDING_AFTER, (Object)n2);
        }
        if ((n2 = commonBorderPaddingBackground.getPadding(2, bl3, percentBaseContext)) != 0) {
            area.addTrait(Trait.PADDING_START, (Object)n2);
        }
        if ((n2 = commonBorderPaddingBackground.getPadding(3, bl4, percentBaseContext)) != 0) {
            area.addTrait(Trait.PADDING_END, (Object)n2);
        }
    }

    private static BorderProps getBorderProps(CommonBorderPaddingBackground commonBorderPaddingBackground, int n2, PercentBaseContext percentBaseContext) {
        int n3 = commonBorderPaddingBackground.getBorderWidth(n2, false);
        int n4 = commonBorderPaddingBackground.getBorderRadiusStart(n2, false, percentBaseContext);
        int n5 = commonBorderPaddingBackground.getBorderRadiusEnd(n2, false, percentBaseContext);
        if (n3 != 0 || n4 != 0 || n5 != 0) {
            return new BorderProps(commonBorderPaddingBackground.getBorderStyle(n2), n3, n4, n5, commonBorderPaddingBackground.getBorderColor(n2), BorderProps.Mode.SEPARATE);
        }
        return null;
    }

    private static BorderProps getCollapsingBorderProps(CommonBorderPaddingBackground.BorderInfo borderInfo, boolean bl) {
        assert (borderInfo != null);
        int n2 = borderInfo.getRetainedWidth();
        if (n2 != 0) {
            return BorderProps.makeRectangular((int)borderInfo.getStyle(), (int)n2, (Color)borderInfo.getColor(), (BorderProps.Mode)(bl ? BorderProps.Mode.COLLAPSE_OUTER : BorderProps.Mode.COLLAPSE_INNER));
        }
        return null;
    }

    public static void addBackground(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, PercentBaseContext percentBaseContext, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!commonBorderPaddingBackground.hasBackground()) {
            return;
        }
        Trait.Background background = new Trait.Background();
        background.setColor(commonBorderPaddingBackground.backgroundColor);
        if (commonBorderPaddingBackground.getImageInfo() != null) {
            SimplePercentBaseContext simplePercentBaseContext;
            int n8;
            background.setURL(commonBorderPaddingBackground.backgroundImage);
            background.setImageInfo(commonBorderPaddingBackground.getImageInfo());
            background.setRepeat(commonBorderPaddingBackground.backgroundRepeat);
            TraitSetter.setImageTargetWidthHeight(area, commonBorderPaddingBackground, background, n4, n5);
            if (commonBorderPaddingBackground.backgroundPositionHorizontal != null && (background.getRepeat() == 96 || background.getRepeat() == 114)) {
                if (area.getIPD() > 0) {
                    n8 = background.getImageInfo().getSize().getWidthMpt();
                    if (background.getImageTargetWidth() != 0) {
                        n8 = background.getImageTargetWidth();
                    }
                    simplePercentBaseContext = new SimplePercentBaseContext(percentBaseContext, 9, n4 - n8);
                    int n9 = n2 + n6 + n7 + commonBorderPaddingBackground.backgroundPositionHorizontal.getValue((PercentBaseContext)simplePercentBaseContext);
                    background.setHoriz(n9);
                } else {
                    LOG.warn((Object)"Horizontal background image positioning ignored because the IPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
            if (commonBorderPaddingBackground.backgroundPositionVertical != null && (background.getRepeat() == 96 || background.getRepeat() == 113)) {
                if (area.getBPD() > 0) {
                    n8 = background.getImageInfo().getSize().getHeightMpt();
                    if (background.getImageTargetHeight() != 0) {
                        n8 = background.getImageTargetHeight();
                    }
                    simplePercentBaseContext = new SimplePercentBaseContext(percentBaseContext, 10, n5 - n8);
                    background.setVertical(n3 + commonBorderPaddingBackground.backgroundPositionVertical.getValue((PercentBaseContext)simplePercentBaseContext));
                } else {
                    LOG.warn((Object)"Vertical background image positioning ignored because the BPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
        }
        area.addTrait(Trait.BACKGROUND, (Object)background);
    }

    private static void setImageTargetWidthHeight(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, Trait.Background background, int n2, int n4) {
        PercentBaseContext percentBaseContext = (n3, fObj) -> n2;
        PercentBaseContext percentBaseContext2 = (n3, fObj) -> n4;
        int n5 = commonBorderPaddingBackground.backgroungImageTargetWidth.getValue(percentBaseContext);
        int n6 = commonBorderPaddingBackground.backgroungImageTargetHeight.getValue(percentBaseContext2);
        if (commonBorderPaddingBackground.backgroungImageTargetWidth instanceof PercentLength && commonBorderPaddingBackground.backgroungImageTargetHeight.getValue() == 0) {
            n6 = commonBorderPaddingBackground.backgroungImageTargetWidth.getValue(percentBaseContext2);
        }
        if (n5 != 0) {
            background.setImageTargetWidth(n5);
        }
        if (n6 != 0) {
            background.setImageTargetHeight(n6);
        }
    }

    public static void addBackground(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, PercentBaseContext percentBaseContext) {
        if (!commonBorderPaddingBackground.hasBackground()) {
            return;
        }
        Trait.Background background = new Trait.Background();
        background.setColor(commonBorderPaddingBackground.backgroundColor);
        if (commonBorderPaddingBackground.getImageInfo() != null) {
            int n2;
            SimplePercentBaseContext simplePercentBaseContext;
            int n3;
            int n4;
            int n5;
            background.setURL(commonBorderPaddingBackground.backgroundImage);
            background.setImageInfo(commonBorderPaddingBackground.getImageInfo());
            background.setRepeat(commonBorderPaddingBackground.backgroundRepeat);
            TraitSetter.setImageTargetWidthHeight(area, commonBorderPaddingBackground, background, area.getIPD(), area.getBPD());
            if (commonBorderPaddingBackground.backgroundPositionHorizontal != null && (background.getRepeat() == 96 || background.getRepeat() == 114)) {
                if (area.getIPD() > 0) {
                    n5 = area.getIPD();
                    n5 += commonBorderPaddingBackground.getPaddingStart(false, percentBaseContext);
                    n5 += commonBorderPaddingBackground.getPaddingEnd(false, percentBaseContext);
                    n4 = background.getImageInfo().getSize().getWidthMpt();
                    if (background.getImageTargetWidth() != 0) {
                        n4 = background.getImageTargetWidth();
                    }
                    n3 = n5 - n4;
                    simplePercentBaseContext = new SimplePercentBaseContext(percentBaseContext, 9, n3);
                    n2 = commonBorderPaddingBackground.backgroundPositionHorizontal.getValue((PercentBaseContext)simplePercentBaseContext);
                    background.setHoriz(n2);
                } else {
                    LOG.warn((Object)"Horizontal background image positioning ignored because the IPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
            if (commonBorderPaddingBackground.backgroundPositionVertical != null && (background.getRepeat() == 96 || background.getRepeat() == 113)) {
                if (area.getBPD() > 0) {
                    n5 = area.getBPD();
                    n5 += commonBorderPaddingBackground.getPaddingBefore(false, percentBaseContext);
                    n5 += commonBorderPaddingBackground.getPaddingAfter(false, percentBaseContext);
                    n4 = background.getImageInfo().getSize().getHeightMpt();
                    if (background.getImageTargetHeight() != 0) {
                        n4 = background.getImageTargetHeight();
                    }
                    n3 = n5 - n4;
                    simplePercentBaseContext = new SimplePercentBaseContext(percentBaseContext, 10, n3);
                    n2 = commonBorderPaddingBackground.backgroundPositionVertical.getValue((PercentBaseContext)simplePercentBaseContext);
                    background.setVertical(n2);
                } else {
                    LOG.warn((Object)"Vertical background image positioning ignored because the BPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
        }
        area.addTrait(Trait.BACKGROUND, (Object)background);
    }

    public static void addMargins(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, int n2, int n3, PercentBaseContext percentBaseContext) {
        int n4;
        int n5;
        if (n2 != 0) {
            area.addTrait(Trait.START_INDENT, (Object)n2);
        }
        if ((n5 = n2 - commonBorderPaddingBackground.getBorderStartWidth(false) - commonBorderPaddingBackground.getPaddingStart(false, percentBaseContext)) != 0) {
            area.addTrait(Trait.SPACE_START, (Object)n5);
        }
        if (n3 != 0) {
            area.addTrait(Trait.END_INDENT, (Object)n3);
        }
        if ((n4 = n3 - commonBorderPaddingBackground.getBorderEndWidth(false) - commonBorderPaddingBackground.getPaddingEnd(false, percentBaseContext)) != 0) {
            area.addTrait(Trait.SPACE_END, (Object)n4);
        }
    }

    public static void addMargins(Area area, CommonBorderPaddingBackground commonBorderPaddingBackground, CommonMarginBlock commonMarginBlock, PercentBaseContext percentBaseContext) {
        int n2 = commonMarginBlock.startIndent.getValue(percentBaseContext);
        int n3 = commonMarginBlock.endIndent.getValue(percentBaseContext);
        TraitSetter.addMargins(area, commonBorderPaddingBackground, n2, n3, percentBaseContext);
    }

    public static int getEffectiveSpace(double d2, MinOptMax minOptMax) {
        if (minOptMax == null) {
            return 0;
        }
        int n2 = minOptMax.getOpt();
        n2 = d2 > 0.0 ? (n2 += (int)(d2 * (double)minOptMax.getStretch())) : (n2 += (int)(d2 * (double)minOptMax.getShrink()));
        return n2;
    }

    public static void addSpaceBeforeAfter(Area area, double d2, MinOptMax minOptMax, MinOptMax minOptMax2) {
        TraitSetter.addSpaceTrait(area, Trait.SPACE_BEFORE, minOptMax, d2);
        TraitSetter.addSpaceTrait(area, Trait.SPACE_AFTER, minOptMax2, d2);
    }

    private static void addSpaceTrait(Area area, Integer n2, MinOptMax minOptMax, double d2) {
        int n3 = TraitSetter.getEffectiveSpace(d2, minOptMax);
        if (n3 != 0) {
            area.addTrait(n2, (Object)n3);
        }
    }

    public static void addBreaks(Area area, int n2, int n3) {
    }

    public static void addFontTraits(Area area, Font font) {
        area.addTrait(Trait.FONT, (Object)font.getFontTriplet());
        area.addTrait(Trait.FONT_SIZE, (Object)font.getFontSize());
    }

    public static void addTextDecoration(Area area, CommonTextDecoration commonTextDecoration) {
        if (commonTextDecoration != null) {
            if (commonTextDecoration.hasUnderline()) {
                area.addTrait(Trait.UNDERLINE, (Object)Boolean.TRUE);
                area.addTrait(Trait.UNDERLINE_COLOR, (Object)commonTextDecoration.getUnderlineColor());
            }
            if (commonTextDecoration.hasOverline()) {
                area.addTrait(Trait.OVERLINE, (Object)Boolean.TRUE);
                area.addTrait(Trait.OVERLINE_COLOR, (Object)commonTextDecoration.getOverlineColor());
            }
            if (commonTextDecoration.hasLineThrough()) {
                area.addTrait(Trait.LINETHROUGH, (Object)Boolean.TRUE);
                area.addTrait(Trait.LINETHROUGH_COLOR, (Object)commonTextDecoration.getLineThroughColor());
            }
            if (commonTextDecoration.isBlinking()) {
                area.addTrait(Trait.BLINK, (Object)Boolean.TRUE);
            }
        }
    }

    public static void setVisibility(Area area, int n2) {
        Visibility visibility;
        switch (n2) {
            case 26: {
                visibility = Visibility.COLLAPSE;
                break;
            }
            case 57: {
                visibility = Visibility.HIDDEN;
                break;
            }
            default: {
                visibility = Visibility.VISIBLE;
            }
        }
        area.addTrait(Trait.VISIBILITY, (Object)visibility);
    }

    public static void addStructureTreeElement(Area area, StructureTreeElement structureTreeElement) {
        if (structureTreeElement != null) {
            area.addTrait(Trait.STRUCTURE_TREE_ELEMENT, (Object)structureTreeElement);
        }
    }

    public static void setProducerID(Area area, String string) {
        if (string != null && string.length() > 0) {
            area.addTrait(Trait.PROD_ID, (Object)string);
        }
    }

    public static void setLayer(Area area, String string) {
        if (string != null && string.length() > 0) {
            area.addTrait(Trait.LAYER, (Object)string);
        }
    }
}

