/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.layoutmgr.BorderOrPaddingElement;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.SpaceElement;
import org.apache.fop.layoutmgr.UnresolvedListElement;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;
import org.apache.fop.traits.MinOptMax;

public final class SpaceResolver {
    private static final Log LOG = LogFactory.getLog(SpaceResolver.class);
    private UnresolvedListElementWithLength[] firstPart;
    private BreakElement breakPoss;
    private UnresolvedListElementWithLength[] secondPart;
    private UnresolvedListElementWithLength[] noBreak;
    private MinOptMax[] firstPartLengths;
    private MinOptMax[] secondPartLengths;
    private MinOptMax[] noBreakLengths;
    private boolean isFirst;
    private boolean isLast;

    private SpaceResolver(List list, BreakElement breakElement, List<ListElement> list2, boolean bl, boolean bl2) {
        ListIterator<Object> listIterator;
        this.isFirst = bl;
        this.isLast = bl2;
        int n2 = 0;
        if (list != null) {
            n2 += list.size();
        }
        if (list2 != null) {
            n2 += list2.size();
        }
        this.noBreak = new UnresolvedListElementWithLength[n2];
        this.noBreakLengths = new MinOptMax[n2];
        int n3 = 0;
        if (list != null) {
            listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                this.noBreak[n3] = (UnresolvedListElementWithLength)((Object)listIterator.next());
                this.noBreakLengths[n3] = this.noBreak[n3].getLength();
                ++n3;
            }
        }
        if (list2 != null) {
            listIterator = list2.listIterator();
            while (listIterator.hasNext()) {
                this.noBreak[n3] = (UnresolvedListElementWithLength)((Object)listIterator.next());
                this.noBreakLengths[n3] = this.noBreak[n3].getLength();
                ++n3;
            }
        }
        if (breakElement != null) {
            if (breakElement.getPendingAfterMarks() != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("    adding pending before break: " + breakElement.getPendingAfterMarks()));
                }
                list.addAll(0, breakElement.getPendingAfterMarks());
            }
            if (breakElement.getPendingBeforeMarks() != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("    adding pending after break: " + breakElement.getPendingBeforeMarks()));
                }
                list2.addAll(0, breakElement.getPendingBeforeMarks());
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("before: " + list));
            LOG.trace((Object)("  break: " + breakElement));
            LOG.trace((Object)("after: " + list2));
            LOG.trace((Object)("NO-BREAK: " + this.toString((Object[])this.noBreak, this.noBreakLengths)));
        }
        if (list != null) {
            this.firstPart = new UnresolvedListElementWithLength[list.size()];
            this.firstPartLengths = new MinOptMax[this.firstPart.length];
            list.toArray(this.firstPart);
            for (n3 = 0; n3 < this.firstPart.length; ++n3) {
                this.firstPartLengths[n3] = this.firstPart[n3].getLength();
            }
        }
        this.breakPoss = breakElement;
        if (list2 != null) {
            this.secondPart = new UnresolvedListElementWithLength[list2.size()];
            this.secondPartLengths = new MinOptMax[this.secondPart.length];
            list2.toArray(this.secondPart);
            for (n3 = 0; n3 < this.secondPart.length; ++n3) {
                this.secondPartLengths[n3] = this.secondPart[n3].getLength();
            }
        }
        this.resolve();
    }

    private String toString(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            throw new IllegalArgumentException("The length of both arrays must be equal");
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(String.valueOf(objectArray[i2]));
            stringBuffer.append("/");
            stringBuffer.append(String.valueOf(objectArray2[i2]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void removeConditionalBorderAndPadding(UnresolvedListElement[] unresolvedListElementArray, MinOptMax[] minOptMaxArray, boolean bl) {
        for (int i2 = 0; i2 < unresolvedListElementArray.length; ++i2) {
            BorderOrPaddingElement borderOrPaddingElement;
            int n2 = bl ? unresolvedListElementArray.length - 1 - i2 : i2;
            if (!(unresolvedListElementArray[n2] instanceof BorderOrPaddingElement) || !(borderOrPaddingElement = (BorderOrPaddingElement)unresolvedListElementArray[n2]).isConditional() || borderOrPaddingElement.isFirst() || borderOrPaddingElement.isLast()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Nulling conditional element: " + borderOrPaddingElement));
            }
            minOptMaxArray[n2] = null;
        }
        if (LOG.isTraceEnabled() && unresolvedListElementArray.length > 0) {
            LOG.trace((Object)("-->Resulting list: " + this.toString(unresolvedListElementArray, minOptMaxArray)));
        }
    }

    private void performSpaceResolutionRule1(UnresolvedListElement[] unresolvedListElementArray, MinOptMax[] minOptMaxArray, boolean bl) {
        for (int i2 = 0; i2 < unresolvedListElementArray.length; ++i2) {
            int n2 = bl ? unresolvedListElementArray.length - 1 - i2 : i2;
            if (minOptMaxArray[n2] == null) continue;
            if (unresolvedListElementArray[n2] instanceof BorderOrPaddingElement || !unresolvedListElementArray[n2].isConditional()) break;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Nulling conditional element using 4.3.1, rule 1: " + unresolvedListElementArray[n2]));
            }
            minOptMaxArray[n2] = null;
        }
        if (LOG.isTraceEnabled() && unresolvedListElementArray.length > 0) {
            LOG.trace((Object)("-->Resulting list: " + this.toString(unresolvedListElementArray, minOptMaxArray)));
        }
    }

    private void performSpaceResolutionRules2to3(UnresolvedListElement[] unresolvedListElementArray, MinOptMax[] minOptMaxArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        SpaceElement spaceElement;
        int n8;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("rule 2-3: " + n2 + "-" + n3));
        }
        boolean bl = false;
        int n9 = 0;
        for (n8 = n2; n8 <= n3; ++n8) {
            if (minOptMaxArray[n8] == null) continue;
            ++n9;
            spaceElement = (SpaceElement)unresolvedListElementArray[n8];
            if (!spaceElement.isForcing()) continue;
            bl = true;
            break;
        }
        if (n9 == 0) {
            return;
        }
        if (bl) {
            for (n8 = n2; n8 <= n3; ++n8) {
                if (minOptMaxArray[n8] == null || (spaceElement = (SpaceElement)unresolvedListElementArray[n8]).isForcing()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Nulling non-forcing space-specifier using 4.3.1, rule 2: " + unresolvedListElementArray[n8]));
                }
                minOptMaxArray[n8] = null;
            }
            return;
        }
        n8 = Integer.MIN_VALUE;
        for (n7 = n2; n7 <= n3; ++n7) {
            if (minOptMaxArray[n7] == null) continue;
            spaceElement = (SpaceElement)unresolvedListElementArray[n7];
            n8 = Math.max(n8, spaceElement.getPrecedence());
        }
        if (n8 != 0 && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Highest precedence is " + n8));
        }
        n9 = 0;
        n7 = Integer.MIN_VALUE;
        int n10 = -1;
        for (n6 = n2; n6 <= n3; ++n6) {
            if (minOptMaxArray[n6] == null) continue;
            spaceElement = (SpaceElement)unresolvedListElementArray[n6];
            if (spaceElement.getPrecedence() != n8) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Nulling space-specifier with precedence " + spaceElement.getPrecedence() + " using 4.3.1, rule 3: " + unresolvedListElementArray[n6]));
                }
                minOptMaxArray[n6] = null;
                continue;
            }
            if (spaceElement.getLength().getOpt() > n7) {
                n10 = spaceElement.getSide() == RelSide.BEFORE ? n6 : -1;
            }
            n7 = Math.max(n7, spaceElement.getLength().getOpt());
            ++n9;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Greatest optimum: " + n7));
        }
        if (n9 <= 1) {
            return;
        }
        n6 = -1;
        int n11 = -1;
        if (n10 != -1) {
            for (n5 = n10; n5 > n2 && (spaceElement = (SpaceElement)unresolvedListElementArray[n5 - 1]).getSide() == RelSide.BEFORE; --n5) {
                n6 = n5 - 1;
            }
        }
        if (n6 != -1) {
            n11 = n10;
        }
        n9 = 0;
        n5 = 0;
        for (n4 = n2; n4 <= n3; ++n4) {
            if (minOptMaxArray[n4] == null) continue;
            spaceElement = (SpaceElement)unresolvedListElementArray[n4];
            if (n5 != 0) {
                minOptMaxArray[n4] = null;
            }
            if (spaceElement.getLength().getOpt() < n7) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Nulling space-specifier with smaller optimum length using 4.3.1, rule 3: " + unresolvedListElementArray[n4]));
                }
                minOptMaxArray[n4] = null;
                if (n6 > n4 || n4 > n11) continue;
                n5 = 1;
                minOptMaxArray[n4] = ((SpaceElement)unresolvedListElementArray[n10]).getLength();
                continue;
            }
            ++n9;
        }
        if (n9 <= 1) {
            return;
        }
        n4 = Integer.MIN_VALUE;
        int n12 = Integer.MAX_VALUE;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (minOptMaxArray[i2] == null) continue;
            spaceElement = (SpaceElement)unresolvedListElementArray[i2];
            n4 = Math.max(n4, spaceElement.getLength().getMin());
            n12 = Math.min(n12, spaceElement.getLength().getMax());
            if (n9 > 1) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Nulling non-last space-specifier using 4.3.1, rule 3, second part: " + unresolvedListElementArray[i2]));
                }
                minOptMaxArray[i2] = null;
                --n9;
                continue;
            }
            minOptMaxArray[i2] = MinOptMax.getInstance((int)n4, (int)minOptMaxArray[i2].getOpt(), (int)n12);
        }
        if (LOG.isTraceEnabled() && unresolvedListElementArray.length > 0) {
            LOG.trace((Object)("Remaining spaces: " + n9));
            LOG.trace((Object)("-->Resulting list: " + this.toString(unresolvedListElementArray, minOptMaxArray)));
        }
    }

    private void performSpaceResolutionRules2to3(UnresolvedListElement[] unresolvedListElementArray, MinOptMax[] minOptMaxArray) {
        int n2;
        int n3 = n2 = 0;
        while (n3 < unresolvedListElementArray.length) {
            if (unresolvedListElementArray[n3] instanceof SpaceElement) {
                while (n3 < unresolvedListElementArray.length && (unresolvedListElementArray[n3] == null || unresolvedListElementArray[n3] instanceof SpaceElement)) {
                    ++n3;
                }
                this.performSpaceResolutionRules2to3(unresolvedListElementArray, minOptMaxArray, n2, n3 - 1);
            }
            n2 = ++n3;
        }
    }

    private boolean hasFirstPart() {
        return this.firstPart != null && this.firstPart.length > 0;
    }

    private boolean hasSecondPart() {
        return this.secondPart != null && this.secondPart.length > 0;
    }

    private void resolve() {
        if (this.breakPoss != null) {
            if (this.hasFirstPart()) {
                this.removeConditionalBorderAndPadding(this.firstPart, this.firstPartLengths, true);
                this.performSpaceResolutionRule1(this.firstPart, this.firstPartLengths, true);
                this.performSpaceResolutionRules2to3(this.firstPart, this.firstPartLengths);
            }
            if (this.hasSecondPart()) {
                this.removeConditionalBorderAndPadding(this.secondPart, this.secondPartLengths, false);
                this.performSpaceResolutionRule1(this.secondPart, this.secondPartLengths, false);
                this.performSpaceResolutionRules2to3(this.secondPart, this.secondPartLengths);
            }
            if (this.noBreak != null) {
                this.performSpaceResolutionRules2to3(this.noBreak, this.noBreakLengths);
            }
        } else {
            if (this.isFirst) {
                this.removeConditionalBorderAndPadding(this.secondPart, this.secondPartLengths, false);
                this.performSpaceResolutionRule1(this.secondPart, this.secondPartLengths, false);
            }
            if (this.isLast) {
                this.removeConditionalBorderAndPadding(this.firstPart, this.firstPartLengths, true);
                this.performSpaceResolutionRule1(this.firstPart, this.firstPartLengths, true);
            }
            if (this.hasFirstPart()) {
                LOG.trace((Object)"Swapping first and second parts.");
                UnresolvedListElementWithLength[] unresolvedListElementWithLengthArray = this.secondPart;
                MinOptMax[] minOptMaxArray = this.secondPartLengths;
                this.secondPart = this.firstPart;
                this.secondPartLengths = this.firstPartLengths;
                this.firstPart = unresolvedListElementWithLengthArray;
                this.firstPartLengths = minOptMaxArray;
                if (this.hasFirstPart()) {
                    throw new IllegalStateException("Didn't expect more than one parts in ano-break condition.");
                }
            }
            this.performSpaceResolutionRules2to3(this.secondPart, this.secondPartLengths);
        }
    }

    private MinOptMax sum(MinOptMax[] minOptMaxArray) {
        MinOptMax minOptMax = MinOptMax.ZERO;
        for (MinOptMax minOptMax2 : minOptMaxArray) {
            if (minOptMax2 == null) continue;
            minOptMax = minOptMax.plus(minOptMax2);
        }
        return minOptMax;
    }

    private void generate(ListIterator listIterator) {
        SpaceHandlingPosition spaceHandlingPosition;
        MinOptMax minOptMax = this.sum(this.firstPartLengths);
        MinOptMax minOptMax2 = this.sum(this.secondPartLengths);
        boolean bl = false;
        if (this.breakPoss != null) {
            if (minOptMax.isNonZero()) {
                listIterator.add(new KnuthPenalty(0, 1000, false, null, true));
                listIterator.add(new KnuthGlue(minOptMax, null, true));
                if (this.breakPoss.isForcedBreak()) {
                    listIterator.add(new KnuthBox(0, null, true));
                }
            }
            listIterator.add(new KnuthPenalty(this.breakPoss.getPenaltyWidth(), this.breakPoss.getPenaltyValue(), false, this.breakPoss.getBreakClass(), (Position)new SpaceHandlingBreakPosition(this, this.breakPoss), false));
            if (this.breakPoss.getPenaltyValue() <= -1000) {
                return;
            }
            spaceHandlingPosition = this.sum(this.noBreakLengths);
            MinOptMax minOptMax3 = minOptMax.plus(minOptMax2);
            int n2 = spaceHandlingPosition.getOpt() - minOptMax3.getOpt();
            int n3 = spaceHandlingPosition.getStretch() - minOptMax3.getStretch();
            int n4 = spaceHandlingPosition.getShrink() - minOptMax3.getShrink();
            if (n2 != 0 || n3 != 0 || n4 != 0) {
                listIterator.add(new KnuthGlue(n2, n3, n4, null, true));
            }
        } else if (minOptMax.isNonZero()) {
            throw new IllegalStateException("spaceBeforeBreak should be 0 in this case");
        }
        spaceHandlingPosition = null;
        if (this.breakPoss == null) {
            spaceHandlingPosition = new SpaceHandlingPosition(this);
        }
        if (minOptMax2.isNonZero() || spaceHandlingPosition != null) {
            listIterator.add(new KnuthBox(0, (Position)spaceHandlingPosition, true));
        }
        if (minOptMax2.isNonZero()) {
            listIterator.add(new KnuthPenalty(0, 1000, false, null, true));
            listIterator.add(new KnuthGlue(minOptMax2, null, true));
            bl = true;
        }
        if (this.isLast && bl) {
            listIterator.add(new KnuthBox(0, null, true));
        }
    }

    public static void resolveElementList(List list) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)list);
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        ArrayList<ListElement> arrayList = new ArrayList<ListElement>();
        ArrayList<ListElement> arrayList2 = new ArrayList<ListElement>();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ListElement listElement = (ListElement)listIterator.next();
            if (listElement.isUnresolvedElement()) {
                Object object;
                ArrayList<ListElement> arrayList3;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("unresolved found: " + listElement + " " + bl + "/" + bl2));
                }
                BreakElement breakElement = null;
                arrayList.clear();
                arrayList2.clear();
                if (listElement instanceof BreakElement) {
                    breakElement = (BreakElement)listElement;
                    arrayList3 = arrayList2;
                } else {
                    arrayList3 = arrayList;
                    arrayList3.add(listElement);
                }
                listIterator.remove();
                bl2 = true;
                bl3 = true;
                while (listIterator.hasNext()) {
                    listElement = (ListElement)listIterator.next();
                    if (listElement instanceof BreakElement && breakElement != null) {
                        bl3 = false;
                        bl2 = false;
                        break;
                    }
                    if (arrayList3 == arrayList && listElement instanceof BreakElement) {
                        breakElement = (BreakElement)listElement;
                        listIterator.remove();
                        arrayList3 = arrayList2;
                        continue;
                    }
                    if (listElement.isUnresolvedElement()) {
                        arrayList3.add(listElement);
                        listIterator.remove();
                        continue;
                    }
                    bl2 = false;
                    break;
                }
                if (breakElement == null && arrayList2.isEmpty() && !bl2) {
                    LOG.trace((Object)"Swap first and second parts in no-break condition, second part is empty.");
                    object = arrayList2;
                    arrayList2 = arrayList;
                    arrayList = object;
                }
                LOG.debug((Object)("----start space resolution (first=" + bl + ", last=" + bl2 + ")..."));
                object = new SpaceResolver(arrayList, breakElement, arrayList2, bl, bl2);
                if (!bl2) {
                    listIterator.previous();
                }
                ((SpaceResolver)object).generate(listIterator);
                if (!bl2 && bl3) {
                    listIterator.next();
                }
                LOG.debug((Object)"----end space resolution.");
            }
            bl = false;
        }
    }

    public static void performConditionalsNotification(List list, int n2, int n3, int n4) {
        Position position;
        KnuthElement knuthElement = null;
        if (n4 > 0) {
            knuthElement = (KnuthElement)((Object)list.get(n4));
        }
        SpaceHandlingBreakPosition spaceHandlingBreakPosition = null;
        SpaceHandlingBreakPosition spaceHandlingBreakPosition2 = null;
        if (knuthElement != null && knuthElement.isPenalty() && (position = knuthElement.getPosition()) instanceof SpaceHandlingBreakPosition) {
            spaceHandlingBreakPosition = (SpaceHandlingBreakPosition)position;
            spaceHandlingBreakPosition.notifyBreakSituation(true, RelSide.BEFORE);
        }
        KnuthElement knuthElement2 = knuthElement = n3 > -1 ? (KnuthElement)((Object)list.get(n3)) : null;
        if (knuthElement != null && knuthElement.isPenalty() && (position = knuthElement.getPosition()) instanceof SpaceHandlingBreakPosition) {
            spaceHandlingBreakPosition2 = (SpaceHandlingBreakPosition)position;
            spaceHandlingBreakPosition2.notifyBreakSituation(true, RelSide.AFTER);
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            SpaceHandlingBreakPosition spaceHandlingBreakPosition3;
            Position position2 = ((KnuthElement)((Object)list.get(i2))).getPosition();
            if (position2 instanceof SpaceHandlingPosition) {
                ((SpaceHandlingPosition)position2).notifySpaceSituation();
                continue;
            }
            if (!(position2 instanceof SpaceHandlingBreakPosition) || (spaceHandlingBreakPosition3 = (SpaceHandlingBreakPosition)position2) == spaceHandlingBreakPosition || spaceHandlingBreakPosition3 == spaceHandlingBreakPosition2) continue;
            spaceHandlingBreakPosition3.notifyBreakSituation(false, null);
        }
    }

    public static class SpaceHandlingBreakPosition
    extends Position {
        private SpaceResolver resolver;
        private Position originalPosition;

        public SpaceHandlingBreakPosition(SpaceResolver spaceResolver, BreakElement breakElement) {
            super(null);
            this.resolver = spaceResolver;
            this.originalPosition = breakElement.getPosition();
            while (this.originalPosition instanceof NonLeafPosition) {
                this.originalPosition = this.originalPosition.getPosition();
            }
        }

        public SpaceResolver getSpaceResolver() {
            return this.resolver;
        }

        public void notifyBreakSituation(boolean bl, RelSide relSide) {
            if (bl) {
                if (RelSide.BEFORE == relSide) {
                    for (int i2 = 0; i2 < this.resolver.secondPart.length; ++i2) {
                        this.resolver.secondPart[i2].notifyLayoutManager(this.resolver.secondPartLengths[i2]);
                    }
                } else {
                    for (int i3 = 0; i3 < this.resolver.firstPart.length; ++i3) {
                        this.resolver.firstPart[i3].notifyLayoutManager(this.resolver.firstPartLengths[i3]);
                    }
                }
            } else {
                for (int i4 = 0; i4 < this.resolver.noBreak.length; ++i4) {
                    this.resolver.noBreak[i4].notifyLayoutManager(this.resolver.noBreakLengths[i4]);
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SpaceHandlingBreakPosition(");
            stringBuffer.append(this.originalPosition);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        public Position getOriginalBreakPosition() {
            return this.originalPosition;
        }

        public Position getPosition() {
            return this.originalPosition;
        }
    }

    public static class SpaceHandlingPosition
    extends Position {
        private SpaceResolver resolver;

        public SpaceHandlingPosition(SpaceResolver spaceResolver) {
            super(null);
            this.resolver = spaceResolver;
        }

        public SpaceResolver getSpaceResolver() {
            return this.resolver;
        }

        public void notifySpaceSituation() {
            if (this.resolver.breakPoss != null) {
                throw new IllegalStateException("Only applicable to no-break situations");
            }
            for (int i2 = 0; i2 < this.resolver.secondPart.length; ++i2) {
                this.resolver.secondPart[i2].notifyLayoutManager(this.resolver.secondPartLengths[i2]);
            }
        }

        public String toString() {
            return "SpaceHandlingPosition";
        }
    }
}

