/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.extensions.ExternalDocument;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.BidiOverride;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.ChangeBarBegin;
import org.apache.fop.fo.flow.ChangeBarEnd;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Float;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InlineContainer;
import org.apache.fop.fo.flow.InlineLevel;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.MultiCase;
import org.apache.fop.fo.flow.MultiSwitch;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.fo.flow.RetrieveTableMarker;
import org.apache.fop.fo.flow.Wrapper;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableAndCaption;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCaption;
import org.apache.fop.fo.flow.table.TableCaptionForNextPage;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.SideRegion;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.pagination.Title;
import org.apache.fop.layoutmgr.BlockContainerLayoutManager;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.ExternalDocumentLayoutManager;
import org.apache.fop.layoutmgr.FlowLayoutManager;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.layoutmgr.MultiCaseLayoutManager;
import org.apache.fop.layoutmgr.MultiSwitchLayoutManager;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.RetrieveTableMarkerLayoutManager;
import org.apache.fop.layoutmgr.StaticContentLayoutManager;
import org.apache.fop.layoutmgr.inline.BasicLinkLayoutManager;
import org.apache.fop.layoutmgr.inline.BidiLayoutManager;
import org.apache.fop.layoutmgr.inline.CharacterLayoutManager;
import org.apache.fop.layoutmgr.inline.ContentLayoutManager;
import org.apache.fop.layoutmgr.inline.ExternalGraphicLayoutManager;
import org.apache.fop.layoutmgr.inline.FloatLayoutManager;
import org.apache.fop.layoutmgr.inline.FootnoteLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineContainerLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.InstreamForeignObjectLM;
import org.apache.fop.layoutmgr.inline.LeaderLayoutManager;
import org.apache.fop.layoutmgr.inline.PageNumberCitationLastLayoutManager;
import org.apache.fop.layoutmgr.inline.PageNumberCitationLayoutManager;
import org.apache.fop.layoutmgr.inline.PageNumberLayoutManager;
import org.apache.fop.layoutmgr.inline.TextLayoutManager;
import org.apache.fop.layoutmgr.inline.WrapperLayoutManager;
import org.apache.fop.layoutmgr.list.ListBlockLayoutManager;
import org.apache.fop.layoutmgr.list.ListItemLayoutManager;
import org.apache.fop.layoutmgr.table.TableAndCaptionLayoutManager;
import org.apache.fop.layoutmgr.table.TableCaptionForNextPageLayoutManager;
import org.apache.fop.layoutmgr.table.TableCaptionLayoutManager;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

public class LayoutManagerMapping
implements LayoutManagerMaker {
    private static final Log LOG = LogFactory.getLog(LayoutManagerMapping.class);
    private final Map makers = new HashMap();
    private FOUserAgent userAgent;

    public LayoutManagerMapping(FOUserAgent fOUserAgent) {
        this.userAgent = fOUserAgent;
        this.initialize();
    }

    protected void initialize() {
        this.registerMaker(FOText.class, new FOTextLayoutManagerMaker());
        this.registerMaker(FObjMixed.class, new Maker());
        this.registerMaker(BidiOverride.class, new BidiOverrideLayoutManagerMaker());
        this.registerMaker(Inline.class, new InlineLayoutManagerMaker());
        this.registerMaker(Footnote.class, new FootnoteLayoutManagerMaker());
        this.registerMaker(InlineContainer.class, new InlineContainerLayoutManagerMaker());
        this.registerMaker(BasicLink.class, new BasicLinkLayoutManagerMaker());
        this.registerMaker(Block.class, new BlockLayoutManagerMaker());
        this.registerMaker(Leader.class, new LeaderLayoutManagerMaker());
        this.registerMaker(RetrieveMarker.class, new RetrieveMarkerLayoutManagerMaker());
        this.registerMaker(RetrieveTableMarker.class, new RetrieveTableMarkerLayoutManagerMaker());
        this.registerMaker(Character.class, new CharacterLayoutManagerMaker());
        this.registerMaker(ExternalGraphic.class, new ExternalGraphicLayoutManagerMaker());
        this.registerMaker(BlockContainer.class, new BlockContainerLayoutManagerMaker());
        this.registerMaker(ListItem.class, new ListItemLayoutManagerMaker());
        this.registerMaker(ListBlock.class, new ListBlockLayoutManagerMaker());
        this.registerMaker(InstreamForeignObject.class, new InstreamForeignObjectLayoutManagerMaker());
        this.registerMaker(PageNumber.class, new PageNumberLayoutManagerMaker());
        this.registerMaker(PageNumberCitation.class, new PageNumberCitationLayoutManagerMaker());
        this.registerMaker(PageNumberCitationLast.class, new PageNumberCitationLastLayoutManagerMaker());
        this.registerMaker(Table.class, new TableLayoutManagerMaker());
        this.registerMaker(TableAndCaption.class, new TableAndCaptionLayoutManagerMaker());
        this.registerMaker(TableCaption.class, new TableCaptionLayoutManagerMaker());
        this.registerMaker(TableCaptionForNextPage.class, new TableCaptionForNextPageLayoutManagerMaker());
        this.registerMaker(TableBody.class, new Maker());
        this.registerMaker(TableColumn.class, new Maker());
        this.registerMaker(TableRow.class, new Maker());
        this.registerMaker(TableCell.class, new Maker());
        this.registerMaker(TableFooter.class, new Maker());
        this.registerMaker(TableHeader.class, new Maker());
        this.registerMaker(Wrapper.class, new WrapperLayoutManagerMaker());
        this.registerMaker(Title.class, new InlineLayoutManagerMaker());
        this.registerMaker(ChangeBarBegin.class, new Maker());
        this.registerMaker(ChangeBarEnd.class, new Maker());
        this.registerMaker(MultiCase.class, new MultiCaseLayoutManagerMaker());
        this.registerMaker(MultiSwitch.class, new MultiSwitchLayoutManagerMaker());
        this.registerMaker(Float.class, new FloatLayoutManagerMaker());
    }

    protected void registerMaker(Class clazz, Maker maker) {
        this.makers.put(clazz, maker);
    }

    public void makeLayoutManagers(FONode fONode, List list) {
        Maker maker = (Maker)this.makers.get(fONode.getClass());
        if (maker == null) {
            if ("http://www.w3.org/1999/XSL/Format".equals(fONode.getNamespaceURI())) {
                LOG.error((Object)("No LayoutManager maker for class " + fONode.getClass()));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skipping the creation of a layout manager for " + fONode.getClass()));
            }
        } else {
            maker.make(fONode, list, this.userAgent);
        }
    }

    public LayoutManager makeLayoutManager(FONode fONode) {
        ArrayList arrayList = new ArrayList();
        this.makeLayoutManagers(fONode, arrayList);
        if (arrayList.size() == 0) {
            throw new IllegalStateException("LayoutManager for class " + fONode.getClass() + " is missing.");
        }
        if (arrayList.size() > 1) {
            throw new IllegalStateException("Duplicate LayoutManagers for class " + fONode.getClass() + " found, only one may be declared.");
        }
        return (LayoutManager)arrayList.get(0);
    }

    public PageSequenceLayoutManager makePageSequenceLayoutManager(AreaTreeHandler areaTreeHandler, PageSequence pageSequence) {
        return new PageSequenceLayoutManager(areaTreeHandler, pageSequence);
    }

    public ExternalDocumentLayoutManager makeExternalDocumentLayoutManager(AreaTreeHandler areaTreeHandler, ExternalDocument externalDocument) {
        return new ExternalDocumentLayoutManager(areaTreeHandler, externalDocument);
    }

    public FlowLayoutManager makeFlowLayoutManager(PageSequenceLayoutManager pageSequenceLayoutManager, Flow flow) {
        return new FlowLayoutManager(pageSequenceLayoutManager, flow);
    }

    public ContentLayoutManager makeContentLayoutManager(PageSequenceLayoutManager pageSequenceLayoutManager, Title title) {
        return new ContentLayoutManager(pageSequenceLayoutManager, title);
    }

    public StaticContentLayoutManager makeStaticContentLayoutManager(PageSequenceLayoutManager pageSequenceLayoutManager, StaticContent staticContent, SideRegion sideRegion) {
        return new StaticContentLayoutManager(pageSequenceLayoutManager, staticContent, sideRegion);
    }

    public StaticContentLayoutManager makeStaticContentLayoutManager(PageSequenceLayoutManager pageSequenceLayoutManager, StaticContent staticContent, org.apache.fop.area.Block block) {
        return new StaticContentLayoutManager(pageSequenceLayoutManager, staticContent, block);
    }

    public static class FOTextLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            FOText fOText = (FOText)fONode;
            if (fOText.length() > 0) {
                list.add(new TextLayoutManager(fOText, fOUserAgent));
            }
        }
    }

    public static class Maker {
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
        }
    }

    public static class BidiOverrideLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            if (fONode instanceof BidiOverride) {
                list.add(new BidiLayoutManager((BidiOverride)fONode));
            }
        }
    }

    public static class InlineLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new InlineLayoutManager((InlineLevel)((Object)fONode)));
        }
    }

    public static class FootnoteLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new FootnoteLayoutManager((Footnote)fONode));
        }
    }

    public static class InlineContainerLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new InlineContainerLayoutManager((InlineContainer)((Object)fONode)));
        }
    }

    public static class BasicLinkLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new BasicLinkLayoutManager((BasicLink)fONode));
        }
    }

    public static class BlockLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new BlockLayoutManager((Block)fONode));
        }
    }

    public static class LeaderLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new LeaderLayoutManager((Leader)fONode));
        }
    }

    public class RetrieveMarkerLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            FONode.FONodeIterator fONodeIterator = fONode.getChildNodes();
            if (fONodeIterator == null) {
                return;
            }
            while (fONodeIterator.hasNext()) {
                FONode fONode2 = (FONode)fONodeIterator.next();
                LayoutManagerMapping.this.makeLayoutManagers(fONode2, list);
            }
        }
    }

    public class RetrieveTableMarkerLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            FONode.FONodeIterator fONodeIterator = fONode.getChildNodes();
            if (fONodeIterator == null) {
                RetrieveTableMarker retrieveTableMarker = (RetrieveTableMarker)fONode;
                RetrieveTableMarkerLayoutManager retrieveTableMarkerLayoutManager = new RetrieveTableMarkerLayoutManager(retrieveTableMarker);
                list.add(retrieveTableMarkerLayoutManager);
                return;
            }
            while (fONodeIterator.hasNext()) {
                FONode fONode2 = fONodeIterator.next();
                LayoutManagerMapping.this.makeLayoutManagers(fONode2, list);
            }
        }
    }

    public static class CharacterLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            Character character = (Character)fONode;
            if (character.getCharacter() != '\u0000') {
                list.add(new CharacterLayoutManager(character));
            }
        }
    }

    public static class ExternalGraphicLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            ExternalGraphic externalGraphic = (ExternalGraphic)((Object)fONode);
            if (!externalGraphic.getSrc().equals("")) {
                list.add(new ExternalGraphicLayoutManager(externalGraphic));
            }
        }
    }

    public static class BlockContainerLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new BlockContainerLayoutManager((BlockContainer)((Object)fONode)));
        }
    }

    public static class ListItemLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new ListItemLayoutManager((ListItem)((Object)fONode)));
        }
    }

    public static class ListBlockLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new ListBlockLayoutManager((ListBlock)((Object)fONode)));
        }
    }

    public static class InstreamForeignObjectLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new InstreamForeignObjectLM((InstreamForeignObject)((Object)fONode)));
        }
    }

    public static class PageNumberLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new PageNumberLayoutManager((PageNumber)((Object)fONode)));
        }
    }

    public static class PageNumberCitationLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new PageNumberCitationLayoutManager((PageNumberCitation)fONode));
        }
    }

    public static class PageNumberCitationLastLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new PageNumberCitationLastLayoutManager((PageNumberCitationLast)fONode));
        }
    }

    public static class TableLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            Table table = (Table)((Object)fONode);
            TableLayoutManager tableLayoutManager = new TableLayoutManager(table);
            list.add(tableLayoutManager);
        }
    }

    public static class TableAndCaptionLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            TableAndCaption tableAndCaption = (TableAndCaption)((Object)fONode);
            TableAndCaptionLayoutManager tableAndCaptionLayoutManager = new TableAndCaptionLayoutManager(tableAndCaption);
            list.add(tableAndCaptionLayoutManager);
        }
    }

    public static class TableCaptionLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            TableCaption tableCaption = (TableCaption)((Object)fONode);
            TableCaptionLayoutManager tableCaptionLayoutManager = new TableCaptionLayoutManager(tableCaption);
            list.add(tableCaptionLayoutManager);
        }
    }

    public static class TableCaptionForNextPageLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            TableCaptionForNextPage tableCaptionForNextPage = (TableCaptionForNextPage)((Object)fONode);
            TableCaptionForNextPageLayoutManager tableCaptionForNextPageLayoutManager = new TableCaptionForNextPageLayoutManager(tableCaptionForNextPage);
            list.add(tableCaptionForNextPageLayoutManager);
        }
    }

    public class WrapperLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new WrapperLayoutManager((Wrapper)fONode));
            FONode.FONodeIterator fONodeIterator = fONode.getChildNodes();
            if (fONodeIterator == null) {
                return;
            }
            while (fONodeIterator.hasNext()) {
                FONode fONode2 = (FONode)fONodeIterator.next();
                LayoutManagerMapping.this.makeLayoutManagers(fONode2, list);
            }
        }
    }

    public class MultiCaseLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new MultiCaseLayoutManager((FObj)((MultiCase)fONode)));
        }
    }

    public class MultiSwitchLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new MultiSwitchLayoutManager((FObj)((MultiSwitch)fONode)));
        }
    }

    public static class FloatLayoutManagerMaker
    extends Maker {
        @Override
        public void make(FONode fONode, List list, FOUserAgent fOUserAgent) {
            list.add(new FloatLayoutManager((Float)fONode));
        }
    }
}

