/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockParent;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.properties.BreakPropertySet;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.layoutmgr.AbstractLayoutManager;
import org.apache.fop.layoutmgr.Adjustment;
import org.apache.fop.layoutmgr.BlockLevelEventProducer;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.BorderElement;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.BreakOpportunityHelper;
import org.apache.fop.layoutmgr.ChemistryWidowsOrphansElementListUtils;
import org.apache.fop.layoutmgr.ElementListUtils;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.PaddingElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.SpaceElement;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;
import org.apache.fop.layoutmgr.inline.InlineContainerLayoutManager;
import org.apache.fop.layoutmgr.inline.InlineLayoutManager;
import org.apache.fop.layoutmgr.inline.LineLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.util.ListUtil;

public abstract class BlockStackingLayoutManager
extends AbstractLayoutManager
implements BlockLevelLayoutManager {
    private static Log log = LogFactory.getLog(BlockStackingLayoutManager.class);
    protected BlockParent parentArea;
    protected int bpUnit;
    protected int adjustedSpaceBefore;
    protected int adjustedSpaceAfter;
    protected List<KnuthElement> storedList;
    protected boolean breakBeforeServed;
    protected boolean firstVisibleMarkServed;
    protected int referenceIPD;
    protected int startIndent;
    protected int endIndent;
    protected MinOptMax foSpaceBefore;
    protected MinOptMax foSpaceAfter;
    private Position auxiliaryPosition;
    private int contentAreaIPD;
    private boolean isRestartAtLM;

    public BlockStackingLayoutManager(FObj fObj) {
        super(fObj);
        this.setGeneratesBlockArea(true);
    }

    protected BlockParent getCurrentArea() {
        return this.parentArea;
    }

    protected void setCurrentArea(BlockParent blockParent) {
        this.parentArea = blockParent;
    }

    public void addBlockSpacing(double d2, MinOptMax minOptMax) {
        int n2 = TraitSetter.getEffectiveSpace(d2, minOptMax);
        if (n2 != 0) {
            Block block = new Block();
            block.setChangeBarList(this.getChangeBarList());
            block.setBPD(n2);
            this.parentLayoutManager.addChildArea((Area)block);
        }
    }

    protected void addChildToArea(Area area, BlockParent blockParent) {
        blockParent.addBlock((Block)area);
        this.flush();
    }

    @Override
    public void addChildArea(Area area) {
        this.addChildToArea(area, this.getCurrentArea());
    }

    protected void flush() {
        if (this.getCurrentArea() != null) {
            this.parentLayoutManager.addChildArea((Area)this.getCurrentArea());
        }
    }

    protected Position getAuxiliaryPosition() {
        if (this.auxiliaryPosition == null) {
            this.auxiliaryPosition = new NonLeafPosition((LayoutManager)this, null);
        }
        return this.auxiliaryPosition;
    }

    protected int neededUnits(int n2) {
        return (int)Math.ceil((float)n2 / (float)this.bpUnit);
    }

    protected int updateContentAreaIPDwithOverconstrainedAdjust(LayoutContext layoutContext) {
        int n2 = this.referenceIPD - (this.startIndent + this.endIndent);
        if (n2 < 0 && !layoutContext.isChildOfAutoLayoutElement()) {
            log.debug((Object)("Adjusting end-indent based on overconstrained geometry rules for " + this.fobj));
            BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getFObj().getUserAgent().getEventBroadcaster());
            if (!layoutContext.isInRotatedBlockLayoutDeterminationMode()) {
                blockLevelEventProducer.overconstrainedAdjustEndIndent(this, this.getNameAndContextInfo(), n2, this.getFObj().getLocator());
            }
            this.endIndent += n2;
            n2 = 0;
        }
        this.setContentAreaIPD(n2);
        return n2;
    }

    protected String getNameAndContextInfo() {
        return this.getFObj().getName() + "  (" + this.getFObj().getContextInfoWithoutLocator() + ")";
    }

    protected int updateContentAreaIPDwithOverconstrainedAdjust(LayoutContext layoutContext, int n2) {
        int n3 = this.referenceIPD - (n2 + (this.startIndent + this.endIndent));
        if (n3 < 0) {
            log.debug((Object)("Adjusting end-indent based on overconstrained geometry rules for " + this.fobj));
            BlockLevelEventProducer blockLevelEventProducer = BlockLevelEventProducer.Provider.get(this.getFObj().getUserAgent().getEventBroadcaster());
            if (!layoutContext.isInRotatedBlockLayoutDeterminationMode()) {
                blockLevelEventProducer.overconstrainedAdjustEndIndent(this, this.getNameAndContextInfo(), n3, this.getFObj().getLocator());
            }
            this.endIndent += n3;
        }
        this.setContentAreaIPD(n2);
        return n2;
    }

    @Override
    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2) {
        return this.getNextKnuthElements(layoutContext, n2, null, null, null);
    }

    @Override
    public List<ListElement> getNextKnuthElements(LayoutContext layoutContext, int n2, Stack stack, Position position, LayoutManager layoutManager) {
        LayoutManager layoutManager2;
        this.isRestartAtLM = layoutManager != null;
        this.referenceIPD = layoutContext.getRefIPD();
        this.updateContentAreaIPDwithOverconstrainedAdjust(layoutContext);
        boolean bl = stack != null;
        boolean bl2 = !bl || stack.isEmpty();
        LinkedList<ListElement> linkedList = new LinkedList<ListElement>();
        LinkedList<ListElement> linkedList2 = new LinkedList<ListElement>();
        if (!this.breakBeforeServed(layoutContext, linkedList2)) {
            return linkedList2;
        }
        this.addFirstVisibleMarks(linkedList2, layoutContext, n2);
        BreakElement breakElement = null;
        if (bl) {
            if (bl2) {
                assert (layoutManager != null && layoutManager.getParent() == this);
                layoutManager2 = layoutManager;
            } else {
                layoutManager2 = (LayoutManager)stack.pop();
            }
            this.setCurrentChildLM(layoutManager2);
        } else {
            layoutManager2 = this.getChildLM();
        }
        while (layoutManager2 != null) {
            List<ListElement> list;
            LayoutContext layoutContext2 = this.makeChildLayoutContext(layoutContext);
            if (!bl || bl2) {
                if (bl) {
                    layoutManager2.reset();
                }
                list = this.getNextChildElements(layoutManager2, layoutContext, layoutContext2, n2, null, null, null);
            } else {
                list = this.getNextChildElements(layoutManager2, layoutContext, layoutContext2, n2, stack, position, layoutManager);
                bl2 = true;
            }
            int n3 = layoutContext2.getRefIPD();
            if (this.getContentAreaIPD() < n3 && layoutContext.isChildOfAutoLayoutElement()) {
                this.referenceIPD = layoutManager2 instanceof LineLayoutManager ? this.startIndent + n3 + this.endIndent : n3;
                this.updateContentAreaIPDwithOverconstrainedAdjust(layoutContext);
                layoutContext.setRefIPD(this.referenceIPD);
            }
            if (linkedList.isEmpty()) {
                layoutContext.updateKeepWithPreviousPending(layoutContext2.getKeepWithPreviousPending());
            }
            if (list != null && !list.isEmpty()) {
                if (!linkedList.isEmpty() && !ElementListUtils.startsWithForcedBreak(list)) {
                    this.addInBetweenBreak(linkedList, layoutContext, layoutContext2);
                }
                if (list.size() == 1 && ElementListUtils.startsWithForcedBreak(list)) {
                    if (layoutManager2.isFinished() && !this.hasNextChildLM()) {
                        breakElement = (BreakElement)list.get(0);
                        layoutContext.clearPendingMarks();
                        break;
                    }
                    if (linkedList.isEmpty()) {
                        linkedList2.add((ListElement)this.makeAuxiliaryZeroWidthBox());
                    }
                    linkedList.addAll(list);
                    this.wrapPositionElements(linkedList, linkedList2);
                    return linkedList2;
                }
                linkedList.addAll(list);
                if (ElementListUtils.endsWithForcedBreak(list)) {
                    if (layoutManager2.isFinished() && !this.hasNextChildLM()) {
                        breakElement = (BreakElement)((Object)ListUtil.removeLast(linkedList));
                        layoutContext.clearPendingMarks();
                        break;
                    }
                    this.wrapPositionElements(linkedList, linkedList2);
                    return linkedList2;
                }
                layoutContext.updateKeepWithNextPending(layoutContext2.getKeepWithNextPending());
            }
            layoutManager2 = this.getChildLM();
        }
        if (linkedList.isEmpty()) {
            if (breakElement == null) {
                linkedList2.add((ListElement)this.makeAuxiliaryZeroWidthBox());
            }
        } else {
            this.wrapPositionElements(linkedList, linkedList2);
        }
        this.addLastVisibleMarks(linkedList2, layoutContext, n2);
        if (breakElement == null) {
            this.addKnuthElementsForBreakAfter(linkedList2, layoutContext);
        } else {
            breakElement.clearPendingMarks();
            linkedList2.add((ListElement)breakElement);
        }
        this.enforceWidowsOrphans(linkedList2);
        layoutContext.updateKeepWithNextPending(this.getKeepWithNext());
        this.setFinished(true);
        return linkedList2;
    }

    private void enforceWidowsOrphans(List<ListElement> list) {
        FObj fObj = this.getFObj();
        if (fObj instanceof org.apache.fop.fo.flow.Block) {
            org.apache.fop.fo.flow.Block block = (org.apache.fop.fo.flow.Block)fObj;
            if (block.getWhitespaceTreatment() == 108) {
                ChemistryWidowsOrphansElementListUtils.removeLegalBreaks(list, block.getOrphans());
                ChemistryWidowsOrphansElementListUtils.removeLegalBreaksFromEnd(list, block.getWidows());
            }
        } else if (fObj instanceof ListBlock) {
            ListBlock listBlock = (ListBlock)fObj;
            ChemistryWidowsOrphansElementListUtils.removeLegalBreaks(list, listBlock.getOrphans());
            ChemistryWidowsOrphansElementListUtils.removeLegalBreaksFromEnd(list, listBlock.getWidows());
        }
    }

    protected LayoutContext makeChildLayoutContext(LayoutContext layoutContext) {
        LayoutContext layoutContext2 = LayoutContext.offspringOf(layoutContext);
        layoutContext2.copyPendingMarksFrom(layoutContext);
        layoutContext2.setStackLimitBP(layoutContext.getStackLimitBP());
        layoutContext2.setRefIPD(this.referenceIPD);
        return layoutContext2;
    }

    protected void addFirstVisibleMarks(List<ListElement> list, LayoutContext layoutContext, int n2) {
        if (!this.firstVisibleMarkServed) {
            this.addKnuthElementsForSpaceBefore(list, n2);
            layoutContext.updateKeepWithPreviousPending(this.getKeepWithPrevious());
        }
        this.addKnuthElementsForBorderPaddingBefore(list, !this.firstVisibleMarkServed);
        this.firstVisibleMarkServed = true;
        this.addPendingMarks(layoutContext);
    }

    protected void addLastVisibleMarks(List<ListElement> list, LayoutContext layoutContext, int n2) {
        this.addKnuthElementsForBorderPaddingAfter(list, true);
        this.addKnuthElementsForSpaceAfter(list, n2);
        layoutContext.clearPendingMarks();
    }

    protected boolean breakBeforeServed(LayoutContext layoutContext, List<ListElement> list) {
        if (!this.breakBeforeServed) {
            this.breakBeforeServed = true;
            if (!layoutContext.suppressBreakBefore() && this.addKnuthElementsForBreakBefore(list, layoutContext)) {
                return false;
            }
        }
        return this.breakBeforeServed;
    }

    private KnuthBox makeZeroWidthBox() {
        return new KnuthBox(0, (Position)new NonLeafPosition((LayoutManager)this, null), false);
    }

    private KnuthBox makeAuxiliaryZeroWidthBox() {
        return new KnuthBox(0, this.notifyPos(new Position((LayoutManager)this)), true);
    }

    private KnuthPenalty makeZeroWidthPenalty(int n2) {
        return new KnuthPenalty(0, n2, false, (Position)new NonLeafPosition((LayoutManager)this, null), false);
    }

    private KnuthGlue makeSpaceAdjustmentGlue(int n2, Adjustment adjustment, boolean bl) {
        return new KnuthGlue(n2, 0, 0, adjustment, (Position)new NonLeafPosition((LayoutManager)this, null), bl);
    }

    protected List<ListElement> getNextChildElements(LayoutManager layoutManager, LayoutContext layoutContext, LayoutContext layoutContext2, int n2, Stack<LayoutManager> stack, Position position, LayoutManager layoutManager2) {
        if (layoutManager == this.childLMs.get(0)) {
            layoutContext2.setFlags(2);
        }
        if (stack == null) {
            return layoutManager.getNextKnuthElements(layoutContext2, n2);
        }
        return layoutManager.getNextKnuthElements(layoutContext2, n2, stack, position, layoutManager2);
    }

    protected void addInBetweenBreak(List<ListElement> list, LayoutContext layoutContext, LayoutContext layoutContext2) {
        if (this.mustKeepTogether() || layoutContext.isKeepWithNextPending() || layoutContext2.isKeepWithPreviousPending()) {
            Keep keep = this.getKeepTogether();
            keep = keep.compare(layoutContext.getKeepWithNextPending());
            layoutContext.clearKeepWithNextPending();
            keep = keep.compare(layoutContext2.getKeepWithPreviousPending());
            layoutContext2.clearKeepWithPreviousPending();
            list.add((ListElement)new BreakElement(new Position((LayoutManager)this), keep.getPenalty(), keep.getContext(), layoutContext));
            return;
        }
        ListElement listElement = ListUtil.getLastListElement(list);
        if (listElement == null || listElement.isGlue()) {
            log.warn((Object)"glue-type break possibility not handled properly, yet");
        } else if (!ElementListUtils.endsWithNonInfinitePenalty(list)) {
            list.add((ListElement)new BreakElement(new Position((LayoutManager)this), 0, 9, layoutContext));
        }
    }

    public int negotiateBPDAdjustment(int n2, KnuthElement knuthElement) {
        assert (knuthElement != null && knuthElement.getPosition() != null);
        Position position = knuthElement.getPosition().getPosition();
        if (position == null && knuthElement.isGlue()) {
            if (((KnuthGlue)knuthElement).getAdjustmentClass() == Adjustment.SPACE_BEFORE_ADJUSTMENT) {
                this.adjustedSpaceBefore += n2;
            } else {
                this.adjustedSpaceAfter += n2;
            }
            return n2;
        }
        if (position instanceof MappingPosition) {
            MappingPosition mappingPosition = (MappingPosition)position;
            if (knuthElement.isGlue()) {
                ListIterator<KnuthElement> listIterator = this.storedList.listIterator(mappingPosition.getFirstIndex());
                int n3 = 0;
                while (listIterator.nextIndex() <= mappingPosition.getLastIndex()) {
                    KnuthElement knuthElement2 = listIterator.next();
                    if (!knuthElement2.isGlue()) continue;
                    n3 += ((BlockLevelLayoutManager)knuthElement2.getLayoutManager()).negotiateBPDAdjustment(n2 - n3, knuthElement2);
                }
                n3 = n3 > 0 ? this.bpUnit * this.neededUnits(n3) : -this.bpUnit * this.neededUnits(-n3);
                return n3;
            }
            KnuthPenalty knuthPenalty = (KnuthPenalty)this.storedList.get(mappingPosition.getLastIndex());
            if (knuthPenalty.getWidth() > 0) {
                return ((BlockLevelLayoutManager)knuthPenalty.getLayoutManager()).negotiateBPDAdjustment(knuthPenalty.getWidth(), (KnuthElement)knuthPenalty);
            }
            return n2;
        }
        if (position != null && position.getLM() != this) {
            Position position2 = knuthElement.getPosition();
            assert (position2 instanceof NonLeafPosition);
            NonLeafPosition nonLeafPosition = (NonLeafPosition)position2;
            knuthElement.setPosition(position);
            int n4 = ((BlockLevelLayoutManager)knuthElement.getLayoutManager()).negotiateBPDAdjustment(n2, knuthElement);
            knuthElement.setPosition((Position)nonLeafPosition);
            return n4;
        }
        log.error((Object)"BlockLayoutManager.negotiateBPDAdjustment(): unexpected Position");
        return 0;
    }

    public void discardSpace(KnuthGlue knuthGlue) {
        assert (knuthGlue != null && knuthGlue.getPosition() != null);
        Position position = knuthGlue.getPosition();
        Position position2 = position.getPosition();
        if (position2 == null || position2.getLM() == this) {
            if (knuthGlue.getAdjustmentClass() == Adjustment.SPACE_BEFORE_ADJUSTMENT) {
                this.adjustedSpaceBefore = 0;
                this.foSpaceBefore = MinOptMax.ZERO;
            } else {
                this.adjustedSpaceAfter = 0;
                this.foSpaceAfter = MinOptMax.ZERO;
            }
        } else {
            assert (position instanceof NonLeafPosition);
            NonLeafPosition nonLeafPosition = (NonLeafPosition)position;
            knuthGlue.setPosition(position2);
            ((BlockLevelLayoutManager)knuthGlue.getLayoutManager()).discardSpace(knuthGlue);
            knuthGlue.setPosition((Position)nonLeafPosition);
        }
    }

    public List<ListElement> getChangedKnuthElements(List list, int n2) {
        LayoutManager layoutManager;
        Position position;
        ListIterator listIterator = list.listIterator();
        KnuthElement knuthElement = null;
        KnuthElement knuthElement2 = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<ListElement> linkedList2 = new LinkedList<ListElement>();
        int n3 = 0;
        while (listIterator.hasNext()) {
            KnuthElement knuthElement3 = (KnuthElement)((Object)listIterator.next());
            assert (knuthElement3.getPosition() != null);
            position = knuthElement3.getPosition().getPosition();
            if (position != null) {
                knuthElement3.setPosition(position);
                continue;
            }
            knuthElement3.setPosition(new Position((LayoutManager)this));
        }
        position = list.listIterator();
        while (position.hasNext()) {
            knuthElement = (KnuthElement)((Object)position.next());
            if (knuthElement2 != null && knuthElement2.getLayoutManager() != knuthElement.getLayoutManager()) {
                layoutManager = (BlockLevelLayoutManager)knuthElement2.getLayoutManager();
                BlockLevelLayoutManager blockLevelLayoutManager = (BlockLevelLayoutManager)knuthElement.getLayoutManager();
                boolean bl = false;
                if (layoutManager != this) {
                    linkedList.addAll(layoutManager.getChangedKnuthElements(list.subList(n3, position.previousIndex()), n2));
                    bl = true;
                }
                n3 = position.previousIndex();
                if (bl && (this.mustKeepTogether() || layoutManager.mustKeepWithNext() || blockLevelLayoutManager.mustKeepWithPrevious())) {
                    linkedList.add(this.makeZeroWidthPenalty(1000));
                } else if (bl && !((KnuthElement)((Object)ListUtil.getLast(linkedList))).isGlue()) {
                    linkedList.add(this.makeZeroWidthPenalty(1000));
                }
            }
            knuthElement2 = knuthElement;
        }
        if (knuthElement != null) {
            layoutManager = knuthElement.getLayoutManager();
            if (layoutManager != this) {
                linkedList.addAll(layoutManager.getChangedKnuthElements(list.subList(n3, list.size()), n2));
            } else if (!linkedList.isEmpty()) {
                ListUtil.removeLast(linkedList);
            }
        }
        boolean bl = true;
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            bl = this.getSpaceBeforeProperty().isDiscard();
        }
        if (this.adjustedSpaceBefore != 0) {
            if (!bl) {
                linkedList2.add((ListElement)this.makeZeroWidthBox());
                linkedList2.add((ListElement)this.makeZeroWidthPenalty(1000));
            }
            linkedList2.add((ListElement)this.makeSpaceAdjustmentGlue(this.adjustedSpaceBefore, Adjustment.SPACE_BEFORE_ADJUSTMENT, false));
        }
        for (KnuthElement knuthElement4 : linkedList) {
            knuthElement4.setPosition((Position)new NonLeafPosition((LayoutManager)this, knuthElement4.getPosition()));
            linkedList2.add(knuthElement4);
        }
        boolean bl2 = true;
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            bl2 = this.getSpaceAfterProperty().isDiscard();
        }
        if (this.adjustedSpaceAfter != 0) {
            if (!bl2) {
                linkedList2.add((ListElement)this.makeZeroWidthPenalty(1000));
            }
            linkedList2.add((ListElement)this.makeSpaceAdjustmentGlue(this.adjustedSpaceAfter, Adjustment.SPACE_AFTER_ADJUSTMENT, bl2));
            if (!bl2) {
                linkedList2.add((ListElement)this.makeZeroWidthBox());
            }
        }
        return linkedList2;
    }

    protected Keep getParentKeepTogether() {
        Keep keep = Keep.KEEP_AUTO;
        if (this.getParent() instanceof BlockLevelLayoutManager) {
            keep = ((BlockLevelLayoutManager)this.getParent()).getKeepTogether();
        } else if (this.getParent() instanceof InlineLayoutManager && ((InlineLayoutManager)this.getParent()).mustKeepTogether()) {
            keep = Keep.KEEP_ALWAYS;
        }
        return keep;
    }

    public boolean mustKeepTogether() {
        return !this.getKeepTogether().isAuto();
    }

    public boolean mustKeepWithPrevious() {
        return !this.getKeepWithPrevious().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.getKeepWithNext().isAuto();
    }

    public Keep getKeepTogether() {
        Keep keep = Keep.getKeep((KeepProperty)this.getKeepTogetherProperty());
        keep = keep.compare(this.getParentKeepTogether());
        if (this.getFObj().isForceKeepTogether()) {
            keep = Keep.KEEP_ALWAYS;
        }
        return keep;
    }

    public Keep getKeepWithPrevious() {
        return Keep.getKeep((KeepProperty)this.getKeepWithPreviousProperty());
    }

    public Keep getKeepWithNext() {
        return Keep.getKeep((KeepProperty)this.getKeepWithNextProperty());
    }

    public KeepProperty getKeepTogetherProperty() {
        throw new IllegalStateException();
    }

    public KeepProperty getKeepWithPreviousProperty() {
        throw new IllegalStateException();
    }

    public KeepProperty getKeepWithNextProperty() {
        throw new IllegalStateException();
    }

    protected void addPendingMarks(LayoutContext layoutContext) {
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.getBorderPaddingBackground();
        if (commonBorderPaddingBackground != null) {
            if (commonBorderPaddingBackground.getBorderBeforeWidth(false) > 0) {
                layoutContext.addPendingBeforeMark((UnresolvedListElementWithLength)new BorderElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getBorderInfo(0).getWidth(), RelSide.BEFORE, false, false, (PercentBaseContext)this));
            }
            if (commonBorderPaddingBackground.getPaddingBefore(false, this) > 0) {
                layoutContext.addPendingBeforeMark((UnresolvedListElementWithLength)new PaddingElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getPaddingLengthProperty(0), RelSide.BEFORE, false, false, (PercentBaseContext)this));
            }
            if (commonBorderPaddingBackground.getBorderAfterWidth(false) > 0) {
                layoutContext.addPendingAfterMark((UnresolvedListElementWithLength)new BorderElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getBorderInfo(1).getWidth(), RelSide.AFTER, false, false, (PercentBaseContext)this));
            }
            if (commonBorderPaddingBackground.getPaddingAfter(false, this) > 0) {
                layoutContext.addPendingAfterMark((UnresolvedListElementWithLength)new PaddingElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getPaddingLengthProperty(1), RelSide.AFTER, false, false, (PercentBaseContext)this));
            }
        }
    }

    private CommonBorderPaddingBackground getBorderPaddingBackground() {
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            return ((org.apache.fop.fo.flow.Block)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof BlockContainer) {
            return ((BlockContainer)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof ListBlock) {
            return ((ListBlock)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof ListItem) {
            return ((ListItem)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof Table) {
            return ((Table)this.fobj).getCommonBorderPaddingBackground();
        }
        if (this.fobj instanceof TableCell) {
            return ((TableCell)this.fobj).getCommonBorderPaddingBackground();
        }
        return null;
    }

    protected SpaceProperty getSpaceBeforeProperty() {
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            return ((org.apache.fop.fo.flow.Block)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof BlockContainer) {
            return ((BlockContainer)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof ListBlock) {
            return ((ListBlock)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof ListItem) {
            return ((ListItem)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        if (this.fobj instanceof Table) {
            return ((Table)this.fobj).getCommonMarginBlock().spaceBefore;
        }
        return null;
    }

    protected SpaceProperty getSpaceAfterProperty() {
        if (this.fobj instanceof org.apache.fop.fo.flow.Block) {
            return ((org.apache.fop.fo.flow.Block)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof BlockContainer) {
            return ((BlockContainer)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof ListBlock) {
            return ((ListBlock)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof ListItem) {
            return ((ListItem)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        if (this.fobj instanceof Table) {
            return ((Table)this.fobj).getCommonMarginBlock().spaceAfter;
        }
        return null;
    }

    protected void addKnuthElementsForBorderPaddingBefore(List<ListElement> list, boolean bl) {
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.getBorderPaddingBackground();
        if (commonBorderPaddingBackground != null) {
            if (commonBorderPaddingBackground.getBorderBeforeWidth(false) > 0) {
                list.add((ListElement)new BorderElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getBorderInfo(0).getWidth(), RelSide.BEFORE, bl, false, (PercentBaseContext)this));
            }
            if (commonBorderPaddingBackground.getPaddingBefore(false, this) > 0) {
                list.add((ListElement)new PaddingElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getPaddingLengthProperty(0), RelSide.BEFORE, bl, false, (PercentBaseContext)this));
            }
        }
    }

    protected void addKnuthElementsForBorderPaddingAfter(List<ListElement> list, boolean bl) {
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.getBorderPaddingBackground();
        if (commonBorderPaddingBackground != null) {
            if (commonBorderPaddingBackground.getPaddingAfter(false, this) > 0) {
                list.add((ListElement)new PaddingElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getPaddingLengthProperty(1), RelSide.AFTER, false, bl, (PercentBaseContext)this));
            }
            if (commonBorderPaddingBackground.getBorderAfterWidth(false) > 0) {
                list.add((ListElement)new BorderElement(this.getAuxiliaryPosition(), commonBorderPaddingBackground.getBorderInfo(1).getWidth(), RelSide.AFTER, false, bl, (PercentBaseContext)this));
            }
        }
    }

    protected boolean addKnuthElementsForBreakBefore(List list, LayoutContext layoutContext) {
        int n2 = this.getBreakBefore();
        if (n2 == 104 || n2 == 28 || n2 == 44 || n2 == 100) {
            list.add(new BreakElement(this.getAuxiliaryPosition(), 0, -1000, n2, layoutContext));
            return true;
        }
        return false;
    }

    public int getBreakBefore() {
        return BreakOpportunityHelper.getBreakBefore((AbstractLayoutManager)this);
    }

    protected boolean addKnuthElementsForBreakAfter(List list, LayoutContext layoutContext) {
        int n2 = -1;
        if (this.fobj instanceof BreakPropertySet) {
            n2 = ((BreakPropertySet)this.fobj).getBreakAfter();
        }
        if (n2 == 104 || n2 == 28 || n2 == 44 || n2 == 100) {
            list.add(new BreakElement(this.getAuxiliaryPosition(), 0, -1000, n2, layoutContext));
            return true;
        }
        return false;
    }

    protected void addKnuthElementsForSpaceBefore(List list, int n2) {
        SpaceProperty spaceProperty = this.getSpaceBeforeProperty();
        if (spaceProperty != null && (spaceProperty.getMinimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this) != 0 || spaceProperty.getMaximum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this) != 0)) {
            list.add(new SpaceElement(this.getAuxiliaryPosition(), spaceProperty, RelSide.BEFORE, true, false, this));
        }
    }

    protected void addKnuthElementsForSpaceAfter(List list, int n2) {
        SpaceProperty spaceProperty = this.getSpaceAfterProperty();
        if (spaceProperty != null && (spaceProperty.getMinimum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this) != 0 || spaceProperty.getMaximum((PercentBaseContext)this).getLength().getValue((PercentBaseContext)this) != 0)) {
            list.add(new SpaceElement(this.getAuxiliaryPosition(), spaceProperty, RelSide.AFTER, false, true, this));
        }
    }

    protected void wrapPositionElements(List list, List<ListElement> list2) {
        this.wrapPositionElements(list, list2, false);
    }

    protected void wrapPositionElements(List list, List<ListElement> list2, boolean bl) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Object e2 = listIterator.next();
            if (e2 instanceof ListElement) {
                this.wrapPositionElement((ListElement)e2, list2, bl);
                continue;
            }
            if (!(e2 instanceof List)) continue;
            this.wrapPositionElements((List)e2, list2, bl);
        }
    }

    protected void wrapPositionElement(ListElement listElement, List<ListElement> list, boolean bl) {
        if (bl || listElement.getLayoutManager() != this) {
            listElement.setPosition(this.notifyPos((Position)new NonLeafPosition((LayoutManager)this, listElement.getPosition())));
        }
        list.add(listElement);
    }

    protected int getIPIndents() {
        return this.startIndent + this.endIndent;
    }

    @Override
    public int getContentAreaIPD() {
        return this.contentAreaIPD;
    }

    protected void setContentAreaIPD(int n2) {
        this.contentAreaIPD = n2;
    }

    @Override
    public int getContentAreaBPD() {
        return -1;
    }

    @Override
    public void reset() {
        super.reset();
        this.breakBeforeServed = false;
        this.firstVisibleMarkServed = false;
    }

    public boolean handleOverflow(int n2) {
        if (this.getParent() instanceof BlockStackingLayoutManager) {
            return ((BlockStackingLayoutManager)this.getParent()).handleOverflow(n2);
        }
        if (this.getParent() instanceof InlineContainerLayoutManager) {
            return ((InlineContainerLayoutManager)this.getParent()).handleOverflow(n2);
        }
        return false;
    }

    public boolean isRestartAtLM() {
        return this.isRestartAtLM;
    }

    @Override
    public int getBorderAreaIPD() {
        int n2 = this.getContentAreaIPD();
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.getBorderPaddingBackground();
        if (commonBorderPaddingBackground != null) {
            n2 += commonBorderPaddingBackground.getIPPaddingAndBorder(false, this);
        }
        return n2;
    }

    @Override
    public int getBorderAreaBPD() {
        int n2 = this.getContentAreaBPD();
        CommonBorderPaddingBackground commonBorderPaddingBackground = this.getBorderPaddingBackground();
        if (commonBorderPaddingBackground != null) {
            n2 += commonBorderPaddingBackground.getBPPaddingAndBorder(false, this);
        }
        return n2;
    }

    protected static class MappingPosition
    extends Position {
        private int firstIndex;
        private int lastIndex;

        public MappingPosition(LayoutManager layoutManager, int n2, int n3) {
            super(layoutManager);
            this.firstIndex = n2;
            this.lastIndex = n3;
        }

        public int getFirstIndex() {
            return this.firstIndex;
        }

        public int getLastIndex() {
            return this.lastIndex;
        }
    }
}

