/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class InputDocumentLoader {
    private Document doc;
    private boolean hasBeenParsed;
    private static ThreadLocal<String> inputUrl = new ThreadLocal();
    public static final ThreadLocal<Boolean> shouldExpandXpathInSvgTemplates = ThreadLocal.withInitial(() -> Boolean.TRUE);

    public Document getInputDocument() {
        if (!this.hasBeenParsed) {
            this.hasBeenParsed = true;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            try {
                this.doc = documentBuilderFactory.newDocumentBuilder().parse(inputUrl.get());
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                exception.printStackTrace();
                this.doc = null;
            }
        }
        return this.doc;
    }

    public static void setInputUrl(String string) {
        inputUrl.set(string);
    }

    public static void setShouldExpandXpathInSvgTemplates(boolean bl) {
        shouldExpandXpathInSvgTemplates.set(bl);
    }
}

