/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.Type2CharString;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.cff.CFFDataReader;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OTFSubSetWriter;
import org.apache.fop.fonts.type1.AdobeStandardEncoding;

public class OTFSubSetFile
extends OTFSubSetWriter {
    protected Map<Integer, Integer> subsetGlyphs = new LinkedHashMap<Integer, Integer>();
    protected Map<Integer, Integer> gidToSID;
    protected CFFDataReader.CFFIndexData localIndexSubr;
    protected CFFDataReader.CFFIndexData globalIndexSubr;
    protected List<byte[]> subsetLocalIndexSubr;
    protected List<byte[]> subsetGlobalIndexSubr;
    protected List<List<byte[]>> fdSubrs;
    private Map<Integer, FDIndexReference> subsetFDSelect;
    protected List<Integer> localUniques;
    protected List<Integer> globalUniques;
    protected int subsetLocalSubrCount;
    protected int subsetGlobalSubrCount;
    protected List<byte[]> subsetCharStringsIndex;
    protected String embeddedName;
    protected List<byte[]> stringIndexData = new ArrayList<byte[]>();
    protected CFFDataReader cffReader;
    private MultiByteFont mbFont;
    public static final int NUM_STANDARD_STRINGS = 391;
    private static final int LOCAL_SUBROUTINE = 10;
    private static final int GLOBAL_SUBROUTINE = 29;
    private static final String ACCENT_CMD = "seac";
    private Type2Parser type2Parser;

    public void readFont(FontFileReader fontFileReader, String string, String string2, MultiByteFont multiByteFont) throws IOException {
        this.readFont(fontFileReader, string, multiByteFont, multiByteFont.getUsedGlyphs(), string2);
    }

    void readFont(FontFileReader fontFileReader, String string, MultiByteFont multiByteFont, Map<Integer, Integer> map, String string2) throws IOException {
        this.mbFont = multiByteFont;
        this.fontFile = fontFileReader;
        if (!this.checkTTC(string2, multiByteFont.getTTCName())) {
            throw new IOException("Failed to read font");
        }
        this.embeddedName = string;
        this.initializeFont(fontFileReader);
        this.cffReader = new CFFDataReader(this.fontFile);
        this.mapChars(map);
        this.subsetGlyphs = this.sortByValue(map);
        this.createCFF();
    }

    private void mapChars(Map<Integer, Integer> map) throws IOException {
        if (this.fileFont instanceof CFFType1Font) {
            CFFType1Font cFFType1Font = (CFFType1Font)this.fileFont;
            this.subsetGlyphs = this.sortByValue(map);
            for (int n2 : this.subsetGlyphs.keySet()) {
                Type2CharString type2CharString = cFFType1Font.getType2CharString(n2);
                ArrayList<Number> arrayList = new ArrayList<Number>();
                for (Object e2 : type2CharString.getType1Sequence()) {
                    if (e2 instanceof CharStringCommand) {
                        String string = (String)CharStringCommand.TYPE1_VOCABULARY.get(((CharStringCommand)e2).getKey());
                        if (ACCENT_CMD.equals(string)) {
                            int n3 = ((Number)arrayList.get(3)).intValue();
                            int n4 = ((Number)arrayList.get(4)).intValue();
                            this.mbFont.mapChar(AdobeStandardEncoding.getUnicodeFromCodePoint((int)n3));
                            this.mbFont.mapChar(AdobeStandardEncoding.getUnicodeFromCodePoint((int)n4));
                        }
                        arrayList.clear();
                        continue;
                    }
                    arrayList.add((Number)e2);
                }
            }
        }
    }

    private Map<Integer, Integer> sortByValue(Map<Integer, Integer> map) {
        ArrayList<Map.Entry<Integer, Integer>> arrayList = new ArrayList<Map.Entry<Integer, Integer>>(map.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> entry, Map.Entry<Integer, Integer> entry2) {
                return ((Comparable)entry.getValue()).compareTo(entry2.getValue());
            }
        });
        LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
        for (Map.Entry entry : arrayList) {
            linkedHashMap.put((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        return linkedHashMap;
    }

    protected void createCFF() throws IOException {
        boolean bl;
        this.writeBytes(this.cffReader.getHeader());
        this.writeIndex(Arrays.asList(new byte[][]{this.embedFontName.getBytes("UTF-8")}));
        Offsets offsets = new Offsets();
        offsets.topDictData = this.currentPos + this.writeTopDICT();
        boolean bl2 = bl = this.cffReader.getFDSelect() != null;
        if (bl) {
            this.createCharStringDataCID();
        } else {
            this.createCharStringData();
        }
        List<Integer> list = null;
        List<Integer> list2 = null;
        if (bl) {
            list2 = this.getUsedFDFonts();
            list = this.storeFDStrings(list2);
        }
        this.writeStringIndex();
        this.writeIndex(this.subsetGlobalIndexSubr);
        offsets.encoding = this.currentPos;
        offsets.charset = this.currentPos;
        this.writeCharsetTable(bl);
        offsets.fdSelect = this.currentPos;
        if (bl) {
            this.writeFDSelect();
            if (!this.isCharStringBeforeFD()) {
                offsets.fdArray = this.writeFDArray(list2, list);
            }
        }
        offsets.charString = this.currentPos;
        this.writeIndex(this.subsetCharStringsIndex);
        if (bl) {
            if (this.isCharStringBeforeFD()) {
                offsets.fdArray = this.writeFDArray(list2, list);
            }
            this.updateCIDOffsets(offsets);
        } else {
            offsets.privateDict = this.currentPos;
            this.writePrivateDict();
            offsets.localIndex = this.currentPos;
            this.writeIndex(this.subsetLocalIndexSubr);
            this.updateOffsets(offsets);
        }
    }

    private int writeFDArray(List<Integer> list, List<Integer> list2) throws IOException {
        List<Integer> list3 = this.writeCIDDictsAndSubrs(list);
        return this.writeFDArray(list, list3, list2);
    }

    private boolean isCharStringBeforeFD() {
        LinkedHashMap linkedHashMap = this.cffReader.getTopDictEntries();
        int n2 = ((CFFDataReader.DICTEntry)linkedHashMap.get("CharStrings")).getOperandLength();
        if (linkedHashMap.containsKey("FDArray")) {
            int n3 = ((CFFDataReader.DICTEntry)linkedHashMap.get("FDArray")).getOperandLength();
            return n2 < n3;
        }
        return true;
    }

    protected List<Integer> storeFDStrings(List<Integer> list) throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list2 = this.cffReader.getFDFonts();
        for (int n2 : list) {
            CFFDataReader.FontDict fontDict = (CFFDataReader.FontDict)list2.get(n2);
            byte[] byArray = fontDict.getByteData();
            LinkedHashMap linkedHashMap = this.cffReader.parseDictData(byArray);
            arrayList.add(this.stringIndexData.size() + 391);
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(((Number)((CFFDataReader.DICTEntry)linkedHashMap.get("FontName")).getOperands().get(0)).intValue() - 391));
        }
        return arrayList;
    }

    protected int writeTopDICT() throws IOException {
        LinkedHashMap linkedHashMap = this.cffReader.getTopDictEntries();
        List<String> list = Arrays.asList("version", "Notice", "Copyright", "FullName", "FamilyName", "Weight", "PostScript");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            String string = (String)entry.getKey();
            CFFDataReader.DICTEntry dICTEntry = (CFFDataReader.DICTEntry)entry.getValue();
            dICTEntry.setOffset(dICTEntry.getOffset() + n2);
            if (string.equals("CharStrings") && dICTEntry.getOperandLength() < 5) {
                byte[] byArray = new byte[5 - dICTEntry.getOperandLength()];
                n2 += byArray.length;
                byteArrayOutputStream.write(byArray);
                byteArrayOutputStream.write(dICTEntry.getByteData());
                dICTEntry.setOperandLength(5);
                continue;
            }
            if (string.equals("ROS")) {
                byteArrayOutputStream.write(this.writeROSEntry(dICTEntry));
                continue;
            }
            if (string.equals("CIDCount")) {
                byteArrayOutputStream.write(this.writeCIDCount(dICTEntry));
                continue;
            }
            if (list.contains(string)) {
                if (dICTEntry.getOperandLength() < 2) {
                    dICTEntry.setOperandLength(2);
                    ++n2;
                }
                byteArrayOutputStream.write(this.writeTopDictStringEntry(dICTEntry));
                continue;
            }
            byteArrayOutputStream.write(dICTEntry.getByteData());
        }
        Object object = this.cffReader.getTopDictIndex().getByteData();
        Object object2 = object[2];
        return this.writeIndex(Arrays.asList(new byte[][]{byteArrayOutputStream.toByteArray()}), (int)object2) - byteArrayOutputStream.size();
    }

    private byte[] writeROSEntry(CFFDataReader.DICTEntry dICTEntry) throws IOException {
        int n2 = ((Number)dICTEntry.getOperands().get(0)).intValue();
        if (n2 > 390) {
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(n2 - 391));
        }
        int n3 = this.stringIndexData.size() + 390;
        int n4 = ((Number)dICTEntry.getOperands().get(1)).intValue();
        if (n4 > 390) {
            this.stringIndexData.add("Identity".getBytes("UTF-8"));
        }
        int n5 = this.stringIndexData.size() + 390;
        byte[] byArray = dICTEntry.getByteData();
        this.updateOffset(byArray, 0, (Integer)dICTEntry.getOperandLengths().get(0), n3);
        this.updateOffset(byArray, (Integer)dICTEntry.getOperandLengths().get(0), (Integer)dICTEntry.getOperandLengths().get(1), n5);
        this.updateOffset(byArray, (Integer)dICTEntry.getOperandLengths().get(0) + (Integer)dICTEntry.getOperandLengths().get(1), (Integer)dICTEntry.getOperandLengths().get(2), 0);
        return byArray;
    }

    protected byte[] writeCIDCount(CFFDataReader.DICTEntry dICTEntry) throws IOException {
        byte[] byArray = dICTEntry.getByteData();
        this.updateOffset(byArray, 0, (Integer)dICTEntry.getOperandLengths().get(0), this.subsetGlyphs.size());
        return byArray;
    }

    private byte[] writeTopDictStringEntry(CFFDataReader.DICTEntry dICTEntry) throws IOException {
        int n2 = ((Number)dICTEntry.getOperands().get(0)).intValue();
        if (n2 > 391) {
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(n2 - 391));
        }
        byte[] byArray = OTFSubSetFile.createNewRef(this.stringIndexData.size() + 390, dICTEntry.getOperator(), dICTEntry.getOperandLength(), true);
        return byArray;
    }

    private void writeStringIndex() throws IOException {
        LinkedHashMap linkedHashMap = this.cffReader.getTopDictEntries();
        int n2 = ((Number)((CFFDataReader.DICTEntry)linkedHashMap.get("charset")).getOperands().get(0)).intValue();
        this.gidToSID = new LinkedHashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> entry : this.subsetGlyphs.entrySet()) {
            int n3;
            int n4 = entry.getKey();
            int n5 = entry.getValue();
            if (this.mbFont.getCIDSet().isVirtualGlyphIndex(n4)) {
                n4 = this.mbFont.getCIDSet().getOriginalGlyphIndexForVirtual(n4);
            }
            if ((n3 = this.cffReader.getSIDFromGID(n2, n4)) < 391) {
                this.gidToSID.put(n5, n3);
                if (this.mbFont == null) continue;
                this.mbFont.mapUsedGlyphName(n5, CFFStandardString.getName((int)n3));
                continue;
            }
            int n6 = n3 - 391;
            if (n6 < this.cffReader.getStringIndex().getNumObjects()) {
                byte[] byArray = this.cffReader.getStringIndex().getValue(n6);
                if (this.mbFont != null) {
                    this.mbFont.mapUsedGlyphName(n5, new String(byArray, "UTF-8"));
                }
                this.gidToSID.put(n5, this.stringIndexData.size() + 391);
                this.stringIndexData.add(byArray);
                continue;
            }
            if (this.mbFont != null) {
                this.mbFont.mapUsedGlyphName(n5, ".notdef");
            }
            this.gidToSID.put(n5, n6);
        }
        this.writeIndex(this.stringIndexData);
    }

    protected void createCharStringDataCID() throws IOException {
        CFFDataReader.CFFIndexData cFFIndexData = this.cffReader.getCharStringIndex();
        CFFDataReader.FDSelect fDSelect = this.cffReader.getFDSelect();
        if (fDSelect instanceof CFFDataReader.Format0FDSelect) {
            throw new UnsupportedOperationException("OTF CFF CID Format0 currently not implemented");
        }
        if (fDSelect instanceof CFFDataReader.Format3FDSelect) {
            int n2;
            int n3;
            CFFDataReader.Format3FDSelect format3FDSelect = (CFFDataReader.Format3FDSelect)fDSelect;
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Map map = format3FDSelect.getRanges();
            Integer[] integerArray = map.keySet().toArray(new Integer[map.size()]);
            Object object = this.subsetGlyphs.keySet().iterator();
            while (object.hasNext()) {
                int n4 = object.next();
                n3 = 0;
                if (this.mbFont.getCIDSet().isVirtualGlyphIndex(n4)) {
                    n4 = this.mbFont.getCIDSet().getOriginalGlyphIndexForVirtual(n4);
                }
                for (Map.Entry entry : map.entrySet()) {
                    n2 = n3 < integerArray.length - 1 ? integerArray[n3 + 1].intValue() : format3FDSelect.getSentinelGID();
                    if (n4 >= (Integer)entry.getKey() && n4 < n2) {
                        int n5 = (Integer)entry.getValue();
                        hashMap.put(n4, n5);
                        if (!arrayList.contains(n5)) {
                            arrayList.add(n5);
                        }
                    }
                    ++n3;
                }
            }
            this.globalIndexSubr = this.cffReader.getGlobalIndexSubr();
            this.subsetCharStringsIndex = new ArrayList<byte[]>();
            this.globalUniques = new ArrayList<Integer>();
            this.subsetFDSelect = new LinkedHashMap<Integer, FDIndexReference>();
            object = new ArrayList();
            Object object2 = arrayList.iterator();
            while (object2.hasNext()) {
                n3 = (Integer)object2.next();
                object.add(new ArrayList());
            }
            object2 = new HashMap();
            for (Map.Entry<Integer, Integer> entry : this.subsetGlyphs.entrySet()) {
                int n6 = entry.getKey();
                if (this.mbFont.getCIDSet().isVirtualGlyphIndex(n6)) {
                    n6 = this.mbFont.getCIDSet().getOriginalGlyphIndexForVirtual(n6);
                }
                n2 = (Integer)hashMap.get(n6);
                this.localIndexSubr = ((CFFDataReader.FontDict)this.cffReader.getFDFonts().get(n2)).getLocalSubrData();
                this.localUniques = (List)object.get(arrayList.indexOf(n2));
                this.type2Parser = new Type2Parser();
                FDIndexReference fDIndexReference = new FDIndexReference(arrayList.indexOf(n2), n2);
                this.subsetFDSelect.put(entry.getValue(), fDIndexReference);
                byte[] byArray = cFFIndexData.getValue(n6);
                this.preScanForSubsetIndexSize(byArray);
                object2.put(n6, this.type2Parser.getMaskLength());
            }
            this.subsetGlobalIndexSubr = new ArrayList<byte[]>();
            this.fdSubrs = new ArrayList<List<byte[]>>();
            this.subsetGlobalSubrCount = this.globalUniques.size();
            this.globalUniques.clear();
            this.localUniques = null;
            Object object3 = object.iterator();
            while (object3.hasNext()) {
                List list = (List)((Object)object3.next());
                this.fdSubrs.add(new ArrayList());
            }
            object3 = new ArrayList();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n7 = (Integer)iterator.next();
                object3.add(new ArrayList());
            }
            for (Map.Entry<Integer, Integer> entry : this.subsetGlyphs.entrySet()) {
                n2 = entry.getKey();
                if (this.mbFont.getCIDSet().isVirtualGlyphIndex(n2)) {
                    n2 = this.mbFont.getCIDSet().getOriginalGlyphIndexForVirtual(n2);
                }
                int n8 = entry.getValue();
                int n9 = (Integer)hashMap.get(n2);
                this.localIndexSubr = ((CFFDataReader.FontDict)this.cffReader.getFDFonts().get(n9)).getLocalSubrData();
                int n10 = this.subsetFDSelect.get(n8).getNewFDIndex();
                this.localUniques = (List)object3.get(n10);
                byte[] byArray = cFFIndexData.getValue(n2);
                this.subsetLocalIndexSubr = this.fdSubrs.get(n10);
                this.subsetLocalSubrCount = ((List)object.get(n10)).size();
                this.type2Parser = new Type2Parser();
                this.type2Parser.setMaskLength((Integer)object2.get(n2));
                byArray = this.readCharStringData(byArray, this.subsetLocalSubrCount);
                this.subsetCharStringsIndex.add(byArray);
            }
        }
    }

    protected void writeFDSelect() {
        if (((CFFDataReader.DICTEntry)this.cffReader.getTopDictEntries().get("CharStrings")).getOperandLength() == 2) {
            Map<Integer, Integer> map = this.getFormat3Index();
            this.writeByte(3);
            this.writeCard16(map.size());
            int n2 = 0;
            for (Map.Entry<Integer, Integer> entry : map.entrySet()) {
                this.writeCard16(n2);
                this.writeByte(entry.getKey());
                n2 += entry.getValue().intValue();
            }
            this.writeCard16(this.subsetFDSelect.size());
        } else {
            this.writeByte(0);
            for (FDIndexReference fDIndexReference : this.subsetFDSelect.values()) {
                this.writeByte(fDIndexReference.getNewFDIndex());
            }
        }
    }

    private Map<Integer, Integer> getFormat3Index() {
        LinkedHashMap<Integer, Integer> linkedHashMap = new LinkedHashMap<Integer, Integer>();
        int n2 = -1;
        int n3 = 0;
        for (FDIndexReference fDIndexReference : this.subsetFDSelect.values()) {
            int n4 = fDIndexReference.getNewFDIndex();
            ++n3;
            if (n4 != n2) {
                linkedHashMap.put(n4, n3);
                n3 = 1;
            }
            n2 = n4;
        }
        linkedHashMap.put(n2, n3);
        return linkedHashMap;
    }

    protected List<Integer> getUsedFDFonts() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (FDIndexReference fDIndexReference : this.subsetFDSelect.values()) {
            int n2 = fDIndexReference.getOldFDIndex();
            if (arrayList.contains(n2)) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    protected List<Integer> writeCIDDictsAndSubrs(List<Integer> list) throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list2 = this.cffReader.getFDFonts();
        int n2 = 0;
        for (int n3 : list) {
            CFFDataReader.FontDict fontDict = (CFFDataReader.FontDict)list2.get(n3);
            byte[] byArray = fontDict.getPrivateDictData();
            LinkedHashMap linkedHashMap = this.cffReader.parseDictData(byArray);
            int n4 = this.currentPos;
            arrayList.add(n4);
            CFFDataReader.DICTEntry dICTEntry = (CFFDataReader.DICTEntry)linkedHashMap.get("Subrs");
            if (dICTEntry != null) {
                byArray = this.resizeToFitOpLen(byArray, dICTEntry);
                this.updateOffset(byArray, dICTEntry.getOffset(), dICTEntry.getOperandLength(), byArray.length);
            }
            this.writeBytes(byArray);
            this.writeIndex(this.fdSubrs.get(n2));
            ++n2;
        }
        return arrayList;
    }

    private byte[] resizeToFitOpLen(byte[] byArray, CFFDataReader.DICTEntry dICTEntry) throws IOException {
        if (dICTEntry.getOperandLength() == 2 && byArray.length < 108) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray);
            byteArrayOutputStream.write(new byte[108 - byArray.length]);
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    protected int writeFDArray(List<Integer> list, List<Integer> list2, List<Integer> list3) throws IOException {
        int n2 = this.currentPos;
        List list4 = this.cffReader.getFDFonts();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n3 = 0;
        for (int n4 : list) {
            CFFDataReader.FontDict fontDict = (CFFDataReader.FontDict)list4.get(n4);
            byte[] byArray = fontDict.getByteData();
            LinkedHashMap linkedHashMap = this.cffReader.parseDictData(byArray);
            this.updateOffset(byArray, ((CFFDataReader.DICTEntry)linkedHashMap.get("FontName")).getOffset() - 1, (Integer)((CFFDataReader.DICTEntry)linkedHashMap.get("FontName")).getOperandLengths().get(0), list3.get(n3));
            this.updateOffset(byArray, ((CFFDataReader.DICTEntry)linkedHashMap.get("Private")).getOffset() + (Integer)((CFFDataReader.DICTEntry)linkedHashMap.get("Private")).getOperandLengths().get(0), (Integer)((CFFDataReader.DICTEntry)linkedHashMap.get("Private")).getOperandLengths().get(1), list2.get(n3));
            arrayList.add(byArray);
            ++n3;
        }
        this.writeIndex(arrayList);
        return n2;
    }

    private void createCharStringData() throws IOException {
        byte[] byArray;
        int n2;
        Object object;
        LinkedHashMap linkedHashMap = this.cffReader.getTopDictEntries();
        CFFDataReader.CFFIndexData cFFIndexData = this.cffReader.getCharStringIndex();
        CFFDataReader.DICTEntry dICTEntry = (CFFDataReader.DICTEntry)linkedHashMap.get("Private");
        if (dICTEntry != null) {
            int n3 = ((Number)dICTEntry.getOperands().get(1)).intValue();
            object = this.cffReader.getPrivateDict(dICTEntry);
            if (object.get("Subrs") != null) {
                n2 = n3 + ((Number)((CFFDataReader.DICTEntry)object.get("Subrs")).getOperands().get(0)).intValue();
                this.localIndexSubr = this.cffReader.readIndex(n2);
            } else {
                this.localIndexSubr = this.cffReader.readIndex(null);
            }
        }
        this.globalIndexSubr = this.cffReader.getGlobalIndexSubr();
        this.subsetLocalIndexSubr = new ArrayList<byte[]>();
        this.subsetGlobalIndexSubr = new ArrayList<byte[]>();
        this.subsetCharStringsIndex = new ArrayList<byte[]>();
        this.localUniques = new ArrayList<Integer>();
        this.globalUniques = new ArrayList<Integer>();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        object = this.subsetGlyphs.keySet().iterator();
        while (object.hasNext()) {
            n2 = (Integer)object.next();
            this.type2Parser = new Type2Parser();
            if (this.mbFont.getCIDSet().isVirtualGlyphIndex(n2)) {
                n2 = this.mbFont.getCIDSet().getOriginalGlyphIndexForVirtual(n2);
            }
            byArray = cFFIndexData.getValue(n2);
            this.preScanForSubsetIndexSize(byArray);
            hashMap.put(n2, this.type2Parser.getMaskLength());
        }
        this.subsetLocalSubrCount = this.localUniques.size();
        this.subsetGlobalSubrCount = this.globalUniques.size();
        this.localUniques.clear();
        this.globalUniques.clear();
        object = this.subsetGlyphs.keySet().iterator();
        while (object.hasNext()) {
            n2 = object.next();
            if (this.mbFont.getCIDSet().isVirtualGlyphIndex(n2)) {
                n2 = this.mbFont.getCIDSet().getOriginalGlyphIndexForVirtual(n2);
            }
            byArray = cFFIndexData.getValue(n2);
            this.type2Parser = new Type2Parser();
            this.type2Parser.setMaskLength((Integer)hashMap.get(n2));
            byArray = this.readCharStringData(byArray, this.subsetLocalSubrCount);
            this.subsetCharStringsIndex.add(byArray);
        }
    }

    private void preScanForSubsetIndexSize(byte[] byArray) throws IOException {
        boolean bl = this.localIndexSubr != null && this.localIndexSubr.getNumObjects() > 0;
        boolean bl2 = this.globalIndexSubr != null && this.globalIndexSubr.getNumObjects() > 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            if (n2 == 10 && bl) {
                this.preScanForSubsetIndexSize(this.localIndexSubr, this.localUniques);
                continue;
            }
            if (n2 == 29 && bl2) {
                this.preScanForSubsetIndexSize(this.globalIndexSubr, this.globalUniques);
                continue;
            }
            i2 += this.type2Parser.exec(n2, byArray, i2);
        }
    }

    private void preScanForSubsetIndexSize(CFFDataReader.CFFIndexData cFFIndexData, List<Integer> list) throws IOException {
        int n2 = this.getSubrNumber(cFFIndexData.getNumObjects(), this.type2Parser.popOperand().getNumber());
        if (!list.contains(n2) && n2 < cFFIndexData.getNumObjects()) {
            list.add(n2);
        }
        if (n2 >= cFFIndexData.getNumObjects()) {
            throw new IllegalArgumentException("callgsubr out of range");
        }
        byte[] byArray = cFFIndexData.getValue(n2);
        this.preScanForSubsetIndexSize(byArray);
    }

    private int getSubrNumber(int n2, int n3) {
        int n4 = this.getBias(n2);
        return n4 + n3;
    }

    private byte[] readCharStringData(byte[] byArray, int n2) throws IOException {
        boolean bl = this.localIndexSubr != null && this.localIndexSubr.getNumObjects() > 0;
        boolean bl2 = this.globalIndexSubr != null && this.globalIndexSubr.getNumObjects() > 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte[] byArray2;
            int n3;
            int n4;
            BytesNumber bytesNumber;
            int n5 = byArray[i2] & 0xFF;
            if (n5 == 10 && bl) {
                bytesNumber = this.type2Parser.popOperand();
                n4 = this.getSubrNumber(this.localIndexSubr.getNumObjects(), bytesNumber.getNumber());
                n3 = this.getNewRefForReference(n4, this.localUniques, this.localIndexSubr, this.subsetLocalIndexSubr, n2);
                if (n3 == -1) continue;
                byArray2 = this.constructNewRefData(i2, byArray, bytesNumber, n2, n3, new int[]{10});
                i2 -= byArray.length - byArray2.length;
                byArray = byArray2;
                continue;
            }
            if (n5 == 29 && bl2) {
                bytesNumber = this.type2Parser.popOperand();
                n4 = this.getSubrNumber(this.globalIndexSubr.getNumObjects(), bytesNumber.getNumber());
                n3 = this.getNewRefForReference(n4, this.globalUniques, this.globalIndexSubr, this.subsetGlobalIndexSubr, this.subsetGlobalSubrCount);
                if (n3 == -1) continue;
                byArray2 = this.constructNewRefData(i2, byArray, bytesNumber, this.subsetGlobalSubrCount, n3, new int[]{29});
                i2 -= byArray.length - byArray2.length;
                byArray = byArray2;
                continue;
            }
            i2 += this.type2Parser.exec(n5, byArray, i2);
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getNewRefForReference(int n2, List<Integer> list, CFFDataReader.CFFIndexData cFFIndexData, List<byte[]> list2, int n3) throws IOException {
        if (list.contains(n2)) return list.indexOf(n2);
        if (n2 >= cFFIndexData.getNumObjects()) throw new IllegalArgumentException("subrNumber out of range");
        byte[] byArray = cFFIndexData.getValue(n2);
        byArray = this.readCharStringData(byArray, n3);
        list.add(n2);
        list2.add(byArray);
        return list2.size() - 1;
    }

    private int getBias(int n2) {
        if (n2 < 1240) {
            return 107;
        }
        if (n2 < 33900) {
            return 1131;
        }
        return 32768;
    }

    private byte[] constructNewRefData(int n2, byte[] byArray, BytesNumber bytesNumber, int n3, int n4, int[] nArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n5 = n2 - bytesNumber.getNumBytes();
        int n6 = bytesNumber.getNumBytes() + 1;
        int n7 = this.getBias(n3);
        int n8 = n4 - n7;
        byte[] byArray2 = OTFSubSetFile.createNewRef(n8, nArray, -1, false);
        byteArrayOutputStream.write(byArray, 0, n5);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(byArray, n5 + n6, byArray.length - (n5 + n6));
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createNewRef(int n2, int[] nArray, int n3, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n3 == -1 && n2 >= -107 && n2 <= 107 || n3 == 1) {
            byteArrayOutputStream.write(n2 + 139);
        } else if (n3 == -1 && n2 >= -1131 && n2 <= 1131 || n3 == 2) {
            if (n2 <= -876) {
                byteArrayOutputStream.write(254);
            } else if (n2 <= -620) {
                byteArrayOutputStream.write(253);
            } else if (n2 <= -364) {
                byteArrayOutputStream.write(252);
            } else if (n2 <= -108) {
                byteArrayOutputStream.write(251);
            } else if (n2 <= 363) {
                byteArrayOutputStream.write(247);
            } else if (n2 <= 619) {
                byteArrayOutputStream.write(248);
            } else if (n2 <= 875) {
                byteArrayOutputStream.write(249);
            } else {
                byteArrayOutputStream.write(250);
            }
            if (n2 > 0) {
                byteArrayOutputStream.write(n2 - 108);
            } else {
                byteArrayOutputStream.write(-n2 - 108);
            }
        } else if (n3 == -1 && n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE || n3 == 3) {
            byteArrayOutputStream.write(28);
            byteArrayOutputStream.write(n2 >> 8);
            byteArrayOutputStream.write(n2);
        } else {
            if (bl) {
                byteArrayOutputStream.write(29);
            } else {
                byteArrayOutputStream.write(255);
            }
            byteArrayOutputStream.write(n2 >> 24);
            byteArrayOutputStream.write(n2 >> 16);
            byteArrayOutputStream.write(n2 >> 8);
            byteArrayOutputStream.write(n2);
        }
        for (int n4 : nArray) {
            byteArrayOutputStream.write(n4);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected int writeIndex(List<byte[]> list) {
        int n2 = 1;
        for (byte[] byArray : list) {
            n2 += byArray.length;
        }
        int n3 = this.getOffSize(n2);
        return this.writeIndex(list, n3);
    }

    protected int writeIndex(List<byte[]> list, int n2) {
        int n3 = 3;
        this.writeCard16(list.size());
        this.writeByte(n2);
        n3 += n2;
        int n4 = 0;
        int n5 = 0;
        for (byte[] byArray : list) {
            n3 += n2;
            int n6 = byArray.length;
            switch (n2) {
                case 1: {
                    if (n5 == 0) {
                        this.writeByte(1);
                    }
                    this.writeByte((n4 += n6) + 1);
                    break;
                }
                case 2: {
                    if (n5 == 0) {
                        this.writeCard16(1);
                    }
                    this.writeCard16((n4 += n6) + 1);
                    break;
                }
                case 3: {
                    if (n5 == 0) {
                        this.writeThreeByteNumber(1);
                    }
                    this.writeThreeByteNumber((n4 += n6) + 1);
                    break;
                }
                case 4: {
                    if (n5 == 0) {
                        this.writeULong(1);
                    }
                    this.writeULong((n4 += n6) + 1);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Offset Size was not an expected value.");
                }
            }
            ++n5;
        }
        for (byte[] byArray : list) {
            this.writeBytes(byArray);
        }
        return n3 + n4;
    }

    private int getOffSize(int n2) {
        int n3 = 1;
        n3 = n2 < 256 ? 1 : (n2 < 65536 ? 2 : (n2 < 0x1000000 ? 3 : 4));
        return n3;
    }

    private void writeCharsetTable(boolean bl) throws IOException {
        if (bl) {
            this.writeByte(2);
            for (int n2 : this.gidToSID.keySet()) {
                if (n2 == 0) continue;
                this.writeCard16(n2);
                this.writeCard16(this.gidToSID.size() - 1);
                break;
            }
        } else {
            this.writeByte(0);
            for (int n3 : this.gidToSID.values()) {
                if (n3 == 0) continue;
                this.writeCard16(n3);
            }
        }
    }

    protected void writePrivateDict() throws IOException {
        LinkedHashMap linkedHashMap = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry dICTEntry = (CFFDataReader.DICTEntry)linkedHashMap.get("Private");
        if (dICTEntry != null) {
            this.writeBytes(this.cffReader.getPrivateDictBytes(dICTEntry));
        }
    }

    protected void updateOffsets(Offsets offsets) throws IOException {
        LinkedHashMap linkedHashMap = this.cffReader.getTopDictEntries();
        Map map = null;
        CFFDataReader.DICTEntry dICTEntry = (CFFDataReader.DICTEntry)linkedHashMap.get("Private");
        if (dICTEntry != null) {
            map = this.cffReader.getPrivateDict(dICTEntry);
        }
        this.updateFixedOffsets(linkedHashMap, offsets);
        if (map != null) {
            int n2 = offsets.topDictData + dICTEntry.getOffset();
            this.updateOffset(n2 + (Integer)dICTEntry.getOperandLengths().get(0), (Integer)dICTEntry.getOperandLengths().get(1), offsets.privateDict);
            CFFDataReader.DICTEntry dICTEntry2 = (CFFDataReader.DICTEntry)map.get("Subrs");
            if (dICTEntry2 != null) {
                int n3 = offsets.privateDict + dICTEntry2.getOffset();
                this.updateOffset(n3, dICTEntry2.getOperandLength(), offsets.localIndex - offsets.privateDict);
            }
        }
    }

    protected void updateFixedOffsets(Map<String, CFFDataReader.DICTEntry> map, Offsets offsets) throws IOException {
        CFFDataReader.DICTEntry dICTEntry = map.get("charset");
        int n2 = offsets.topDictData + dICTEntry.getOffset();
        this.updateOffset(n2, dICTEntry.getOperandLength(), offsets.charset);
        CFFDataReader.DICTEntry dICTEntry2 = map.get("CharStrings");
        int n3 = offsets.topDictData + dICTEntry2.getOffset();
        this.updateOffset(n3, dICTEntry2.getOperandLength(), offsets.charString);
        CFFDataReader.DICTEntry dICTEntry3 = map.get("Encoding");
        if (dICTEntry3 != null && ((Number)dICTEntry3.getOperands().get(0)).intValue() != 0 && ((Number)dICTEntry3.getOperands().get(0)).intValue() != 1) {
            int n4 = offsets.topDictData + dICTEntry3.getOffset();
            this.updateOffset(n4, dICTEntry3.getOperandLength(), offsets.encoding);
        }
    }

    protected void updateCIDOffsets(Offsets offsets) throws IOException {
        CFFDataReader.DICTEntry dICTEntry;
        LinkedHashMap linkedHashMap = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry dICTEntry2 = (CFFDataReader.DICTEntry)linkedHashMap.get("FDArray");
        if (dICTEntry2 != null) {
            this.updateOffset(offsets.topDictData + dICTEntry2.getOffset() - 1, dICTEntry2.getOperandLength(), offsets.fdArray);
        }
        if ((dICTEntry = (CFFDataReader.DICTEntry)linkedHashMap.get("FDSelect")) != null) {
            this.updateOffset(offsets.topDictData + dICTEntry.getOffset() - 1, dICTEntry.getOperandLength(), offsets.fdSelect);
        }
        this.updateFixedOffsets(linkedHashMap, offsets);
    }

    private void updateOffset(int n2, int n3, int n4) throws IOException {
        byte[] byArray = this.output.toByteArray();
        this.updateOffset(byArray, n2, n3, n4);
        this.output.reset();
        this.output.write(byArray);
    }

    private void updateOffset(byte[] byArray, int n2, int n3, int n4) {
        switch (n3) {
            case 1: {
                byArray[n2] = (byte)(n4 + 139);
                break;
            }
            case 2: {
                assert (n4 <= 1131);
                byArray[n2] = n4 <= -876 ? -2 : (n4 <= -620 ? -3 : (n4 <= -364 ? -4 : (n4 <= -108 ? -5 : (n4 <= 363 ? -9 : (n4 <= 619 ? -8 : (n4 <= 875 ? -7 : -6))))));
                if (n4 > 0) {
                    byArray[n2 + 1] = (byte)(n4 - 108);
                    break;
                }
                byArray[n2 + 1] = (byte)(-n4 - 108);
                break;
            }
            case 3: {
                assert (n4 <= Short.MAX_VALUE);
                byArray[n2] = 28;
                byArray[n2 + 1] = (byte)(n4 >> 8 & 0xFF);
                byArray[n2 + 2] = (byte)(n4 & 0xFF);
                break;
            }
            case 5: {
                byArray[n2] = 29;
                byArray[n2 + 1] = (byte)(n4 >> 24 & 0xFF);
                byArray[n2 + 2] = (byte)(n4 >> 16 & 0xFF);
                byArray[n2 + 3] = (byte)(n4 >> 8 & 0xFF);
                byArray[n2 + 4] = (byte)(n4 & 0xFF);
                break;
            }
        }
    }

    public CFFDataReader getCFFReader() {
        return this.cffReader;
    }

    static class Offsets {
        Integer topDictData;
        Integer encoding;
        Integer charset;
        Integer fdSelect;
        Integer charString;
        Integer fdArray;
        Integer privateDict;
        Integer localIndex;

        Offsets() {
        }
    }

    static class Type2Parser {
        protected Log log = LogFactory.getLog(Type2Parser.class);
        private List<BytesNumber> stack = new ArrayList<BytesNumber>();
        private int hstemCount;
        private int vstemCount;
        private int lastOp = -1;
        private int maskLength = -1;

        Type2Parser() {
        }

        public void pushOperand(BytesNumber bytesNumber) {
            this.stack.add(bytesNumber);
        }

        public BytesNumber popOperand() {
            return this.stack.remove(this.stack.size() - 1);
        }

        public void clearStack() {
            this.stack.clear();
        }

        public int[] getOperands(int n2) {
            int[] nArray = new int[n2];
            while (n2 > 0) {
                nArray[--n2] = this.popOperand().getNumber();
            }
            return nArray;
        }

        public void setMaskLength(int n2) {
            this.maskLength = n2;
        }

        public int getMaskLength() {
            if (this.maskLength > 0) {
                return this.maskLength;
            }
            return 1 + (this.hstemCount + this.vstemCount - 1) / 8;
        }

        private int exec(int n2, byte[] byArray, int n3) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            byteArrayInputStream.skip(n3 + 1);
            return this.exec(n2, byteArrayInputStream);
        }

        public int exec(int n2, InputStream inputStream) throws IOException {
            int n3 = 0;
            if (n2 >= 0 && n2 <= 27 || n2 >= 29 && n2 <= 31) {
                if (n2 == 12) {
                    this.log.warn((Object)"May not guess the operand count correctly.");
                    n3 = 1;
                } else if (n2 == 1 || n2 == 18) {
                    this.hstemCount += this.stack.size() / 2;
                    this.clearStack();
                } else if (n2 == 19 || n2 == 20) {
                    if (this.lastOp == 1 || this.lastOp == 18) {
                        this.vstemCount += this.stack.size() / 2;
                    }
                    this.clearStack();
                    n3 = this.getMaskLength();
                } else if (n2 == 3 || n2 == 23) {
                    this.vstemCount += this.stack.size() / 2;
                    this.clearStack();
                }
                if (n2 != 11 && n2 != 12) {
                    this.lastOp = n2;
                }
            } else if (n2 == 28 || n2 >= 32 && n2 <= 255) {
                BytesNumber bytesNumber = this.readNumber(n2, inputStream);
                this.pushOperand(bytesNumber);
                n3 = bytesNumber.getNumBytes() - 1;
            } else {
                throw new UnsupportedOperationException("Operator:" + n2 + " is not supported");
            }
            return n3;
        }

        private BytesNumber readNumber(int n2, InputStream inputStream) throws IOException {
            if (n2 == 28) {
                int n3 = inputStream.read();
                int n4 = inputStream.read();
                return new BytesNumber((short)(n3 << 8 | n4), 3);
            }
            if (n2 >= 32 && n2 <= 246) {
                return new BytesNumber(n2 - 139, 1);
            }
            if (n2 >= 247 && n2 <= 250) {
                int n5 = inputStream.read();
                return new BytesNumber((n2 - 247) * 256 + n5 + 108, 2);
            }
            if (n2 >= 251 && n2 <= 254) {
                int n6 = inputStream.read();
                return new BytesNumber(-(n2 - 251) * 256 - n6 - 108, 2);
            }
            if (n2 == 255) {
                int n7 = inputStream.read();
                int n8 = inputStream.read();
                int n9 = inputStream.read();
                int n10 = inputStream.read();
                return new BytesNumber(n7 << 24 | n8 << 16 | n9 << 8 | n10, 5);
            }
            throw new IllegalArgumentException();
        }
    }

    private static class FDIndexReference {
        private int newFDIndex;
        private int oldFDIndex;

        public FDIndexReference(int n2, int n3) {
            this.newFDIndex = n2;
            this.oldFDIndex = n3;
        }

        public int getNewFDIndex() {
            return this.newFDIndex;
        }

        public int getOldFDIndex() {
            return this.oldFDIndex;
        }
    }

    static class BytesNumber {
        private int number;
        private int numBytes;

        public BytesNumber(int n2, int n3) {
            this.number = n2;
            this.numBytes = n3;
        }

        public int getNumber() {
            return this.number;
        }

        public int getNumBytes() {
            return this.numBytes;
        }

        public void clearNumber() {
            this.number = -1;
            this.numBytes = -1;
        }

        public String toString() {
            return Integer.toString(this.number);
        }

        public boolean equals(Object object) {
            assert (object instanceof BytesNumber);
            BytesNumber bytesNumber = (BytesNumber)object;
            return this.number == bytesNumber.getNumber() && this.numBytes == bytesNumber.getNumBytes();
        }

        public int hashCode() {
            int n2 = 1;
            n2 = n2 * 17 + this.number;
            n2 = n2 * 31 + this.numBytes;
            return n2;
        }
    }
}

