/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.CFFToType1Font;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.NamedCharacter;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OTFFile;
import org.apache.fop.fonts.truetype.OpenFont;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.util.HexEncoder;
import org.apache.xmlgraphics.io.Resource;

public class OFFontLoader
extends FontLoader {
    private MultiByteFont multiFont;
    private SingleByteFont singleFont;
    private final String subFontName;
    private EncodingMode encodingMode;
    private EmbeddingMode embeddingMode;
    private boolean simulateStyle;
    private boolean embedAsType1;
    private boolean useSVG;

    public OFFontLoader(URI uRI, InternalResourceResolver internalResourceResolver) {
        this(uRI, null, true, EmbeddingMode.AUTO, EncodingMode.AUTO, true, true, internalResourceResolver, false, false, true);
    }

    public OFFontLoader(URI uRI, String string, boolean bl, EmbeddingMode embeddingMode, EncodingMode encodingMode, boolean bl2, boolean bl3, InternalResourceResolver internalResourceResolver, boolean bl4, boolean bl5, boolean bl6) {
        super(uRI, bl, bl2, bl3, internalResourceResolver);
        this.subFontName = string;
        this.encodingMode = encodingMode;
        this.embeddingMode = embeddingMode;
        this.simulateStyle = bl4;
        this.embedAsType1 = bl5;
        this.useSVG = bl6;
        if (this.encodingMode == EncodingMode.AUTO) {
            this.encodingMode = EncodingMode.CID;
        }
        if (this.embeddingMode == EmbeddingMode.AUTO) {
            this.embeddingMode = EmbeddingMode.SUBSET;
        }
    }

    protected void read() throws IOException {
        this.read(this.subFontName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(String string) throws IOException {
        Resource resource = this.resourceResolver.getResource(this.fontFileURI);
        try {
            FontFileReader fontFileReader = new FontFileReader((InputStream)resource);
            String string2 = OFFontLoader.readHeader(fontFileReader);
            boolean bl = this.isCFF(string, fontFileReader, string2);
            OTFFile oTFFile = bl ? new OTFFile(this.useKerning, this.useAdvanced) : new TTFFile(this.useKerning, this.useAdvanced);
            boolean bl2 = oTFFile.readFont(fontFileReader, string2, string);
            if (!bl2) {
                throw new IOException("The font does not have a Unicode cmap table: " + this.fontFileURI);
            }
            this.buildFont(oTFFile, string);
            this.loaded = true;
        }
        finally {
            IOUtils.closeQuietly((InputStream)resource);
        }
    }

    private boolean isCFF(String string, FontFileReader fontFileReader, String string2) throws IOException {
        boolean bl = false;
        if (string2.equals("ttcf")) {
            TTFFile tTFFile = new TTFFile(this.useKerning, this.useAdvanced);
            tTFFile.initializeFont(fontFileReader);
            tTFFile.checkTTC(string2, string);
            bl = fontFileReader.readTTFString(4).equals("OTTO");
            OFFontLoader.readHeader(fontFileReader);
        } else {
            bl = string2.equals("OTTO");
        }
        return bl;
    }

    public static String readHeader(FontFileReader fontFileReader) throws IOException {
        if (fontFileReader != null) {
            fontFileReader.seekSet(0L);
            return fontFileReader.readTTFString(4);
        }
        return null;
    }

    private void buildFont(OpenFont openFont, String string) {
        Object object;
        boolean bl = this.embedded;
        if (this.encodingMode == EncodingMode.SINGLE_BYTE) {
            bl = false;
        }
        if (bl) {
            this.multiFont = openFont instanceof OTFFile && this.embedAsType1 ? new CFFToType1Font(this.resourceResolver, this.embeddingMode) : new MultiByteFont(this.resourceResolver, this.embeddingMode);
            this.multiFont.setIsOTFFile(openFont instanceof OTFFile);
            this.returnFont = this.multiFont;
            this.multiFont.setTTCName(string);
            object = this.multiFont;
        } else {
            this.singleFont = new SingleByteFont(this.resourceResolver, this.embeddingMode);
            this.returnFont = this.singleFont;
            object = this.singleFont;
        }
        object.setSimulateStyle(this.simulateStyle);
        this.returnFont.setFontURI(this.fontFileURI);
        if (!openFont.getEmbedFontName().equals("")) {
            this.returnFont.setFontName(openFont.getEmbedFontName());
        } else {
            this.returnFont.setFontName(openFont.getPostScriptName());
        }
        this.returnFont.setFullName(openFont.getFullName());
        this.returnFont.setFamilyNames(openFont.getFamilyNames());
        this.returnFont.setFontSubFamilyName(openFont.getSubFamilyName());
        this.returnFont.setCapHeight(openFont.getCapHeight());
        this.returnFont.setXHeight(openFont.getXHeight());
        this.returnFont.setAscender(openFont.getLowerCaseAscent());
        this.returnFont.setDescender(openFont.getLowerCaseDescent());
        this.returnFont.setFontBBox(openFont.getFontBBox());
        this.returnFont.setUnderlinePosition(openFont.getUnderlinePosition() - openFont.getUnderlineThickness() / 2);
        this.returnFont.setUnderlineThickness(openFont.getUnderlineThickness());
        this.returnFont.setStrikeoutPosition(openFont.getStrikeoutPosition() - openFont.getStrikeoutThickness() / 2);
        this.returnFont.setStrikeoutThickness(openFont.getStrikeoutThickness());
        this.returnFont.setFlags(openFont.getFlags());
        this.returnFont.setStemV(Integer.parseInt(openFont.getStemV()));
        this.returnFont.setItalicAngle(Integer.parseInt(openFont.getItalicAngle()));
        this.returnFont.setMissingWidth(0);
        this.returnFont.setWeight(openFont.getWeightClass());
        if (bl) {
            if (openFont instanceof OTFFile) {
                if (((OTFFile)openFont).isType1() && this.embeddingMode == EmbeddingMode.SUBSET && !this.embedAsType1) {
                    this.multiFont.setFontType(FontType.TYPE1C);
                    this.copyGlyphMetricsSingleByte(openFont);
                }
                this.multiFont.setCIDType(CIDFontType.CIDTYPE0);
            } else {
                this.multiFont.setCIDType(CIDFontType.CIDTYPE2);
            }
            this.multiFont.setWidthArray(openFont.getWidths());
            this.multiFont.setBBoxArray(openFont.getBoundingBoxes());
        } else {
            this.singleFont.setFontType(FontType.TRUETYPE);
            this.singleFont.setEncoding(openFont.getCharSetName());
            this.returnFont.setFirstChar((int)openFont.getFirstChar());
            this.returnFont.setLastChar((int)openFont.getLastChar());
            this.singleFont.setTrueTypePostScriptVersion(openFont.getPostScriptVersion());
            this.copyGlyphMetricsSingleByte(openFont);
        }
        this.returnFont.setCMap(this.getCMap(openFont));
        if (this.useSVG) {
            this.returnFont.setSVG(openFont.svgs);
        }
        if (openFont.getKerning() != null && this.useKerning) {
            this.copyKerning(openFont, bl);
        }
        if (this.useAdvanced) {
            this.copyAdvanced(openFont);
        }
        if (this.embedded) {
            if (openFont.isEmbeddable()) {
                this.returnFont.setEmbedURI(this.fontFileURI);
            } else {
                String string2 = "The font " + this.fontFileURI + " is not embeddable due to a licensing restriction.";
                throw new RuntimeException(string2);
            }
        }
    }

    private CMapSegment[] getCMap(OpenFont openFont) {
        CMapSegment[] cMapSegmentArray = new CMapSegment[openFont.getCMaps().size()];
        return openFont.getCMaps().toArray(cMapSegmentArray);
    }

    private void copyGlyphMetricsSingleByte(OpenFont openFont) {
        int[] nArray = openFont.getWidths();
        Rectangle[] rectangleArray = openFont.getBoundingBoxes();
        if (this.singleFont != null) {
            for (int i2 = this.singleFont.getFirstChar(); i2 <= this.singleFont.getLastChar(); ++i2) {
                this.singleFont.setWidth(i2, openFont.getCharWidth(i2));
                Object object = openFont.getBBox(i2);
                this.singleFont.setBoundingBox(i2, new Rectangle((int)object[0], (int)object[1], (int)(object[2] - object[0]), (int)(object[3] - object[1])));
            }
        }
        for (Object object : openFont.getCMaps()) {
            if (object.getUnicodeStart() >= 65534) continue;
            for (char c2 = (char)object.getUnicodeStart(); c2 <= object.getUnicodeEnd(); c2 = (char)(c2 + '\u0001')) {
                int n2 = 0;
                if (this.singleFont != null) {
                    n2 = this.singleFont.getEncoding().mapChar(c2);
                }
                if (n2 > 0) continue;
                int n3 = object.getGlyphStartIndex() + c2 - object.getUnicodeStart();
                Object object2 = openFont.getGlyphName(n3);
                if (((String)object2).length() == 0 && openFont.getPostScriptVersion() != OpenFont.PostScriptVersion.V2) {
                    object2 = "u" + HexEncoder.encode((int)c2);
                }
                if (((String)object2).length() <= 0) continue;
                String string = Character.toString(c2);
                NamedCharacter namedCharacter = new NamedCharacter((String)object2, string);
                this.returnFont.addUnencodedCharacter(namedCharacter, nArray[n3], rectangleArray[n3]);
            }
        }
    }

    private void copyKerning(OpenFont openFont, boolean bl) {
        Set<Integer> set = bl ? openFont.getKerning().keySet() : openFont.getAnsiKerning().keySet();
        for (Integer n2 : set) {
            Map<Integer, Integer> map = bl ? openFont.getKerning().get(n2) : openFont.getAnsiKerning().get(n2);
            this.returnFont.putKerningEntry(n2, map);
        }
    }

    private void copyAdvanced(OpenFont openFont) {
        if (this.returnFont instanceof MultiByteFont) {
            MultiByteFont multiByteFont = (MultiByteFont)this.returnFont;
            multiByteFont.setGDEF(openFont.getGDEF());
            multiByteFont.setGSUB(openFont.getGSUB());
            multiByteFont.setGPOS(openFont.getGPOS());
        }
    }
}

