/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OFDirTabEntry;
import org.apache.fop.fonts.truetype.OFMtxEntry;

public class GlyfTable {
    private final OFMtxEntry[] mtxTab;
    private final long tableOffset;
    private final Set<Long> remappedComposites;
    protected final Map<Integer, Integer> subset;
    private final FontFileReader in;
    protected Set<Integer> compositeGlyphs = new TreeSet<Integer>();
    protected Set<Integer> composedGlyphs = new TreeSet<Integer>();
    private MultiByteFont mbFont;

    public GlyfTable(FontFileReader fontFileReader, OFMtxEntry[] oFMtxEntryArray, OFDirTabEntry oFDirTabEntry, Map<Integer, Integer> map, MultiByteFont multiByteFont) throws IOException {
        this.mtxTab = oFMtxEntryArray;
        this.mbFont = multiByteFont;
        this.tableOffset = oFDirTabEntry.getOffset();
        this.remappedComposites = new HashSet<Long>();
        this.subset = map;
        this.in = fontFileReader;
    }

    protected void populateGlyphsWithComposites() throws IOException {
        for (int n2 : this.subset.keySet()) {
            this.scanGlyphsRecursively(n2);
        }
        this.addAllComposedGlyphsToSubset();
        for (int n2 : this.compositeGlyphs) {
            long l2 = this.tableOffset + this.mtxTab[n2].getOffset() + 10L;
            if (this.remappedComposites.contains(l2)) continue;
            this.remapComposite(l2);
        }
    }

    private void scanGlyphsRecursively(int n2) throws IOException {
        if (!this.subset.containsKey(n2)) {
            this.composedGlyphs.add(n2);
        }
        if (this.isComposite(n2)) {
            if (this.mbFont.getCIDSet().isVirtualGlyphIndex(n2)) {
                n2 = this.mbFont.getCIDSet().getOriginalGlyphIndexForVirtual(n2);
            }
            this.compositeGlyphs.add(n2);
            Set<Integer> set = this.retrieveComposedGlyphs(n2);
            for (Integer n3 : set) {
                if (n3 == n2) continue;
                this.scanGlyphsRecursively(n3);
            }
        }
    }

    protected void addAllComposedGlyphsToSubset() {
        int n2 = this.subset.size();
        for (int n3 : this.composedGlyphs) {
            this.subset.put(n3, n2++);
        }
    }

    private void remapComposite(long l2) throws IOException {
        long l3 = l2;
        this.remappedComposites.add(l3);
        int n2 = 0;
        do {
            n2 = this.in.readTTFUShort(l3);
            int n3 = this.in.readTTFUShort(l3 + 2L);
            Integer n4 = this.subset.get(n3);
            assert (n4 != null);
            this.in.writeTTFUShort(l3 + 2L, n4.intValue());
            l3 += (long)(4 + GlyfFlags.getOffsetToNextComposedGlyf(n2));
        } while (GlyfFlags.hasMoreComposites(n2));
    }

    public boolean isComposite(int n2) throws IOException {
        short s2;
        if (this.mbFont.getCIDSet().isVirtualGlyphIndex(n2)) {
            n2 = this.mbFont.getCIDSet().getOriginalGlyphIndexForVirtual(n2);
        }
        return (s2 = this.in.readTTFShort(this.tableOffset + this.mtxTab[n2].getOffset())) < 0;
    }

    public Set<Integer> retrieveComposedGlyphs(int n2) throws IOException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        long l2 = this.tableOffset + this.mtxTab[n2].getOffset() + 10L;
        int n3 = 0;
        do {
            n3 = this.in.readTTFUShort(l2);
            hashSet.add(this.in.readTTFUShort(l2 + 2L));
            l2 += (long)(4 + GlyfFlags.getOffsetToNextComposedGlyf(n3));
        } while (GlyfFlags.hasMoreComposites(n3));
        return hashSet;
    }

    public static enum GlyfFlags {
        ARG_1_AND_2_ARE_WORDS(4, 2),
        ARGS_ARE_XY_VALUES,
        ROUND_XY_TO_GRID,
        WE_HAVE_A_SCALE(2),
        RESERVED,
        MORE_COMPONENTS,
        WE_HAVE_AN_X_AND_Y_SCALE(4),
        WE_HAVE_A_TWO_BY_TWO(8),
        WE_HAVE_INSTRUCTIONS,
        USE_MY_METRICS,
        OVERLAP_COMPOUND,
        SCALED_COMPONENT_OFFSET,
        UNSCALED_COMPONENT_OFFSET;

        private final int bitMask = 1 << this.ordinal();
        private final int argsCountIfSet;
        private final int argsCountIfNotSet;

        private GlyfFlags(int n3, int n4) {
            this.argsCountIfSet = n3;
            this.argsCountIfNotSet = n4;
        }

        private GlyfFlags(int n3) {
            this(n3, 0);
        }

        private GlyfFlags() {
            this(0, 0);
        }

        public static int getOffsetToNextComposedGlyf(int n2) {
            int n3 = 0;
            for (GlyfFlags glyfFlags : GlyfFlags.values()) {
                n3 += (n2 & glyfFlags.bitMask) > 0 ? glyfFlags.argsCountIfSet : glyfFlags.argsCountIfNotSet;
            }
            return n3;
        }

        public static boolean hasMoreComposites(int n2) {
            return (n2 & GlyfFlags.MORE_COMPONENTS.bitMask) > 0;
        }
    }
}

