/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.java2d.CustomFontMetricsMapper;
import org.apache.fop.util.CharUtilities;

public class Font
implements Substitutable,
Positionable {
    public static final int WEIGHT_EXTRA_BOLD = 800;
    public static final int WEIGHT_BOLD = 700;
    public static final int WEIGHT_NORMAL = 400;
    public static final int WEIGHT_LIGHT = 200;
    public static final String STYLE_NORMAL = "normal";
    public static final String STYLE_ITALIC = "italic";
    public static final String STYLE_OBLIQUE = "oblique";
    public static final String STYLE_INCLINED = "inclined";
    public static final int PRIORITY_DEFAULT = 0;
    public static final FontTriplet DEFAULT_FONT = new FontTriplet("any", "normal", 400, 0);
    private static Log log = LogFactory.getLog(Font.class);
    private final String fontName;
    private final FontTriplet triplet;
    private final int fontSize;
    private final FontMetrics metric;
    private static boolean fixForAscender = true;

    public Font(String string, FontTriplet fontTriplet, FontMetrics fontMetrics, int n2) {
        this.fontName = string;
        this.triplet = fontTriplet;
        this.metric = fontMetrics;
        this.fontSize = n2;
    }

    public FontMetrics getFontMetrics() {
        return this.metric;
    }

    public boolean isMultiByte() {
        return this.getFontMetrics().isMultiByte();
    }

    public static void setFixForAscender(boolean bl) {
        fixForAscender = bl;
    }

    public static boolean getFixForAscender() {
        return fixForAscender;
    }

    public int getAscender() {
        if (fixForAscender) {
            return this.metric.getAscender(this.fontSize) / 1000 - this.getDescender();
        }
        return this.metric.getAscender(this.fontSize) / 1000;
    }

    public int getCapHeight() {
        return this.metric.getCapHeight(this.fontSize) / 1000;
    }

    public int getDescender() {
        return this.metric.getDescender(this.fontSize) / 1000;
    }

    public String getFontName() {
        return this.fontName;
    }

    public FontTriplet getFontTriplet() {
        return this.triplet;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public int getXHeight() {
        return this.metric.getXHeight(this.fontSize) / 1000;
    }

    public boolean hasKerning() {
        return this.metric.hasKerningInfo();
    }

    public boolean hasFeature(int n2, String string, String string2, String string3) {
        return this.metric.hasFeature(n2, string, string2, string3);
    }

    public Map<Integer, Map<Integer, Integer>> getKerning() {
        if (this.metric.hasKerningInfo()) {
            return this.metric.getKerningInfo();
        }
        return Collections.emptyMap();
    }

    public int getKernValue(int n2, int n3) {
        Integer n4;
        if (n2 >= 55296 && n2 <= 57344) {
            return 0;
        }
        if (n3 >= 55296 && n3 <= 57344) {
            return 0;
        }
        Map<Integer, Integer> map = this.getKerning().get(n2);
        if (map != null && (n4 = map.get(n3)) != null) {
            return n4 * this.getFontSize() / 1000;
        }
        return 0;
    }

    public int getWidth(int n2) {
        return this.metric.getWidth(n2, this.fontSize) / 1000;
    }

    public char mapChar(char c2) {
        if (this.metric instanceof Typeface) {
            return ((Typeface)this.metric).mapChar(c2);
        }
        char c3 = CodePointMapping.getMapping((String)"WinAnsiEncoding").mapChar(c2);
        if (c3 != '\u0000') {
            c2 = c3;
        } else {
            log.warn((Object)("Glyph " + c2 + " not available in font " + this.fontName));
            c2 = (char)35;
        }
        return c2;
    }

    public int mapCodePoint(int n2) {
        FontMetrics fontMetrics = this.getRealFontMetrics();
        if (fontMetrics instanceof CIDFont) {
            return ((CIDFont)fontMetrics).mapCodePoint(n2);
        }
        if (CharUtilities.isBmpCodePoint((int)n2)) {
            return this.mapChar((char)n2);
        }
        return 35;
    }

    public boolean hasChar(char c2) {
        if (this.metric instanceof Typeface) {
            return ((Typeface)this.metric).hasChar(c2);
        }
        return CodePointMapping.getMapping((String)"WinAnsiEncoding").mapChar(c2) > '\u0000';
    }

    public boolean hasCodePoint(int n2) {
        FontMetrics fontMetrics = this.getRealFontMetrics();
        if (fontMetrics instanceof CIDFont) {
            return ((CIDFont)fontMetrics).hasCodePoint(n2);
        }
        if (CharUtilities.isBmpCodePoint((int)n2)) {
            return this.hasChar((char)n2);
        }
        return false;
    }

    private FontMetrics getRealFontMetrics() {
        FontMetrics fontMetrics = this.metric;
        if (fontMetrics instanceof CustomFontMetricsMapper) {
            fontMetrics = ((CustomFontMetricsMapper)fontMetrics).getRealFont();
        }
        if (fontMetrics instanceof LazyFont) {
            return ((LazyFont)fontMetrics).getRealFont();
        }
        return fontMetrics;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append('{');
        stringBuffer.append(this.fontName);
        stringBuffer.append(',');
        stringBuffer.append(this.fontSize);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public int getCharWidth(char c2) {
        int n2;
        if (c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '\u00a0') {
            n2 = this.getCharWidth(' ');
        } else {
            int n3;
            if (this.hasChar(c2)) {
                n3 = this.mapChar(c2);
                n2 = this.getWidth(n3);
            } else {
                n2 = -1;
            }
            if (n2 <= 0) {
                n3 = this.getFontSize();
                int n4 = n3 / 2;
                n2 = c2 == ' ' ? n3 : (c2 == '\u2000' ? n4 : (c2 == '\u2001' ? n3 : (c2 == '\u2002' ? n3 / 2 : (c2 == '\u2003' ? this.getFontSize() : (c2 == '\u2004' ? n3 / 3 : (c2 == '\u2005' ? n3 / 4 : (c2 == '\u2006' ? n3 / 6 : (c2 == '\u2007' ? this.getCharWidth('0') : (c2 == '\u2008' ? this.getCharWidth('.') : (c2 == '\u2009' ? n3 / 5 : (c2 == '\u200a' ? n3 / 10 : (c2 == '\u200b' ? 0 : (c2 == '\u202f' ? this.getCharWidth(' ') / 2 : (c2 == '\u2060' ? 0 : (c2 == '\u3000' ? this.getCharWidth(' ') * 2 : (c2 == '\ufeff' ? 0 : this.getWidth(this.mapChar(c2))))))))))))))))));
            }
        }
        return n2;
    }

    public int getCharWidth(int n2) {
        if (n2 < 65536) {
            return this.getCharWidth((char)n2);
        }
        if (this.hasCodePoint(n2)) {
            int n3 = this.mapCodePoint(n2);
            return this.getWidth(n3);
        }
        return -1;
    }

    public int getWordWidth(String string) {
        if (string == null) {
            return 0;
        }
        int n2 = string.length();
        int n3 = 0;
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += this.getCharWidth(cArray[i2]);
        }
        return n3;
    }

    public boolean performsSubstitution() {
        if (this.metric instanceof Substitutable) {
            Substitutable substitutable = (Substitutable)this.metric;
            return substitutable.performsSubstitution();
        }
        return false;
    }

    public CharSequence performSubstitution(CharSequence charSequence, String string, String string2, List list, boolean bl) {
        if (this.metric instanceof Substitutable) {
            Substitutable substitutable = (Substitutable)this.metric;
            return substitutable.performSubstitution(charSequence, string, string2, list, bl);
        }
        throw new UnsupportedOperationException();
    }

    public CharSequence reorderCombiningMarks(CharSequence charSequence, int[][] nArray, String string, String string2, List list) {
        if (this.metric instanceof Substitutable) {
            Substitutable substitutable = (Substitutable)this.metric;
            return substitutable.reorderCombiningMarks(charSequence, nArray, string, string2, list);
        }
        throw new UnsupportedOperationException();
    }

    public boolean performsPositioning() {
        if (this.metric instanceof Positionable) {
            Positionable positionable = (Positionable)this.metric;
            return positionable.performsPositioning();
        }
        return false;
    }

    public int[][] performPositioning(CharSequence charSequence, String string, String string2, int n2) {
        if (this.metric instanceof Positionable) {
            Positionable positionable = (Positionable)this.metric;
            return positionable.performPositioning(charSequence, string, string2, n2);
        }
        throw new UnsupportedOperationException();
    }

    public int[][] performPositioning(CharSequence charSequence, String string, String string2) {
        return this.performPositioning(charSequence, string, string2, this.fontSize);
    }
}

