/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.HashMap;
import java.util.Map;

public final class FallbackFont {
    private static final Map<String, String> FALLBACK_CACHE = new HashMap<String, String>();
    private static final String PLATFORM = System.getProperty("os.name").toLowerCase();
    private static final boolean IS_MAC_OR_WIN = PLATFORM.indexOf("win") >= 0 || PLATFORM.indexOf("mac") >= 0;
    private static final String WINDOWS_SANS_SERIF_FALLBACK = ",Segoe UI,Symbol,Segoe UI Symbol,Microsoft YaHei,Yu Gothic,Malgun Gothic,Latha,Arial Unicode MS";
    private static final String LINUX_SANS_SERIF_FALLBACK = ",DejaVu Sans,FreeSans,Noto Sans CJK SC,Noto Sans CJK JP,Noto Sans CJK KR";
    private static final String WINDOWS_SERIF_FALLBACK = ",Times,Times New Roman,Symbol,Segoe UI Symbol,SimSun,MingLiU,MS Mincho,Batang,Vijaya,Arial Unicode MS";
    private static final String LINUX_SERIF_FALLBACK = ",Times,DejaVu Serif,FreeSerif,Noto Serif CJK SC,Noto Serif CJK JP,Noto Serif CJK KR";
    private static final String WINDOWS_MONOSPACE_FALLBACK = ",Segoe UI,Symbol,Segoe UI Symbol,Microsoft YaHei,Yu Gothic,Malgun Gothic,Latha,Arial Unicode MS";
    private static final String LINUX_MONOSPACE_FALLBACK = ",DejaVu Sans Mono,FreeMono,Noto Sans CJK SC,Noto Sans CJK JP,Noto Sans CJK KR";

    private FallbackFont() {
    }

    public static String addFallbackFonts(String string) {
        return FALLBACK_CACHE.computeIfAbsent(string, string2 -> {
            Object object = string2;
            if (string.contains("sans-serif") || string.contains("sansserif")) {
                object = (String)object + FallbackFont.getSansSerifFallback();
            } else if (string.contains("serif")) {
                object = (String)object + FallbackFont.getSerifFallback();
            } else if (string.contains("monospace")) {
                object = (String)object + FallbackFont.getMonospaceFallback();
            }
            return object;
        });
    }

    private static String getSansSerifFallback() {
        if (IS_MAC_OR_WIN) {
            return ",Segoe UI,Symbol,Segoe UI Symbol,Microsoft YaHei,Yu Gothic,Malgun Gothic,Latha,Arial Unicode MS";
        }
        return LINUX_SANS_SERIF_FALLBACK;
    }

    private static String getSerifFallback() {
        if (IS_MAC_OR_WIN) {
            return WINDOWS_SERIF_FALLBACK;
        }
        return LINUX_SERIF_FALLBACK;
    }

    private static String getMonospaceFallback() {
        if (IS_MAC_OR_WIN) {
            return ",Segoe UI,Symbol,Segoe UI Symbol,Microsoft YaHei,Yu Gothic,Malgun Gothic,Latha,Arial Unicode MS";
        }
        return LINUX_MONOSPACE_FALLBACK;
    }
}

