/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.util.List;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.FontFamilyProperty;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyCache;
import org.apache.fop.fo.properties.StringProperty;
import org.apache.fop.fonts.FontFeatureSettings;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.util.CompareUtil;

public final class CommonFont {
    private static final PropertyCache<CommonFont> CACHE = new PropertyCache();
    private int hash = -1;
    private final FontFamilyProperty fontFamily;
    private final EnumProperty fontSelectionStrategy;
    private final EnumProperty fontStretch;
    private final EnumProperty fontStyle;
    private final EnumProperty fontVariant;
    private final ListProperty fontVariantLigatures;
    private StringProperty fontVariantAlternates;
    private final ListProperty fontVariantNumeric;
    private final EnumProperty fontWeight;
    public final Length fontSize;
    public final Numeric fontSizeAdjust;
    private FontFeatureSettings fontFeatureSettings = null;

    private CommonFont(FontFamilyProperty fontFamilyProperty, EnumProperty enumProperty, EnumProperty enumProperty2, EnumProperty enumProperty3, EnumProperty enumProperty4, ListProperty listProperty, StringProperty stringProperty, ListProperty listProperty2, EnumProperty enumProperty5, Length length, Numeric numeric) {
        this.fontFamily = fontFamilyProperty;
        this.fontSelectionStrategy = enumProperty;
        this.fontStretch = enumProperty2;
        this.fontStyle = enumProperty3;
        this.fontVariant = enumProperty4;
        this.fontVariantLigatures = listProperty;
        this.fontVariantAlternates = stringProperty;
        this.fontVariantNumeric = listProperty2;
        this.fontWeight = enumProperty5;
        this.fontSize = length;
        this.fontSizeAdjust = numeric;
    }

    public static CommonFont getInstance(PropertyList propertyList) throws PropertyException {
        FontFamilyProperty fontFamilyProperty = (FontFamilyProperty)propertyList.get(101);
        EnumProperty enumProperty = (EnumProperty)propertyList.get(102);
        EnumProperty enumProperty2 = (EnumProperty)propertyList.get(105);
        EnumProperty enumProperty3 = (EnumProperty)propertyList.get(106);
        EnumProperty enumProperty4 = (EnumProperty)propertyList.get(107);
        ListProperty listProperty = (ListProperty)propertyList.get(297);
        StringProperty stringProperty = (StringProperty)propertyList.get(298);
        ListProperty listProperty2 = (ListProperty)propertyList.get(299);
        EnumProperty enumProperty5 = (EnumProperty)propertyList.get(108);
        Numeric numeric = propertyList.get(104).getNumeric();
        Length length = propertyList.get(103).getLength();
        CommonFont commonFont = new CommonFont(fontFamilyProperty, enumProperty, enumProperty2, enumProperty3, enumProperty4, listProperty, stringProperty, listProperty2, enumProperty5, length, numeric);
        return (CommonFont)CACHE.fetch((Object)commonFont);
    }

    private String[] getFontFamily() {
        List list = this.fontFamily.getList();
        String[] stringArray = new String[list.size()];
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = ((Property)list.get(i2)).getString();
        }
        return stringArray;
    }

    public String getFirstFontFamily() {
        return ((Property)this.fontFamily.list.get(0)).getString();
    }

    public int getFontSelectionStrategy() {
        return this.fontSelectionStrategy.getEnum();
    }

    public int getFontStretch() {
        return this.fontStretch.getEnum();
    }

    public int getFontStyle() {
        return this.fontStyle.getEnum();
    }

    public int getFontVariant() {
        return this.fontVariant.getEnum();
    }

    public ListProperty getFontVariantLigatures() {
        return this.fontVariantLigatures;
    }

    public String getFontVariantAlternates() {
        return this.fontVariantAlternates.getString();
    }

    public ListProperty getFontVariantNumeric() {
        return this.fontVariantNumeric;
    }

    public int getFontWeight() {
        return this.fontWeight.getEnum();
    }

    public Length getFontSize() {
        return this.fontSize;
    }

    public Numeric getFontSizeAdjust() {
        return this.fontSizeAdjust;
    }

    public FontTriplet[] getFontState(FontInfo fontInfo) {
        String string;
        int n2;
        switch (this.fontWeight.getEnum()) {
            case 167: {
                n2 = 100;
                break;
            }
            case 168: {
                n2 = 200;
                break;
            }
            case 169: {
                n2 = 300;
                break;
            }
            case 170: {
                n2 = 400;
                break;
            }
            case 171: {
                n2 = 500;
                break;
            }
            case 172: {
                n2 = 600;
                break;
            }
            case 173: {
                n2 = 700;
                break;
            }
            case 174: {
                n2 = 800;
                break;
            }
            case 175: {
                n2 = 900;
                break;
            }
            default: {
                n2 = 400;
            }
        }
        switch (this.fontStyle.getEnum()) {
            case 162: {
                string = "italic";
                break;
            }
            case 163: {
                string = "oblique";
                break;
            }
            case 164: {
                string = "backslant";
                break;
            }
            default: {
                string = "normal";
            }
        }
        FontTriplet[] fontTripletArray = fontInfo.fontLookup(this.getFontFamily(), string, n2);
        return fontTripletArray;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CommonFont)) {
            return false;
        }
        CommonFont commonFont = (CommonFont)object;
        return CompareUtil.equal((Object)((Object)this.fontFamily), (Object)((Object)commonFont.fontFamily)) && CompareUtil.equal((Object)this.fontSelectionStrategy, (Object)commonFont.fontSelectionStrategy) && CompareUtil.equal((Object)this.fontSize, (Object)commonFont.fontSize) && CompareUtil.equal((Object)this.fontSizeAdjust, (Object)commonFont.fontSizeAdjust) && CompareUtil.equal((Object)this.fontStretch, (Object)commonFont.fontStretch) && CompareUtil.equal((Object)this.fontStyle, (Object)commonFont.fontStyle) && CompareUtil.equal((Object)this.fontVariant, (Object)commonFont.fontVariant) && CompareUtil.equal((Object)this.fontVariantLigatures, (Object)commonFont.fontVariantLigatures) && CompareUtil.equal((Object)this.fontVariantAlternates, (Object)commonFont.fontVariantAlternates) && CompareUtil.equal((Object)this.fontVariantNumeric, (Object)commonFont.fontVariantNumeric) && CompareUtil.equal((Object)this.fontWeight, (Object)commonFont.fontWeight);
    }

    public int hashCode() {
        if (this.hash == -1) {
            int n2 = 17;
            n2 = 37 * n2 + CompareUtil.getHashCode((Object)this.fontSize);
            n2 = 37 * n2 + CompareUtil.getHashCode((Object)this.fontSizeAdjust);
            n2 = 37 * n2 + CompareUtil.getHashCode((Object)((Object)this.fontFamily));
            n2 = 37 * n2 + CompareUtil.getHashCode((Object)this.fontSelectionStrategy);
            n2 = 37 * n2 + CompareUtil.getHashCode((Object)this.fontStretch);
            n2 = 37 * n2 + CompareUtil.getHashCode((Object)this.fontStyle);
            n2 = 37 * n2 + CompareUtil.getHashCode((Object)this.fontVariant);
            n2 = 37 * n2 + CompareUtil.getHashCode((Object)this.fontVariantLigatures);
            n2 = 37 * n2 + CompareUtil.getHashCode((Object)this.fontVariantAlternates);
            n2 = 37 * n2 + CompareUtil.getHashCode((Object)this.fontVariantNumeric);
            this.hash = n2 = 37 * n2 + CompareUtil.getHashCode((Object)this.fontWeight);
        }
        return this.hash;
    }

    public FontFeatureSettings getFontFeatureSettings() {
        if (this.fontFeatureSettings == null) {
            this.fontFeatureSettings = new FontFeatureSettings(this.getFontVariantLigatures(), this.getFontVariantAlternates(), this.getFontVariantNumeric());
        }
        return this.fontFeatureSettings;
    }
}

