/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableCellContainer;
import org.apache.fop.fo.flow.table.TablePart;
import org.apache.fop.fo.properties.BreakPropertySet;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class TableRow
extends TableCellContainer
implements BreakPropertySet {
    private LengthRangeProperty blockProgressionDimension;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private int breakAfter;
    private int breakBefore;
    private Length height;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private int relativeAlign;

    public TableRow(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        this.blockProgressionDimension = propertyList.get(17).getLengthRange();
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.breakAfter = propertyList.get(58).getEnum();
        this.breakBefore = propertyList.get(59).getEnum();
        this.height = propertyList.get(115).getLength();
        this.keepTogether = propertyList.get(131).getKeep();
        this.keepWithNext = propertyList.get(132).getKeep();
        this.keepWithPrevious = propertyList.get(133).getKeep();
        this.relativeAlign = propertyList.get(202).getEnum();
        super.bind(propertyList);
    }

    public int getRelativeAlign() {
        return this.relativeAlign;
    }

    public void processNode(String string, Locator locator, Attributes attributes, PropertyList propertyList) throws FOPException {
        super.processNode(string, locator, attributes, propertyList);
        if (!this.inMarker()) {
            TablePart tablePart = (TablePart)this.parent;
            this.pendingSpans = tablePart.pendingSpans;
            this.columnNumberManager = tablePart.columnNumberManager;
        }
    }

    protected void addChildNode(FONode fONode) throws FOPException {
        if (!this.inMarker() && fONode instanceof TableCell) {
            TableCell tableCell = (TableCell)fONode;
            TablePart tablePart = (TablePart)this.getParent();
            this.addTableCellChild(tableCell, tablePart.isFirst(this));
        }
        super.addChildNode(fONode);
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startRow(this);
    }

    public void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endRow(this);
    }

    public void finalizeNode() throws FOPException {
        if (this.firstChild == null) {
            this.missingChildElementError("(table-cell+)");
        }
        if (!this.inMarker()) {
            this.pendingSpans = null;
            this.columnNumberManager = null;
        }
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if ("marker".equals(string2)) {
                if (this.firstChild != null) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "(table-cell+)");
                }
            } else if (!"table-cell".equals(string2)) {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    TablePart getTablePart() {
        return (TablePart)this.parent;
    }

    boolean isTableRow() {
        return true;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public boolean mustKeepTogether() {
        return !this.getKeepTogether().getWithinPage().isAuto() || !this.getKeepTogether().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithNext() {
        return !this.getKeepWithNext().getWithinPage().isAuto() || !this.getKeepWithNext().getWithinColumn().isAuto();
    }

    public boolean mustKeepWithPrevious() {
        return !this.getKeepWithPrevious().getWithinPage().isAuto() || !this.getKeepWithPrevious().getWithinColumn().isAuto();
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public Length getHeight() {
        return this.height;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public String getLocalName() {
        return "table-row";
    }

    public int getNameId() {
        return 79;
    }
}

