/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.fop.apps.FOPException;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.ValidationPercentBaseContext;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.StaticPropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.table.ColumnNumberManager;
import org.apache.fop.fo.flow.table.ColumnNumberManagerHolder;
import org.apache.fop.fo.flow.table.FixedColRowGroupBuilder;
import org.apache.fop.fo.flow.table.RowGroupBuilder;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableEventProducer;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.VariableColRowGroupBuilder;
import org.apache.fop.fo.properties.BreakPropertySet;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthPairProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.TableColLength;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.WritingMode;
import org.apache.fop.traits.WritingModeTraits;
import org.apache.fop.traits.WritingModeTraitsGetter;
import org.xml.sax.Locator;

public class Table
extends TableFObj
implements ColumnNumberManagerHolder,
BreakPropertySet,
WritingModeTraitsGetter,
CommonAccessibilityHolder {
    private CommonAccessibility commonAccessibility;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginBlock commonMarginBlock;
    private LengthRangeProperty blockProgressionDimension;
    private int borderCollapse;
    private LengthPairProperty borderSeparation;
    private int breakAfter;
    private int breakBefore;
    private LengthRangeProperty inlineProgressionDimension;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private int tableLayout;
    private int tableOmitFooterAtBreak;
    private int tableOmitHeaderAtBreak;
    private WritingModeTraits writingModeTraits;
    private Length widowContentLimit;
    private Length orphanContentLimit;
    private List<FONode> columns = new ArrayList<FONode>();
    private ColumnNumberManager columnNumberManager = new ColumnNumberManager();
    private TableHeader tableHeader;
    private TableFooter tableFooter;
    private boolean tableColumnFound;
    private boolean tableHeaderFound;
    private boolean tableFooterFound;
    private boolean tableBodyFound;
    private boolean hasExplicitColumns;
    private boolean columnsFinalized;
    private RowGroupBuilder rowGroupBuilder;
    private PropertyList propList;
    private boolean isSpecifiedWidth;

    public boolean isSpecifiedWidth() {
        return this.isSpecifiedWidth;
    }

    public Table(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        TableEventProducer tableEventProducer;
        super.bind(propertyList);
        this.commonAccessibility = CommonAccessibility.getInstance((PropertyList)propertyList);
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.commonMarginBlock = propertyList.getMarginBlockProps();
        this.blockProgressionDimension = propertyList.get(17).getLengthRange();
        this.borderCollapse = propertyList.get(31).getEnum();
        this.borderSeparation = propertyList.get(45).getLengthPair();
        this.breakAfter = propertyList.get(58).getEnum();
        this.breakBefore = propertyList.get(59).getEnum();
        this.inlineProgressionDimension = propertyList.get(127).getLengthRange();
        this.keepTogether = propertyList.get(131).getKeep();
        this.keepWithNext = propertyList.get(132).getKeep();
        this.keepWithPrevious = propertyList.get(133).getKeep();
        this.tableLayout = propertyList.get(239).getEnum();
        this.tableOmitFooterAtBreak = propertyList.get(240).getEnum();
        this.tableOmitHeaderAtBreak = propertyList.get(241).getEnum();
        this.writingModeTraits = new WritingModeTraits(WritingMode.valueOf((int)propertyList.get(267).getEnum()), propertyList.getExplicit(267) != null);
        this.widowContentLimit = propertyList.get(270).getLength();
        this.orphanContentLimit = propertyList.get(271).getLength();
        if (!this.blockProgressionDimension.getOptimum(null).isAuto()) {
            tableEventProducer = TableEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
            tableEventProducer.nonAutoBPDOnTable((Object)this, this.getLocator());
        }
        boolean bl = this.isSpecifiedWidth = !propertyList.get(264).isAuto();
        if (!this.isSeparateBorderModel()) {
            if (this.borderCollapse == 27) {
                this.getFOValidationEventProducer().unimplementedFeature((Object)this, this.getName(), "border-collapse=\"collapse-with-precedence\"; defaulting to \"collapse\"", this.getLocator());
                this.borderCollapse = 26;
            }
            if (this.getCommonBorderPaddingBackground().hasPadding(ValidationPercentBaseContext.getPseudoContext())) {
                tableEventProducer = TableEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                tableEventProducer.noTablePaddingWithCollapsingBorderModel((Object)this, this.getLocator());
            }
        }
        this.propList = propertyList;
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startTable(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if ("marker".equals(string2)) {
                if (this.tableColumnFound || this.tableHeaderFound || this.tableFooterFound || this.tableBodyFound) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "(table-column*,table-header?,table-footer?,table-body+)");
                }
            } else if ("table-column".equals(string2)) {
                this.tableColumnFound = true;
                if (this.tableHeaderFound || this.tableFooterFound || this.tableBodyFound) {
                    this.nodesOutOfOrderError(locator, "fo:table-column", "(table-header?,table-footer?,table-body+)");
                }
            } else if ("table-header".equals(string2)) {
                if (this.tableHeaderFound) {
                    this.tooManyNodesError(locator, "table-header");
                } else {
                    this.tableHeaderFound = true;
                    if (this.tableFooterFound || this.tableBodyFound) {
                        this.nodesOutOfOrderError(locator, "fo:table-header", "(table-footer?,table-body+)");
                    }
                }
            } else if ("table-footer".equals(string2)) {
                if (this.tableFooterFound) {
                    this.tooManyNodesError(locator, "table-footer");
                } else {
                    this.tableFooterFound = true;
                    if (this.tableBodyFound) {
                        if (this.getUserAgent().validateStrictly()) {
                            this.nodesOutOfOrderError(locator, "fo:table-footer", "(table-body+)", true);
                        }
                        if (!this.isSeparateBorderModel()) {
                            TableEventProducer tableEventProducer = TableEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                            tableEventProducer.footerOrderCannotRecover((Object)this, this.getName(), this.getLocator());
                        }
                    }
                }
            } else if ("table-body".equals(string2)) {
                this.tableBodyFound = true;
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    public void endOfNode() throws FOPException {
        super.endOfNode();
        this.getFOEventHandler().endTable(this);
    }

    public void finalizeNode() throws FOPException {
        if (!this.tableBodyFound) {
            this.missingChildElementError("(marker*,table-column*,table-header?,table-footer?,table-body+)");
        }
        if (!this.hasChildren()) {
            this.getParent().removeChild((FONode)((Object)this));
            return;
        }
        if (!this.inMarker()) {
            this.rowGroupBuilder.endTable();
            int n2 = this.columns.size();
            while (--n2 >= 0) {
                TableColumn tableColumn = (TableColumn)((Object)this.columns.get(n2));
                if (tableColumn == null) continue;
                tableColumn.releasePropertyList();
            }
            this.propList = null;
            this.rowGroupBuilder = null;
        }
    }

    protected void addChildNode(FONode fONode) throws FOPException {
        int n2 = fONode.getNameId();
        block0 : switch (n2) {
            case 76: {
                this.hasExplicitColumns = true;
                if (!this.inMarker()) {
                    this.addColumnNode((TableColumn)((Object)fONode));
                    break;
                }
                this.columns.add(fONode);
                break;
            }
            case 73: 
            case 77: 
            case 78: {
                if (!this.inMarker() && !this.columnsFinalized) {
                    this.columnsFinalized = true;
                    if (this.hasExplicitColumns) {
                        this.finalizeColumns();
                        this.rowGroupBuilder = new FixedColRowGroupBuilder(this);
                    } else {
                        this.rowGroupBuilder = new VariableColRowGroupBuilder(this);
                    }
                }
                switch (n2) {
                    case 77: {
                        this.tableFooter = (TableFooter)fONode;
                        break block0;
                    }
                    case 78: {
                        this.tableHeader = (TableHeader)fONode;
                        break block0;
                    }
                }
                super.addChildNode(fONode);
                break;
            }
            default: {
                super.addChildNode(fONode);
            }
        }
    }

    private void finalizeColumns() throws FOPException {
        for (int i2 = 0; i2 < this.columns.size(); ++i2) {
            if (this.columns.get(i2) != null) continue;
            this.columns.set(i2, (FONode)((Object)this.createImplicitColumn(i2 + 1)));
        }
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public Table getTable() {
        return this;
    }

    void ensureColumnNumber(int n2) throws FOPException {
        assert (!this.hasExplicitColumns);
        for (int i2 = this.columns.size() + 1; i2 <= n2; ++i2) {
            this.columns.add((FONode)((Object)this.createImplicitColumn(i2)));
        }
    }

    private TableColumn createImplicitColumn(int n2) throws FOPException {
        TableColumn tableColumn = new TableColumn((FONode)((Object)this), true);
        StaticPropertyList staticPropertyList = new StaticPropertyList((FObj)tableColumn, this.propList);
        tableColumn.bind(staticPropertyList);
        tableColumn.setColumnWidth((Length)new TableColLength(1.0, (FObj)tableColumn));
        tableColumn.setColumnNumber(n2);
        if (!this.isSeparateBorderModel()) {
            tableColumn.setCollapsedBorders(this.collapsingBorderModel);
        }
        return tableColumn;
    }

    private void addColumnNode(TableColumn tableColumn) {
        int n2 = tableColumn.getColumnNumber();
        int n3 = tableColumn.getNumberColumnsRepeated();
        while (this.columns.size() < n2 + n3 - 1) {
            this.columns.add(null);
        }
        for (int i2 = n2 - 1; i2 < n2 + n3 - 1; ++i2) {
            this.columns.set(i2, (FONode)((Object)tableColumn));
        }
        this.columnNumberManager.signalUsedColumnNumbers(n2, n2 + n3 - 1);
    }

    boolean hasExplicitColumns() {
        return this.hasExplicitColumns;
    }

    public boolean isAutoLayout() {
        return this.tableLayout == 9;
    }

    public List<FONode> getColumns() {
        return this.columns;
    }

    public TableColumn getColumn(int n2) {
        return (TableColumn)((Object)this.columns.get(n2));
    }

    public int getNumberOfColumns() {
        return this.columns.size();
    }

    public TableHeader getTableHeader() {
        return this.tableHeader;
    }

    public TableFooter getTableFooter() {
        return this.tableFooter;
    }

    public boolean omitHeaderAtBreak() {
        return this.tableOmitHeaderAtBreak == 149;
    }

    public boolean omitFooterAtBreak() {
        return this.tableOmitFooterAtBreak == 149;
    }

    public LengthRangeProperty getInlineProgressionDimension() {
        return this.inlineProgressionDimension;
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public boolean mustKeepTogether() {
        return !this.getKeepTogether().getWithinPage().isAuto() || !this.getKeepTogether().getWithinColumn().isAuto();
    }

    public int getBorderCollapse() {
        return this.borderCollapse;
    }

    public boolean isSeparateBorderModel() {
        return this.getBorderCollapse() == 129;
    }

    public LengthPairProperty getBorderSeparation() {
        return this.borderSeparation;
    }

    public Direction getInlineProgressionDirection() {
        return this.writingModeTraits.getInlineProgressionDirection();
    }

    public Direction getBlockProgressionDirection() {
        return this.writingModeTraits.getBlockProgressionDirection();
    }

    public Direction getColumnProgressionDirection() {
        return this.writingModeTraits.getColumnProgressionDirection();
    }

    public Direction getRowProgressionDirection() {
        return this.writingModeTraits.getRowProgressionDirection();
    }

    public Direction getShiftDirection() {
        return this.writingModeTraits.getShiftDirection();
    }

    public WritingMode getWritingMode() {
        return this.writingModeTraits.getWritingMode();
    }

    public boolean getExplicitWritingMode() {
        return this.writingModeTraits.getExplicitWritingMode();
    }

    public Length getWidowContentLimit() {
        return this.widowContentLimit;
    }

    public Length getOrphanContentLimit() {
        return this.orphanContentLimit;
    }

    public String getLocalName() {
        return "table";
    }

    public int getNameId() {
        return 71;
    }

    public FONode clone(FONode fONode, boolean bl) throws FOPException {
        Table table = (Table)((Object)super.clone(fONode, bl));
        if (bl) {
            table.columns = new ArrayList<FONode>();
            table.columnsFinalized = false;
            table.columnNumberManager = new ColumnNumberManager();
            table.tableHeader = null;
            table.tableFooter = null;
            table.rowGroupBuilder = null;
        }
        return table;
    }

    public ColumnNumberManager getColumnNumberManager() {
        return this.columnNumberManager;
    }

    RowGroupBuilder getRowGroupBuilder() {
        return this.rowGroupBuilder;
    }

    protected Stack<DelimitedTextRange> collectDelimitedTextRanges(Stack<DelimitedTextRange> stack, DelimitedTextRange delimitedTextRange) {
        TableFooter tableFooter;
        TableHeader tableHeader = this.getTableHeader();
        if (tableHeader != null) {
            stack = tableHeader.collectDelimitedTextRanges(stack);
        }
        if ((tableFooter = this.getTableFooter()) != null) {
            stack = tableFooter.collectDelimitedTextRanges((Stack)stack);
        }
        FONode.FONodeIterator fONodeIterator = this.getChildNodes();
        while (fONodeIterator != null && fONodeIterator.hasNext()) {
            stack = ((FONode)fONodeIterator.next()).collectDelimitedTextRanges(stack);
        }
        return stack;
    }

    protected boolean isBidiBoundary(boolean bl) {
        return this.getExplicitWritingMode();
    }
}

