/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.BreakPropertySet;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.KeepProperty;
import org.xml.sax.Locator;

public class ListBlock
extends FObj
implements BreakPropertySet,
CommonAccessibilityHolder {
    private CommonAccessibility commonAccessibility;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginBlock commonMarginBlock;
    private int breakAfter;
    private int breakBefore;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private Length widowContentLimit;
    private Length orphanContentLimit;
    private boolean hasListItem;
    private Numeric widows;
    private Numeric orphans;

    public ListBlock(FONode fONode) {
        super(fONode);
    }

    public void bind(PropertyList propertyList) throws FOPException {
        super.bind(propertyList);
        this.commonAccessibility = CommonAccessibility.getInstance((PropertyList)propertyList);
        this.commonBorderPaddingBackground = propertyList.getBorderPaddingBackgroundProps();
        this.commonMarginBlock = propertyList.getMarginBlockProps();
        this.breakAfter = propertyList.get(58).getEnum();
        this.breakBefore = propertyList.get(59).getEnum();
        this.keepTogether = propertyList.get(131).getKeep();
        this.keepWithNext = propertyList.get(132).getKeep();
        this.keepWithPrevious = propertyList.get(133).getKeep();
        this.widowContentLimit = propertyList.get(270).getLength();
        this.orphanContentLimit = propertyList.get(271).getLength();
        this.widows = propertyList.get(263).getNumeric();
        this.orphans = propertyList.get(168).getNumeric();
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startList(this);
    }

    public void endOfNode() throws FOPException {
        if (!this.hasListItem) {
            this.missingChildElementError("marker* (list-item)+");
        }
        this.getFOEventHandler().endList(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            if (string2.equals("marker")) {
                if (this.hasListItem) {
                    this.nodesOutOfOrderError(locator, "fo:marker", "fo:list-item");
                }
            } else if (string2.equals("list-item")) {
                this.hasListItem = true;
            } else {
                this.invalidChildError(locator, string, string2);
            }
        }
    }

    public CommonAccessibility getCommonAccessibility() {
        return this.commonAccessibility;
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public Length getWidowContentLimit() {
        return this.widowContentLimit;
    }

    public Length getOrphanContentLimit() {
        return this.orphanContentLimit;
    }

    public String getLocalName() {
        return "list-block";
    }

    public int getNameId() {
        return 40;
    }

    public int getOrphans() {
        return this.orphans.getValue();
    }

    public int getWidows() {
        return this.widows.getValue();
    }
}

