/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.awt.geom.Point2D;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.XMLObj;
import org.apache.fop.fo.flow.AbstractGraphics;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Locator;

public class InstreamForeignObject
extends AbstractGraphics {
    private Point2D intrinsicDimensions;
    private boolean instrisicSizeDetermined;
    private Length intrinsicAlignmentAdjust;

    public InstreamForeignObject(FONode fONode) {
        super(fONode);
    }

    public void startOfNode() throws FOPException {
        super.startOfNode();
        this.getFOEventHandler().startInstreamForeignObject(this);
    }

    public void endOfNode() throws FOPException {
        if (this.firstChild == null) {
            this.missingChildElementError("one (1) non-XSL namespace child");
        }
        this.getFOEventHandler().endInstreamForeignObject(this);
    }

    protected void validateChildNode(Locator locator, String string, String string2) throws ValidationException {
        if ("http://www.w3.org/1999/XSL/Format".equals(string)) {
            this.invalidChildError(locator, string, string2);
        } else if (this.firstChild != null) {
            this.tooManyNodesError(locator, new QName(string, null, string2));
        }
    }

    public String getLocalName() {
        return "instream-foreign-object";
    }

    public int getNameId() {
        return 37;
    }

    private void prepareIntrinsicSize(int n2) {
        if (!this.instrisicSizeDetermined) {
            XMLObj xMLObj = (XMLObj)this.firstChild;
            Point2D.Float float_ = new Point2D.Float(n2, n2);
            this.intrinsicDimensions = xMLObj.getDimension((Point2D)float_);
            if (this.intrinsicDimensions == null) {
                ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                resourceEventProducer.ifoNoIntrinsicSize((Object)this, this.getLocator());
            }
            this.intrinsicAlignmentAdjust = xMLObj.getIntrinsicAlignmentAdjust();
            this.instrisicSizeDetermined = true;
        }
    }

    @Override
    public int getIntrinsicWidth(int n2) {
        this.prepareIntrinsicSize(n2);
        if (this.intrinsicDimensions != null) {
            return (int)(this.intrinsicDimensions.getX() * 1000.0);
        }
        return 0;
    }

    @Override
    public int getIntrinsicHeight(int n2) {
        this.prepareIntrinsicSize(n2);
        if (this.intrinsicDimensions != null) {
            return (int)(this.intrinsicDimensions.getY() * 1000.0);
        }
        return 0;
    }

    @Override
    public Length getIntrinsicAlignmentAdjust(int n2) {
        this.prepareIntrinsicSize(n2);
        return this.intrinsicAlignmentAdjust;
    }

    protected void addChildNode(FONode fONode) throws FOPException {
        super.addChildNode(fONode);
    }

    public XMLObj getChildXMLObj() {
        return (XMLObj)this.firstChild;
    }
}

