/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.expr.FunctionBase;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.expr.PropertyInfo;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.Property;

public class RGBAColorFunction
extends FunctionBase {
    public int getRequiredArgsCount() {
        return 4;
    }

    public PercentBase getPercentBase() {
        return new RGBAPercentBase();
    }

    public Property eval(Property[] propertyArray, PropertyInfo propertyInfo) throws PropertyException {
        return ColorProperty.getInstance((FOUserAgent)propertyInfo.getUserAgent(), (String)("rgba(" + propertyArray[0] + "," + propertyArray[1] + "," + propertyArray[2] + "," + propertyArray[3] + ")"));
    }

    private static class RGBAPercentBase
    implements PercentBase {
        private RGBAPercentBase() {
        }

        public int getDimension() {
            return 0;
        }

        public double getBaseValue() {
            return 255.0;
        }

        public int getBaseLength(PercentBaseContext percentBaseContext) {
            return 0;
        }
    }
}

