/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FOPropertyMapping;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CommonAbsolutePosition;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Attributes;

public abstract class PropertyList {
    private static boolean[] inheritableProperty = new boolean[300];
    protected PropertyList parentPropertyList;
    private FObj fobj;
    private static Log log;
    private final UnknownPropertyHandler unknownPropertyHandler = new UnknownPropertyHandler();

    public PropertyList(FObj fObj, PropertyList propertyList) {
        this.fobj = fObj;
        this.parentPropertyList = propertyList;
    }

    public FObj getFObj() {
        return this.fobj;
    }

    public FObj getParentFObj() {
        if (this.parentPropertyList != null) {
            return this.parentPropertyList.getFObj();
        }
        return null;
    }

    public void validatePropertyValue(String string, Property property, Property property2) {
        this.unknownPropertyHandler.validatePropertyValue(string, property, property2);
    }

    public Map<String, Property> getUnknownPropertyValues() {
        return this.unknownPropertyHandler.getUnknownPropertyValues();
    }

    public PropertyList getParentPropertyList() {
        return this.parentPropertyList;
    }

    public Property getExplicitOrShorthand(int n2) throws PropertyException {
        Property property = this.getExplicit(n2);
        if (property == null) {
            property = this.getShorthand(n2);
        }
        return property;
    }

    public abstract Property getExplicit(int var1);

    public abstract void putExplicit(int var1, Property var2);

    public Property getInherited(int n2) throws PropertyException {
        if (this.isInherited(n2)) {
            return this.getFromParent(n2);
        }
        return this.makeProperty(n2);
    }

    public Property get(int n2) throws PropertyException {
        return this.get(n2, true, true);
    }

    public Property get(int n2, boolean bl, boolean bl2) throws PropertyException {
        PropertyMaker propertyMaker = PropertyList.findMaker(n2 & 0x1FF);
        if (propertyMaker != null) {
            return propertyMaker.get(n2 & 0xFFFFFE00, this, bl, bl2);
        }
        return null;
    }

    public Property getNearestSpecified(int n2) throws PropertyException {
        Property property = null;
        PropertyList propertyList = this.parentPropertyList;
        while (propertyList != null) {
            property = propertyList.getExplicit(n2);
            if (property != null) {
                return property;
            }
            propertyList = propertyList.parentPropertyList;
        }
        return this.makeProperty(n2);
    }

    public Property getFromParent(int n2) throws PropertyException {
        if (this.parentPropertyList != null) {
            return this.parentPropertyList.get(n2);
        }
        return this.makeProperty(n2);
    }

    public int selectFromWritingMode(int n2, int n3, int n4, int n5) {
        int n6;
        try {
            switch (this.get(267).getEnum()) {
                case 79: {
                    n6 = n2;
                    break;
                }
                case 121: {
                    n6 = n3;
                    break;
                }
                case 140: {
                    n6 = n4;
                    break;
                }
                case 203: {
                    n6 = n5;
                    break;
                }
                default: {
                    n6 = -1;
                    break;
                }
            }
        }
        catch (PropertyException propertyException) {
            n6 = -1;
        }
        return n6;
    }

    private String addAttributeToList(Attributes attributes, String string) throws ValidationException {
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            this.convertAttributeToProperty(attributes, string, string2);
        }
        return string2;
    }

    public void addAttributesToList(Attributes attributes) throws ValidationException {
        this.addAttributeToList(attributes, "writing-mode");
        this.addAttributeToList(attributes, "column-number");
        this.addAttributeToList(attributes, "number-columns-spanned");
        String string = this.addAttributeToList(attributes, "font");
        if (string == null || "".equals(string)) {
            this.addAttributeToList(attributes, "font-size");
        }
        FOUserAgent fOUserAgent = this.getFObj().getUserAgent();
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String string2 = attributes.getURI(i2);
            String string3 = attributes.getQName(i2);
            String string4 = attributes.getValue(i2);
            if (string2 == null || string2.length() == 0 || "xml:lang".equals(string3) || "xml:base".equals(string3)) {
                this.convertAttributeToProperty(attributes, string3, string4);
                continue;
            }
            if (fOUserAgent.isNamespaceIgnored(string2)) continue;
            ElementMapping elementMapping = fOUserAgent.getElementMappingRegistry().getElementMapping(string2);
            QName qName = new QName(string2, string3);
            if (elementMapping != null) {
                if (elementMapping.isAttributeProperty(qName) && elementMapping.getStandardPrefix() != null) {
                    this.convertAttributeToProperty(attributes, elementMapping.getStandardPrefix() + ":" + qName.getLocalName(), string4);
                    continue;
                }
                this.getFObj().addForeignAttribute(qName, string4);
                continue;
            }
            this.handleInvalidProperty(qName);
        }
    }

    protected boolean isValidPropertyName(String string) {
        int n2 = FOPropertyMapping.getPropertyId(PropertyList.findBasePropertyName(string));
        int n3 = FOPropertyMapping.getSubPropertyId(PropertyList.findSubPropertyName(string));
        return n2 != -1 && (n3 != -1 || PropertyList.findSubPropertyName(string) == null);
    }

    public Property getPropertyForAttribute(Attributes attributes, String string, String string2) throws FOPException {
        if (string2 != null) {
            if (string.startsWith("xmlns:") || "xmlns".equals(string)) {
                return null;
            }
            String string3 = PropertyList.findBasePropertyName(string);
            String string4 = PropertyList.findSubPropertyName(string);
            int n2 = FOPropertyMapping.getPropertyId(string3);
            int n3 = FOPropertyMapping.getSubPropertyId(string4);
            if (n2 == -1 || n3 == -1 && string4 != null) {
                return null;
            }
            return this.getExplicit(n2);
        }
        return null;
    }

    private void convertAttributeToProperty(Attributes attributes, String string, String string2) throws ValidationException {
        if (string.startsWith("xmlns:") || "xmlns".equals(string)) {
            return;
        }
        if (string2 != null) {
            String string3 = PropertyList.findBasePropertyName(string);
            String string4 = PropertyList.findSubPropertyName(string);
            int n2 = FOPropertyMapping.getPropertyId(string3);
            int n3 = FOPropertyMapping.getSubPropertyId(string4);
            if (n2 == -1 || n3 == -1 && string4 != null) {
                this.handleInvalidProperty(new QName(null, string));
            }
            FObj fObj = this.fobj.findNearestAncestorFObj();
            PropertyMaker propertyMaker = PropertyList.findMaker(n2);
            if (propertyMaker == null) {
                log.warn((Object)("No PropertyMaker registered for " + string + ". Ignoring property."));
                return;
            }
            try {
                Property property = null;
                if (string4 == null) {
                    if (this.getExplicit(n2) != null) {
                        return;
                    }
                    property = propertyMaker.make(this, string2, fObj);
                } else {
                    Property property2 = this.findBaseProperty(attributes, fObj, n2, string3, propertyMaker);
                    property = propertyMaker.make(property2, n3, this, string2, fObj);
                }
                if (property != null) {
                    this.putExplicit(n2, property);
                }
            }
            catch (PropertyException propertyException) {
                this.fobj.getFOValidationEventProducer().invalidPropertyValue((Object)this, this.fobj.getName(), string, string2, propertyException, this.fobj.locator);
            }
        }
    }

    private Property findBaseProperty(Attributes attributes, FObj fObj, int n2, String string, PropertyMaker propertyMaker) throws PropertyException {
        Property property = this.getExplicit(n2);
        if (property != null) {
            return property;
        }
        String string2 = attributes.getValue(string);
        if (string2 != null && propertyMaker != null) {
            property = propertyMaker.make(this, string2, fObj);
            return property;
        }
        return null;
    }

    protected void handleInvalidProperty(QName qName) throws ValidationException {
        if (!qName.getQName().startsWith("xmlns")) {
            this.fobj.getFOValidationEventProducer().invalidProperty((Object)this, this.fobj.getName(), qName, true, this.fobj.locator);
        }
    }

    protected static String findBasePropertyName(String string) {
        int n2 = string.indexOf(46);
        String string2 = string;
        if (n2 > -1) {
            string2 = string.substring(0, n2);
        }
        return string2;
    }

    protected static String findSubPropertyName(String string) {
        int n2 = string.indexOf(46);
        String string2 = null;
        if (n2 > -1) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }

    private Property getShorthand(int n2) throws PropertyException {
        PropertyMaker propertyMaker = PropertyList.findMaker(n2);
        if (propertyMaker != null) {
            return propertyMaker.getShorthand(this);
        }
        return null;
    }

    private Property makeProperty(int n2) throws PropertyException {
        PropertyMaker propertyMaker = PropertyList.findMaker(n2);
        if (propertyMaker != null) {
            return propertyMaker.make(this);
        }
        return null;
    }

    private boolean isInherited(int n2) {
        return inheritableProperty[n2];
    }

    private static PropertyMaker findMaker(int n2) {
        if (n2 < 1 || n2 > 299) {
            return null;
        }
        return FObj.getPropertyMakerFor((int)n2);
    }

    public CommonBorderPaddingBackground getBorderPaddingBackgroundProps() throws PropertyException {
        return CommonBorderPaddingBackground.getInstance(this);
    }

    public CommonHyphenation getHyphenationProps() throws PropertyException {
        return CommonHyphenation.getInstance(this);
    }

    public CommonMarginBlock getMarginBlockProps() throws PropertyException {
        return new CommonMarginBlock(this);
    }

    public CommonMarginInline getMarginInlineProps() throws PropertyException {
        return new CommonMarginInline(this);
    }

    public CommonAural getAuralProps() throws PropertyException {
        CommonAural commonAural = new CommonAural(this);
        return commonAural;
    }

    public CommonRelativePosition getRelativePositionProps() throws PropertyException {
        return new CommonRelativePosition(this);
    }

    public CommonAbsolutePosition getAbsolutePositionProps() throws PropertyException {
        return new CommonAbsolutePosition(this);
    }

    public CommonFont getFontProps() throws PropertyException {
        return CommonFont.getInstance(this);
    }

    public CommonTextDecoration getTextDecorationProps() throws PropertyException {
        return CommonTextDecoration.createFromPropertyList((PropertyList)this);
    }

    static {
        PropertyMaker propertyMaker = null;
        for (int i2 = 1; i2 <= 299; ++i2) {
            propertyMaker = PropertyList.findMaker(i2);
            PropertyList.inheritableProperty[i2] = propertyMaker != null && propertyMaker.isInherited();
        }
        log = LogFactory.getLog(PropertyList.class);
    }

    private static class UnknownPropertyHandler {
        private Map<String, Property> unknownPropertyValues = new HashMap<String, Property>();
        private Set<Property> knownProperties = new HashSet<Property>();

        private UnknownPropertyHandler() {
        }

        void validatePropertyValue(String string, Property property, Property property2) {
            if (!this.knownProperties.contains(property2) && property == null) {
                if (string != null) {
                    this.unknownPropertyValues.put(string, property2);
                }
            } else {
                this.knownProperties.add(property2);
            }
        }

        Map<String, Property> getUnknownPropertyValues() {
            return this.unknownPropertyValues;
        }
    }
}

