/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.RecursiveCharIterator;
import org.apache.fop.fo.flow.Block;
import org.xml.sax.Locator;

public abstract class FObjMixed
extends FObj {
    private FOText ft;
    protected FONode currentTextNode;
    protected FOText lastFOTextProcessed;

    protected FObjMixed(FONode fONode) {
        super(fONode);
    }

    public FONode clone(FONode fONode, boolean bl) throws FOPException {
        this.flushText();
        FObjMixed fObjMixed = (FObjMixed)((Object)super.clone(fONode, bl));
        if (bl) {
            fObjMixed.currentTextNode = null;
        }
        return fObjMixed;
    }

    protected void characters(char[] cArray, int n2, int n3, PropertyList propertyList, Locator locator) throws FOPException {
        if (this.ft == null) {
            this.ft = new FOText((FONode)((Object)this));
            this.ft.setLocator(locator);
            if (!this.inMarker()) {
                this.ft.bind(propertyList);
            }
        }
        this.ft.characters(cArray, n2, n3, null, null);
    }

    public void endOfNode() throws FOPException {
        super.endOfNode();
        if (!this.inMarker() || this.getNameId() == 44) {
            this.sendCharacters();
        }
    }

    protected static void handleWhiteSpaceFor(FObjMixed fObjMixed, FONode fONode) {
        fObjMixed.getBuilderContext().getXMLWhiteSpaceHandler().handleWhiteSpace(fObjMixed, fObjMixed.currentTextNode, fONode);
    }

    private void flushText() throws FOPException {
        if (this.ft != null) {
            FOText fOText = this.ft;
            this.ft = null;
            if (this.getNameId() == 3) {
                fOText.createBlockPointers((Block)this);
                this.lastFOTextProcessed = fOText;
            } else if (this.getNameId() != 44 && this.getNameId() != 80 && this.getNameId() != 7) {
                FONode fONode = this.parent;
                int n2 = fONode.getNameId();
                while (n2 != 3 && n2 != 44 && n2 != 80 && n2 != 7 && n2 != 53) {
                    fONode = fONode.getParent();
                    n2 = fONode.getNameId();
                }
                if (n2 == 3) {
                    fOText.createBlockPointers((Block)fONode);
                    ((FObjMixed)((Object)fONode)).lastFOTextProcessed = fOText;
                } else if (n2 == 53 && fOText.willCreateArea()) {
                    log.error((Object)"Could not create block pointers. FOText w/o Block ancestor.");
                }
            }
            this.addChildNode((FONode)fOText);
        }
    }

    private void sendCharacters() throws FOPException {
        if (this.currentTextNode != null) {
            FONode.FONodeIterator fONodeIterator = this.getChildNodes(this.currentTextNode);
            while (fONodeIterator.hasNext()) {
                FONode fONode = fONodeIterator.next();
                if (this.isPageNumberCitation(fONode)) continue;
                assert (fONode instanceof FOText || fONode.getNameId() == 10);
                if (fONode.getNameId() == 10) {
                    fONode.startOfNode();
                }
                fONode.endOfNode();
            }
        }
        this.currentTextNode = null;
    }

    protected boolean isPageNumberCitation(FONode fONode) {
        return fONode != null && (fONode.getNameId() == 51 || fONode.getNameId() == 52);
    }

    protected void addChildNode(FONode fONode) throws FOPException {
        this.flushText();
        if (!this.inMarker()) {
            if (fONode instanceof FOText || fONode.getNameId() == 10 || this.isPageNumberCitation(fONode)) {
                if (this.currentTextNode == null) {
                    this.currentTextNode = fONode;
                }
            } else {
                FObjMixed.handleWhiteSpaceFor(this, fONode);
                this.sendCharacters();
            }
        }
        super.addChildNode(fONode);
    }

    public void removeChild(FONode fONode) {
        super.removeChild(fONode);
        if (fONode == this.currentTextNode) {
            this.currentTextNode = fONode.siblings != null ? fONode.siblings[1] : null;
        }
    }

    public void finalizeNode() throws FOPException {
        this.flushText();
        if (!this.inMarker() || this.getNameId() == 44) {
            FObjMixed.handleWhiteSpaceFor(this, null);
        }
    }

    public CharIterator charIterator() {
        return new RecursiveCharIterator((FObj)this);
    }
}

