/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.BorderShorthandParser;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.table.TableFObj;
import org.apache.fop.fo.properties.BackgroundPositionShorthand;
import org.apache.fop.fo.properties.BorderSpacingShorthandParser;
import org.apache.fop.fo.properties.BorderWidthPropertyMaker;
import org.apache.fop.fo.properties.BoxCornerPropShorthandParser;
import org.apache.fop.fo.properties.BoxPropShorthandParser;
import org.apache.fop.fo.properties.CharacterProperty;
import org.apache.fop.fo.properties.ColorProperty;
import org.apache.fop.fo.properties.CondLengthProperty;
import org.apache.fop.fo.properties.CorrespondingPropertyMaker;
import org.apache.fop.fo.properties.DimensionPropertyMaker;
import org.apache.fop.fo.properties.EnumProperty;
import org.apache.fop.fo.properties.EnumsListPropertyMaker;
import org.apache.fop.fo.properties.FontFamilyProperty;
import org.apache.fop.fo.properties.FontShorthandParser;
import org.apache.fop.fo.properties.FontShorthandProperty;
import org.apache.fop.fo.properties.FontSizePropertyMaker;
import org.apache.fop.fo.properties.FontStretchPropertyMaker;
import org.apache.fop.fo.properties.FontWeightPropertyMaker;
import org.apache.fop.fo.properties.GenericShorthandParser;
import org.apache.fop.fo.properties.IndentPropertyMaker;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthPairProperty;
import org.apache.fop.fo.properties.LengthProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.LineHeightPropertyMaker;
import org.apache.fop.fo.properties.ListProperty;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.OptionalCharacterProperty;
import org.apache.fop.fo.properties.PageBreakShorthandParser;
import org.apache.fop.fo.properties.PageDimensionMaker;
import org.apache.fop.fo.properties.PercentLength;
import org.apache.fop.fo.properties.PositionShorthandParser;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.fo.properties.ReferenceOrientationMaker;
import org.apache.fop.fo.properties.ShorthandParser;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.fo.properties.SpacePropertyMaker;
import org.apache.fop.fo.properties.SpacingPropertyMaker;
import org.apache.fop.fo.properties.StringProperty;
import org.apache.fop.fo.properties.TableBorderPrecedence;
import org.apache.fop.fo.properties.TextDecorationMaker;
import org.apache.fop.fo.properties.ToBeImplementedProperty;
import org.apache.fop.fo.properties.URIProperty;
import org.apache.fop.fo.properties.VerticalAlignShorthandParser;
import org.apache.fop.fo.properties.WhiteSpaceShorthandParser;
import org.apache.fop.fo.properties.XMLLangShorthandParser;
import org.apache.fop.fonts.FallbackFont;

public final class FOPropertyMapping
implements Constants {
    private static Map<String, Integer> propNames = new HashMap<String, Integer>();
    private static Map<String, Integer> subPropNames = new HashMap<String, Integer>();
    private static Map<Integer, String> propIds = new HashMap<Integer, String>();
    private static PropertyMaker[] generics = new PropertyMaker[300];
    private Property[] enums;
    private PropertyMaker genericColor;
    private PropertyMaker genericBoolean;
    private PropertyMaker genericKeep;
    private PropertyMaker genericCondLength;
    private PropertyMaker genericCondPadding;
    private PropertyMaker genericPadding;
    private PropertyMaker genericCondBorderWidth;
    PropertyMaker genericBorderWidth;
    private PropertyMaker genericBorderStyle;
    private PropertyMaker genericCondCornerRadiusOnHeightAxis;
    private PropertyMaker genericCondCornerRadiusOnWidthAxis;
    private PropertyMaker genericBreak;
    private PropertyMaker genericSpace;

    private FOPropertyMapping() {
    }

    private void createGenerics() {
        this.genericColor = new ColorProperty.Maker(0);
        this.genericBoolean = new EnumProperty.Maker(0);
        this.genericBoolean.addEnum("true", this.getEnumProperty(149, "TRUE"));
        this.genericBoolean.addEnum("false", this.getEnumProperty(48, "FALSE"));
        this.genericKeep = new KeepProperty.Maker(0);
        NumberProperty.Maker maker = new NumberProperty.Maker(5632);
        maker.setByShorthand(true);
        maker.setDefault("auto");
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker((PropertyMaker)maker);
        maker = new NumberProperty.Maker(5120);
        maker.setByShorthand(true);
        maker.setDefault("auto");
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker((PropertyMaker)maker);
        maker = new NumberProperty.Maker(4608);
        maker.setByShorthand(true);
        maker.setDefault("auto");
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        this.genericKeep.addSubpropMaker((PropertyMaker)maker);
        this.genericCondLength = new CondLengthProperty.Maker(0);
        maker = new LengthProperty.Maker(2048);
        maker.setByShorthand(true);
        this.genericCondLength.addSubpropMaker((PropertyMaker)maker);
        maker = new EnumProperty.Maker(1024);
        maker.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        maker.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        this.genericCondLength.addSubpropMaker((PropertyMaker)maker);
        this.genericCondPadding = new CondLengthProperty.Maker(0);
        this.genericCondPadding.useGeneric(this.genericCondLength);
        this.genericCondPadding.setInherited(false);
        this.genericCondPadding.getSubpropMaker(2048).setDefault("0pt");
        this.genericCondPadding.setPercentBase(5);
        this.genericPadding = new LengthProperty.Maker(0);
        this.genericPadding.setInherited(false);
        this.genericPadding.setDefault("0pt");
        this.genericPadding.setPercentBase(5);
        this.genericPadding.addShorthand(generics[170]);
        this.genericCondBorderWidth = new CondLengthProperty.Maker(0);
        this.genericCondBorderWidth.setInherited(false);
        this.genericCondBorderWidth.addKeyword("thin", "0.5pt");
        this.genericCondBorderWidth.addKeyword("medium", "1pt");
        this.genericCondBorderWidth.addKeyword("thick", "2pt");
        maker = new LengthProperty.Maker(2048);
        maker.setByShorthand(true);
        maker.addKeyword("thin", "0.5pt");
        maker.addKeyword("medium", "1pt");
        maker.addKeyword("thick", "2pt");
        maker.setDefault("medium");
        this.genericCondBorderWidth.addSubpropMaker((PropertyMaker)maker);
        maker = new EnumProperty.Maker(1024);
        maker.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        maker.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        this.genericCondBorderWidth.addSubpropMaker((PropertyMaker)maker);
        this.genericBorderWidth = new LengthProperty.Maker(0);
        this.genericBorderWidth.setInherited(false);
        this.genericBorderWidth.addKeyword("thin", "0.5pt");
        this.genericBorderWidth.addKeyword("medium", "1pt");
        this.genericBorderWidth.addKeyword("thick", "2pt");
        this.genericBorderWidth.setDefault("medium");
        this.genericBorderStyle = new EnumProperty.Maker(0);
        this.genericBorderStyle.setInherited(false);
        this.genericBorderStyle.addEnum("none", this.getEnumProperty(95, "NONE"));
        this.genericBorderStyle.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        this.genericBorderStyle.addEnum("dotted", this.getEnumProperty(36, "DOTTED"));
        this.genericBorderStyle.addEnum("dashed", this.getEnumProperty(31, "DASHED"));
        this.genericBorderStyle.addEnum("solid", this.getEnumProperty(133, "SOLID"));
        this.genericBorderStyle.addEnum("double", this.getEnumProperty(37, "DOUBLE"));
        this.genericBorderStyle.addEnum("groove", this.getEnumProperty(55, "GROOVE"));
        this.genericBorderStyle.addEnum("ridge", this.getEnumProperty(119, "RIDGE"));
        this.genericBorderStyle.addEnum("inset", this.getEnumProperty(67, "INSET"));
        this.genericBorderStyle.addEnum("outset", this.getEnumProperty(101, "OUTSET"));
        this.genericBorderStyle.setDefault("none");
        this.genericCondCornerRadiusOnHeightAxis = new CondLengthProperty.Maker(0);
        this.genericCondCornerRadiusOnHeightAxis.useGeneric(this.genericCondLength);
        this.genericCondCornerRadiusOnHeightAxis.setInherited(false);
        this.genericCondCornerRadiusOnHeightAxis.getSubpropMaker(2048).setDefault("0pt");
        this.genericCondCornerRadiusOnHeightAxis.setPercentBase(14);
        this.genericCondCornerRadiusOnWidthAxis = new CondLengthProperty.Maker(0);
        this.genericCondCornerRadiusOnWidthAxis.useGeneric(this.genericCondLength);
        this.genericCondCornerRadiusOnWidthAxis.setInherited(false);
        this.genericCondCornerRadiusOnWidthAxis.getSubpropMaker(2048).setDefault("0pt");
        this.genericCondCornerRadiusOnWidthAxis.setPercentBase(13);
        this.genericBreak = new EnumProperty.Maker(0);
        this.genericBreak.setInherited(false);
        this.genericBreak.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        this.genericBreak.addEnum("column", this.getEnumProperty(28, "COLUMN"));
        this.genericBreak.addEnum("page", this.getEnumProperty(104, "PAGE"));
        this.genericBreak.addEnum("even-page", this.getEnumProperty(44, "EVEN_PAGE"));
        this.genericBreak.addEnum("odd-page", this.getEnumProperty(100, "ODD_PAGE"));
        this.genericBreak.setDefault("auto");
        this.genericSpace = new SpaceProperty.Maker(0);
        this.genericSpace.setInherited(false);
        maker = new LengthProperty.Maker(3072);
        maker.setDefault("0pt");
        maker.setByShorthand(true);
        this.genericSpace.addSubpropMaker((PropertyMaker)maker);
        maker = new LengthProperty.Maker(3584);
        maker.setDefault("0pt");
        maker.setByShorthand(true);
        this.genericSpace.addSubpropMaker((PropertyMaker)maker);
        maker = new LengthProperty.Maker(2560);
        maker.setDefault("0pt");
        maker.setByShorthand(true);
        this.genericSpace.addSubpropMaker((PropertyMaker)maker);
        maker = new NumberProperty.Maker(4096);
        maker.addEnum("force", this.getEnumProperty(53, "FORCE"));
        maker.setDefault("0");
        this.genericSpace.addSubpropMaker((PropertyMaker)maker);
        maker = new EnumProperty.Maker(1024);
        maker.addEnum("discard", this.getEnumProperty(32, "DISCARD"));
        maker.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        maker.setDefault("discard");
        this.genericSpace.addSubpropMaker((PropertyMaker)maker);
    }

    private static void addPropertyMaker(String string, PropertyMaker propertyMaker) {
        FOPropertyMapping.generics[propertyMaker.getPropId()] = propertyMaker;
        propNames.put(string, propertyMaker.getPropId());
        propIds.put(propertyMaker.getPropId(), string);
    }

    private static void addSubpropMakerName(String string, int n2) {
        subPropNames.put(string, n2);
        propIds.put(n2, string);
    }

    private Property getEnumProperty(int n2, String string) {
        if (this.enums == null) {
            this.enums = new Property[224];
        }
        if (this.enums[n2] == null) {
            this.enums[n2] = EnumProperty.getInstance((int)n2, (String)string);
        }
        return this.enums[n2];
    }

    public static PropertyMaker[] getGenericMappings() {
        return generics;
    }

    public static int getPropertyId(String string) {
        Integer n2;
        if (string != null && (n2 = propNames.get(string)) != null) {
            return n2;
        }
        return -1;
    }

    public static int getSubPropertyId(String string) {
        Integer n2;
        if (string != null && (n2 = subPropNames.get(string)) != null) {
            return n2;
        }
        return -1;
    }

    public static String getPropertyName(int n2) {
        if ((n2 & 0xFFFFFE00) == 0 || (n2 & 0x1FF) == 0) {
            return propIds.get(n2);
        }
        return propIds.get(n2 & 0x1FF) + "." + propIds.get(n2 & 0xFFFFFE00);
    }

    private void createAccessibilityProperties() {
        StringProperty.Maker maker = new StringProperty.Maker(221);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("source-document", (PropertyMaker)maker);
        maker = new StringProperty.Maker(212);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("role", (PropertyMaker)maker);
    }

    private void createAbsolutePositionProperties() {
        EnumProperty.Maker maker = new EnumProperty.Maker(1);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        maker.addEnum("absolute", this.getEnumProperty(1, "ABSOLUTE"));
        maker.setDefault("auto");
        maker.addShorthand(generics[193]);
        FOPropertyMapping.addPropertyMaker("absolute-position", (PropertyMaker)maker);
        LengthProperty.Maker maker2 = new LengthProperty.Maker(253);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setDefault("auto");
        maker2.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("top", (PropertyMaker)maker2);
        maker2 = new LengthProperty.Maker(211);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setDefault("auto");
        maker2.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("right", (PropertyMaker)maker2);
        maker2 = new LengthProperty.Maker(57);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setDefault("auto");
        maker2.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("bottom", (PropertyMaker)maker2);
        maker2 = new LengthProperty.Maker(140);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setDefault("auto");
        maker2.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("left", (PropertyMaker)maker2);
    }

    private void createAuralProperties() {
        ToBeImplementedProperty.Maker maker = new ToBeImplementedProperty.Maker(6);
        maker.setInherited(true);
        maker.setDefault("center");
        FOPropertyMapping.addPropertyMaker("azimuth", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(83);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("cue-after", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(84);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("cue-before", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(89);
        maker.setInherited(true);
        maker.setDefault("level");
        FOPropertyMapping.addPropertyMaker("elevation", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(188);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause-after", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(189);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause-before", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(190);
        maker.setInherited(true);
        maker.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("pitch", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(191);
        maker.setInherited(true);
        maker.setDefault("50");
        FOPropertyMapping.addPropertyMaker("pitch-range", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(192);
        maker.setInherited(false);
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("play-during", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(210);
        maker.setInherited(true);
        maker.setDefault("50");
        FOPropertyMapping.addPropertyMaker("richness", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(227);
        maker.setInherited(true);
        maker.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("speak", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(228);
        maker.setInherited(true);
        maker.setDefault("once");
        FOPropertyMapping.addPropertyMaker("speak-header", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(229);
        maker.setInherited(true);
        maker.setDefault("continuous");
        FOPropertyMapping.addPropertyMaker("speak-numeral", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(230);
        maker.setInherited(true);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("speak-punctuation", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(231);
        maker.setInherited(true);
        maker.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("speech-rate", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(236);
        maker.setInherited(true);
        maker.setDefault("50");
        FOPropertyMapping.addPropertyMaker("stress", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(258);
        maker.setInherited(true);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("voice-family", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(259);
        maker.setInherited(true);
        maker.setDefault("medium");
        FOPropertyMapping.addPropertyMaker("volume", (PropertyMaker)maker);
    }

    private void createBorderPaddingBackgroundProperties() {
        Object object = new EnumProperty.Maker(8);
        object.setInherited(false);
        object.addEnum("scroll", this.getEnumProperty(126, "SCROLL"));
        object.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        object.setDefault("scroll");
        FOPropertyMapping.addPropertyMaker("background-attachment", (PropertyMaker)object);
        object = new ColorProperty.Maker(9){

            protected Property convertPropertyDatatype(Property property, PropertyList propertyList, FObj fObj) throws PropertyException {
                String string = property.getNCname();
                if (string != null) {
                    FObj fObj2 = fObj == null ? propertyList.getFObj() : fObj;
                    FOUserAgent fOUserAgent = fObj2 == null ? null : fObj2.getUserAgent();
                    return ColorProperty.getInstance((FOUserAgent)fOUserAgent, (String)string);
                }
                return super.convertPropertyDatatype(property, propertyList, fObj);
            }
        };
        object.useGeneric(this.genericColor);
        object.setInherited(false);
        object.setDefault("transparent");
        FOPropertyMapping.addPropertyMaker("background-color", (PropertyMaker)object);
        object = new StringProperty.Maker(10);
        object.setInherited(false);
        object.setDefault("none");
        FOPropertyMapping.addPropertyMaker("background-image", (PropertyMaker)object);
        object = new EnumProperty.Maker(14);
        object.setInherited(false);
        object.addEnum("repeat", this.getEnumProperty(112, "REPEAT"));
        object.addEnum("repeat-x", this.getEnumProperty(113, "REPEATX"));
        object.addEnum("repeat-y", this.getEnumProperty(114, "REPEATY"));
        object.addEnum("no-repeat", this.getEnumProperty(96, "NOREPEAT"));
        object.setDefault("repeat");
        FOPropertyMapping.addPropertyMaker("background-repeat", (PropertyMaker)object);
        object = new LengthProperty.Maker(12);
        object.setInherited(false);
        object.setDefault("0pt");
        object.addKeyword("left", "0pt");
        object.addKeyword("center", "50%");
        object.addKeyword("right", "100%");
        object.setPercentBase(9);
        object.addShorthand(generics[11]);
        FOPropertyMapping.addPropertyMaker("background-position-horizontal", (PropertyMaker)object);
        object = new LengthProperty.Maker(13);
        object.setInherited(false);
        object.setDefault("0pt");
        object.addKeyword("top", "0pt");
        object.addKeyword("center", "50%");
        object.addKeyword("bottom", "100%");
        object.setPercentBase(10);
        object.addShorthand(generics[11]);
        FOPropertyMapping.addPropertyMaker("background-position-vertical", (PropertyMaker)object);
        object = new ColorProperty.Maker(23);
        object.useGeneric(this.genericColor);
        object.setInherited(false);
        object.setDefault("black");
        CorrespondingPropertyMaker correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(53, 53, 42, 38);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-color", (PropertyMaker)object);
        object = new EnumProperty.Maker(25);
        object.useGeneric(this.genericBorderStyle);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(54, 54, 43, 39);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-style", (PropertyMaker)object);
        object = new CondLengthProperty.Maker(26);
        object.useGeneric(this.genericCondBorderWidth);
        object.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(55, 55, 44, 40);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-before-width", (PropertyMaker)object);
        object = new ColorProperty.Maker(19);
        object.useGeneric(this.genericColor);
        object.setInherited(false);
        object.setDefault("black");
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(28, 28, 38, 42);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-color", (PropertyMaker)object);
        object = new EnumProperty.Maker(21);
        object.useGeneric(this.genericBorderStyle);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(29, 29, 39, 43);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-style", (PropertyMaker)object);
        object = new CondLengthProperty.Maker(22);
        object.useGeneric(this.genericCondBorderWidth);
        object.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(30, 30, 40, 40);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-after-width", (PropertyMaker)object);
        object = new ColorProperty.Maker(47);
        object.useGeneric(this.genericColor);
        object.setInherited(false);
        object.setDefault("black");
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(38, 42, 53, 53);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-color", (PropertyMaker)object);
        object = new EnumProperty.Maker(49);
        object.useGeneric(this.genericBorderStyle);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(39, 43, 54, 54);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-style", (PropertyMaker)object);
        object = new CondLengthProperty.Maker(50);
        object.useGeneric(this.genericCondBorderWidth);
        object.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(40, 44, 55, 55);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-start-width", (PropertyMaker)object);
        object = new ColorProperty.Maker(33);
        object.useGeneric(this.genericColor);
        object.setInherited(false);
        object.setDefault("black");
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(42, 38, 28, 28);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-color", (PropertyMaker)object);
        object = new EnumProperty.Maker(35);
        object.useGeneric(this.genericBorderStyle);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(43, 39, 29, 29);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-style", (PropertyMaker)object);
        object = new CondLengthProperty.Maker(36);
        object.useGeneric(this.genericCondBorderWidth);
        object.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(44, 40, 30, 30);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("border-end-width", (PropertyMaker)object);
        object = new ColorProperty.Maker(53);
        object.useGeneric(this.genericColor);
        object.setInherited(false);
        object.setDefault("black");
        object.addShorthand(generics[52]);
        object.addShorthand(generics[32]);
        object.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(23, 23, 47, 47);
        FOPropertyMapping.addPropertyMaker("border-top-color", (PropertyMaker)object);
        object = new EnumProperty.Maker(54);
        object.useGeneric(this.genericBorderStyle);
        object.addShorthand(generics[52]);
        object.addShorthand(generics[51]);
        object.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(25, 25, 49, 49);
        FOPropertyMapping.addPropertyMaker("border-top-style", (PropertyMaker)object);
        BorderWidthPropertyMaker borderWidthPropertyMaker = new BorderWidthPropertyMaker(55);
        borderWidthPropertyMaker.useGeneric(this.genericBorderWidth);
        borderWidthPropertyMaker.setBorderStyleId(54);
        borderWidthPropertyMaker.addShorthand(generics[52]);
        borderWidthPropertyMaker.addShorthand(generics[56]);
        borderWidthPropertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)borderWidthPropertyMaker);
        correspondingPropertyMaker.setCorresponding(26, 26, 50, 50);
        FOPropertyMapping.addPropertyMaker("border-top-width", (PropertyMaker)borderWidthPropertyMaker);
        object = new ColorProperty.Maker(28);
        object.useGeneric(this.genericColor);
        object.setInherited(false);
        object.setDefault("black");
        object.addShorthand(generics[27]);
        object.addShorthand(generics[32]);
        object.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(19, 19, 33, 33);
        FOPropertyMapping.addPropertyMaker("border-bottom-color", (PropertyMaker)object);
        object = new EnumProperty.Maker(29);
        object.useGeneric(this.genericBorderStyle);
        object.addShorthand(generics[27]);
        object.addShorthand(generics[51]);
        object.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(21, 21, 35, 35);
        FOPropertyMapping.addPropertyMaker("border-bottom-style", (PropertyMaker)object);
        borderWidthPropertyMaker = new BorderWidthPropertyMaker(30);
        borderWidthPropertyMaker.useGeneric(this.genericBorderWidth);
        borderWidthPropertyMaker.setBorderStyleId(29);
        borderWidthPropertyMaker.addShorthand(generics[27]);
        borderWidthPropertyMaker.addShorthand(generics[56]);
        borderWidthPropertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)borderWidthPropertyMaker);
        correspondingPropertyMaker.setCorresponding(22, 22, 36, 36);
        FOPropertyMapping.addPropertyMaker("border-bottom-width", (PropertyMaker)borderWidthPropertyMaker);
        object = new ColorProperty.Maker(38);
        object.useGeneric(this.genericColor);
        object.setInherited(false);
        object.setDefault("black");
        object.addShorthand(generics[37]);
        object.addShorthand(generics[32]);
        object.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(47, 33, 19, 23);
        FOPropertyMapping.addPropertyMaker("border-left-color", (PropertyMaker)object);
        object = new EnumProperty.Maker(39);
        object.useGeneric(this.genericBorderStyle);
        object.addShorthand(generics[37]);
        object.addShorthand(generics[51]);
        object.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(49, 35, 21, 25);
        FOPropertyMapping.addPropertyMaker("border-left-style", (PropertyMaker)object);
        borderWidthPropertyMaker = new BorderWidthPropertyMaker(40);
        borderWidthPropertyMaker.useGeneric(this.genericBorderWidth);
        borderWidthPropertyMaker.setBorderStyleId(39);
        borderWidthPropertyMaker.addShorthand(generics[37]);
        borderWidthPropertyMaker.addShorthand(generics[56]);
        borderWidthPropertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)borderWidthPropertyMaker);
        correspondingPropertyMaker.setCorresponding(50, 36, 22, 26);
        FOPropertyMapping.addPropertyMaker("border-left-width", (PropertyMaker)borderWidthPropertyMaker);
        object = new ColorProperty.Maker(42);
        object.useGeneric(this.genericColor);
        object.setInherited(false);
        object.setDefault("black");
        object.addShorthand(generics[41]);
        object.addShorthand(generics[32]);
        object.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(33, 47, 23, 19);
        FOPropertyMapping.addPropertyMaker("border-right-color", (PropertyMaker)object);
        object = new EnumProperty.Maker(43);
        object.useGeneric(this.genericBorderStyle);
        object.addShorthand(generics[41]);
        object.addShorthand(generics[51]);
        object.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(35, 49, 25, 21);
        FOPropertyMapping.addPropertyMaker("border-right-style", (PropertyMaker)object);
        borderWidthPropertyMaker = new BorderWidthPropertyMaker(44);
        borderWidthPropertyMaker.useGeneric(this.genericBorderWidth);
        borderWidthPropertyMaker.setBorderStyleId(43);
        borderWidthPropertyMaker.addShorthand(generics[41]);
        borderWidthPropertyMaker.addShorthand(generics[56]);
        borderWidthPropertyMaker.addShorthand(generics[18]);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)borderWidthPropertyMaker);
        correspondingPropertyMaker.setCorresponding(36, 50, 26, 22);
        FOPropertyMapping.addPropertyMaker("border-right-width", (PropertyMaker)borderWidthPropertyMaker);
        object = new CondLengthProperty.Maker(172);
        object.useGeneric(this.genericCondPadding);
        object.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(178, 178, 176, 175);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-before", (PropertyMaker)object);
        object = new CondLengthProperty.Maker(171);
        object.useGeneric(this.genericCondPadding);
        object.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(173, 173, 175, 176);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-after", (PropertyMaker)object);
        object = new CondLengthProperty.Maker(177);
        object.useGeneric(this.genericCondPadding);
        object.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(175, 176, 178, 178);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-start", (PropertyMaker)object);
        object = new CondLengthProperty.Maker(174);
        object.useGeneric(this.genericCondPadding);
        object.getSubpropMaker(1024).setDefault("discard");
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(176, 175, 173, 173);
        correspondingPropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("padding-end", (PropertyMaker)object);
        object = new LengthProperty.Maker(178);
        object.useGeneric(this.genericPadding);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(172, 172, 177, 177);
        FOPropertyMapping.addPropertyMaker("padding-top", (PropertyMaker)object);
        object = new LengthProperty.Maker(173);
        object.useGeneric(this.genericPadding);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(171, 171, 174, 174);
        FOPropertyMapping.addPropertyMaker("padding-bottom", (PropertyMaker)object);
        object = new LengthProperty.Maker(175);
        object.useGeneric(this.genericPadding);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(177, 174, 171, 172);
        FOPropertyMapping.addPropertyMaker("padding-left", (PropertyMaker)object);
        object = new LengthProperty.Maker(176);
        object.useGeneric(this.genericPadding);
        correspondingPropertyMaker = new CorrespondingPropertyMaker((PropertyMaker)object);
        correspondingPropertyMaker.setCorresponding(174, 177, 172, 171);
        FOPropertyMapping.addPropertyMaker("padding-right", (PropertyMaker)object);
    }

    private void createFontProperties() {
        Object object = new FontFamilyProperty.Maker(101);
        object.setInherited(true);
        object.setDefault(FallbackFont.addFallbackFonts("sans-serif,Symbol,ZapfDingbats"));
        object.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-family", object);
        object = new EnumProperty.Maker(102);
        object.setInherited(true);
        object.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        object.addEnum("character-by-character", this.getEnumProperty(25, "CHARACTER_BY_CHARACTER"));
        object.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("font-selection-strategy", object);
        object = new FontSizePropertyMaker(103);
        object.setInherited(true);
        object.setDefault("12pt");
        object.addKeyword("xx-small", "6.944pt");
        object.addKeyword("x-small", "8.333pt");
        object.addKeyword("small", "10pt");
        object.addKeyword("medium", "12pt");
        object.addKeyword("large", "14.4pt");
        object.addKeyword("x-large", "17.28pt");
        object.addKeyword("xx-large", "20.736pt");
        object.addEnum("larger", this.getEnumProperty(71, "LARGER"));
        object.addEnum("smaller", this.getEnumProperty(132, "SMALLER"));
        object.setPercentBase(2);
        object.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-size", object);
        object = new FontStretchPropertyMaker(105);
        object.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        object.addEnum("wider", this.getEnumProperty(160, "WIDER"));
        object.addEnum("narrower", this.getEnumProperty(85, "NARROWER"));
        object.addEnum("ultra-condensed", this.getEnumProperty(150, "ULTRA_CONDENSED"));
        object.addEnum("extra-condensed", this.getEnumProperty(46, "EXTRA_CONDENSED"));
        object.addEnum("condensed", this.getEnumProperty(29, "CONDENSED"));
        object.addEnum("semi-condensed", this.getEnumProperty(127, "SEMI_CONDENSED"));
        object.addEnum("semi-expanded", this.getEnumProperty(128, "SEMI_EXPANDED"));
        object.addEnum("expanded", this.getEnumProperty(45, "EXPANDED"));
        object.addEnum("extra-expanded", this.getEnumProperty(47, "EXTRA_EXPANDED"));
        object.addEnum("ultra-expanded", this.getEnumProperty(151, "ULTRA_EXPANDED"));
        object.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("font-stretch", object);
        object = new NumberProperty.Maker(104);
        object.setInherited(true);
        object.addEnum("none", this.getEnumProperty(95, "NONE"));
        object.setDefault("none");
        FOPropertyMapping.addPropertyMaker("font-size-adjust", object);
        object = new EnumProperty.Maker(106);
        object.setInherited(true);
        object.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        object.addEnum("italic", this.getEnumProperty(162, "ITALIC"));
        object.addEnum("oblique", this.getEnumProperty(163, "OBLIQUE"));
        object.addEnum("backslant", this.getEnumProperty(164, "BACKSLANT"));
        object.setDefault("normal");
        object.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-style", object);
        object = new EnumProperty.Maker(107);
        object.setInherited(true);
        object.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        object.addEnum("small-caps", this.getEnumProperty(131, "SMALL_CAPS"));
        object.setDefault("normal");
        object.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-variant", object);
        object = new EnumsListPropertyMaker(297);
        object.setInherited(true);
        object.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        object.addEnum("none", this.getEnumProperty(95, "NONE"));
        object.addEnum("common-ligatures", this.getEnumProperty(208, "EN_COMMON_LIGATURES"));
        object.addEnum("no-common-ligatures", this.getEnumProperty(209, "EN_NO_COMMON_LIGATURES"));
        object.addEnum("discretionary-ligatures", this.getEnumProperty(210, "EN_DISCRETIONARY_LIGATURES"));
        object.addEnum("no-discretionary-ligatures", this.getEnumProperty(211, "EN_NO_DISCRETIONARY_LIGATURES"));
        object.addEnum("historical-ligatures", this.getEnumProperty(212, "EN_HISTORICAL_LIGATURES"));
        object.addEnum("no-historical-ligatures", this.getEnumProperty(213, "EN_NO_HISTORICAL_LIGATURES"));
        object.addEnum("contextual", this.getEnumProperty(214, "EN_CONTEXTUAL"));
        object.addEnum("no-contextual", this.getEnumProperty(215, "EN_NO_CONTEXTUAL"));
        object.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("font-variant-ligatures", object);
        object = new StringProperty.Maker(298);
        object.setInherited(true);
        object.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        object.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("font-variant-alternates", object);
        object = new EnumsListPropertyMaker(299);
        object.setInherited(true);
        object.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        object.addEnum("none", this.getEnumProperty(95, "NONE"));
        object.addEnum("lining-nums", this.getEnumProperty(216, "EN_LINING_NUMS"));
        object.addEnum("oldstyle-nums", this.getEnumProperty(217, "EN_OLDSTYLE_NUMS"));
        object.addEnum("proportional-nums", this.getEnumProperty(218, "EN_PROPORTIONAL_NUMS"));
        object.addEnum("tabular-nums", this.getEnumProperty(219, "EN_TABULAR_NUMS"));
        object.addEnum("diagonal-fractions", this.getEnumProperty(220, "EN_DIAGONAL_FRACTIONS"));
        object.addEnum("stacked-fractions", this.getEnumProperty(221, "EN_STACKED_FRACTIONS"));
        object.addEnum("ordinal", this.getEnumProperty(222, "EN_ORDINAL"));
        object.addEnum("slashed-zero", this.getEnumProperty(223, "EN_SLASHED_ZERO"));
        object.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("font-variant-numeric", object);
        object = new FontWeightPropertyMaker(108);
        object.setInherited(true);
        object.addKeyword("normal", "400");
        object.addKeyword("bold", "700");
        object.addEnum("bolder", this.getEnumProperty(165, "BOLDER"));
        object.addEnum("lighter", this.getEnumProperty(166, "LIGHTER"));
        object.addEnum("100", this.getEnumProperty(167, "100"));
        object.addEnum("200", this.getEnumProperty(168, "200"));
        object.addEnum("300", this.getEnumProperty(169, "300"));
        object.addEnum("400", this.getEnumProperty(170, "400"));
        object.addEnum("500", this.getEnumProperty(171, "500"));
        object.addEnum("600", this.getEnumProperty(172, "600"));
        object.addEnum("700", this.getEnumProperty(173, "700"));
        object.addEnum("800", this.getEnumProperty(174, "800"));
        object.addEnum("900", this.getEnumProperty(175, "900"));
        object.setDefault("400");
        object.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("font-weight", object);
    }

    private void createHyphenationProperties() {
        StringProperty.Maker maker = new StringProperty.Maker(81);
        maker.setInherited(true);
        maker.setDefault("none");
        maker.addShorthand(generics[268]);
        FOPropertyMapping.addPropertyMaker("country", (PropertyMaker)maker);
        maker = new StringProperty.Maker(134);
        maker.setInherited(true);
        maker.setDefault("none");
        maker.addShorthand(generics[268]);
        FOPropertyMapping.addPropertyMaker("language", (PropertyMaker)maker);
        maker = new StringProperty.Maker(218);
        maker.setInherited(true);
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("script", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(116);
        maker.useGeneric(this.genericBoolean);
        maker.setInherited(true);
        maker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("hyphenate", (PropertyMaker)maker);
        maker = new OptionalCharacterProperty.Maker(117);
        maker.setInherited(true);
        maker.setDefault("\u00ad");
        FOPropertyMapping.addPropertyMaker("hyphenation-character", (PropertyMaker)maker);
        maker = new NumberProperty.PositiveIntegerMaker(120);
        maker.setInherited(true);
        maker.setDefault("2");
        FOPropertyMapping.addPropertyMaker("hyphenation-push-character-count", (PropertyMaker)maker);
        maker = new NumberProperty.PositiveIntegerMaker(121);
        maker.setInherited(true);
        maker.setDefault("2");
        FOPropertyMapping.addPropertyMaker("hyphenation-remain-character-count", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(295);
        maker.useGeneric(this.genericBoolean);
        maker.setInherited(true);
        maker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("avoid-breaking-line-at-hyphens", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(296);
        maker.useGeneric(this.genericBoolean);
        maker.setInherited(true);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        maker.addEnum("avoid", this.getEnumProperty(176, "AVOID"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("break-line-at-hyphens", (PropertyMaker)maker);
    }

    private void createMarginBlockProperties() {
        LengthProperty.Maker maker = new LengthProperty.Maker(151);
        maker.setInherited(false);
        maker.setDefault("0pt");
        maker.addShorthand(generics[147]);
        maker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-top", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(148);
        maker.setInherited(false);
        maker.setDefault("0pt");
        maker.addShorthand(generics[147]);
        maker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-bottom", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(149);
        maker.setInherited(false);
        maker.setDefault("0pt");
        maker.addShorthand(generics[147]);
        maker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-left", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(150);
        maker.setInherited(false);
        maker.setDefault("0pt");
        maker.addShorthand(generics[147]);
        maker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin-right", (PropertyMaker)maker);
        maker = new SpaceProperty.Maker(223);
        maker.useGeneric(this.genericSpace);
        SpacePropertyMaker spacePropertyMaker = new SpacePropertyMaker((PropertyMaker)maker);
        spacePropertyMaker.setCorresponding(151, 151, 150, 149);
        spacePropertyMaker.setUseParent(false);
        spacePropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("space-before", (PropertyMaker)maker);
        maker = new SpaceProperty.Maker(222);
        maker.useGeneric(this.genericSpace);
        spacePropertyMaker = new SpacePropertyMaker((PropertyMaker)maker);
        spacePropertyMaker.setCorresponding(148, 148, 149, 150);
        spacePropertyMaker.setUseParent(false);
        spacePropertyMaker.setRelative(true);
        FOPropertyMapping.addPropertyMaker("space-after", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(233);
        maker.setInherited(true);
        maker.setDefault("0pt");
        maker.setPercentBase(4);
        IndentPropertyMaker indentPropertyMaker = new IndentPropertyMaker((PropertyMaker)maker);
        indentPropertyMaker.setCorresponding(149, 150, 151, 151);
        indentPropertyMaker.setUseParent(false);
        indentPropertyMaker.setRelative(true);
        indentPropertyMaker.setPaddingCorresponding(new int[]{175, 176, 178, 178});
        indentPropertyMaker.setBorderWidthCorresponding(new int[]{40, 44, 55, 55});
        FOPropertyMapping.addPropertyMaker("start-indent", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(91);
        maker.setInherited(true);
        maker.setDefault("0pt");
        maker.setPercentBase(4);
        IndentPropertyMaker indentPropertyMaker2 = new IndentPropertyMaker((PropertyMaker)maker);
        indentPropertyMaker2.setCorresponding(150, 149, 148, 148);
        indentPropertyMaker2.setUseParent(false);
        indentPropertyMaker2.setRelative(true);
        indentPropertyMaker2.setPaddingCorresponding(new int[]{176, 175, 173, 173});
        indentPropertyMaker2.setBorderWidthCorresponding(new int[]{44, 40, 30, 30});
        FOPropertyMapping.addPropertyMaker("end-indent", (PropertyMaker)maker);
    }

    private void createMarginInlineProperties() {
        SpaceProperty.Maker maker = new SpaceProperty.Maker(224);
        maker.useGeneric(this.genericSpace);
        FOPropertyMapping.addPropertyMaker("space-end", (PropertyMaker)maker);
        maker = new SpaceProperty.Maker(225);
        maker.useGeneric(this.genericSpace);
        FOPropertyMapping.addPropertyMaker("space-start", (PropertyMaker)maker);
    }

    private void createRelativePosProperties() {
        EnumProperty.Maker maker = new EnumProperty.Maker(203);
        maker.setInherited(false);
        maker.addEnum("static", this.getEnumProperty(136, "STATIC"));
        maker.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        maker.setDefault("static");
        maker.addShorthand(generics[193]);
        FOPropertyMapping.addPropertyMaker("relative-position", (PropertyMaker)maker);
    }

    private void createAreaAlignmentProperties() {
        LengthProperty.Maker maker = new LengthProperty.Maker(3);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        maker.addEnum("before-edge", this.getEnumProperty(14, "BEFORE_EDGE"));
        maker.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        maker.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        maker.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        maker.addEnum("after-edge", this.getEnumProperty(4, "AFTER_EDGE"));
        maker.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        maker.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        maker.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        maker.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        maker.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        maker.setDefault("auto");
        maker.setPercentBase(12);
        maker.addShorthand(generics[256]);
        FOPropertyMapping.addPropertyMaker("alignment-adjust", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(4);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        maker.addEnum("before-edge", this.getEnumProperty(14, "BEFORE_EDGE"));
        maker.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        maker.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        maker.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        maker.addEnum("after-edge", this.getEnumProperty(4, "AFTER_EDGE"));
        maker.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        maker.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        maker.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        maker.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        maker.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        maker.addEnum("-oxy-first-line", this.getEnumProperty(206, "FIRST_LINE_BASELINE"));
        maker.setDefault("auto");
        maker.addShorthand(generics[256]);
        FOPropertyMapping.addPropertyMaker("alignment-baseline", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(15);
        maker.setInherited(false);
        maker.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        maker.addEnum("sub", this.getEnumProperty(137, "SUB"));
        maker.addEnum("super", this.getEnumProperty(138, "SUPER"));
        maker.setDefault("baseline");
        maker.addShorthand(generics[256]);
        maker.setPercentBase(0);
        FOPropertyMapping.addPropertyMaker("baseline-shift", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(87);
        maker.setInherited(true);
        maker.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        maker.addEnum("after", this.getEnumProperty(3, "AFTER"));
        maker.addEnum("center", this.getEnumProperty(23, "CENTER"));
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("display-align", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(88);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("use-script", this.getEnumProperty(157, "USE_SCRIPT"));
        maker.addEnum("no-change", this.getEnumProperty(87, "NO_CHANGE"));
        maker.addEnum("reset-size", this.getEnumProperty(116, "RESET_SIZE"));
        maker.addEnum("ideographic", this.getEnumProperty(59, "IDEOGRAPHIC"));
        maker.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        maker.addEnum("hanging", this.getEnumProperty(56, "HANGING"));
        maker.addEnum("mathematical", this.getEnumProperty(82, "MATHEMATICAL"));
        maker.addEnum("central", this.getEnumProperty(24, "CENTRAL"));
        maker.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        maker.addEnum("text-after-edge", this.getEnumProperty(141, "TEXT_AFTER_EDGE"));
        maker.addEnum("text-before-edge", this.getEnumProperty(142, "TEXT_BEFORE_EDGE"));
        maker.setDefault("auto");
        maker.addShorthand(generics[256]);
        FOPropertyMapping.addPropertyMaker("dominant-baseline", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(202);
        maker.setInherited(true);
        maker.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        maker.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        maker.setDefault("before");
        FOPropertyMapping.addPropertyMaker("relative-align", (PropertyMaker)maker);
    }

    private void createAreaDimensionProperties() {
        LengthRangeProperty.Maker maker = new LengthRangeProperty.Maker(17);
        maker.setInherited(false);
        maker.setPercentBase(6);
        LengthProperty.Maker maker2 = new LengthProperty.Maker(3072);
        maker2.setDefault("auto");
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setPercentBase(6);
        maker2.setByShorthand(true);
        maker.addSubpropMaker((PropertyMaker)maker2);
        maker2 = new LengthProperty.Maker(3584);
        maker2.setDefault("auto");
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setPercentBase(6);
        maker2.setByShorthand(true);
        maker.addSubpropMaker((PropertyMaker)maker2);
        maker2 = new LengthProperty.Maker(2560);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setDefault("auto");
        maker2.setPercentBase(6);
        maker2.setByShorthand(true);
        maker.addSubpropMaker((PropertyMaker)maker2);
        DimensionPropertyMaker dimensionPropertyMaker = new DimensionPropertyMaker((PropertyMaker)maker);
        dimensionPropertyMaker.setCorresponding(115, 115, 264, 264);
        dimensionPropertyMaker.setExtraCorresponding((int[][])new int[][]{{162, 162, 163, 163}, {155, 155, 157, 157}});
        dimensionPropertyMaker.setRelative(true);
        maker.setCorresponding((CorrespondingPropertyMaker)dimensionPropertyMaker);
        FOPropertyMapping.addPropertyMaker("block-progression-dimension", (PropertyMaker)maker);
        maker2 = new LengthProperty.Maker(78);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.addEnum("scale-to-fit", this.getEnumProperty(125, "SCALE_TO_FIT"));
        maker2.addEnum("scale-down-to-fit", this.getEnumProperty(185, "SCALE_DOWN_TO_FIT"));
        maker2.addEnum("scale-up-to-fit", this.getEnumProperty(186, "SCALE_UP_TO_FIT"));
        maker2.setDefault("auto");
        maker2.setPercentBase(8);
        FOPropertyMapping.addPropertyMaker("content-height", (PropertyMaker)maker2);
        maker2 = new LengthProperty.Maker(80);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.addEnum("scale-to-fit", this.getEnumProperty(125, "SCALE_TO_FIT"));
        maker2.addEnum("scale-down-to-fit", this.getEnumProperty(185, "SCALE_DOWN_TO_FIT"));
        maker2.addEnum("scale-up-to-fit", this.getEnumProperty(186, "SCALE_UP_TO_FIT"));
        maker2.setDefault("auto");
        maker2.setPercentBase(7);
        FOPropertyMapping.addPropertyMaker("content-width", (PropertyMaker)maker2);
        maker2 = new LengthProperty.Maker(115);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setPercentBase(6);
        maker2.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("height", (PropertyMaker)maker2);
        maker = new LengthRangeProperty.Maker(127);
        maker.setInherited(false);
        maker.setPercentBase(5);
        maker2 = new LengthProperty.Maker(3072);
        maker2.setDefault("auto");
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setPercentBase(5);
        maker2.setByShorthand(true);
        maker.addSubpropMaker((PropertyMaker)maker2);
        maker2 = new LengthProperty.Maker(3584);
        maker2.setDefault("auto");
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setPercentBase(5);
        maker2.setByShorthand(true);
        maker.addSubpropMaker((PropertyMaker)maker2);
        maker2 = new LengthProperty.Maker(2560);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setDefault("auto");
        maker2.setPercentBase(5);
        maker2.setByShorthand(true);
        maker.addSubpropMaker((PropertyMaker)maker2);
        dimensionPropertyMaker = new DimensionPropertyMaker((PropertyMaker)maker);
        dimensionPropertyMaker.setRelative(true);
        dimensionPropertyMaker.setCorresponding(264, 264, 115, 115);
        dimensionPropertyMaker.setExtraCorresponding((int[][])new int[][]{{163, 163, 162, 162}, {157, 157, 155, 162}});
        maker.setCorresponding((CorrespondingPropertyMaker)dimensionPropertyMaker);
        FOPropertyMapping.addPropertyMaker("inline-progression-dimension", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(155);
        maker.addEnum("NONE", this.getEnumProperty(95, "NONE"));
        maker.setInherited(false);
        maker.setDefault("0pt");
        maker.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("max-height", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(157);
        maker.addEnum("NONE", this.getEnumProperty(95, "NONE"));
        maker.setInherited(false);
        maker.setDefault("none");
        maker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("max-width", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(162);
        maker.setInherited(false);
        maker.setDefault("0pt");
        maker.setPercentBase(6);
        FOPropertyMapping.addPropertyMaker("min-height", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(163);
        maker.setInherited(false);
        maker.setDefault("");
        maker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("min-width", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(215);
        maker.setInherited(true);
        maker.addEnum("uniform", this.getEnumProperty(154, "UNIFORM"));
        maker.addEnum("non-uniform", this.getEnumProperty(94, "NON_UNIFORM"));
        maker.setDefault("uniform");
        FOPropertyMapping.addPropertyMaker("scaling", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(216);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("integer-pixels", this.getEnumProperty(69, "INTEGER_PIXELS"));
        maker.addEnum("resample-any-method", this.getEnumProperty(115, "RESAMPLE_ANY_METHOD"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("scaling-method", (PropertyMaker)maker);
        maker2 = new LengthProperty.Maker(264);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setPercentBase(5);
        maker2.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("width", (PropertyMaker)maker2);
    }

    private Property calcWritingModeDependent(int n2, int n3) {
        if (n2 == 73) {
            n2 = n3 == 79 ? 135 : (n3 == 121 ? 39 : 135);
        } else if (n2 == 120) {
            n2 = n3 == 79 ? 39 : (n3 == 121 ? 135 : 39);
        }
        return this.makeWritingModeDependentEnum(n2);
    }

    private Property makeWritingModeDependentEnum(int n2) {
        if (n2 == 135) {
            return this.getEnumProperty(135, "START");
        }
        if (n2 == 39) {
            return this.getEnumProperty(39, "END");
        }
        return null;
    }

    private void createBlockAndLineProperties() {
        EnumProperty.Maker maker = new EnumProperty.Maker(118);
        maker.setInherited(true);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("column", this.getEnumProperty(28, "COLUMN"));
        maker.addEnum("page", this.getEnumProperty(104, "PAGE"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("hyphenation-keep", (PropertyMaker)maker);
        maker = new NumberProperty.Maker(119);
        maker.setInherited(true);
        maker.addEnum("no-limit", this.getEnumProperty(89, "NO_LIMIT"));
        maker.setDefault("no-limit");
        FOPropertyMapping.addPropertyMaker("hyphenation-ladder-count", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(135);
        maker.setInherited(true);
        maker.setDefault("0pt");
        maker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("last-line-end-indent", (PropertyMaker)maker);
        maker = new LineHeightPropertyMaker(144);
        maker.useGeneric(this.genericSpace);
        maker.setInherited(true);
        maker.addKeyword("normal", "1.2");
        maker.setPercentBase(1);
        maker.setDefault("normal", true);
        maker.addShorthand(generics[100]);
        FOPropertyMapping.addPropertyMaker("line-height", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(145);
        maker.setInherited(true);
        maker.addEnum("consider-shifts", this.getEnumProperty(30, "CONSIDER_SHIFTS"));
        maker.addEnum("disregard-shifts", this.getEnumProperty(33, "DISREGARD_SHIFTS"));
        maker.setDefault("consider-shifts");
        FOPropertyMapping.addPropertyMaker("line-height-shift-adjustment", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(146);
        maker.setInherited(true);
        maker.addEnum("line-height", this.getEnumProperty(76, "LINE_HEIGHT"));
        maker.addEnum("font-height", this.getEnumProperty(52, "FONT_HEIGHT"));
        maker.addEnum("max-height", this.getEnumProperty(83, "MAX_HEIGHT"));
        maker.setDefault("max-height");
        FOPropertyMapping.addPropertyMaker("line-stacking-strategy", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(143);
        maker.setInherited(true);
        maker.addEnum("ignore", this.getEnumProperty(60, "IGNORE"));
        maker.addEnum("preserve", this.getEnumProperty(108, "PRESERVE"));
        maker.addEnum("treat-as-space", this.getEnumProperty(147, "TREAT_AS_SPACE"));
        maker.addEnum("treat-as-zero-width-space", this.getEnumProperty(148, "TREAT_AS_ZERO_WIDTH_SPACE"));
        maker.setDefault("treat-as-space");
        maker.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("linefeed-treatment", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(262);
        maker.setInherited(true);
        maker.addEnum("ignore", this.getEnumProperty(60, "IGNORE"));
        maker.addEnum("preserve", this.getEnumProperty(108, "PRESERVE"));
        maker.addEnum("ignore-if-before-linefeed", this.getEnumProperty(62, "IGNORE_IF_BEFORE_LINEFEED"));
        maker.addEnum("ignore-if-after-linefeed", this.getEnumProperty(61, "IGNORE_IF_AFTER_LINEFEED"));
        maker.addEnum("ignore-if-surrounding-linefeed", this.getEnumProperty(63, "IGNORE_IF_SURROUNDING_LINEFEED"));
        maker.setDefault("ignore-if-surrounding-linefeed");
        maker.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("white-space-treatment", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(245){

            public Property get(int n2, PropertyList propertyList, boolean bl, boolean bl2) throws PropertyException {
                int n3;
                Property property = super.get(n2, propertyList, bl, bl2);
                if (property != null && ((n3 = property.getEnum()) == 73 || n3 == 120)) {
                    property = FOPropertyMapping.this.calcWritingModeDependent(n3, propertyList.get(267).getEnum());
                }
                return property;
            }
        };
        maker.setInherited(true);
        maker.addEnum("center", this.getEnumProperty(23, "CENTER"));
        maker.addEnum("end", this.getEnumProperty(39, "END"));
        maker.addEnum("start", this.getEnumProperty(135, "START"));
        maker.addEnum("justify", this.getEnumProperty(70, "JUSTIFY"));
        maker.addEnum("left", this.getEnumProperty(73, "LEFT"));
        maker.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        maker.addEnum("inside", this.getEnumProperty(135, "START"));
        maker.addEnum("outside", this.getEnumProperty(39, "END"));
        maker.setDefault("start");
        FOPropertyMapping.addPropertyMaker("text-align", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(246){

            public Property get(int n2, PropertyList propertyList, boolean bl, boolean bl2) throws PropertyException {
                Property property = super.get(n2, propertyList, bl, bl2);
                if (property != null && property.getEnum() == 110 && (property = propertyList.getNearestSpecified(246)).getEnum() == 110) {
                    return this.calcRelative(propertyList);
                }
                return property;
            }

            private Property calcRelative(PropertyList propertyList) throws PropertyException {
                Property property = propertyList.get(245);
                if (property == null) {
                    return null;
                }
                int n2 = property.getEnum();
                if (n2 == 70) {
                    return FOPropertyMapping.this.getEnumProperty(135, "START");
                }
                if (n2 == 39) {
                    return FOPropertyMapping.this.getEnumProperty(39, "END");
                }
                if (n2 == 135) {
                    return FOPropertyMapping.this.getEnumProperty(135, "START");
                }
                if (n2 == 23) {
                    return FOPropertyMapping.this.getEnumProperty(23, "CENTER");
                }
                if (n2 == 73) {
                    return FOPropertyMapping.this.calcWritingModeDependent(73, propertyList.get(267).getEnum());
                }
                if (n2 == 120) {
                    return FOPropertyMapping.this.calcWritingModeDependent(120, propertyList.get(267).getEnum());
                }
                return null;
            }
        };
        maker.setInherited(false);
        maker.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        maker.addEnum("center", this.getEnumProperty(23, "CENTER"));
        maker.addEnum("end", this.getEnumProperty(39, "END"));
        maker.addEnum("right", this.getEnumProperty(39, "END"));
        maker.addEnum("start", this.getEnumProperty(135, "START"));
        maker.addEnum("left", this.getEnumProperty(135, "START"));
        maker.addEnum("justify", this.getEnumProperty(70, "JUSTIFY"));
        maker.addEnum("inside", this.getEnumProperty(135, "START"));
        maker.addEnum("outside", this.getEnumProperty(39, "END"));
        maker.setDefault("relative", true);
        FOPropertyMapping.addPropertyMaker("text-align-last", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(250);
        maker.setInherited(true);
        maker.setDefault("0pt");
        maker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("text-indent", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(261);
        maker.useGeneric(this.genericBoolean);
        maker.setInherited(true);
        maker.setDefault("true");
        maker.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("white-space-collapse", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(266);
        maker.setInherited(true);
        maker.addEnum("wrap", this.getEnumProperty(161, "WRAP"));
        maker.addEnum("no-wrap", this.getEnumProperty(93, "NO_WRAP"));
        maker.setDefault("wrap");
        maker.addShorthand(generics[260]);
        FOPropertyMapping.addPropertyMaker("wrap-option", (PropertyMaker)maker);
    }

    private void createCharacterProperties() {
        CharacterProperty.Maker maker = new CharacterProperty.Maker(69);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("character", (PropertyMaker)maker);
        maker = new SpacingPropertyMaker(141);
        maker.useGeneric(this.genericSpace);
        maker.setInherited(true);
        maker.getSubpropMaker(4096).setDefault("force");
        maker.getSubpropMaker(1024).setDefault("discard");
        maker.setDefault("normal");
        maker.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        FOPropertyMapping.addPropertyMaker("letter-spacing", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(237);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("suppress", this.getEnumProperty(139, "SUPPRESS"));
        maker.addEnum("retain", this.getEnumProperty(118, "RETAIN"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("suppress-at-line-break", (PropertyMaker)maker);
        maker = new TextDecorationMaker(248);
        maker.setInherited(false);
        maker.addEnum("none", this.getEnumProperty(95, "NONE"));
        maker.addEnum("underline", this.getEnumProperty(153, "UNDERLINE"));
        maker.addEnum("overline", this.getEnumProperty(103, "OVERLINE"));
        maker.addEnum("line-through", this.getEnumProperty(77, "LINE_THROUGH"));
        maker.addEnum("blink", this.getEnumProperty(17, "BLINK"));
        maker.addEnum("no-underline", this.getEnumProperty(92, "NO_UNDERLINE"));
        maker.addEnum("no-overline", this.getEnumProperty(91, "NO_OVERLINE"));
        maker.addEnum("no-line-through", this.getEnumProperty(90, "NO_LINE_THROUGH"));
        maker.addEnum("no-blink", this.getEnumProperty(86, "NO_BLINK"));
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-decoration", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(251);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-shadow", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(252);
        maker.setInherited(true);
        maker.addEnum("none", this.getEnumProperty(95, "NONE"));
        maker.addEnum("capitalize", this.getEnumProperty(22, "CAPITALIZE"));
        maker.addEnum("uppercase", this.getEnumProperty(155, "UPPERCASE"));
        maker.addEnum("lowercase", this.getEnumProperty(78, "LOWERCASE"));
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("text-transform", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(254);
        maker.useGeneric(this.genericBoolean);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setInherited(false);
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("treat-as-word-space", (PropertyMaker)maker);
        maker = new SpacingPropertyMaker(265);
        maker.useGeneric(this.genericSpace);
        maker.setInherited(true);
        maker.getSubpropMaker(4096).setDefault("force");
        maker.getSubpropMaker(1024).setDefault("discard");
        maker.setDefault("normal");
        maker.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        FOPropertyMapping.addPropertyMaker("word-spacing", (PropertyMaker)maker);
    }

    private void createColorProperties() {
        ColorProperty.Maker maker = new ColorProperty.Maker(72);
        maker.useGeneric(this.genericColor);
        maker.setInherited(true);
        maker.setDefault("black");
        FOPropertyMapping.addPropertyMaker("color", (PropertyMaker)maker);
        maker = new StringProperty.Maker(73);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("color-profile-name", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(204);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("perceptual", this.getEnumProperty(107, "PERCEPTUAL"));
        maker.addEnum("relative-colorimetric", this.getEnumProperty(111, "RELATIVE_COLOMETRIC"));
        maker.addEnum("saturation", this.getEnumProperty(124, "SATURATION"));
        maker.addEnum("absolute-colorimetric", this.getEnumProperty(2, "ABSOLUTE_COLORMETRIC"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("rendering-intent", (PropertyMaker)maker);
    }

    private void createFloatProperties() {
        EnumProperty.Maker maker = new EnumProperty.Maker(70);
        maker.setInherited(false);
        maker.addEnum("start", this.getEnumProperty(135, "START"));
        maker.addEnum("end", this.getEnumProperty(39, "END"));
        maker.addEnum("left", this.getEnumProperty(135, "START"));
        maker.addEnum("right", this.getEnumProperty(39, "END"));
        maker.addEnum("both", this.getEnumProperty(19, "BOTH"));
        maker.addEnum("none", this.getEnumProperty(95, "NONE"));
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("clear", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(95);
        maker.setInherited(false);
        maker.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        maker.addEnum("start", this.getEnumProperty(135, "START"));
        maker.addEnum("end", this.getEnumProperty(39, "END"));
        maker.addEnum("left", this.getEnumProperty(135, "START"));
        maker.addEnum("right", this.getEnumProperty(39, "END"));
        maker.addEnum("none", this.getEnumProperty(95, "NONE"));
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("float", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(130);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("none", this.getEnumProperty(95, "NONE"));
        maker.addEnum("line", this.getEnumProperty(75, "LINE"));
        maker.addEnum("indent", this.getEnumProperty(65, "INDENT"));
        maker.addEnum("block", this.getEnumProperty(18, "BLOCK"));
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("intrusion-displace", (PropertyMaker)maker);
    }

    private void createKeepsAndBreaksProperties() {
        EnumProperty.Maker maker = new EnumProperty.Maker(58);
        maker.useGeneric(this.genericBreak);
        maker.addShorthand(generics[179]);
        FOPropertyMapping.addPropertyMaker("break-after", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(59);
        maker.useGeneric(this.genericBreak);
        maker.addShorthand(generics[180]);
        FOPropertyMapping.addPropertyMaker("break-before", (PropertyMaker)maker);
        maker = new KeepProperty.Maker(131);
        maker.useGeneric(this.genericKeep);
        maker.setInherited(true);
        maker.setDefault("auto");
        maker.addShorthand(generics[181]);
        FOPropertyMapping.addPropertyMaker("keep-together", (PropertyMaker)maker);
        maker = new KeepProperty.Maker(132);
        maker.useGeneric(this.genericKeep);
        maker.setInherited(false);
        maker.setDefault("auto");
        maker.addShorthand(generics[179]);
        FOPropertyMapping.addPropertyMaker("keep-with-next", (PropertyMaker)maker);
        maker = new KeepProperty.Maker(133);
        maker.useGeneric(this.genericKeep);
        maker.setInherited(false);
        maker.setDefault("auto");
        maker.addShorthand(generics[180]);
        FOPropertyMapping.addPropertyMaker("keep-with-previous", (PropertyMaker)maker);
        maker = new NumberProperty.Maker(168);
        maker.setInherited(true);
        maker.setDefault("2");
        FOPropertyMapping.addPropertyMaker("orphans", (PropertyMaker)maker);
        maker = new NumberProperty.Maker(263);
        maker.setInherited(true);
        maker.setDefault("2");
        FOPropertyMapping.addPropertyMaker("widows", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(270);
        maker.setInherited(true);
        maker.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:widow-content-limit", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(271);
        maker.setInherited(true);
        maker.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("fox:orphan-content-limit", (PropertyMaker)maker);
    }

    private void createLayoutProperties() {
        ToBeImplementedProperty.Maker maker = new ToBeImplementedProperty.Maker(71);
        maker.setInherited(false);
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("clip", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(169);
        maker.setInherited(false);
        maker.addEnum("visible", this.getEnumProperty(159, "VISIBLE"));
        maker.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        maker.addEnum("scroll", this.getEnumProperty(126, "SCROLL"));
        maker.addEnum("error-if-overflow", this.getEnumProperty(42, "ERROR_IF_OVERFLOW"));
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("overflow", (PropertyMaker)maker);
        maker = new ReferenceOrientationMaker(197);
        maker.setInherited(true);
        maker.setDefault("0");
        FOPropertyMapping.addPropertyMaker("reference-orientation", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(226);
        maker.setInherited(false);
        maker.addEnum("none", this.getEnumProperty(95, "NONE"));
        maker.addEnum("all", this.getEnumProperty(5, "ALL"));
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("span", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(272);
        maker.useGeneric(this.genericBoolean);
        maker.setInherited(true);
        maker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("fox:disable-column-balancing", (PropertyMaker)maker);
    }

    private void createLeaderAndRuleProperties() {
        EnumProperty.Maker maker = new EnumProperty.Maker(136);
        maker.setInherited(true);
        maker.addEnum("none", this.getEnumProperty(95, "NONE"));
        maker.addEnum("reference-area", this.getEnumProperty(109, "REFERENCE_AREA"));
        maker.addEnum("page", this.getEnumProperty(104, "PAGE"));
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("leader-alignment", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(138);
        maker.setInherited(true);
        maker.addEnum("space", this.getEnumProperty(134, "SPACE"));
        maker.addEnum("rule", this.getEnumProperty(123, "RULE"));
        maker.addEnum("dots", this.getEnumProperty(35, "DOTS"));
        maker.addEnum("use-content", this.getEnumProperty(158, "USECONTENT"));
        maker.setDefault("space");
        FOPropertyMapping.addPropertyMaker("leader-pattern", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(139);
        maker.setInherited(true);
        maker.setDefault("use-font-metrics", true);
        maker.addKeyword("use-font-metrics", "0pt");
        maker.setPercentBase(3);
        FOPropertyMapping.addPropertyMaker("leader-pattern-width", (PropertyMaker)maker);
        maker = new LengthRangeProperty.Maker(137);
        maker.setInherited(true);
        maker.setPercentBase(3);
        LengthProperty.Maker maker2 = new LengthProperty.Maker(3072);
        maker2.setDefault("0pt");
        maker2.setPercentBase(5);
        maker2.setByShorthand(true);
        maker.addSubpropMaker((PropertyMaker)maker2);
        maker2 = new LengthProperty.Maker(3584);
        maker2.setDefault("12.0pt");
        maker2.setPercentBase(5);
        maker2.setByShorthand(true);
        maker.addSubpropMaker((PropertyMaker)maker2);
        maker2 = new LengthProperty.Maker(2560);
        maker2.setDefault("100%", true);
        maker2.setPercentBase(5);
        maker2.setByShorthand(true);
        maker.addSubpropMaker((PropertyMaker)maker2);
        FOPropertyMapping.addPropertyMaker("leader-length", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(213);
        maker.setInherited(true);
        maker.addEnum("none", this.getEnumProperty(95, "NONE"));
        maker.addEnum("dotted", this.getEnumProperty(36, "DOTTED"));
        maker.addEnum("dashed", this.getEnumProperty(31, "DASHED"));
        maker.addEnum("solid", this.getEnumProperty(133, "SOLID"));
        maker.addEnum("double", this.getEnumProperty(37, "DOUBLE"));
        maker.addEnum("groove", this.getEnumProperty(55, "GROOVE"));
        maker.addEnum("ridge", this.getEnumProperty(119, "RIDGE"));
        maker.setDefault("solid");
        FOPropertyMapping.addPropertyMaker("rule-style", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(214);
        maker.setInherited(true);
        maker.setDefault("1.0pt");
        FOPropertyMapping.addPropertyMaker("rule-thickness", (PropertyMaker)maker);
    }

    private void createDynamicProperties() {
        ToBeImplementedProperty.Maker maker = new ToBeImplementedProperty.Maker(2);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("active-state", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(5);
        maker.setInherited(true);
        maker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("auto-restore", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(61);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("case-name", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(62);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("case-title", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(85);
        maker.setInherited(false);
        maker.setDefault("0pt");
        FOPropertyMapping.addPropertyMaker("destination-placement-offset", (PropertyMaker)maker);
        maker = new StringProperty.Maker(94);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("external-destination", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(123);
        maker.setInherited(false);
        maker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("indicate-destination", (PropertyMaker)maker);
        maker = new StringProperty.Maker(128);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("internal-destination", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(219);
        maker.setInherited(false);
        maker.addEnum("new", this.getEnumProperty(188, "NEW"));
        maker.addEnum("replace", this.getEnumProperty(187, "REPLACE"));
        maker.setDefault("replace");
        FOPropertyMapping.addPropertyMaker("show-destination", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(234);
        maker.setInherited(false);
        maker.addEnum("show", this.getEnumProperty(130, "SHOW"));
        maker.addEnum("hide", this.getEnumProperty(58, "HIDE"));
        maker.setDefault("show");
        FOPropertyMapping.addPropertyMaker("starting-state", (PropertyMaker)maker);
        maker = new StringProperty.Maker(238);
        maker.setInherited(false);
        maker.setDefault("xsl-any");
        FOPropertyMapping.addPropertyMaker("switch-to", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(242);
        maker.setInherited(false);
        maker.setDefault("use-target-processing-context");
        FOPropertyMapping.addPropertyMaker("target-presentation-context", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(243);
        maker.setInherited(false);
        maker.setDefault("document-root");
        FOPropertyMapping.addPropertyMaker("target-processing-context", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(244);
        maker.setInherited(false);
        maker.setDefault("use-normal-stylesheet");
        FOPropertyMapping.addPropertyMaker("target-stylesheet", (PropertyMaker)maker);
    }

    private void createMarkersProperties() {
        StringProperty.Maker maker = new StringProperty.Maker(152);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("marker-class-name", (PropertyMaker)maker);
        maker = new StringProperty.Maker(207);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("retrieve-class-name", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(208);
        maker.setInherited(false);
        maker.addEnum("first-starting-within-page", this.getEnumProperty(54, "FSWP"));
        maker.addEnum("first-including-carryover", this.getEnumProperty(49, "FIC"));
        maker.addEnum("last-starting-within-page", this.getEnumProperty(81, "LSWP"));
        maker.addEnum("last-ending-within-page", this.getEnumProperty(74, "LEWP"));
        maker.setDefault("first-starting-within-page");
        FOPropertyMapping.addPropertyMaker("retrieve-position", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(205);
        maker.setInherited(false);
        maker.addEnum("page", this.getEnumProperty(104, "PAGE"));
        maker.addEnum("page-sequence", this.getEnumProperty(105, "PAGE_SEQUENCE"));
        maker.addEnum("document", this.getEnumProperty(34, "DOCUMENT"));
        maker.setDefault("page-sequence");
        FOPropertyMapping.addPropertyMaker("retrieve-boundary", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(209);
        maker.setInherited(false);
        maker.addEnum("first-starting", this.getEnumProperty(189, "FIRST_STARTING"));
        maker.addEnum("first-including-carryover", this.getEnumProperty(204, "FIRST_INCLUDING_CARRYOVER"));
        maker.addEnum("last-starting", this.getEnumProperty(190, "LAST_STARTING"));
        maker.addEnum("last-ending", this.getEnumProperty(191, "LAST_ENDING"));
        maker.setDefault("first-starting");
        FOPropertyMapping.addPropertyMaker("retrieve-position-within-table", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(206);
        maker.setInherited(false);
        maker.addEnum("table", this.getEnumProperty(192, "TABLE"));
        maker.addEnum("table-fragment", this.getEnumProperty(193, "TABLE_FRAGMENT"));
        maker.addEnum("page", this.getEnumProperty(104, "PAGE"));
        maker.setDefault("table");
        FOPropertyMapping.addPropertyMaker("retrieve-boundary-within-table", (PropertyMaker)maker);
    }

    private void createNumberToStringProperties() {
        StringProperty.Maker maker = new StringProperty.Maker(110);
        maker.setInherited(false);
        maker.setDefault("1");
        FOPropertyMapping.addPropertyMaker("format", (PropertyMaker)maker);
        maker = new CharacterProperty.Maker(113);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("grouping-separator", (PropertyMaker)maker);
        maker = new NumberProperty.Maker(114);
        maker.setInherited(false);
        maker.setDefault("0");
        FOPropertyMapping.addPropertyMaker("grouping-size", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(142);
        maker.setInherited(false);
        maker.addEnum("alphabetic", this.getEnumProperty(6, "ALPHABETIC"));
        maker.addEnum("traditional", this.getEnumProperty(146, "TRADITIONAL"));
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("letter-value", (PropertyMaker)maker);
        maker = new StringProperty.Maker(288);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("fox:number-conversion-features", (PropertyMaker)maker);
    }

    private void createPaginationAndLayoutProperties() {
        EnumProperty.Maker maker = new EnumProperty.Maker(16);
        maker.setInherited(false);
        maker.addEnum("blank", this.getEnumProperty(16, "BLANK"));
        maker.addEnum("not-blank", this.getEnumProperty(98, "NOT_BLANK"));
        maker.addEnum("any", this.getEnumProperty(8, "ANY"));
        maker.setDefault("any");
        FOPropertyMapping.addPropertyMaker("blank-or-not-blank", (PropertyMaker)maker);
        maker = new NumberProperty.PositiveIntegerMaker(74);
        maker.setInherited(false);
        maker.setDefault("1");
        FOPropertyMapping.addPropertyMaker("column-count", (PropertyMaker)maker);
        LengthProperty.Maker maker2 = new LengthProperty.Maker(75);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.setDefault("0.25in");
        FOPropertyMapping.addPropertyMaker("column-gap", (PropertyMaker)maker2);
        maker = new LengthProperty.Maker(93);
        maker.setInherited(true);
        maker.setDefault("0pt");
        maker.setPercentBase(0);
        FOPropertyMapping.addPropertyMaker("extent", (PropertyMaker)maker);
        maker = new StringProperty.Maker(98);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("flow-name", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(109);
        maker.setInherited(false);
        maker.addEnum("even", this.getEnumProperty(43, "EVEN"));
        maker.addEnum("odd", this.getEnumProperty(99, "ODD"));
        maker.addEnum("end-on-even", this.getEnumProperty(40, "END_ON_EVEN"));
        maker.addEnum("end-on-odd", this.getEnumProperty(41, "END_ON_ODD"));
        maker.addEnum("no-force", this.getEnumProperty(88, "NO_FORCE"));
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("force-page-count", (PropertyMaker)maker);
        maker = new NumberProperty.PositiveIntegerMaker(126);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("auto-odd", this.getEnumProperty(11, "AUTO_ODD"));
        maker.addEnum("auto-even", this.getEnumProperty(10, "AUTO_EVEN"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("initial-page-number", (PropertyMaker)maker);
        maker = new StringProperty.Maker(153);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("master-name", (PropertyMaker)maker);
        maker = new StringProperty.Maker(154);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("master-reference", (PropertyMaker)maker);
        maker = new NumberProperty.Maker(156);
        maker.setInherited(false);
        maker.addEnum("no-limit", this.getEnumProperty(89, "NO_LIMIT"));
        maker.setDefault("no-limit");
        FOPropertyMapping.addPropertyMaker("maximum-repeats", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(161);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("paginate", this.getEnumProperty(106, "PAGINATE"));
        maker.addEnum("bounded-in-one-dimension", this.getEnumProperty(21, "BOUNDED_IN_ONE_DIMENSION"));
        maker.addEnum("unbounded", this.getEnumProperty(152, "UNBOUNDED"));
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("media-usage", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(167);
        maker.setInherited(false);
        maker.addEnum("odd", this.getEnumProperty(99, "ODD"));
        maker.addEnum("even", this.getEnumProperty(43, "EVEN"));
        maker.addEnum("any", this.getEnumProperty(8, "ANY"));
        maker.setDefault("any");
        FOPropertyMapping.addPropertyMaker("odd-or-even", (PropertyMaker)maker);
        maker2 = new PageDimensionMaker(183);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.addEnum("indefinite", this.getEnumProperty(64, "INDEFINITE"));
        maker2.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("page-height", (PropertyMaker)maker2);
        maker = new EnumProperty.Maker(185);
        maker.setInherited(false);
        maker.addEnum("first", this.getEnumProperty(50, "FIRST"));
        maker.addEnum("last", this.getEnumProperty(72, "LAST"));
        maker.addEnum("rest", this.getEnumProperty(117, "REST"));
        maker.addEnum("any", this.getEnumProperty(8, "ANY"));
        maker.addEnum("only", this.getEnumProperty(184, "ONLY"));
        maker.setDefault("any");
        FOPropertyMapping.addPropertyMaker("page-position", (PropertyMaker)maker);
        maker2 = new PageDimensionMaker(186);
        maker2.setInherited(false);
        maker2.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker2.addEnum("indefinite", this.getEnumProperty(64, "INDEFINITE"));
        maker2.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("page-width", (PropertyMaker)maker2);
        maker = new EnumProperty.Maker(194);
        maker.useGeneric(this.genericBoolean);
        maker.setInherited(false);
        maker.setDefault("false");
        FOPropertyMapping.addPropertyMaker("precedence", (PropertyMaker)maker);
        maker = new StringProperty.Maker(199);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("region-name", (PropertyMaker)maker);
    }

    private void createTableProperties() {
        TableBorderPrecedence tableBorderPrecedence = new TableBorderPrecedence(20);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-after-precedence", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new TableBorderPrecedence(24);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-before-precedence", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new EnumProperty.Maker(31);
        tableBorderPrecedence.setInherited(true);
        tableBorderPrecedence.setDefault("collapse");
        tableBorderPrecedence.addEnum("separate", this.getEnumProperty(129, "SEPARATE"));
        tableBorderPrecedence.addEnum("collapse-with-precedence", this.getEnumProperty(27, "COLLAPSE_WITH_PRECEDENCE"));
        tableBorderPrecedence.addEnum("collapse", this.getEnumProperty(26, "COLLAPSE"));
        FOPropertyMapping.addPropertyMaker("border-collapse", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new TableBorderPrecedence(34);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-end-precedence", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new LengthPairProperty.Maker(45);
        tableBorderPrecedence.setInherited(true);
        tableBorderPrecedence.addShorthand(generics[46]);
        LengthProperty.Maker maker = new LengthProperty.Maker(512);
        maker.setDefault("0pt");
        maker.setByShorthand(true);
        tableBorderPrecedence.addSubpropMaker((PropertyMaker)maker);
        maker = new LengthProperty.Maker(1536);
        maker.setDefault("0pt");
        maker.setByShorthand(true);
        tableBorderPrecedence.addSubpropMaker((PropertyMaker)maker);
        FOPropertyMapping.addPropertyMaker("border-separation", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new TableBorderPrecedence(48);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.addEnum("force", this.getEnumProperty(53, "FORCE"));
        FOPropertyMapping.addPropertyMaker("border-start-precedence", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new EnumProperty.Maker(60);
        tableBorderPrecedence.setInherited(true);
        tableBorderPrecedence.addEnum("before", this.getEnumProperty(13, "BEFORE"));
        tableBorderPrecedence.addEnum("after", this.getEnumProperty(3, "AFTER"));
        tableBorderPrecedence.addEnum("start", this.getEnumProperty(135, "START"));
        tableBorderPrecedence.addEnum("end", this.getEnumProperty(39, "END"));
        tableBorderPrecedence.addEnum("top", this.getEnumProperty(145, "TOP"));
        tableBorderPrecedence.addEnum("bottom", this.getEnumProperty(20, "BOTTOM"));
        tableBorderPrecedence.addEnum("left", this.getEnumProperty(73, "LEFT"));
        tableBorderPrecedence.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        tableBorderPrecedence.setDefault("before");
        FOPropertyMapping.addPropertyMaker("caption-side", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new TableFObj.ColumnNumberPropertyMaker(76);
        tableBorderPrecedence.setInherited(false);
        FOPropertyMapping.addPropertyMaker("column-number", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new LengthProperty.Maker(77);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        tableBorderPrecedence.setDefault("auto");
        tableBorderPrecedence.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("column-width", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new EnumProperty.Maker(90);
        tableBorderPrecedence.setInherited(true);
        tableBorderPrecedence.addEnum("show", this.getEnumProperty(130, "SHOW"));
        tableBorderPrecedence.addEnum("hide", this.getEnumProperty(58, "HIDE"));
        tableBorderPrecedence.setDefault("show");
        FOPropertyMapping.addPropertyMaker("empty-cells", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new EnumProperty.Maker(92);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.useGeneric(this.genericBoolean);
        tableBorderPrecedence.setDefault("false");
        FOPropertyMapping.addPropertyMaker("ends-row", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new NumberProperty.PositiveIntegerMaker(164);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-columns-repeated", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new NumberProperty.PositiveIntegerMaker(165);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-columns-spanned", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new NumberProperty.PositiveIntegerMaker(166);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.setDefault("1");
        FOPropertyMapping.addPropertyMaker("number-rows-spanned", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new EnumProperty.Maker(235);
        tableBorderPrecedence.useGeneric(this.genericBoolean);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.setDefault("false");
        FOPropertyMapping.addPropertyMaker("starts-row", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new EnumProperty.Maker(239);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.setDefault("auto");
        tableBorderPrecedence.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        tableBorderPrecedence.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        FOPropertyMapping.addPropertyMaker("table-layout", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new EnumProperty.Maker(240);
        tableBorderPrecedence.useGeneric(this.genericBoolean);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.setDefault("false");
        FOPropertyMapping.addPropertyMaker("table-omit-footer-at-break", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new EnumProperty.Maker(241);
        tableBorderPrecedence.useGeneric(this.genericBoolean);
        tableBorderPrecedence.setInherited(false);
        tableBorderPrecedence.setDefault("false");
        FOPropertyMapping.addPropertyMaker("table-omit-header-at-break", (PropertyMaker)tableBorderPrecedence);
        tableBorderPrecedence = new EnumProperty.Maker(289);
        tableBorderPrecedence.useGeneric(this.genericBoolean);
        tableBorderPrecedence.setDefault("false");
        FOPropertyMapping.addPropertyMaker("fox:header", (PropertyMaker)tableBorderPrecedence);
    }

    private void createWritingModeProperties() {
        EnumProperty.Maker maker = new EnumProperty.Maker(86);
        maker.setInherited(true);
        maker.addEnum("ltr", this.getEnumProperty(80, "LTR"));
        maker.addEnum("rtl", this.getEnumProperty(122, "RTL"));
        maker.setDefault("ltr");
        FOPropertyMapping.addPropertyMaker("direction", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(111);
        maker.setInherited(true);
        maker.setDefault("0deg");
        FOPropertyMapping.addPropertyMaker("glyph-orientation-horizontal", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(112);
        maker.setInherited(true);
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("glyph-orientation-vertical", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(247);
        maker.setInherited(false);
        maker.addEnum("use-font-metrics", this.getEnumProperty(156, "USE_FONT_METRICS"));
        maker.setDefault("use-font-metrics");
        maker.setPercentBase(1);
        FOPropertyMapping.addPropertyMaker("text-altitude", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(249);
        maker.setInherited(false);
        maker.addEnum("use-font-metrics", this.getEnumProperty(156, "USE_FONT_METRICS"));
        maker.setDefault("use-font-metrics");
        maker.setPercentBase(1);
        FOPropertyMapping.addPropertyMaker("text-depth", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(255);
        maker.setInherited(false);
        maker.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        maker.addEnum("embed", this.getEnumProperty(38, "EMBED"));
        maker.addEnum("bidi-override", this.getEnumProperty(15, "BIDI_OVERRIDE"));
        maker.setDefault("normal");
        FOPropertyMapping.addPropertyMaker("unicode-bidi", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(267);
        maker.setInherited(true);
        maker.setDefault("lr-tb");
        maker.addEnum("lr-tb", this.getEnumProperty(79, "LR_TB"));
        maker.addEnum("rl-tb", this.getEnumProperty(121, "RL_TB"));
        maker.addEnum("tb-rl", this.getEnumProperty(140, "TB_RL"));
        maker.addEnum("tb-lr", this.getEnumProperty(203, "TB_LR"));
        maker.addKeyword("lr", "lr-tb");
        maker.addKeyword("rl", "rl-tb");
        maker.addKeyword("tb", "tb-rl");
        FOPropertyMapping.addPropertyMaker("writing-mode", (PropertyMaker)maker);
    }

    private void createChangeBarProperties() {
        StringProperty.Maker maker = new StringProperty.Maker(63);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("change-bar-class", (PropertyMaker)maker);
        maker = new ColorProperty.Maker(64);
        maker.setInherited(true);
        maker.setDefault("black");
        FOPropertyMapping.addPropertyMaker("change-bar-color", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(66);
        maker.setInherited(true);
        maker.setDefault("start");
        maker.addEnum("start", this.getEnumProperty(135, "START"));
        maker.addEnum("end", this.getEnumProperty(39, "END"));
        maker.addEnum("left", this.getEnumProperty(73, "LEFT"));
        maker.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        maker.addEnum("inside", this.getEnumProperty(68, "INSIDE"));
        maker.addEnum("outside", this.getEnumProperty(102, "OUTSIDE"));
        maker.addEnum("alternate", this.getEnumProperty(198, "ALTERNATE"));
        FOPropertyMapping.addPropertyMaker("change-bar-placement", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(67);
        maker.useGeneric(this.genericBorderStyle);
        maker.setInherited(true);
        maker.setDefault("solid");
        FOPropertyMapping.addPropertyMaker("change-bar-style", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(68);
        maker.setInherited(true);
        maker.setDefault("6pt");
        FOPropertyMapping.addPropertyMaker("change-bar-width", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(65);
        maker.setInherited(true);
        maker.setDefault("6pt");
        FOPropertyMapping.addPropertyMaker("change-bar-offset", (PropertyMaker)maker);
    }

    private void createMiscProperties() {
        Object object = new StringProperty.Maker(79);
        object.setInherited(false);
        object.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("content-type", (PropertyMaker)object);
        object = new StringProperty.Maker(122);
        object.setInherited(false);
        object.setDefault("");
        FOPropertyMapping.addPropertyMaker("id", (PropertyMaker)object);
        object = new StringProperty.Maker(273);
        object.setInherited(false);
        object.setDefault("");
        FOPropertyMapping.addPropertyMaker("fox:alt-text", (PropertyMaker)object);
        object = new StringProperty.Maker(294);
        object.setInherited(false);
        object.setDefault("");
        FOPropertyMapping.addPropertyMaker("fox:abbreviation", (PropertyMaker)object);
        object = new EnumProperty.Maker(291);
        object.setInherited(false);
        object.addEnum("select-first-fitting", this.getEnumProperty(205, "SELECT_FIRST_FITTING"));
        object.setDefault("select-first-fitting");
        FOPropertyMapping.addPropertyMaker("fox:auto-toggle", (PropertyMaker)object);
        object = new LengthProperty.Maker(292);
        object.setInherited(false);
        object.setDefault("0pt");
        object.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("fox:background-image-width", (PropertyMaker)object);
        object = new LengthProperty.Maker(293);
        object.setInherited(false);
        object.setDefault("0pt");
        object.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("fox:background-image-height", (PropertyMaker)object);
        object = new BorderRadiusMaker(275);
        object.useGeneric(this.genericCondCornerRadiusOnHeightAxis);
        object.addShorthand(generics[284]);
        object.addShorthand(generics[283]);
        object.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-before-radius-start", (PropertyMaker)object);
        object = new BorderRadiusMaker(276);
        object.useGeneric(this.genericCondCornerRadiusOnHeightAxis);
        object.addShorthand(generics[285]);
        object.addShorthand(generics[283]);
        object.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-before-radius-end", (PropertyMaker)object);
        object = new BorderRadiusMaker(277);
        object.useGeneric(this.genericCondCornerRadiusOnHeightAxis);
        object.addShorthand(generics[286]);
        object.addShorthand(generics[283]);
        object.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-after-radius-start", (PropertyMaker)object);
        object = new BorderRadiusMaker(278);
        object.useGeneric(this.genericCondCornerRadiusOnHeightAxis);
        object.addShorthand(generics[287]);
        object.addShorthand(generics[283]);
        object.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-after-radius-end", (PropertyMaker)object);
        object = new BorderRadiusMaker(279);
        object.useGeneric(this.genericCondCornerRadiusOnWidthAxis);
        object.addShorthand(generics[284]);
        object.addShorthand(generics[283]);
        object.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-start-radius-before", (PropertyMaker)object);
        object = new BorderRadiusMaker(280);
        object.useGeneric(this.genericCondCornerRadiusOnWidthAxis);
        object.addShorthand(generics[286]);
        object.addShorthand(generics[283]);
        object.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-start-radius-after", (PropertyMaker)object);
        object = new BorderRadiusMaker(281);
        object.useGeneric(this.genericCondCornerRadiusOnWidthAxis);
        object.addShorthand(generics[285]);
        object.addShorthand(generics[283]);
        object.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-end-radius-before", (PropertyMaker)object);
        object = new BorderRadiusMaker(282);
        object.useGeneric(this.genericCondCornerRadiusOnWidthAxis);
        object.addShorthand(generics[287]);
        object.addShorthand(generics[283]);
        object.getSubpropMaker(1024).setDefault("discard");
        FOPropertyMapping.addPropertyMaker("fox:border-end-radius-after", (PropertyMaker)object);
        object = new LengthProperty.Maker(196);
        object.setInherited(true);
        object.setDefault("6pt");
        object.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("provisional-label-separation", (PropertyMaker)object);
        object = new LengthProperty.Maker(195);
        object.setInherited(true);
        object.setDefault("24pt");
        object.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("provisional-distance-between-starts", (PropertyMaker)object);
        object = new StringProperty.Maker(198);
        object.setInherited(false);
        object.setDefault("");
        FOPropertyMapping.addPropertyMaker("ref-id", (PropertyMaker)object);
        object = new EnumProperty.Maker(217);
        object.useGeneric(this.genericBoolean);
        object.setInherited(true);
        object.setDefault("true");
        FOPropertyMapping.addPropertyMaker("score-spaces", (PropertyMaker)object);
        object = new URIProperty.Maker(232);
        object.setInherited(false);
        object.setDefault("");
        FOPropertyMapping.addPropertyMaker("src", (PropertyMaker)object);
        object = new EnumProperty.Maker(257);
        object.setInherited(false);
        object.addEnum("visible", this.getEnumProperty(159, "VISIBLE"));
        object.addEnum("hidden", this.getEnumProperty(57, "HIDDEN"));
        object.addEnum("collapse", this.getEnumProperty(26, "COLLAPSE"));
        object.setDefault("visible");
        FOPropertyMapping.addPropertyMaker("visibility", (PropertyMaker)object);
        object = new NumberProperty.Maker(269);
        object.setInherited(false);
        object.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        object.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("z-index", (PropertyMaker)object);
        object = new StringProperty.Maker(290);
        object.setInherited(false);
        object.setDefault("");
        FOPropertyMapping.addPropertyMaker("fox:layer", (PropertyMaker)object);
    }

    private void createShorthandProperties() {
        ToBeImplementedProperty.Maker maker = new ToBeImplementedProperty.Maker(7);
        maker.setInherited(false);
        maker.setDefault("none");
        FOPropertyMapping.addPropertyMaker("background", (PropertyMaker)maker);
        maker = new BackgroundPositionShorthand.Maker(11);
        maker.setInherited(false);
        maker.addKeyword("left", "0pt 50%");
        maker.addKeyword("left center", "0pt 50%");
        maker.addKeyword("center left", "0pt 50%");
        maker.addKeyword("right", "100% 50%");
        maker.addKeyword("right center", "100% 50%");
        maker.addKeyword("center right", "100% 50%");
        maker.addKeyword("center", "50% 50%");
        maker.addKeyword("center center", "50% 50%");
        maker.addKeyword("top", "50% 0pt");
        maker.addKeyword("top center", "50% 0pt");
        maker.addKeyword("center top", "50% 0pt");
        maker.addKeyword("bottom", "50% 100%");
        maker.addKeyword("bottom center", "50% 100%");
        maker.addKeyword("center bottom", "50% 100%");
        maker.addKeyword("top left", "0pt 0pt");
        maker.addKeyword("left top", "0pt 0pt");
        maker.addKeyword("top right", "100% 0pt");
        maker.addKeyword("right top", "100% 0pt");
        maker.addKeyword("bottom left", "0pt 100%");
        maker.addKeyword("left bottom", "0pt 100%");
        maker.addKeyword("bottom right", "100% 100%");
        maker.addKeyword("right bottom", "100% 100%");
        maker.setDefault("0pt 0pt");
        maker.setPercentBase(0);
        maker.setDatatypeParser((ShorthandParser)new BackgroundPositionShorthand.Parser());
        FOPropertyMapping.addPropertyMaker("background-position", (PropertyMaker)maker);
        maker = new ListProperty.Maker(18);
        maker.setInherited(false);
        maker.setDefault("");
        maker.setDatatypeParser((ShorthandParser)new GenericShorthandParser());
        FOPropertyMapping.addPropertyMaker("border", (PropertyMaker)maker);
        maker = new ListProperty.Maker(27);
        maker.setInherited(false);
        maker.setDefault("");
        maker.setDatatypeParser((ShorthandParser)new BorderShorthandParser(this));
        FOPropertyMapping.addPropertyMaker("border-bottom", (PropertyMaker)maker);
        maker = new ListProperty.Maker(32);
        maker.setInherited(false);
        maker.setDefault("");
        maker.setDatatypeParser((ShorthandParser)new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-color", (PropertyMaker)maker);
        maker = new ListProperty.Maker(37);
        maker.setInherited(false);
        maker.setDefault("");
        maker.setDatatypeParser((ShorthandParser)new BorderShorthandParser(this));
        FOPropertyMapping.addPropertyMaker("border-left", (PropertyMaker)maker);
        maker = new ListProperty.Maker(41);
        maker.setInherited(false);
        maker.setDefault("");
        maker.setDatatypeParser((ShorthandParser)new BorderShorthandParser(this));
        FOPropertyMapping.addPropertyMaker("border-right", (PropertyMaker)maker);
        maker = new ListProperty.Maker(51);
        maker.setInherited(false);
        maker.setDefault("");
        maker.setDatatypeParser((ShorthandParser)new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-style", (PropertyMaker)maker);
        maker = new ListProperty.Maker(46);
        maker.setInherited(true);
        maker.setDefault("0pt");
        maker.setDatatypeParser((ShorthandParser)new BorderSpacingShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-spacing", (PropertyMaker)maker);
        maker = new ListProperty.Maker(52);
        maker.setInherited(false);
        maker.setDefault("");
        maker.setDatatypeParser((ShorthandParser)new BorderShorthandParser(this));
        FOPropertyMapping.addPropertyMaker("border-top", (PropertyMaker)maker);
        maker = new ListProperty.Maker(56);
        maker.setInherited(false);
        maker.setDefault("");
        maker.setDatatypeParser((ShorthandParser)new BoxPropShorthandParser());
        FOPropertyMapping.addPropertyMaker("border-width", (PropertyMaker)maker);
        maker = new ListProperty.Maker(283);
        maker.setInherited(false);
        maker.setDatatypeParser((ShorthandParser)new BoxCornerPropShorthandParser());
        maker.setPercentBase(13);
        FOPropertyMapping.addPropertyMaker("fox:border-radius", (PropertyMaker)maker);
        maker = new ListProperty.Maker(284);
        maker.setInherited(false);
        maker.setDatatypeParser((ShorthandParser)new BoxCornerPropShorthandParser());
        maker.setPercentBase(13);
        FOPropertyMapping.addPropertyMaker("fox:border-before-start-radius", (PropertyMaker)maker);
        maker = new ListProperty.Maker(285);
        maker.setInherited(false);
        maker.setDatatypeParser((ShorthandParser)new BoxCornerPropShorthandParser());
        maker.setPercentBase(13);
        FOPropertyMapping.addPropertyMaker("fox:border-before-end-radius", (PropertyMaker)maker);
        maker = new ListProperty.Maker(286);
        maker.setInherited(false);
        maker.setDatatypeParser((ShorthandParser)new BoxCornerPropShorthandParser());
        maker.setPercentBase(13);
        FOPropertyMapping.addPropertyMaker("fox:border-after-start-radius", (PropertyMaker)maker);
        maker = new ListProperty.Maker(287);
        maker.setInherited(false);
        maker.setDatatypeParser((ShorthandParser)new BoxCornerPropShorthandParser());
        maker.setPercentBase(13);
        FOPropertyMapping.addPropertyMaker("fox:border-after-end-radius", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(82);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("cue", (PropertyMaker)maker);
        maker = new FontShorthandProperty.Maker(100);
        maker.setInherited(true);
        maker.addEnum("caption", this.getEnumProperty(178, "CAPTION"));
        maker.addEnum("icon", this.getEnumProperty(179, "ICON"));
        maker.addEnum("message-box", this.getEnumProperty(181, "MESSAGE_BOX"));
        maker.addEnum("menu", this.getEnumProperty(180, "MENU"));
        maker.addEnum("small-caption", this.getEnumProperty(182, "SMALL_CAPTION"));
        maker.addEnum("status-bar", this.getEnumProperty(183, "STATUS_BAR"));
        maker.setDefault("");
        maker.setDatatypeParser((ShorthandParser)new FontShorthandParser());
        FOPropertyMapping.addPropertyMaker("font", (PropertyMaker)maker);
        maker = new ListProperty.Maker(147);
        maker.setInherited(false);
        maker.setDefault("");
        maker.setDatatypeParser((ShorthandParser)new BoxPropShorthandParser());
        maker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("margin", (PropertyMaker)maker);
        maker = new ListProperty.Maker(170);
        maker.setInherited(false);
        maker.setDatatypeParser((ShorthandParser)new BoxPropShorthandParser());
        maker.setPercentBase(5);
        FOPropertyMapping.addPropertyMaker("padding", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(179);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        maker.addEnum("avoid", this.getEnumProperty(176, "AVOID"));
        maker.addEnum("left", this.getEnumProperty(73, "LEFT"));
        maker.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        maker.setDefault("auto");
        maker.setDatatypeParser((ShorthandParser)new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-after", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(180);
        maker.setInherited(false);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("always", this.getEnumProperty(7, "ALWAYS"));
        maker.addEnum("avoid", this.getEnumProperty(176, "AVOID"));
        maker.addEnum("left", this.getEnumProperty(73, "LEFT"));
        maker.addEnum("right", this.getEnumProperty(120, "RIGHT"));
        maker.setDefault("auto");
        maker.setDatatypeParser((ShorthandParser)new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-before", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(181);
        maker.setInherited(true);
        maker.addEnum("auto", this.getEnumProperty(9, "AUTO"));
        maker.addEnum("avoid", this.getEnumProperty(176, "AVOID"));
        maker.setDefault("auto");
        maker.setDatatypeParser((ShorthandParser)new PageBreakShorthandParser());
        FOPropertyMapping.addPropertyMaker("page-break-inside", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(187);
        maker.setInherited(false);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("pause", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(193);
        maker.setInherited(false);
        maker.addEnum("static", this.getEnumProperty(136, "STATIC"));
        maker.addEnum("relative", this.getEnumProperty(110, "RELATIVE"));
        maker.addEnum("absolute", this.getEnumProperty(1, "ABSOLUTE"));
        maker.addEnum("fixed", this.getEnumProperty(51, "FIXED"));
        maker.setDefault("static");
        maker.setDatatypeParser((ShorthandParser)new PositionShorthandParser());
        FOPropertyMapping.addPropertyMaker("position", (PropertyMaker)maker);
        maker = new ToBeImplementedProperty.Maker(220);
        maker.setInherited(false);
        maker.setDefault("auto");
        FOPropertyMapping.addPropertyMaker("size", (PropertyMaker)maker);
        maker = new LengthProperty.Maker(256);
        maker.setInherited(false);
        maker.addEnum("baseline", this.getEnumProperty(12, "BASELINE"));
        maker.addEnum("middle", this.getEnumProperty(84, "MIDDLE"));
        maker.addEnum("sub", this.getEnumProperty(137, "SUB"));
        maker.addEnum("super", this.getEnumProperty(138, "SUPER"));
        maker.addEnum("text-top", this.getEnumProperty(144, "TEXT_TOP"));
        maker.addEnum("text-bottom", this.getEnumProperty(143, "TEXT_BOTTOM"));
        maker.addEnum("top", this.getEnumProperty(145, "TOP"));
        maker.addEnum("bottom", this.getEnumProperty(20, "BOTTOM"));
        maker.setDatatypeParser((ShorthandParser)new VerticalAlignShorthandParser());
        maker.setDefault("baseline");
        maker.setPercentBase(12);
        FOPropertyMapping.addPropertyMaker("vertical-align", (PropertyMaker)maker);
        maker = new EnumProperty.Maker(260);
        maker.setInherited(true);
        maker.addEnum("normal", this.getEnumProperty(97, "NORMAL"));
        maker.addEnum("pre", this.getEnumProperty(177, "PRE"));
        maker.addEnum("nowrap", this.getEnumProperty(93, "NO_WRAP"));
        maker.setDefault("normal");
        maker.setDatatypeParser((ShorthandParser)new WhiteSpaceShorthandParser());
        FOPropertyMapping.addPropertyMaker("white-space", (PropertyMaker)maker);
        maker = new StringProperty.Maker(268);
        maker.setInherited(true);
        maker.setDefault("");
        maker.setDatatypeParser((ShorthandParser)new XMLLangShorthandParser());
        FOPropertyMapping.addPropertyMaker("xml:lang", (PropertyMaker)maker);
        maker = new URIProperty.Maker(274);
        maker.setInherited(true);
        maker.setDefault("");
        FOPropertyMapping.addPropertyMaker("xml:base", (PropertyMaker)maker);
    }

    static {
        FOPropertyMapping fOPropertyMapping = new FOPropertyMapping();
        fOPropertyMapping.createShorthandProperties();
        fOPropertyMapping.createGenerics();
        fOPropertyMapping.createAccessibilityProperties();
        fOPropertyMapping.createAbsolutePositionProperties();
        fOPropertyMapping.createAuralProperties();
        fOPropertyMapping.createBorderPaddingBackgroundProperties();
        fOPropertyMapping.createFontProperties();
        fOPropertyMapping.createHyphenationProperties();
        fOPropertyMapping.createMarginBlockProperties();
        fOPropertyMapping.createMarginInlineProperties();
        fOPropertyMapping.createRelativePosProperties();
        fOPropertyMapping.createAreaAlignmentProperties();
        fOPropertyMapping.createAreaDimensionProperties();
        fOPropertyMapping.createBlockAndLineProperties();
        fOPropertyMapping.createCharacterProperties();
        fOPropertyMapping.createColorProperties();
        fOPropertyMapping.createFloatProperties();
        fOPropertyMapping.createKeepsAndBreaksProperties();
        fOPropertyMapping.createLayoutProperties();
        fOPropertyMapping.createLeaderAndRuleProperties();
        fOPropertyMapping.createDynamicProperties();
        fOPropertyMapping.createMarkersProperties();
        fOPropertyMapping.createNumberToStringProperties();
        fOPropertyMapping.createPaginationAndLayoutProperties();
        fOPropertyMapping.createTableProperties();
        fOPropertyMapping.createWritingModeProperties();
        fOPropertyMapping.createMiscProperties();
        fOPropertyMapping.createChangeBarProperties();
        FOPropertyMapping.addSubpropMakerName("length", 2048);
        FOPropertyMapping.addSubpropMakerName("conditionality", 1024);
        FOPropertyMapping.addSubpropMakerName("block-progression-direction", 512);
        FOPropertyMapping.addSubpropMakerName("inline-progression-direction", 1536);
        FOPropertyMapping.addSubpropMakerName("within-line", 5120);
        FOPropertyMapping.addSubpropMakerName("within-column", 4608);
        FOPropertyMapping.addSubpropMakerName("within-page", 5632);
        FOPropertyMapping.addSubpropMakerName("minimum", 3072);
        FOPropertyMapping.addSubpropMakerName("maximum", 2560);
        FOPropertyMapping.addSubpropMakerName("optimum", 3584);
        FOPropertyMapping.addSubpropMakerName("precedence", 4096);
    }

    private class BorderRadiusMaker
    extends CondLengthProperty.Maker {
        public BorderRadiusMaker(int n2) {
            super(n2);
        }

        public Property convertProperty(Property property, PropertyList propertyList, FObj fObj2) throws PropertyException {
            Numeric numeric = property.getNumeric();
            if (numeric != null && !numeric.isAbsolute() && numeric instanceof PercentLength) {
                double d2 = numeric.getNumericValue((n2, fObj) -> 1);
                property = new PercentLength(d2, this.getPercentBase(propertyList));
            }
            return super.convertProperty(property, propertyList, fObj2);
        }
    }
}

