/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.util.CompareUtil;

public class LengthBase
implements PercentBase {
    public static final int CUSTOM_BASE = 0;
    public static final int FONTSIZE = 1;
    public static final int INH_FONTSIZE = 2;
    public static final int PARENT_AREA_WIDTH = 3;
    public static final int CONTAINING_REFAREA_WIDTH = 4;
    public static final int CONTAINING_BLOCK_WIDTH = 5;
    public static final int CONTAINING_BLOCK_HEIGHT = 6;
    public static final int IMAGE_INTRINSIC_WIDTH = 7;
    public static final int IMAGE_INTRINSIC_HEIGHT = 8;
    public static final int IMAGE_BACKGROUND_POSITION_HORIZONTAL = 9;
    public static final int IMAGE_BACKGROUND_POSITION_VERTICAL = 10;
    public static final int TABLE_UNITS = 11;
    public static final int ALIGNMENT_ADJUST = 12;
    public static final int BORDER_AREA_WIDTH = 13;
    public static final int BORDER_AREA_HEIGHT = 14;
    protected static final Log log = LogFactory.getLog(LengthBase.class);
    protected FObj fobj;
    private int baseType;
    private Length baseLength;

    public LengthBase(PropertyList propertyList, int n2) throws PropertyException {
        this.fobj = propertyList.getFObj();
        this.baseType = n2;
        switch (n2) {
            case 1: {
                this.baseLength = propertyList.get(103).getLength();
                break;
            }
            case 2: {
                this.baseLength = propertyList.getInherited(103).getLength();
                break;
            }
        }
    }

    public int getDimension() {
        return 1;
    }

    public double getBaseValue() {
        return 1.0;
    }

    public int getBaseLength(PercentBaseContext percentBaseContext) throws PropertyException {
        int n2 = 0;
        if (percentBaseContext != null) {
            if (this.baseType == 1 || this.baseType == 2) {
                return this.baseLength.getValue(percentBaseContext);
            }
            n2 = percentBaseContext.getBaseLength(this.baseType, this.fobj);
        } else {
            log.error((Object)"getBaseLength called without context");
        }
        return n2;
    }

    public String toString() {
        return super.toString() + "[fo=" + this.fobj + ",baseType=" + this.baseType + ",baseLength=" + this.baseLength + "]";
    }

    public Length getBaseLength() {
        return this.baseLength;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + CompareUtil.getHashCode((Object)this.baseLength);
        n3 = 31 * n3 + this.baseType;
        n3 = 31 * n3 + CompareUtil.getHashCode((Object)this.fobj);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LengthBase)) {
            return false;
        }
        LengthBase lengthBase = (LengthBase)object;
        return CompareUtil.equal((Object)this.baseLength, (Object)lengthBase.baseLength) && this.baseType == lengthBase.baseType && CompareUtil.equal((Object)this.fobj, (Object)lengthBase.fobj);
    }
}

