/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.bidi;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.complexscripts.bidi.DelimitedTextRange;
import org.apache.fop.complexscripts.bidi.InlineRun;
import org.apache.fop.complexscripts.bidi.UnflattenProcessor;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.pagination.PageSequence;

public final class BidiResolver {
    private static final Log log = LogFactory.getLog(BidiResolver.class);

    private BidiResolver() {
    }

    public static void resolveInlineDirectionality(PageSequence pageSequence) {
        BidiResolver.resolveInlineDirectionality((FONode)((Object)pageSequence), new Stack());
    }

    public static void resolveInlineDirectionality(FONode fONode, Stack stack) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("BD: RESOLVE: " + fONode));
        }
        List<Object> list = fONode.collectDelimitedTextRanges(stack);
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRanges("BD: RESOLVE: RANGES:", list);
        }
        list = BidiResolver.pruneEmptyRanges(list);
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRanges("BD: RESOLVE: PRUNED RANGES:", list);
        }
        BidiResolver.resolveInlineDirectionality(list);
    }

    public static void reorder(LineArea lineArea) {
        int n2;
        List list = BidiResolver.collectRuns(lineArea.getInlineAreas(), new Vector());
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: INPUT:", list);
        }
        list = BidiResolver.splitRuns(list);
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: SPLIT INLINES:", list);
        }
        int[] nArray = BidiResolver.computeMinMaxLevel(list, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("BD: REORDER: { min = " + nArray[0] + ", max = " + nArray[1] + "}"));
        }
        int n3 = nArray[0];
        int n4 = nArray[1];
        if (n4 > 0) {
            int n5;
            int n6 = n5 = (n3 & 1) == 0 ? n3 + 1 : n3;
            for (n2 = n4; n2 >= n5; --n2) {
                list = BidiResolver.reorderRuns(list, n2);
            }
        }
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: REORDERED RUNS:", list);
        }
        n2 = 1;
        BidiResolver.reverseWords(list, n2 != 0);
        if (log.isDebugEnabled()) {
            BidiResolver.dumpRuns("BD: REORDER: REORDERED WORDS:", list);
        }
        BidiResolver.replaceInlines(lineArea, BidiResolver.replicateSplitWords(list));
    }

    private static void resolveInlineDirectionality(List list) {
        for (Object e2 : list) {
            DelimitedTextRange delimitedTextRange = (DelimitedTextRange)e2;
            delimitedTextRange.resolve();
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)delimitedTextRange);
        }
    }

    private static List collectRuns(List list, List list2) {
        for (Object e2 : list) {
            InlineArea inlineArea = (InlineArea)((Object)e2);
            list2 = inlineArea.collectInlineRuns(list2);
        }
        return list2;
    }

    private static List splitRuns(List vector) {
        Vector<InlineRun> vector2 = new Vector<InlineRun>();
        for (Object e2 : vector) {
            InlineRun inlineRun = (InlineRun)e2;
            if (inlineRun.isHomogenous()) {
                vector2.add(inlineRun);
                continue;
            }
            vector2.addAll(inlineRun.split());
        }
        if (!vector2.equals(vector)) {
            vector = vector2;
        }
        return vector;
    }

    private static int[] computeMinMaxLevel(List list, int[] nArray) {
        if (nArray == null) {
            nArray = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        }
        for (Object e2 : list) {
            InlineRun inlineRun = (InlineRun)e2;
            inlineRun.updateMinMax(nArray);
        }
        return nArray;
    }

    private static List reorderRuns(List vector, int n2) {
        assert (n2 >= 0);
        Vector<InlineRun> vector2 = new Vector<InlineRun>();
        int n3 = vector.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            InlineRun inlineRun;
            int n5;
            InlineRun inlineRun2 = (InlineRun)vector.get(i2);
            if (inlineRun2.getMinLevel() < n2) {
                vector2.add(inlineRun2);
                continue;
            }
            for (n5 = n4 = i2; n5 < n3 && (inlineRun = (InlineRun)vector.get(n5)).getMinLevel() >= n2; ++n5) {
            }
            if (n4 < n5) {
                vector2.addAll(BidiResolver.reverseRuns(vector, n4, n5));
            }
            i2 = n5 - 1;
        }
        if (!vector2.equals(vector)) {
            vector = vector2;
        }
        return vector;
    }

    private static List reverseRuns(List list, int n2, int n3) {
        int n4 = n3 - n2;
        Vector<InlineRun> vector = new Vector<InlineRun>(n4);
        if (n4 > 0) {
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5 = n4 - i2 - 1;
                InlineRun inlineRun = (InlineRun)list.get(n2 + n5);
                inlineRun.reverse();
                vector.add(inlineRun);
            }
        }
        return vector;
    }

    private static void reverseWords(List list, boolean bl) {
        for (Object e2 : list) {
            InlineRun inlineRun = (InlineRun)e2;
            inlineRun.maybeReverseWord(bl);
        }
    }

    private static List replicateSplitWords(List list) {
        return list;
    }

    private static void replaceInlines(LineArea lineArea, List list) {
        ArrayList<InlineArea> arrayList = new ArrayList<InlineArea>();
        for (Object e2 : list) {
            InlineRun inlineRun = (InlineRun)e2;
            arrayList.add(inlineRun.getInline());
        }
        lineArea.setInlineAreas(BidiResolver.unflattenInlines(arrayList));
    }

    private static List unflattenInlines(List<InlineArea> list) {
        return new UnflattenProcessor(list).unflatten();
    }

    private static void dumpRuns(String string, List list) {
        log.debug((Object)string);
        for (Object e2 : list) {
            InlineRun inlineRun = (InlineRun)e2;
            log.debug((Object)inlineRun);
        }
    }

    private static void dumpRanges(String string, List list) {
        log.debug((Object)string);
        for (Object e2 : list) {
            DelimitedTextRange delimitedTextRange = (DelimitedTextRange)e2;
            log.debug((Object)delimitedTextRange);
        }
    }

    private static List pruneEmptyRanges(List list) {
        Vector<DelimitedTextRange> vector = new Vector<DelimitedTextRange>();
        for (Object e2 : list) {
            DelimitedTextRange delimitedTextRange = (DelimitedTextRange)e2;
            if (delimitedTextRange.isEmpty()) continue;
            vector.add(delimitedTextRange);
        }
        return vector;
    }
}

