/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.util.Arrays;
import org.apache.fop.area.Area;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.util.CharUtilities;

public class TextArea
extends AbstractTextArea {
    private static final long serialVersionUID = 7315900267242540809L;
    private boolean isHyphenated;
    private Character spaceThatFollows;

    public TextArea() {
    }

    public TextArea(int n2, int n3, int n4) {
        super(n2, n3, n4);
    }

    public void removeText() {
        this.inlines.clear();
    }

    public void addWord(String string, int n2) {
        this.addWord(string, 0, null, null, null, n2);
    }

    public void addWord(String string, int n2, int n3) {
        this.addWord(string, 0, null, this.makeLevels(n3, string.length()), null, n2);
    }

    public void addWord(String string, int n2, int[] nArray, int[] nArray2, int[][] nArray3, int n3, boolean bl) {
        int n4 = TextArea.findMinLevel(nArray2, this.getBidiLevel());
        WordArea wordArea = new WordArea(n3, n4, string, nArray, nArray2, nArray3, false, bl);
        wordArea.setIPD(n2);
        wordArea.setChangeBarList(this.getChangeBarList());
        this.addChildArea((Area)wordArea);
        wordArea.setParentArea((Area)this);
        this.updateLevel(n4);
    }

    public void addWord(String string, int n2, int[] nArray, int[] nArray2, int[][] nArray3, int n3) {
        this.addWord(string, n2, nArray, nArray2, nArray3, n3, false);
    }

    public void addSpace(char c2, int n2, boolean bl, int n3, int n4) {
        SpaceArea spaceArea = new SpaceArea(n3, n4, c2, bl);
        spaceArea.setIPD(n2);
        spaceArea.setChangeBarList(this.getChangeBarList());
        this.addChildArea((Area)spaceArea);
        spaceArea.setParentArea((Area)this);
        this.updateLevel(n4);
    }

    public void setHyphenated() {
        this.isHyphenated = true;
    }

    public boolean isHyphenated() {
        return this.isHyphenated;
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (InlineArea inlineArea : this.inlines) {
            if (inlineArea instanceof WordArea) {
                stringBuilder.append(((WordArea)inlineArea).getWord());
                continue;
            }
            assert (inlineArea instanceof SpaceArea);
            stringBuilder.append(((SpaceArea)inlineArea).getSpace());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" {text=\"");
        stringBuffer.append(CharUtilities.toNCRefs((String)this.getText()));
        stringBuffer.append("\"");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void updateLevel(int n2) {
        if (n2 >= 0) {
            int n3 = this.getBidiLevel();
            if (n3 >= 0) {
                if (n2 < n3) {
                    this.setBidiLevel(n2);
                }
            } else {
                this.setBidiLevel(n2);
            }
        }
    }

    private static int findMinLevel(int[] nArray, int n2) {
        if (nArray != null) {
            int n3 = Integer.MAX_VALUE;
            for (int n4 : nArray) {
                if (n4 < 0 || n4 >= n3) continue;
                n3 = n4;
            }
            if (n3 == Integer.MAX_VALUE) {
                return -1;
            }
            return n3;
        }
        return n2;
    }

    private int[] makeLevels(int n2, int n3) {
        if (n2 >= 0) {
            int[] nArray = new int[n3];
            Arrays.fill(nArray, n2);
            return nArray;
        }
        return null;
    }

    public int getEffectiveIPD() {
        return this.getIPD();
    }

    public void setSpaceThatFollows(Character c2) {
        this.spaceThatFollows = c2;
    }

    public Character getSpaceThatFollows() {
        return this.spaceThatFollows;
    }
}

