/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FormattingResults;
import org.apache.fop.area.AreaEventProducer;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.CachedRenderPagesModel;
import org.apache.fop.area.DestinationData;
import org.apache.fop.area.IDTracker;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RenderPagesModel;
import org.apache.fop.area.Resolvable;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fo.extensions.ExternalDocument;
import org.apache.fop.fo.extensions.destination.Destination;
import org.apache.fop.fo.pagination.AbstractPageSequence;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.bookmarks.BookmarkTree;
import org.apache.fop.layoutmgr.ExternalDocumentLayoutManager;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.layoutmgr.LayoutManagerMapping;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.TopLevelLayoutManager;
import org.xml.sax.SAXException;

public class AreaTreeHandler
extends FOEventHandler {
    private static Log log = LogFactory.getLog(AreaTreeHandler.class);
    private Statistics statistics;
    private LayoutManagerMaker lmMaker;
    protected AreaTreeModel model;
    private boolean useComplexScriptFeatures = true;
    private IDTracker idTracker;
    private Root rootFObj;
    private FormattingResults results = new FormattingResults();
    private TopLevelLayoutManager prevPageSeqLM;
    private int idGen;
    public static final ThreadLocal<AreaTreeHandler> AREA_TREE_HANDLER_INSTANCE = new ThreadLocal();

    public AreaTreeHandler(FOUserAgent fOUserAgent, String string, OutputStream outputStream) throws FOPException {
        super(fOUserAgent);
        AREA_TREE_HANDLER_INSTANCE.set(this);
        this.setupModel(fOUserAgent, string, outputStream);
        this.lmMaker = fOUserAgent.getLayoutManagerMakerOverride();
        if (this.lmMaker == null) {
            this.lmMaker = new LayoutManagerMapping(fOUserAgent);
        }
        this.idTracker = new IDTracker();
        this.useComplexScriptFeatures = fOUserAgent.isComplexScriptFeaturesEnabled();
        if (log.isDebugEnabled()) {
            this.statistics = new Statistics();
        }
    }

    protected void setupModel(FOUserAgent fOUserAgent, String string, OutputStream outputStream) throws FOPException {
        this.model = fOUserAgent.isConserveMemoryPolicyEnabled() ? new CachedRenderPagesModel(fOUserAgent, string, this.fontInfo, outputStream) : new RenderPagesModel(fOUserAgent, string, this.fontInfo, outputStream);
    }

    public AreaTreeModel getAreaTreeModel() {
        return this.model;
    }

    public LayoutManagerMaker getLayoutManagerMaker() {
        return this.lmMaker;
    }

    public IDTracker getIDTracker() {
        return this.idTracker;
    }

    public FormattingResults getResults() {
        return this.results;
    }

    public boolean isComplexScriptFeaturesEnabled() {
        return this.useComplexScriptFeatures;
    }

    public void startDocument() throws SAXException {
        if (this.statistics != null) {
            this.statistics.start();
        }
    }

    public void startRoot(Root root) {
        Locale locale = root.getLocale();
        if (locale != null) {
            this.model.setDocumentLocale(locale);
        }
    }

    private void finishPrevPageSequence(Numeric numeric) {
        if (this.prevPageSeqLM != null) {
            this.prevPageSeqLM.doForcePageCount(numeric);
            this.prevPageSeqLM.finishPageSequence();
            this.prevPageSeqLM = null;
        }
    }

    public void startPageSequence(PageSequence pageSequence) {
        this.startAbstractPageSequence(pageSequence);
    }

    private void startAbstractPageSequence(AbstractPageSequence abstractPageSequence) {
        this.rootFObj = abstractPageSequence.getRoot();
        if (this.prevPageSeqLM == null) {
            this.wrapAndAddExtensionAttachments(this.rootFObj.getExtensionAttachments());
            if (this.rootFObj.getDeclarations() != null) {
                this.wrapAndAddExtensionAttachments(this.rootFObj.getDeclarations().getExtensionAttachments());
            }
        }
        this.finishPrevPageSequence(abstractPageSequence.getInitialPageNumber());
        abstractPageSequence.initPageNumber();
    }

    private void wrapAndAddExtensionAttachments(List<ExtensionAttachment> list) {
        for (ExtensionAttachment extensionAttachment : list) {
            this.addOffDocumentItem((OffDocumentItem)new OffDocumentExtensionAttachment(extensionAttachment));
        }
    }

    public void endPageSequence(PageSequence pageSequence) {
        if (this.statistics != null) {
            this.statistics.end();
        }
        if (pageSequence.getMainFlow() != null) {
            PageSequenceLayoutManager pageSequenceLayoutManager = this.getLayoutManagerMaker().makePageSequenceLayoutManager(this, pageSequence);
            pageSequenceLayoutManager.activateLayout();
            this.prevPageSeqLM = pageSequenceLayoutManager;
        }
    }

    public void startExternalDocument(ExternalDocument externalDocument) {
        this.startAbstractPageSequence((AbstractPageSequence)externalDocument);
    }

    public void endExternalDocument(ExternalDocument externalDocument) {
        if (this.statistics != null) {
            this.statistics.end();
        }
        ExternalDocumentLayoutManager externalDocumentLayoutManager = this.getLayoutManagerMaker().makeExternalDocumentLayoutManager(this, externalDocument);
        externalDocumentLayoutManager.activateLayout();
        this.prevPageSeqLM = externalDocumentLayoutManager;
    }

    public void notifyPageSequenceFinished(AbstractPageSequence abstractPageSequence, int n2) {
        this.results.haveFormattedPageSequence(abstractPageSequence, n2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Last page-sequence produced " + n2 + " pages."));
        }
    }

    public void endDocument() throws SAXException {
        this.finishPrevPageSequence(null);
        if (this.rootFObj != null) {
            BookmarkData bookmarkData;
            BookmarkTree bookmarkTree;
            List list = this.rootFObj.getDestinationList();
            if (list != null) {
                while (list.size() > 0) {
                    bookmarkTree = (Destination)list.remove(0);
                    bookmarkData = new DestinationData((Destination)bookmarkTree);
                    this.addOffDocumentItem((OffDocumentItem)bookmarkData);
                }
            }
            if ((bookmarkTree = this.rootFObj.getBookmarkTree()) != null) {
                bookmarkData = new BookmarkData(bookmarkTree);
                this.addOffDocumentItem((OffDocumentItem)bookmarkData);
                if (!bookmarkData.isResolved()) {
                    this.model.handleOffDocumentItem((OffDocumentItem)bookmarkData);
                }
            }
            this.idTracker.signalIDProcessed(this.rootFObj.getId());
        }
        this.model.endDocument();
        if (this.statistics != null) {
            this.statistics.logResults();
        }
    }

    private void addOffDocumentItem(OffDocumentItem offDocumentItem) {
        if (offDocumentItem instanceof Resolvable) {
            String[] stringArray;
            Resolvable resolvable = (Resolvable)offDocumentItem;
            for (String string : stringArray = resolvable.getIDRefs()) {
                List list = this.idTracker.getPageViewportsContainingID(string);
                if (list != null && !list.isEmpty()) {
                    resolvable.resolveIDRef(string, list);
                    continue;
                }
                AreaEventProducer areaEventProducer = AreaEventProducer.Provider.get((EventBroadcaster)this.getUserAgent().getEventBroadcaster());
                areaEventProducer.unresolvedIDReference((Object)this, offDocumentItem.getName(), string);
                this.idTracker.addUnresolvedIDRef(string, resolvable);
            }
            if (resolvable.isResolved()) {
                this.model.handleOffDocumentItem(offDocumentItem);
            }
        } else {
            this.model.handleOffDocumentItem(offDocumentItem);
        }
    }

    public String generatePageViewportKey() {
        ++this.idGen;
        return "P" + this.idGen;
    }

    @Deprecated
    public void associateIDWithPageViewport(String string, PageViewport pageViewport) {
        this.idTracker.associateIDWithPageViewport(string, pageViewport);
    }

    @Deprecated
    public void signalPendingID(String string) {
        this.idTracker.signalPendingID(string);
    }

    @Deprecated
    public void signalIDProcessed(String string) {
        this.idTracker.signalIDProcessed(string);
    }

    @Deprecated
    public boolean alreadyResolvedID(String string) {
        return this.idTracker.alreadyResolvedID(string);
    }

    @Deprecated
    public void tryIDResolution(PageViewport pageViewport) {
        this.idTracker.tryIDResolution(pageViewport);
    }

    @Deprecated
    public List<PageViewport> getPageViewportsContainingID(String string) {
        return this.idTracker.getPageViewportsContainingID(string);
    }

    @Deprecated
    public void addUnresolvedIDRef(String string, Resolvable resolvable) {
        this.idTracker.addUnresolvedIDRef(string, resolvable);
    }

    private class Statistics {
        private Runtime runtime = Runtime.getRuntime();
        private long initialMemory;
        private long startTime;

        protected Statistics() {
        }

        protected void start() {
            this.initialMemory = this.runtime.totalMemory() - this.runtime.freeMemory();
            this.startTime = System.currentTimeMillis();
        }

        protected void end() {
            long l2 = this.runtime.totalMemory() - this.runtime.freeMemory();
            log.debug((Object)("Current heap size: " + l2 / 1024L + "KB"));
        }

        protected void logResults() {
            long l2 = this.runtime.totalMemory() - this.runtime.freeMemory();
            long l3 = (l2 - this.initialMemory) / 1024L;
            long l4 = System.currentTimeMillis() - this.startTime;
            int n2 = AreaTreeHandler.this.rootFObj.getTotalPagesGenerated();
            log.debug((Object)("Initial heap size: " + this.initialMemory / 1024L + "KB"));
            log.debug((Object)("Current heap size: " + l2 / 1024L + "KB"));
            log.debug((Object)("Total memory used: " + l3 + "KB"));
            log.debug((Object)("Total time used: " + l4 + "ms"));
            log.debug((Object)("Pages rendered: " + n2));
            if (n2 > 0) {
                long l5 = l4 / (long)n2;
                long l6 = l4 != 0L ? Math.round((double)(60000 * n2) / (double)l4) : -1L;
                log.debug((Object)("Avg render time: " + l5 + "ms/page (" + l6 + "pages/min)"));
            }
        }
    }
}

