/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.accessibility.fo;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.accessibility.fo.Event;
import org.apache.fop.accessibility.fo.StructureTreeEventTrigger;
import org.apache.fop.fo.DelegatingFOEventHandler;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.extensions.ExternalDocument;
import org.apache.fop.fo.flow.AbstractRetrieveMarker;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemBody;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.PageNumberCitation;
import org.apache.fop.fo.flow.PageNumberCitationLast;
import org.apache.fop.fo.flow.RetrieveMarker;
import org.apache.fop.fo.flow.RetrieveTableMarker;
import org.apache.fop.fo.flow.Wrapper;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableBody;
import org.apache.fop.fo.flow.table.TableCell;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.flow.table.TableFooter;
import org.apache.fop.fo.flow.table.TableHeader;
import org.apache.fop.fo.flow.table.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.fo.pagination.StaticContent;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAccessibilityHolder;
import org.xml.sax.SAXException;

public class FO2StructureTreeConverter
extends DelegatingFOEventHandler {
    protected FOEventHandler converter;
    private Stack<FOEventHandler> converters = new Stack();
    private final StructureTreeEventTrigger structureTreeEventTrigger;
    private final FOEventHandler eventSwallower = new FOEventHandler(){};
    private final Map<AbstractRetrieveMarker, State> states = new HashMap<AbstractRetrieveMarker, State>();
    private Event root;
    private Event currentNode = this.root = new Event((Event)null);

    private void startContent(Event event, boolean bl) {
        if (this.getUserAgent().isKeepEmptyTags()) {
            event.run();
        } else {
            Event event2 = new Event(this.currentNode);
            event.hasContent = bl;
            event2.add(event);
            this.currentNode.add(event2);
            this.currentNode = event2;
        }
    }

    private void content(Event event, boolean bl) {
        if (this.getUserAgent().isKeepEmptyTags()) {
            event.run();
        } else {
            this.currentNode.add(event);
            event.hasContent = bl;
        }
    }

    private void endContent(Event event) {
        if (this.getUserAgent().isKeepEmptyTags()) {
            event.run();
        } else {
            this.currentNode.add(event);
            this.currentNode = this.currentNode.parent;
            if (this.currentNode == this.root) {
                this.root.run();
            }
        }
    }

    public FO2StructureTreeConverter(StructureTreeEventHandler structureTreeEventHandler, FOEventHandler fOEventHandler) {
        super(fOEventHandler);
        this.structureTreeEventTrigger = new StructureTreeEventTrigger(structureTreeEventHandler);
        this.converter = this.structureTreeEventTrigger;
    }

    public void startDocument() throws SAXException {
        this.converter.startDocument();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.converter.endDocument();
        super.endDocument();
    }

    public void startRoot(Root root) {
        this.converter.startRoot(root);
        super.startRoot(root);
    }

    public void endRoot(Root root) {
        this.converter.endRoot(root);
        super.endRoot(root);
    }

    public void startPageSequence(PageSequence pageSequence) {
        this.converter.startPageSequence(pageSequence);
        super.startPageSequence(pageSequence);
    }

    public void endPageSequence(PageSequence pageSequence) {
        this.converter.endPageSequence(pageSequence);
        super.endPageSequence(pageSequence);
        if (this.converter == this.eventSwallower) {
            this.converter = this.structureTreeEventTrigger;
            this.converters.clear();
        }
    }

    public void startPageNumber(final PageNumber pageNumber) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startPageNumber(pageNumber);
            }
        }, true);
        super.startPageNumber(pageNumber);
    }

    public void endPageNumber(final PageNumber pageNumber) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endPageNumber(pageNumber);
            }
        });
        super.endPageNumber(pageNumber);
    }

    public void startPageNumberCitation(final PageNumberCitation pageNumberCitation) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startPageNumberCitation(pageNumberCitation);
            }
        }, true);
        super.startPageNumberCitation(pageNumberCitation);
    }

    public void endPageNumberCitation(final PageNumberCitation pageNumberCitation) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endPageNumberCitation(pageNumberCitation);
            }
        });
        super.endPageNumberCitation(pageNumberCitation);
    }

    public void startPageNumberCitationLast(final PageNumberCitationLast pageNumberCitationLast) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startPageNumberCitationLast(pageNumberCitationLast);
            }
        }, true);
        super.startPageNumberCitationLast(pageNumberCitationLast);
    }

    public void endPageNumberCitationLast(final PageNumberCitationLast pageNumberCitationLast) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endPageNumberCitationLast(pageNumberCitationLast);
            }
        });
        super.endPageNumberCitationLast(pageNumberCitationLast);
    }

    public void startStatic(final StaticContent staticContent) {
        this.handleStartArtifact((CommonAccessibilityHolder)staticContent);
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startStatic(staticContent);
            }
        }, true);
        super.startStatic(staticContent);
    }

    public void endStatic(final StaticContent staticContent) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endStatic(staticContent);
            }
        });
        this.handleEndArtifact((CommonAccessibilityHolder)staticContent);
        super.endStatic(staticContent);
    }

    public void startFlow(Flow flow) {
        this.converter.startFlow(flow);
        super.startFlow(flow);
    }

    public void endFlow(Flow flow) {
        this.converter.endFlow(flow);
        super.endFlow(flow);
    }

    public void startBlock(final Block block) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startBlock(block);
            }
        }, false);
        super.startBlock(block);
    }

    public void endBlock(final Block block) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endBlock(block);
            }
        });
        super.endBlock(block);
    }

    public void startBlockContainer(final BlockContainer blockContainer) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startBlockContainer(blockContainer);
            }
        }, false);
        super.startBlockContainer(blockContainer);
    }

    public void endBlockContainer(final BlockContainer blockContainer) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endBlockContainer(blockContainer);
            }
        });
        super.endBlockContainer(blockContainer);
    }

    public void startInline(final Inline inline) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startInline(inline);
            }
        }, true);
        super.startInline(inline);
    }

    public void endInline(final Inline inline) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endInline(inline);
            }
        });
        super.endInline(inline);
    }

    public void startTable(final Table table) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startTable(table);
            }
        }, true);
        super.startTable(table);
    }

    public void endTable(final Table table) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endTable(table);
            }
        });
        super.endTable(table);
    }

    public void startColumn(final TableColumn tableColumn) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startColumn(tableColumn);
            }
        }, true);
        super.startColumn(tableColumn);
    }

    public void endColumn(final TableColumn tableColumn) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endColumn(tableColumn);
            }
        });
        super.endColumn(tableColumn);
    }

    public void startHeader(final TableHeader tableHeader) {
        this.handleStartArtifact((CommonAccessibilityHolder)tableHeader);
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startHeader(tableHeader);
            }
        }, false);
        super.startHeader(tableHeader);
    }

    public void endHeader(final TableHeader tableHeader) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endHeader(tableHeader);
            }
        });
        this.handleEndArtifact((CommonAccessibilityHolder)tableHeader);
        super.endHeader(tableHeader);
    }

    public void startFooter(final TableFooter tableFooter) {
        this.handleStartArtifact((CommonAccessibilityHolder)tableFooter);
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startFooter(tableFooter);
            }
        }, false);
        super.startFooter(tableFooter);
    }

    public void endFooter(final TableFooter tableFooter) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endFooter(tableFooter);
            }
        });
        this.handleEndArtifact((CommonAccessibilityHolder)tableFooter);
        super.endFooter(tableFooter);
    }

    public void startBody(final TableBody tableBody) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startBody(tableBody);
            }
        }, true);
        super.startBody(tableBody);
    }

    public void endBody(final TableBody tableBody) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endBody(tableBody);
            }
        });
        super.endBody(tableBody);
    }

    public void startRow(final TableRow tableRow) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startRow(tableRow);
            }
        }, false);
        super.startRow(tableRow);
    }

    public void endRow(final TableRow tableRow) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endRow(tableRow);
            }
        });
        super.endRow(tableRow);
    }

    public void startCell(final TableCell tableCell) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startCell(tableCell);
            }
        }, false);
        super.startCell(tableCell);
    }

    public void endCell(final TableCell tableCell) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endCell(tableCell);
            }
        });
        super.endCell(tableCell);
    }

    public void startList(final ListBlock listBlock) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startList(listBlock);
            }
        }, true);
        super.startList(listBlock);
    }

    public void endList(final ListBlock listBlock) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endList(listBlock);
            }
        });
        super.endList(listBlock);
    }

    public void startListItem(final ListItem listItem) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startListItem(listItem);
            }
        }, true);
        super.startListItem(listItem);
    }

    public void endListItem(final ListItem listItem) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endListItem(listItem);
            }
        });
        super.endListItem(listItem);
    }

    public void startListLabel(final ListItemLabel listItemLabel) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startListLabel(listItemLabel);
            }
        }, true);
        super.startListLabel(listItemLabel);
    }

    public void endListLabel(final ListItemLabel listItemLabel) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endListLabel(listItemLabel);
            }
        });
        super.endListLabel(listItemLabel);
    }

    public void startListBody(final ListItemBody listItemBody) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startListBody(listItemBody);
            }
        }, true);
        super.startListBody(listItemBody);
    }

    public void endListBody(final ListItemBody listItemBody) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endListBody(listItemBody);
            }
        });
        super.endListBody(listItemBody);
    }

    public void startMarkup() {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startMarkup();
            }
        }, true);
        super.startMarkup();
    }

    public void endMarkup() {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endMarkup();
            }
        });
        super.endMarkup();
    }

    public void startLink(final BasicLink basicLink) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startLink(basicLink);
            }
        }, true);
        super.startLink(basicLink);
    }

    public void endLink(final BasicLink basicLink) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endLink(basicLink);
            }
        });
        super.endLink(basicLink);
    }

    public void image(final ExternalGraphic externalGraphic) {
        this.content(new Event(this){

            public void run() {
                this.eventHandler.image(externalGraphic);
            }
        }, true);
        super.image(externalGraphic);
    }

    public void pageRef() {
        this.content(new Event(this){

            public void run() {
                this.eventHandler.pageRef();
            }
        }, true);
        super.pageRef();
    }

    public void startInstreamForeignObject(final InstreamForeignObject instreamForeignObject) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startInstreamForeignObject(instreamForeignObject);
            }
        }, true);
        super.startInstreamForeignObject(instreamForeignObject);
    }

    public void endInstreamForeignObject(final InstreamForeignObject instreamForeignObject) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endInstreamForeignObject(instreamForeignObject);
            }
        });
        super.endInstreamForeignObject(instreamForeignObject);
    }

    public void startFootnote(final Footnote footnote) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startFootnote(footnote);
            }
        }, true);
        super.startFootnote(footnote);
    }

    public void endFootnote(final Footnote footnote) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endFootnote(footnote);
            }
        });
        super.endFootnote(footnote);
    }

    public void startFootnoteBody(final FootnoteBody footnoteBody) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startFootnoteBody(footnoteBody);
            }
        }, true);
        super.startFootnoteBody(footnoteBody);
    }

    public void endFootnoteBody(final FootnoteBody footnoteBody) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endFootnoteBody(footnoteBody);
            }
        });
        super.endFootnoteBody(footnoteBody);
    }

    public void startLeader(final Leader leader) {
        this.converters.push(this.converter);
        this.converter = this.eventSwallower;
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startLeader(leader);
            }
        }, false);
        super.startLeader(leader);
    }

    public void endLeader(final Leader leader) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endLeader(leader);
            }
        });
        this.converter = this.converters.pop();
        super.endLeader(leader);
    }

    public void startWrapper(final Wrapper wrapper) {
        this.handleStartArtifact((CommonAccessibilityHolder)wrapper);
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startWrapper(wrapper);
            }
        }, true);
        super.startWrapper(wrapper);
    }

    public void endWrapper(final Wrapper wrapper) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endWrapper(wrapper);
            }
        });
        this.handleEndArtifact((CommonAccessibilityHolder)wrapper);
        super.endWrapper(wrapper);
    }

    public void startRetrieveMarker(final RetrieveMarker retrieveMarker) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startRetrieveMarker(retrieveMarker);
            }
        }, true);
        this.saveState((AbstractRetrieveMarker)retrieveMarker);
        super.startRetrieveMarker(retrieveMarker);
    }

    private void saveState(AbstractRetrieveMarker abstractRetrieveMarker) {
        this.states.put(abstractRetrieveMarker, new State(this));
    }

    public void endRetrieveMarker(final RetrieveMarker retrieveMarker) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endRetrieveMarker(retrieveMarker);
            }
        });
        super.endRetrieveMarker(retrieveMarker);
    }

    public void restoreState(final RetrieveMarker retrieveMarker) {
        this.restoreRetrieveMarkerState((AbstractRetrieveMarker)retrieveMarker);
        this.content(new Event(this){

            public void run() {
                this.eventHandler.restoreState(retrieveMarker);
            }
        }, true);
        super.restoreState(retrieveMarker);
    }

    private void restoreRetrieveMarkerState(AbstractRetrieveMarker abstractRetrieveMarker) {
        State state = this.states.get((Object)abstractRetrieveMarker);
        this.converter = state.converter;
        this.converters = (Stack)state.converters.clone();
    }

    public void startRetrieveTableMarker(final RetrieveTableMarker retrieveTableMarker) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startRetrieveTableMarker(retrieveTableMarker);
            }
        }, true);
        this.saveState((AbstractRetrieveMarker)retrieveTableMarker);
        super.startRetrieveTableMarker(retrieveTableMarker);
    }

    public void endRetrieveTableMarker(final RetrieveTableMarker retrieveTableMarker) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endRetrieveTableMarker(retrieveTableMarker);
            }
        });
        super.endRetrieveTableMarker(retrieveTableMarker);
    }

    public void restoreState(final RetrieveTableMarker retrieveTableMarker) {
        this.restoreRetrieveMarkerState((AbstractRetrieveMarker)retrieveTableMarker);
        this.currentNode.add(new Event(this){

            public void run() {
                this.eventHandler.restoreState(retrieveTableMarker);
            }
        });
        super.restoreState(retrieveTableMarker);
    }

    public void character(final Character character) {
        this.content(new Event(this){

            public void run() {
                this.eventHandler.character(character);
            }
        }, true);
        super.character(character);
    }

    public void characters(final FOText fOText) {
        this.content(new Event(this){

            public void run() {
                this.eventHandler.characters(fOText);
            }
        }, fOText.length() > 0);
        super.characters(fOText);
    }

    public void startExternalDocument(final ExternalDocument externalDocument) {
        this.startContent(new Event(this){

            public void run() {
                this.eventHandler.startExternalDocument(externalDocument);
            }
        }, true);
        super.startExternalDocument(externalDocument);
    }

    public void endExternalDocument(final ExternalDocument externalDocument) {
        this.endContent(new Event(this){

            public void run() {
                this.eventHandler.endExternalDocument(externalDocument);
            }
        });
        super.endExternalDocument(externalDocument);
    }

    private void handleStartArtifact(CommonAccessibilityHolder commonAccessibilityHolder) {
        if (this.isArtifact(commonAccessibilityHolder)) {
            this.converters.push(this.converter);
            this.converter = this.eventSwallower;
        }
    }

    private void handleEndArtifact(CommonAccessibilityHolder commonAccessibilityHolder) {
        if (this.isArtifact(commonAccessibilityHolder)) {
            this.converter = this.converters.pop();
        }
    }

    private boolean isArtifact(CommonAccessibilityHolder commonAccessibilityHolder) {
        CommonAccessibility commonAccessibility = commonAccessibilityHolder.getCommonAccessibility();
        return "artifact".equalsIgnoreCase(commonAccessibility.getRole());
    }

    private static final class State {
        private final FOEventHandler converter;
        private final Stack<FOEventHandler> converters;

        State(FO2StructureTreeConverter fO2StructureTreeConverter) {
            this.converter = fO2StructureTreeConverter.converter;
            this.converters = (Stack)fO2StructureTreeConverter.converters.clone();
        }
    }
}

