/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.chemistry.util;

import com.oxygenxml.chemistry.util.PDFTextAndColorStripper;
import com.oxygenxml.chemistry.util.PDFTextAndFontStripper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.MessageFormat;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType3;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkedContentReference;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPattern;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationText;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineNode;
import org.apache.pdfbox.text.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import ro.sync.basic.io.IOUtil;

public class PDFUtil {
    private static final int b = 65535;
    private static final Logger c = LoggerFactory.getLogger(PDFUtil.class);

    public static String getTextFromPDF(File file) throws IOException {
        PDDocument pDDocument = PDDocument.load((File)file);
        try {
            String string = PDFUtil.getTextFromPDF(pDDocument);
            return string;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    public static String getTextFromPDF(PDDocument pDDocument) throws IOException {
        PDFTextStripper pDFTextStripper = new PDFTextStripper();
        return PDFUtil.b(pDDocument, pDFTextStripper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTextAndFontsFromPDF(File file) throws IOException {
        PDDocument pDDocument = PDDocument.load((File)file);
        try {
            PDFTextAndFontStripper pDFTextAndFontStripper = new PDFTextAndFontStripper();
            String string = PDFUtil.b(pDDocument, pDFTextAndFontStripper);
            return string;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTextAndColorsFromPDF(File file) throws IOException {
        PDDocument pDDocument = PDDocument.load((File)file);
        try {
            PDFTextAndColorStripper pDFTextAndColorStripper = new PDFTextAndColorStripper();
            String string = PDFUtil.b(pDDocument, pDFTextAndColorStripper);
            return string;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    private static String b(PDDocument pDDocument, PDFTextStripper pDFTextStripper) throws IOException {
        pDFTextStripper.setStartPage(1);
        pDFTextStripper.setEndPage(pDDocument.getNumberOfPages());
        String string = pDFTextStripper.getText(pDDocument);
        return PDFUtil.c(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getNamedDestinationsFromPDF(File file) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        PDDocument pDDocument = PDDocument.load((File)file);
        try {
            Object object;
            PDDocumentCatalog pDDocumentCatalog = pDDocument.getDocumentCatalog();
            PDDocumentNameDictionary pDDocumentNameDictionary = pDDocumentCatalog.getNames();
            if (pDDocumentNameDictionary != null) {
                Object object2;
                object = pDDocumentNameDictionary.getDests();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (object.getNames() != null) {
                    object2 = object.getNames().keySet();
                    arrayList.addAll((Collection<Object>)object2);
                } else {
                    object2 = object.getKids();
                    Object object3 = object2.iterator();
                    while (object3.hasNext()) {
                        PDNameTreeNode pDNameTreeNode = (PDNameTreeNode)object3.next();
                        Map map = pDNameTreeNode.getNames();
                        for (Object k2 : map.keySet()) {
                            arrayList.add(String.valueOf(k2));
                        }
                    }
                }
                Collections.sort(arrayList);
                for (Object object3 : arrayList) {
                    stringBuilder.append(((String)object3).trim());
                    stringBuilder.append("\n");
                }
            }
            object = PDFUtil.c(stringBuilder.toString());
            return object;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getFontsFromPDF(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        PDDocument pDDocument = PDDocument.load((File)file);
        try {
            for (int i2 = 0; i2 < pDDocument.getNumberOfPages(); ++i2) {
                PDPage pDPage = pDDocument.getPage(i2);
                Iterable iterable = pDPage.getResources().getFontNames();
                for (COSName cOSName : iterable) {
                    PDFont pDFont = pDPage.getResources().getFont(cOSName);
                    String string = pDFont.getName().substring(pDFont.getName().indexOf(43) + 1);
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamFromPDF(File file) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        PDDocument pDDocument = PDDocument.load((File)file);
        for (int i2 = 0; i2 < pDDocument.getNumberOfPages(); ++i2) {
            PDPage pDPage = pDDocument.getPage(i2);
            InputStream inputStream = pDPage.getContents();
            stringBuilder.append((CharSequence)IOUtil.read((Reader)new InputStreamReader(inputStream, "UTF-8")));
        }
        try {
            String string = PDFUtil.c(stringBuilder.toString());
            return string;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    public static String getAnnotationsFromPDF(File file) throws IOException {
        return PDFUtil.getAnnotationsFromPDF(file, null, null, true);
    }

    public static String getAnnotationsFromPDF(File file, String string) throws IOException {
        return PDFUtil.getAnnotationsFromPDF(file, null, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAnnotationsFromPDF(File file, String string, String string2, boolean bl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        PDDocument pDDocument = PDDocument.load((File)file, (String)string2);
        try {
            for (int i2 = 0; i2 < pDDocument.getNumberOfPages(); ++i2) {
                PDPage pDPage = pDDocument.getPage(i2);
                List list = pDPage.getAnnotations();
                boolean bl2 = false;
                if (list.isEmpty()) continue;
                for (PDAnnotation pDAnnotation : list) {
                    if (string != null && string.equals(pDAnnotation.getSubtype())) continue;
                    if (!bl2) {
                        stringBuilder.append("---------- Page " + (i2 + 1) + " ------------\n");
                        bl2 = true;
                    }
                    PDFUtil.b(stringBuilder, pDAnnotation, bl);
                }
            }
            String string3 = PDFUtil.c(stringBuilder.toString());
            return string3;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    private static String c(String string) {
        return string.replace("\r", "").replace("\u00ad", "-");
    }

    private static void b(StringBuilder stringBuilder, PDAnnotation pDAnnotation, boolean bl) throws IOException {
        PDAnnotationLink pDAnnotationLink;
        stringBuilder.append(" Annotation\n");
        stringBuilder.append("    Subtype:" + pDAnnotation.getSubtype() + "\n");
        stringBuilder.append("    Contents:" + PDFUtil.b(pDAnnotation) + "\n");
        if (bl) {
            stringBuilder.append("    Rectangle:" + pDAnnotation.getRectangle() + "\n");
        }
        stringBuilder.append("    Date:" + PDFUtil.c(pDAnnotation) + "\n");
        if (pDAnnotation instanceof PDAnnotationMarkup) {
            stringBuilder.append("    Author:" + ((PDAnnotationMarkup)pDAnnotation).getTitlePopup() + "\n");
            pDAnnotationLink = ((PDAnnotationMarkup)pDAnnotation).getInReplyTo();
            if (pDAnnotationLink != null) {
                stringBuilder.append("    In reply to:" + PDFUtil.b((PDAnnotation)pDAnnotationLink) + "\n");
            }
        }
        if (pDAnnotation instanceof PDAnnotationText) {
            if (((PDAnnotationText)pDAnnotation).getState() != null) {
                stringBuilder.append("    State:" + ((PDAnnotationText)pDAnnotation).getState() + "\n");
            }
            if (((PDAnnotationText)pDAnnotation).getStateModel() != null) {
                stringBuilder.append("    StateModel:" + ((PDAnnotationText)pDAnnotation).getStateModel() + "\n");
            }
        }
        if (pDAnnotation instanceof PDAnnotationLink) {
            pDAnnotationLink = (PDAnnotationLink)pDAnnotation;
            PDAction pDAction = pDAnnotationLink.getAction();
            if (pDAnnotationLink.getQuadPoints() != null) {
                stringBuilder.append("    QuadPoints:" + Arrays.toString(pDAnnotationLink.getQuadPoints()) + "\n");
            }
            PDFUtil.b(stringBuilder, pDAction);
        }
        if (pDAnnotation instanceof PDAnnotationWidget) {
            stringBuilder.append("    Flags:" + ((PDAnnotationWidget)pDAnnotation).getAnnotationFlags() + "\n");
            stringBuilder.append("    Title:" + ((PDAnnotationWidget)pDAnnotation).getCOSObject().getString(COSName.T) + "\n");
        }
    }

    private static void b(StringBuilder stringBuilder, PDAction pDAction) throws IOException {
        if (pDAction != null) {
            stringBuilder.append("    Action:" + pDAction.getSubType() + "\n");
            if (pDAction instanceof PDActionGoTo) {
                PDDestination pDDestination = ((PDActionGoTo)pDAction).getDestination();
                stringBuilder.append("        GoTo:" + pDDestination.getClass() + "\n");
                if (pDDestination instanceof PDPageXYZDestination) {
                    PDPageXYZDestination pDPageXYZDestination = (PDPageXYZDestination)pDDestination;
                    int n2 = pDPageXYZDestination.getLeft();
                    int n3 = pDPageXYZDestination.getTop();
                    int n4 = pDPageXYZDestination.getPageNumber();
                    String string = n4 == -1 ? "(internal to doc)" : Integer.toString(n4);
                    stringBuilder.append("            Page:" + string + " Top:" + n3 + " Left: " + n2 + "\n");
                }
            } else if (pDAction instanceof PDActionURI) {
                PDActionURI pDActionURI = (PDActionURI)pDAction;
                stringBuilder.append("        GoTo:" + pDActionURI.getURI() + "\n");
            }
        }
    }

    private static String b(PDAnnotation pDAnnotation) {
        String string = null;
        if (pDAnnotation.getContents() != null) {
            string = pDAnnotation.getContents();
        } else if (pDAnnotation instanceof PDAnnotationText && ((PDAnnotationText)pDAnnotation).getRichContents() != null) {
            string = ((PDAnnotationText)pDAnnotation).getRichContents();
        }
        return string;
    }

    private static String c(PDAnnotation pDAnnotation) {
        String string = pDAnnotation.getModifiedDate();
        if (string != null) {
            String string2 = string.replace("D:", "").replace("'", "");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssx");
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(string2, dateTimeFormatter);
            return zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toString();
        }
        return string;
    }

    public static void killAcrobatReader() {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            try {
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("taskkill /F /IM AcroRd32.exe");
                runtime.exec("taskkill /F /IM Acrobat.exe");
            }
            catch (IOException iOException) {
                c.error(iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    public static void openPDFInSystemApp(File file) throws IOException {
        if (file != null && file.exists() && file.getName().endsWith(".pdf")) {
            String string = System.getProperty("os.name", "").toLowerCase();
            if (string.contains("win")) {
                ProcessBuilder processBuilder = new ProcessBuilder("rundll32", "SHELL32.DLL,ShellExec_RunDLL", file.getAbsolutePath());
                processBuilder.start();
            } else if (string.contains("mac")) {
                ProcessBuilder processBuilder = new ProcessBuilder("/usr/bin/open", file.getAbsolutePath());
                processBuilder.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBookmarksFromPDF(File file) throws IOException {
        PDDocument pDDocument = PDDocument.load((File)file);
        try {
            PDDocumentOutline pDDocumentOutline = pDDocument.getDocumentCatalog().getDocumentOutline();
            StringBuilder stringBuilder = new StringBuilder();
            PDFUtil.b((PDOutlineNode)pDDocumentOutline, "", stringBuilder);
            String string = PDFUtil.c(stringBuilder.toString());
            return string;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    private static void b(PDOutlineNode pDOutlineNode, String string, StringBuilder stringBuilder) throws IOException {
        String string2 = string + "  ";
        for (PDOutlineItem pDOutlineItem = pDOutlineNode.getFirstChild(); pDOutlineItem != null; pDOutlineItem = pDOutlineItem.getNextSibling()) {
            stringBuilder.append(string + pDOutlineItem.getTitle());
            stringBuilder.append('\n');
            PDFUtil.b((PDOutlineNode)pDOutlineItem, string2, stringBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDocumentInformation(File file) throws IOException {
        PDDocument pDDocument = PDDocument.load((File)file);
        try {
            PDDocumentInformation pDDocumentInformation = pDDocument.getDocumentInformation();
            StringBuilder stringBuilder = new StringBuilder();
            Set set = pDDocumentInformation.getMetadataKeys();
            ArrayList arrayList = new ArrayList(set);
            Collections.sort(arrayList);
            for (String string : arrayList) {
                if (PDFUtil.d(string)) {
                    stringBuilder.append(string + " = <<" + string + ">>\n");
                    continue;
                }
                stringBuilder.append(string + " = " + pDDocumentInformation.getCustomMetadataValue(string) + "\n");
            }
            String string = PDFUtil.c(stringBuilder.toString());
            return string;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDocumentCopyright(File file) throws IOException {
        PDDocument pDDocument = PDDocument.load((File)file);
        try {
            Object object;
            PDDocumentCatalog pDDocumentCatalog = pDDocument.getDocumentCatalog();
            PDMetadata pDMetadata = pDDocumentCatalog.getMetadata();
            String string = "";
            try {
                object = pDMetadata.createInputStream();
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                    Document document = documentBuilderFactory.newDocumentBuilder().parse((InputStream)object);
                    XPathFactory xPathFactory = XPathFactory.newInstance();
                    XPathExpression xPathExpression = xPathFactory.newXPath().compile("//*[local-name()='rights']/*[local-name()='Alt']/*[local-name()='li']");
                    string = xPathExpression.evaluate(document);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            catch (ParserConfigurationException | XPathExpressionException | SAXException exception) {
                c.error(exception.getMessage(), (Throwable)exception);
            }
            object = string;
            return object;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    private static boolean d(String string) {
        return "CreationDate".equals(string) || "Creator".equals(string) || "Producer".equals(string);
    }

    public static String getEmbeddedFontsUnicodeMap(PDDocument pDDocument, boolean bl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        PDPageTree pDPageTree = pDDocument.getDocumentCatalog().getPages();
        for (int i2 = 0; i2 < pDPageTree.getCount(); ++i2) {
            PDPage pDPage = pDPageTree.get(i2);
            stringBuilder.append("Fonts for page: " + i2 + "\n");
            PDFUtil.b(stringBuilder, pDPage, bl);
        }
        return stringBuilder.toString();
    }

    private static void b(StringBuilder stringBuilder, PDPage pDPage, boolean bl) throws IOException {
        Iterable iterable = pDPage.getResources().getFontNames();
        ArrayList<COSName> arrayList = new ArrayList<COSName>();
        for (COSName cOSName : iterable) {
            arrayList.add(cOSName);
        }
        Collections.sort(arrayList, new _b(pDPage, bl));
        for (COSName cOSName : arrayList) {
            PDFont pDFont = pDPage.getResources().getFont(cOSName);
            if (!bl) {
                stringBuilder.append(cOSName.getName());
                stringBuilder.append(" ");
            }
            if (!pDFont.isEmbedded()) continue;
            stringBuilder.append(pDFont.getFontDescriptor().getFontFamily());
            stringBuilder.append(" - ");
            stringBuilder.append(PDFUtil.b(pDFont.getFontDescriptor().getFontName()));
            stringBuilder.append(" - ");
            stringBuilder.append(pDFont.getType());
            stringBuilder.append(" - ");
            stringBuilder.append(pDFont.getSubType());
            stringBuilder.append(" (embedded)\n");
            stringBuilder.append("\n");
            PDFUtil.b(stringBuilder, pDFont);
        }
    }

    private static String b(String string) {
        int n2 = string.indexOf(43);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        return string;
    }

    private static void b(StringBuilder stringBuilder, PDFont pDFont) throws IOException {
        for (int i2 = 0; i2 <= 65535; ++i2) {
            String string;
            if (!pDFont.hasExplicitWidth(i2) || (string = pDFont.toUnicode(i2)) == null) continue;
            stringBuilder.append("\t " + i2 + " glyph[");
            stringBuilder.append(Integer.toHexString(i2));
            stringBuilder.append("]=");
            stringBuilder.append(" - ");
            PDFUtil.b(stringBuilder, string);
            stringBuilder.append("\n");
        }
    }

    private static void b(StringBuilder stringBuilder, String string) {
        boolean bl = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2 = string.codePointAt(i2);
            stringBuilder.append(Integer.toHexString(n2));
            stringBuilder.append(' ');
            stringBuilder.append('\'');
            if (string.charAt(i2) > '\uffff') {
                stringBuilder.append(string.charAt(i2));
                bl = true;
            } else if (bl) {
                stringBuilder.append(string.charAt(i2));
                bl = false;
            } else if (string.charAt(i2) == '\uffff') {
                stringBuilder.append("\\FFFF");
            } else {
                stringBuilder.append(string.charAt(i2));
            }
            stringBuilder.append('\'');
            if (i2 >= string.length() - 1) continue;
            stringBuilder.append(", ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFontsUnicodeMap(File file, boolean bl) throws IOException {
        PDDocument pDDocument = PDDocument.load((File)file);
        try {
            String string;
            String string2 = string = PDFUtil.getEmbeddedFontsUnicodeMap(pDDocument, bl);
            return string2;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStructureTreeFromPDF(File file, String string) throws IOException {
        PDDocument pDDocument = PDDocument.load((File)file, (String)string);
        try {
            PDDocumentCatalog pDDocumentCatalog = pDDocument.getDocumentCatalog();
            PDStructureTreeRoot pDStructureTreeRoot = pDDocumentCatalog.getStructureTreeRoot();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(pDStructureTreeRoot.getCOSObject().getCOSName(COSName.TYPE).getName() + "\n");
            PDFUtil.b((PDStructureNode)pDStructureTreeRoot, stringBuilder, 0);
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    private static void b(PDStructureNode pDStructureNode, StringBuilder stringBuilder, int n2) {
        StringBuilder stringBuilder2 = new StringBuilder(++n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder2.append(" ");
        }
        for (Object e2 : pDStructureNode.getKids()) {
            PDStructureElement pDStructureElement;
            stringBuilder.append((CharSequence)stringBuilder2);
            if (e2 instanceof PDStructureElement) {
                pDStructureElement = (PDStructureElement)e2;
                stringBuilder.append(pDStructureElement.getCOSObject().getCOSName(COSName.S).getName());
                if (pDStructureElement.getAlternateDescription() != null) {
                    stringBuilder.append(" (Alt: " + pDStructureElement.getAlternateDescription() + ")");
                }
                stringBuilder.append("\n");
                PDFUtil.b((PDStructureNode)pDStructureElement, stringBuilder, n2);
                continue;
            }
            if (e2 instanceof PDMarkedContentReference) {
                pDStructureElement = (PDMarkedContentReference)e2;
                stringBuilder.append("Marked Content " + pDStructureElement.getMCID() + "\n");
                continue;
            }
            stringBuilder.append("Unknown kid type:  " + e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getViewerPreferencesFromPDF(File file) throws IOException {
        PDDocument pDDocument = PDDocument.load((File)file);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Object object;
            PDDocumentCatalog pDDocumentCatalog = pDDocument.getDocumentCatalog();
            PDDestinationOrAction pDDestinationOrAction = pDDocumentCatalog.getOpenAction();
            if (pDDestinationOrAction instanceof PDActionGoTo) {
                object = (PDActionGoTo)pDDestinationOrAction;
                PDDestination pDDestination = object.getDestination();
                stringBuilder.append(pDDestination.getCOSObject());
            }
            object = stringBuilder.toString();
            return object;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSVGPatternsGradients(File file) throws IOException {
        PDDocument pDDocument = PDDocument.load((File)file);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (PDPage pDPage : pDDocument.getPages()) {
                PDResources pDResources = pDPage.getResources();
                for (COSName cOSName : pDResources.getPatternNames()) {
                    PDShadingPattern pDShadingPattern;
                    PDFunction pDFunction;
                    stringBuilder.append("\n" + cOSName.getName() + "\n");
                    PDAbstractPattern pDAbstractPattern = pDResources.getPattern(cOSName);
                    if (!(pDAbstractPattern instanceof PDShadingPattern) || !((pDFunction = (pDShadingPattern = (PDShadingPattern)pDAbstractPattern).getShading().getFunction()) instanceof PDFunctionType3)) continue;
                    PDFunctionType3 pDFunctionType3 = (PDFunctionType3)pDFunction;
                    COSArray cOSArray = pDFunctionType3.getFunctions();
                    for (int i2 = 0; i2 < cOSArray.size(); ++i2) {
                        COSObject cOSObject = (COSObject)cOSArray.get(i2);
                        COSArray cOSArray2 = (COSArray)cOSObject.getDictionaryObject(COSName.C0);
                        COSArray cOSArray3 = (COSArray)cOSObject.getDictionaryObject(COSName.C1);
                        stringBuilder.append(cOSArray2.toList() + " --> " + cOSArray3.toList() + "\n");
                    }
                }
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            PDFUtil.b(pDDocument);
        }
    }

    private static void b(PDDocument pDDocument) {
        if (pDDocument == null) {
            return;
        }
        try {
            pDDocument.close();
        }
        catch (IOException iOException) {
            c.error(MessageFormat.format("Cannot close PDF file: {0}", iOException.getMessage()), (Throwable)iOException);
        }
    }

    private static class _b
    implements Comparator<COSName> {
        private boolean c;
        private PDPage b;

        private _b(PDPage pDPage, boolean bl) {
            this.c = bl;
            this.b = pDPage;
        }

        public int b(COSName cOSName, COSName cOSName2) {
            try {
                String string;
                String string2;
                PDFont pDFont = this.b.getResources().getFont(cOSName);
                PDFont pDFont2 = this.b.getResources().getFont(cOSName2);
                if (this.c) {
                    string2 = PDFUtil.b(pDFont.getFontDescriptor().getFontName());
                    string = PDFUtil.b(pDFont2.getFontDescriptor().getFontName());
                } else {
                    string2 = pDFont.getName();
                    string = pDFont2.getName();
                }
                return string2.compareTo(string);
            }
            catch (IOException iOException) {
                c.error(iOException.getMessage(), (Throwable)iOException);
                return 0;
            }
        }
    }
}

