/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.dynamic.resources.converter;

import com.oxygenxml.batch.converter.core.extensions.ExtensionGetter;
import com.oxygenxml.batch.converter.core.word.styles.WordStyleMapLoader;
import com.oxygenxml.dynamic.resources.converter.ConverterReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import org.dita.dost.util.CatalogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlresolver.ResolvedResource;
import org.xmlresolver.Resolver;
import ro.sync.basic.util.URLUtil;

public class WordConverterReader
extends ConverterReader {
    private static final Logger logger = LoggerFactory.getLogger((String)WordConverterReader.class.getName());
    private static final String[] WORD_STYLE_MAP_LOCATIONS = new String[]{"com.oxygenxml.dynamic.resources.converter.config:wordStyleMap.xml", "plugin:com.oxygenxml.dynamic.resources.converter:wordStyleMap.xml"};

    public WordConverterReader() {
        this(false);
    }

    public WordConverterReader(boolean shouldCreateContentForPreview) {
        super(shouldCreateContentForPreview);
        Resolver catalogResolver = CatalogUtils.getCatalogResolver();
        for (int i = 0; i < WORD_STYLE_MAP_LOCATIONS.length; ++i) {
            String wordStyleMap = WORD_STYLE_MAP_LOCATIONS[i];
            try {
                ResolvedResource wordStyleMapResource = catalogResolver.getCatalogResolver().resolveURI(wordStyleMap, null);
                if (wordStyleMapResource == null) continue;
                try {
                    InputStream is = wordStyleMapResource.getInputStream();
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (wordStyleMapResource.getResolvedURI() == null || wordStyleMap.equals(wordStyleMapResource.getResolvedURI().toString()) || !URLUtil.existsLocalFile((String)wordStyleMapResource.getResolvedURI().toString())) continue;
                WordStyleMapLoader.imposeStyleMapURL((URL)wordStyleMapResource.getResolvedURI().toURL());
                continue;
            }
            catch (IOException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public String determineConverterType(String inputFileExtension) {
        String toRet = null;
        if (Arrays.asList(ExtensionGetter.getInputExtension((String)"_word.to.dita")).contains(inputFileExtension)) {
            toRet = "_word.to.dita";
        }
        return toRet;
    }

    @Override
    public String[] getAllowedInputExtensions() {
        return ExtensionGetter.getInputExtension((String)"_word.to.dita");
    }

    @Override
    public String getFormat() {
        return "word-to-dita";
    }
}

