/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.dynamic.resources.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import ro.sync.licensemanager.base.LicenseCheckerWithOxygenParent;

public class ConverterLicenseValidationHandler
implements LicenseCheckerWithOxygenParent.LicenseValidationHandler {
    private static final String ERRORS_DELIMITER = "\n\n";
    private ErrorHandler errorHandler;
    private List<String> errorsList = new ArrayList<String>(0);

    public ConverterLicenseValidationHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void error(String message) {
        this.errorsList.add(message);
    }

    public void info(String message) {
    }

    public void warn(String message) {
    }

    public void validationStarted() {
        this.errorsList.clear();
    }

    public void validationEnded() {
        if (this.hasErrors()) {
            try {
                String errorMessage = this.getErrorMessage();
                this.errorHandler.fatalError(new SAXParseException(errorMessage, "", "", 0, 0));
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public String getErrorMessage() {
        return this.errorsList.stream().collect(Collectors.joining(ERRORS_DELIMITER));
    }

    public boolean hasErrors() {
        return !this.errorsList.isEmpty();
    }
}

