/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.xhtml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JSAttributesRecognizer {
    private static JSAttributesRecognizer instance;
    private final Map<String, List<String>> jsAttrsMap = new HashMap<String, List<String>>(76);

    public static JSAttributesRecognizer getInstance() {
        if (instance == null) {
            instance = new JSAttributesRecognizer();
        }
        return instance;
    }

    private JSAttributesRecognizer() {
        List<String> starList = List.of("*");
        List<String> bodyList = List.of("body");
        this.jsAttrsMap.put("onabort", starList);
        this.jsAttrsMap.put("onafterprint", bodyList);
        this.jsAttrsMap.put("onbeforeprint", bodyList);
        this.jsAttrsMap.put("onbeforeunload", bodyList);
        this.jsAttrsMap.put("onblur", starList);
        this.jsAttrsMap.put("oncancel", starList);
        this.jsAttrsMap.put("oncanplay", starList);
        this.jsAttrsMap.put("oncanplaythrough", starList);
        this.jsAttrsMap.put("onchange", starList);
        this.jsAttrsMap.put("onclick", starList);
        this.jsAttrsMap.put("onclose", starList);
        this.jsAttrsMap.put("oncontextmenu", starList);
        this.jsAttrsMap.put("oncopy", starList);
        this.jsAttrsMap.put("oncuechange", starList);
        this.jsAttrsMap.put("oncut", starList);
        this.jsAttrsMap.put("ondblclick", starList);
        this.jsAttrsMap.put("ondrag", starList);
        this.jsAttrsMap.put("ondragend", starList);
        this.jsAttrsMap.put("ondragenter", starList);
        this.jsAttrsMap.put("ondragexit", starList);
        this.jsAttrsMap.put("ondragleave", starList);
        this.jsAttrsMap.put("ondragover", starList);
        this.jsAttrsMap.put("ondragstart", starList);
        this.jsAttrsMap.put("ondrop", starList);
        this.jsAttrsMap.put("ondurationchange", starList);
        this.jsAttrsMap.put("onemptied", starList);
        this.jsAttrsMap.put("onended", starList);
        this.jsAttrsMap.put("onerror", starList);
        this.jsAttrsMap.put("onfocus", starList);
        this.jsAttrsMap.put("onhashchange", bodyList);
        this.jsAttrsMap.put("oninput", starList);
        this.jsAttrsMap.put("oninvalid", starList);
        this.jsAttrsMap.put("onkeydown", starList);
        this.jsAttrsMap.put("onkeypres", starList);
        this.jsAttrsMap.put("onkeyup", starList);
        this.jsAttrsMap.put("onlanguagechange", bodyList);
        this.jsAttrsMap.put("onload", starList);
        this.jsAttrsMap.put("onloadeddata", starList);
        this.jsAttrsMap.put("onloadedmetadata", starList);
        this.jsAttrsMap.put("onloadstart", starList);
        this.jsAttrsMap.put("onmessage", bodyList);
        this.jsAttrsMap.put("onmousedown", starList);
        this.jsAttrsMap.put("onmouseenter", starList);
        this.jsAttrsMap.put("onmouseleave", starList);
        this.jsAttrsMap.put("onmousemove", starList);
        this.jsAttrsMap.put("onmouseout", starList);
        this.jsAttrsMap.put("onmouseover", starList);
        this.jsAttrsMap.put("onmouseup", starList);
        this.jsAttrsMap.put("onmousewheel", starList);
        this.jsAttrsMap.put("onwheel", starList);
        this.jsAttrsMap.put("onoffline", bodyList);
        this.jsAttrsMap.put("ononline", bodyList);
        this.jsAttrsMap.put("onpagehide", bodyList);
        this.jsAttrsMap.put("onpageshow", bodyList);
        this.jsAttrsMap.put("onpaste", starList);
        this.jsAttrsMap.put("onpause", starList);
        this.jsAttrsMap.put("onplay", starList);
        this.jsAttrsMap.put("onplaying", starList);
        this.jsAttrsMap.put("onpopstate", bodyList);
        this.jsAttrsMap.put("onprogress", starList);
        this.jsAttrsMap.put("onratechange", starList);
        this.jsAttrsMap.put("onreset", starList);
        this.jsAttrsMap.put("onresize", starList);
        this.jsAttrsMap.put("onscroll", starList);
        this.jsAttrsMap.put("onseeked", starList);
        this.jsAttrsMap.put("onseeking", starList);
        this.jsAttrsMap.put("onselect", starList);
        this.jsAttrsMap.put("onstalled", starList);
        this.jsAttrsMap.put("onstorage", bodyList);
        this.jsAttrsMap.put("onsubmit", starList);
        this.jsAttrsMap.put("onsuspend", starList);
        this.jsAttrsMap.put("ontimeupdate", starList);
        this.jsAttrsMap.put("ontoggle", starList);
        this.jsAttrsMap.put("onunload", bodyList);
        this.jsAttrsMap.put("onvolumechange", starList);
        this.jsAttrsMap.put("onwaiting", starList);
    }

    public boolean isJSAttribute(String elementName, String attributeName) {
        List<String> elements = this.jsAttrsMap.get(attributeName);
        if (elements != null) {
            return elements.contains(elementName) || elements.contains("*");
        }
        return false;
    }
}

