/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.rnc;

import com.oxygenxml.tokenmarker.AbstractLexer;
import com.oxygenxml.tokenmarker.LexerException;
import com.oxygenxml.tokenmarker.Symbol;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class RNCLexer
extends AbstractLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int SQ_STRING = 2;
    public static final int DQ_STRING = 4;
    public static final int COMMENT1 = 6;
    public static final int COMMENT2 = 8;
    public static final int ANNOTATION = 10;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 3, 3, 4, 4};
    private static final String ZZ_CMAP_PACKED = "\t\u0000\u0001-\u0001.\u0001.\u0001.\u0001.\u0012\u0000\u0001-\u0001\u0000\u0001\u0001\u0001*\u0002\u0000\u0001 \u0001\u0003\u0001#\u0001#\u0001'\u0001$\u0001!\u0001%\u0001(\u0001,\n\u0000\u0001)\u0002\u0000\u0001\u001d\u0001\u0000\u0001&\u0001\u0000\u0001\u0017\u0019\u0000\u0001+\u0001\u0002\u0001\u001c\u0003\u0000\u0001\u0005\u0001\u0014\u0001\n\u0001\u000b\u0001\u0007\u0001\f\u0001\u0019\u0001\u0012\u0001\u0011\u0001\u0000\u0001\u001b\u0001\u000e\u0001\u0006\u0001\u0004\u0001\u0016\u0001\t\u0001\u0000\u0001\u0013\u0001\b\u0001\u000f\u0001\r\u0001\u001a\u0001\u0018\u0001\u0015\u0001\u0010\u0001\u0000\u0001\"\u0001\u001f\u0001\"\u0001\u001e\u0006\u0000\u0001.\u1fa2\u0000\u0001.\u0001.\udfd6\u0000";
    private static final char[] ZZ_CMAP = RNCLexer.zzUnpackCMap("\t\u0000\u0001-\u0001.\u0001.\u0001.\u0001.\u0012\u0000\u0001-\u0001\u0000\u0001\u0001\u0001*\u0002\u0000\u0001 \u0001\u0003\u0001#\u0001#\u0001'\u0001$\u0001!\u0001%\u0001(\u0001,\n\u0000\u0001)\u0002\u0000\u0001\u001d\u0001\u0000\u0001&\u0001\u0000\u0001\u0017\u0019\u0000\u0001+\u0001\u0002\u0001\u001c\u0003\u0000\u0001\u0005\u0001\u0014\u0001\n\u0001\u000b\u0001\u0007\u0001\f\u0001\u0019\u0001\u0012\u0001\u0011\u0001\u0000\u0001\u001b\u0001\u000e\u0001\u0006\u0001\u0004\u0001\u0016\u0001\t\u0001\u0000\u0001\u0013\u0001\b\u0001\u000f\u0001\r\u0001\u001a\u0001\u0018\u0001\u0015\u0001\u0010\u0001\u0000\u0001\"\u0001\u001f\u0001\"\u0001\u001e\u0006\u0000\u0001.\u1fa2\u0000\u0001.\u0001.\udfd6\u0000");
    private static final int[] ZZ_ACTION = RNCLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0005\u0000\u0001\u0001\u0001\u0000\u0001\u0002\u0001\u0000\u000b\u0001\u0001\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0012\u0001\u0001\u0003\u0013\u0001\u0014\u0002\u0000\u0001\u0015\u0001\u0016\u0001\u0000\u0001\u0017\u0003\u0000\u0001\u0018\u0011\u0001\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0003\u0000\u0001\u001d\u0003\u0000\u0001\u001e\u0001\u0017\u0001\u001f\u0001\u0017\u0002\u0018\u0001 \f\u0001\u0001!\u0005\u0001\u0001\"\u0001#\u0001\u001d\u0001$\u0001\u001d\u0002\u001e\u0001%%\u0001\u0001&\u0002\u0001";
    private static final int[] ZZ_ROWMAP = RNCLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000/\u0000^\u0000\u008d\u0000\u00bc\u0000\u00eb\u0000\u011a\u0000\u0149\u0000\u0178\u0000\u01a7\u0000\u01d6\u0000\u0205\u0000\u0234\u0000\u0263\u0000\u0292\u0000\u02c1\u0000\u02f0\u0000\u031f\u0000\u034e\u0000\u037d\u0000\u0149\u0000\u0149\u0000\u03ac\u0000\u03db\u0000\u0149\u0000\u0149\u0000\u0149\u0000\u0149\u0000\u0149\u0000\u0149\u0000\u0149\u0000\u0149\u0000\u040a\u0000\u0439\u0000\u0149\u0000\u00eb\u0000\u0468\u0000\u0149\u0000\u0497\u0000\u04c6\u0000\u04f5\u0000\u0524\u0000\u0553\u0000\u0149\u0000\u0149\u0000\u0582\u0000\u05b1\u0000\u05e0\u0000\u060f\u0000\u063e\u0000\u066d\u0000\u069c\u0000\u06cb\u0000\u06fa\u0000\u0729\u0000\u0758\u0000\u0787\u0000\u07b6\u0000\u07e5\u0000\u0814\u0000\u0843\u0000\u0872\u0000\u08a1\u0000\u08d0\u0000\u08ff\u0000\u092e\u0000\u095d\u0000\u098c\u0000\u0149\u0000\u0149\u0000\u0149\u0000\u0149\u0000\u09bb\u0000\u09ea\u0000\u0a19\u0000\u0a48\u0000\u0a77\u0000\u0aa6\u0000\u0ad5\u0000\u0b04\u0000\u0149\u0000\u0149\u0000\u0582\u0000\u0149\u0000\u060f\u0000\u0149\u0000\u0b33\u0000\u0b62\u0000\u0b91\u0000\u0bc0\u0000\u0bef\u0000\u0c1e\u0000\u0c4d\u0000\u0c7c\u0000\u0cab\u0000\u0cda\u0000\u0d09\u0000\u0d38\u0000\u00eb\u0000\u0d67\u0000\u0d96\u0000\u0dc5\u0000\u0df4\u0000\u0e23\u0000\u0149\u0000\u0149\u0000\u0149\u0000\u0149\u0000\u0a19\u0000\u0149\u0000\u0aa6\u0000\u0149\u0000\u0e52\u0000\u0e81\u0000\u0eb0\u0000\u0edf\u0000\u0f0e\u0000\u0f3d\u0000\u0f6c\u0000\u0f9b\u0000\u0fca\u0000\u0ff9\u0000\u1028\u0000\u1057\u0000\u1086\u0000\u10b5\u0000\u10e4\u0000\u1113\u0000\u1142\u0000\u1171\u0000\u11a0\u0000\u11cf\u0000\u11fe\u0000\u122d\u0000\u125c\u0000\u128b\u0000\u12ba\u0000\u12e9\u0000\u1318\u0000\u1347\u0000\u1376\u0000\u13a5\u0000\u13d4\u0000\u1403\u0000\u1432\u0000\u1461\u0000\u1490\u0000\u14bf\u0000\u14ee\u0000\u00eb\u0000\u151d\u0000\u154c";
    private static final int[] ZZ_TRANS = RNCLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0001\f\u0001\r\u0001\u000e\u0001\u000f\u0001\u0006\u0001\u0010\u0002\u0006\u0001\u0011\u0001\u0012\u0001\u0006\u0001\u0013\u0007\u0006\u0001\u0014\u0002\u0006\u0001\u0000\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\u0001\u0019\u0001\u001a\u0001\u001b\u0001\u001c\u0001\u001d\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0001$\u0001%\u0001\u0006\u0003&\u0001'*&\u0001\u0000\u0001&\u0001(,&\u0001\u0000.&\u0001\u0000\u0001)\u0001*\u0001\u0000\u0001+\u0018)\u0001,\u0001\u0015\u0001\u0016\u0001\u0000\u0001)\b\u0000\u0001)\u0001\u0000\u0001-\u0001)\u0001%\u0001)\u0001\u0006\u0003\u0000\u0018\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0001.\u0001/\u00010,./\u0000\u00021\u00012\u00013+1\u0001\u0006\u0003\u0000\u0001\u0006\u00014\u0010\u0006\u00015\u0005\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000b\u0006\u00016\f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\r\u0006\u00017\n\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0002\u0006\u00018\u0007\u0006\u00019\u0006\u0006\u0001:\u0006\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000b\u0006\u0001;\f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0006\u0001<\u0016\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0006\u0001=\u0001\u0006\u0001>\t\u0006\u0001?\n\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\r\u0006\u0001@\n\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0001A\u000e\u0006\u0001B\u0005\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001C\u0017\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000f\u0006\u0001D\b\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u001d\u0000\u0001E\u0011\u0000\u0001\u0006\u0003\u0000\u0018\u0006\u0001\u0000\u0001F\u0002\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0001\u0006'\u0000\u0001G1\u0000\u0001H1\u0000\u0001%\u0004\u0000\u0001I,\u0000\u0001J-\u0000\u0001)\u0003\u0000\u0018)\u0004\u0000\u0001)\b\u0000\u0001)\u0002\u0000\u0001)\u0001\u0000\u0001)\u0001K\u0001L\u0001M,K\u0002N\u0001O\u0001P+N\u0001.\u0001Q\u00010,.\u0001\u0000\u0001R-\u0000\u0001.\u0001S\u00010,.\u00021\u00012\u0001T-1\u00012\u0001U+1\u0003\u0000\u0001V+\u0000\u0001\u0006\u0003\u0000\u0002\u0006\u0001W\u0015\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000b\u0006\u0001X\f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000b\u0006\u0001Y\f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0011\u0006\u0001Z\u0006\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0005\u0006\u0001[\u0012\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0001\\\u0014\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000b\u0006\u0001]\f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0006\u0001^\r\u0006\u0001_\b\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000f\u0006\u0001`\b\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000b\u0006\u0001a\f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\b\u0006\u0001b\u000f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0016\u0006\u0001c\u0001\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0004\u0006\u0001d\u0013\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0011\u0006\u0001d\u0006\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0017\u0006\u0001e\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0006\u0006\u0001f\u0007\u0006\u0001g\t\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0006\u0001h\u0016\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0001\u0006\u0003\u0000\u0001i,\u0000\u0001j-\u0000\u0001K\u0001k\u0001M,K\u0001\u0000\u0001l-\u0000\u0001K\u0001m\u0001M,K\u0002N\u0001O\u0001n-N\u0001O\u0001o+N\u0003\u0000\u0001p+\u0000\u0001\u0006\u0003\u0000\u0003\u0006\u0001q\u0014\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0013\u0006\u0001r\u0004\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000f\u0006\u0001s\b\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0001t\u0014\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000b\u0006\u0001u\f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0002\u0006\u0001`\u0015\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0001v\u0014\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000f\u0006\u0001d\b\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\r\u0006\u0001w\n\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0001x\u0014\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0006\u0001y\u0016\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0006\u0001z\u0016\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000b\u0006\u0001c\f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0001{\u0014\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\n\u0006\u0001|\r\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0001}\u0014\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0002\u0006\u0001~\u0015\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0004\u0006\u0001\u007f\u0013\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\n\u0006\u0001\u0080\r\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\r\u0006\u0001\u0081\n\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0007\u0006\u0001c\u0010\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\f\u0006\u0001c\u000b\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000f\u0006\u0001\u0082\b\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0083\u0017\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001d\u0017\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000b\u0006\u0001\u0084\f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\t\u0006\u0001\u0085\u000e\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001c\u0017\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\t\u0006\u0001\u0086\u000e\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000f\u0006\u0001\u0087\b\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0002\u0006\u0001\u0088\u0015\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0005\u0006\u0001\u0089\u0012\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\n\u0006\u0001\u008a\r\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0010\u0006\u0001\u008b\u0007\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u008c\u0017\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0015\u0006\u0001c\u0002\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\f\u0006\u0001\u008d\u000b\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\n\u0006\u0001\u008e\r\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0007\u0006\u0001\u008f\u0010\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\r\u0006\u0001\u008e\n\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0006\u0001\u0090\u0016\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0006\u0001\u0091\u0016\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0012\u0006\u0001\u0092\u0005\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\t\u0006\u0001\u0093\u000e\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0001\u0006\u0001\u0094\u0016\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0005\u0006\u0001\u0095\u0012\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000b\u0006\u0001\u0096\f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0001c\u0014\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000f\u0006\u0001c\b\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0006\u0006\u0001\u0097\u0011\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0014\u0006\u0001Z\u0003\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u000b\u0006\u0001\u008f\f\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\n\u0006\u0001c\r\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0001\u0098\u0014\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0003\u0006\u0001\u0096\u0014\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0002\u0006\u0003\u0000\u0004\u0006\u0001\u0096\u0013\u0006\u0004\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0001\u0000\u0001\u0006";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unkown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = RNCLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0005\u0000\u0001\u0001\u0001\u0000\u0001\t\u0001\u0000\u000b\u0001\u0002\t\u0002\u0001\b\t\u0002\u0001\u0001\t\u0002\u0001\u0001\t\u0003\u0001\u0002\u0000\u0002\t\u0001\u0000\u0001\u0001\u0003\u0000\u0012\u0001\u0004\t\u0003\u0000\u0001\u0001\u0003\u0000\u0001\u0001\u0002\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t\u0012\u0001\u0004\t\u0001\u0001\u0001\t\u0001\u0001\u0001\t(\u0001";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private static final byte SYM_SLASH = 9;
    private static final byte SYM_BACKSLASH = 9;
    private static final byte SYM_COMMA = 9;
    private static final byte SYM_DOT = 9;
    private static final byte SYM_ASTERISK = 9;
    private static final byte SYM_CURLY_BRACKET = 18;
    private static final byte SYM_BRACKET = 20;
    private static final byte SYM_QUESTION = 9;
    private static final byte SYM_COLON = 9;
    private static final byte SYM_COLON_STAR = 9;
    private static final byte SYM_AMPERSAND = 9;
    private static final byte SYM_PLUS = 9;
    private static final byte SYM_MINUS = 9;
    private static final byte SYM_EQ = 9;
    private static final byte SYM_TILDA = 9;
    private static final byte SYM_PIPE = 9;
    private static final byte SYM_AMPERSANDEQ = 9;
    private static final byte SYM_PIPEEQ = 9;
    private static final byte SYM_KEYWORD1 = 6;
    private static final byte SYM_KEYWORD2 = 7;
    private static final byte SYM_STRING_DQ = 3;
    private static final byte SYM_STRING_SQ = 4;
    private static final byte SYM_COMMENT1 = 1;
    private static final byte SYM_COMMENT2 = 2;
    private static final byte SYM_ANNOTATION = 11;
    private static final byte SYM_ANNOTATION_NAME = 12;
    private static final byte SYM_ANN_STRING_DQ = 13;
    private static final byte SYM_ANN_STRING_SQ = 14;
    private static final byte SYM_TEXT = 0;
    public byte annotationLevel = 0;

    private static int[] zzUnpackAction() {
        int[] result = new int[152];
        int offset = 0;
        offset = RNCLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[152];
        int offset = 0;
        offset = RNCLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[5499];
        int offset = 0;
        offset = RNCLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[152];
        int offset = 0;
        offset = RNCLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public RNCLexer() {
    }

    @Override
    public String getName() {
        return "RNC";
    }

    public RNCLexer(Reader in) {
        this.zzReader = in;
    }

    public RNCLexer(InputStream in) {
        this(new InputStreamReader(in, Charset.forName("UTF-8")));
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[65536];
        int i = 0;
        int j = 0;
        while (i < 142) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int numRead;
        if (this.zzStartRead > 0) {
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length) {
            char[] newBuffer = new char[this.zzCurrentPos * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, this.zzBuffer.length - this.zzEndRead)) > 0) {
            this.zzEndRead += numRead;
            return false;
        }
        if (numRead == 0) {
            int c = this.zzReader.read();
            if (c == -1) {
                return true;
            }
            this.zzBuffer[this.zzEndRead++] = (char)c;
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    @Override
    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    @Override
    public final int yystate() {
        return this.zzLexicalState;
    }

    @Override
    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    @Override
    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    @Override
    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) throws LexerException {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new LexerException(message);
    }

    public void yypushback(int number) throws LexerException {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    @Override
    public Symbol yylex() throws IOException, LexerException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block90: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = zzBufferL[zzCurrentPosL++];
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = zzBufferL[zzCurrentPosL++];
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return this.symbol((byte)0);
                }
                case 39: {
                    continue block90;
                }
                case 2: {
                    return this.symbol((byte)9);
                }
                case 40: {
                    continue block90;
                }
                case 3: {
                    return this.symbol((byte)9);
                }
                case 41: {
                    continue block90;
                }
                case 4: {
                    return this.symbol((byte)9);
                }
                case 42: {
                    continue block90;
                }
                case 5: {
                    return this.symbol((byte)9);
                }
                case 43: {
                    continue block90;
                }
                case 6: {
                    return this.symbol((byte)9);
                }
                case 44: {
                    continue block90;
                }
                case 7: {
                    return this.symbol((byte)9);
                }
                case 45: {
                    continue block90;
                }
                case 8: {
                    return this.symbol((byte)18);
                }
                case 46: {
                    continue block90;
                }
                case 9: {
                    return this.symbol((byte)20);
                }
                case 47: {
                    continue block90;
                }
                case 10: {
                    return this.symbol((byte)9);
                }
                case 48: {
                    continue block90;
                }
                case 11: {
                    return this.symbol((byte)9);
                }
                case 49: {
                    continue block90;
                }
                case 12: {
                    return this.symbol((byte)9);
                }
                case 50: {
                    continue block90;
                }
                case 13: {
                    return this.symbol((byte)9);
                }
                case 51: {
                    continue block90;
                }
                case 14: {
                    return this.symbol((byte)9);
                }
                case 52: {
                    continue block90;
                }
                case 15: {
                    return this.symbol((byte)9);
                }
                case 53: {
                    continue block90;
                }
                case 16: {
                    this.pushState(0);
                    this.yybegin(6);
                    this.cLen = 0;
                    return this.symbol((byte)1);
                }
                case 54: {
                    continue block90;
                }
                case 17: {
                    this.pushState(0);
                    this.yybegin(10);
                    this.cLen = 0;
                    this.annotationLevel = 1;
                    return this.symbol((byte)11);
                }
                case 55: {
                    continue block90;
                }
                case 18: {
                    return this.symbol((byte)9);
                }
                case 56: {
                    continue block90;
                }
                case 19: {
                    ++this.cLen;
                }
                case 57: {
                    continue block90;
                }
                case 20: {
                    return this.symbol((byte)12);
                }
                case 58: {
                    continue block90;
                }
                case 21: {
                    this.annotationLevel = (byte)(this.annotationLevel - 1);
                    if (this.annotationLevel <= 0) {
                        this.yybegin(this.popState());
                    }
                    return this.symbol((byte)11);
                }
                case 59: {
                    continue block90;
                }
                case 22: {
                    this.annotationLevel = (byte)(this.annotationLevel + 1);
                    return this.symbol((byte)11);
                }
                case 60: {
                    continue block90;
                }
                case 23: {
                    return this.symbol((byte)3);
                }
                case 61: {
                    continue block90;
                }
                case 24: {
                    return this.symbol((byte)4);
                }
                case 62: {
                    continue block90;
                }
                case 25: {
                    return this.symbol((byte)9);
                }
                case 63: {
                    continue block90;
                }
                case 26: {
                    return this.symbol((byte)9);
                }
                case 64: {
                    continue block90;
                }
                case 27: {
                    return this.symbol((byte)9);
                }
                case 65: {
                    continue block90;
                }
                case 28: {
                    this.pushState(0);
                    this.yybegin(8);
                    this.cLen = 0;
                    return this.symbol((byte)2);
                }
                case 66: {
                    continue block90;
                }
                case 29: {
                    return this.symbol((byte)13);
                }
                case 67: {
                    continue block90;
                }
                case 30: {
                    return this.symbol((byte)14);
                }
                case 68: {
                    continue block90;
                }
                case 31: {
                    this.pushState(0);
                    this.yybegin(4);
                    return this.symbol((byte)3);
                }
                case 69: {
                    continue block90;
                }
                case 32: {
                    this.pushState(0);
                    this.yybegin(2);
                    return this.symbol((byte)4);
                }
                case 70: {
                    continue block90;
                }
                case 33: {
                    return this.symbol((byte)7);
                }
                case 71: {
                    continue block90;
                }
                case 34: {
                    if (this.cLen == 0) {
                        this.yybegin(this.popState());
                        return this.symbol(this.annotationLevel == 0 ? (byte)4 : 14);
                    }
                    this.yypushback(3);
                    return this.flush(this.annotationLevel == 0 ? (byte)4 : 14);
                }
                case 72: {
                    continue block90;
                }
                case 35: {
                    if (this.cLen == 0) {
                        this.yybegin(this.popState());
                        return this.symbol(this.annotationLevel == 0 ? (byte)3 : 13);
                    }
                    this.yypushback(3);
                    return this.flush(this.annotationLevel == 0 ? (byte)3 : 13);
                }
                case 73: {
                    continue block90;
                }
                case 36: {
                    this.pushState(10);
                    this.yybegin(4);
                    return this.symbol((byte)13);
                }
                case 74: {
                    continue block90;
                }
                case 37: {
                    this.pushState(10);
                    this.yybegin(2);
                    return this.symbol((byte)14);
                }
                case 75: {
                    continue block90;
                }
                case 38: {
                    return this.symbol((byte)6);
                }
                case 76: {
                    continue block90;
                }
            }
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 0: {
                        return this.flush((byte)0);
                    }
                    case 153: {
                        continue block90;
                    }
                    case 2: {
                        return this.flush(this.annotationLevel == 0 ? (byte)4 : 14);
                    }
                    case 154: {
                        continue block90;
                    }
                    case 4: {
                        return this.flush(this.annotationLevel == 0 ? (byte)3 : 13);
                    }
                    case 155: {
                        continue block90;
                    }
                    case 6: {
                        this.yybegin(this.popState());
                        return this.flush((byte)1);
                    }
                    case 156: {
                        continue block90;
                    }
                    case 8: {
                        this.yybegin(this.popState());
                        return this.flush((byte)2);
                    }
                    case 157: {
                        continue block90;
                    }
                }
                return null;
            }
            this.zzScanError(1);
        }
    }
}

