/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.activation;

import com.oxygenxml.tokenmarker.activation.AbstractXMLActivationRule;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeBasedActivationRule
extends AbstractXMLActivationRule {
    private static final Logger logger = LoggerFactory.getLogger((String)AttributeBasedActivationRule.class.getName());
    private final String[] attributeNames;
    private final String[] attributeValues;
    private final String openTag;
    private final String startTag;
    private static final byte S_RECOGNIZED_OPEN_TAG = 1;
    private static final byte S_RECOGNIZED_ATTRIBUTE_NAME = 2;
    private static final byte S_RECOGNIZED_EQUALS_OPERATOR = 3;
    private static final byte S_RECOGNIZED_ATTRIBUTE_VALUE = 4;
    private static final byte S_ACTIVE_ON_NEXT_TOKEN = 5;
    private static final byte S_ACTIVE = 6;

    public AttributeBasedActivationRule(String elementName, String[] attributeNames, String[] attributeValues) {
        this.attributeValues = attributeValues;
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeNames[i] = attributeNames[i].toLowerCase();
        }
        this.attributeNames = attributeNames;
        this.openTag = "<" + elementName;
        this.startTag = this.openTag + ">";
    }

    private static boolean isEqualToken(byte tokenId, String tokenText) {
        return tokenId == 9 && "=".equals(tokenText);
    }

    private static boolean isCloseToken(byte tokenId, String tokenText) {
        return tokenId == 6 && ">".equals(tokenText);
    }

    @Override
    public void update(byte tokenId, String originalTokenText, String trimmedTokenText) {
        String tokenText = trimmedTokenText;
        logger.debug("Updating {} - {} in state {}", new Object[]{tokenId, tokenText, this.state});
        switch (this.state) {
            case 0: {
                if (!this.isStartTag(tokenId)) break;
                if (this.openTag.equalsIgnoreCase(tokenText)) {
                    this.state = 1;
                    break;
                }
                if (!this.startTag.equalsIgnoreCase(tokenText)) break;
                this.state = (byte)5;
                break;
            }
            case 1: {
                if (tokenId == 7 && Arrays.asList(this.attributeNames).contains(tokenText.toLowerCase())) {
                    this.state = (byte)2;
                    break;
                }
                if (AttributeBasedActivationRule.isCloseToken(tokenId, tokenText)) {
                    this.state = (byte)5;
                    break;
                }
                if (AttributeBasedActivationRule.isAttributeRelatedToken(tokenId)) break;
                this.state = 0;
                break;
            }
            case 2: {
                this.state = (byte)(AttributeBasedActivationRule.isEqualToken(tokenId, tokenText) ? 3 : 0);
                break;
            }
            case 3: {
                this.state = AttributeBasedActivationRule.isAttributeValueQuote(tokenId) && this.containsAnyAttributeValue(tokenText) ? 4 : 0;
                break;
            }
            case 4: {
                if (AttributeBasedActivationRule.isCloseToken(tokenId, tokenText)) {
                    this.state = (byte)5;
                    break;
                }
                if (AttributeBasedActivationRule.isAttributeRelatedToken(tokenId)) break;
                this.state = 0;
                break;
            }
            case 5: {
                this.state = (byte)6;
            }
            case 6: {
                if (tokenId == 1 || tokenId == 0 || tokenId == 11 || tokenId == 5) break;
                this.state = 0;
                break;
            }
            default: {
                logger.error("Illegal state.");
            }
        }
        logger.debug("--> {}", (Object)this.state);
    }

    private boolean containsAnyAttributeValue(String tokenText) {
        boolean containsAttrValue = false;
        String tokenTextLower = tokenText.toLowerCase();
        for (int i = 0; !containsAttrValue && i < this.attributeValues.length; ++i) {
            containsAttrValue = tokenTextLower.contains(this.attributeValues[i]);
        }
        return containsAttrValue;
    }

    @Override
    public int getActivationState() {
        return this.state == 6 ? -1 : -2;
    }
}

