/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker;

import com.oxygenxml.tokenmarker.AbstractLexer;
import com.oxygenxml.tokenmarker.CharSequenceReader;
import com.oxygenxml.tokenmarker.FullLexicalState;
import com.oxygenxml.tokenmarker.LexerException;
import com.oxygenxml.tokenmarker.LexicalState;
import com.oxygenxml.tokenmarker.SegmentReader;
import com.oxygenxml.tokenmarker.Symbol;
import com.oxygenxml.tokenmarker.activation.ActivationRange;
import com.oxygenxml.tokenmarker.activation.ActivationRule;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import javax.swing.text.Segment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.syntaxhighlight.marker.LineInfoTokens;
import ro.sync.syntaxhighlight.marker.PrimaryLineInfoTokens;
import ro.sync.syntaxhighlight.marker.SecondaryLineInfoTokens;
import ro.sync.syntaxhighlight.marker.Token;
import ro.sync.syntaxhighlight.marker.TokenInfo;
import ro.sync.syntaxhighlight.marker.TokenMarker;

public class LexerTokenMarker
implements TokenMarker {
    private static boolean ENABLE_SECOND_LEVEL = true;
    private AbstractLexer pLexer;
    private AbstractLexer[] sLexers;
    private ActivationRule[] rules;
    private static final Logger logger = LoggerFactory.getLogger((String)LexerTokenMarker.class.getName());
    protected static final byte ON_BOTH_LEVELS = 0;
    private static final byte ON_FIRST_LEVEL = 1;
    private static final byte ON_SECOND_LEVEL = 2;
    protected static final byte NO_TOKEN = -1;
    private Token firstLevelFirstToken;
    private int firstLevelTokens;
    private Token firstLevelLastToken;
    private int firstLevelOffsetInLine;
    private LineInfoTokens[] flLineInfo;
    private int lastLine;
    private int length;
    private boolean nextLineRequested;
    private Token secondLevelFirstToken;
    private int secondLevelTokens;
    private boolean secondLevelActive;
    private Token secondLevelLastToken;
    private int secondLevelOffsetInLine;
    private LineInfoTokens[] slLineInfo;
    private static final double LOAD_FACTOR = 1.5;

    public static void disableNestedSyntaxHighlight(boolean disable) {
        ENABLE_SECOND_LEVEL = !disable;
    }

    private FullLexicalState getFullLexicalState(int line) {
        LexicalLineInfo state = null;
        LexicalLineInfo li = null;
        if (line >= 0 && this.flLineInfo != null) {
            li = (LexicalLineInfo)this.flLineInfo[line];
            if (li == null) {
                this.flLineInfo[line] = this.createNewLineInfo(false);
                li = (LexicalLineInfo)this.flLineInfo[line];
            }
            if (li != null) {
                state = li;
            }
        }
        logger.debug("GFLS For {} LI: {}  S: {}", new Object[]{line, li != null ? Integer.valueOf(li.hashCode()) : "", state});
        return state;
    }

    private LineInfoTokens createNewLineInfo(boolean includeSecondLevel) {
        return new LexicalLineInfo(this.rules == null ? 0 : this.rules.length, this.pLexer.getInitialLexicalState(), this.pLexer.getInitialLexicalState(), includeSecondLevel);
    }

    @Override
    public LexicalState getPrimaryLexicalState(int lineIndex) {
        LexicalState state = this.pLexer.createLexicalState();
        FullLexicalState fstate = this.getFullLexicalState(lineIndex);
        return fstate != null ? fstate.getPrimaryLexicalState() : state;
    }

    @Override
    public void setPrimaryLexicalState(int lineIndex, LexicalState lexicalState) {
        if (lineIndex < this.flLineInfo.length) {
            if (this.flLineInfo[lineIndex] == null) {
                this.flLineInfo[lineIndex] = this.createNewLineInfo(false);
            }
            logger.debug(() -> "Saving primary state for line: " + lineIndex + " in " + this.flLineInfo[lineIndex].hashCode() + " - " + lexicalState);
            ((LexicalLineInfo)this.flLineInfo[lineIndex]).setPrimaryLexicalState(lexicalState);
        }
    }

    public LexerTokenMarker(AbstractLexer primaryLexer, AbstractLexer[] secondaryLexers, ActivationRule[] rules) {
        this.pLexer = primaryLexer;
        if (ENABLE_SECOND_LEVEL) {
            this.sLexers = secondaryLexers;
            this.rules = rules;
        }
    }

    public LexerTokenMarker(AbstractLexer primaryLexer) {
        this(primaryLexer, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void markTokensImpl(CharSequence line, int lineIndex) {
        logger.debug(() -> "==================================================");
        logger.debug("Tokeninzing line {}: '{}'", (Object)lineIndex, (Object)line);
        Reader reader = LexerTokenMarker.createCharSequenceReader(line);
        this.pLexer.reset(reader);
        this.pLexer.setDocumentStart(lineIndex == 0);
        this.pLexer.setLexicalState(this.getPrimaryLexicalState(lineIndex - 1));
        logger.debug("Intializing state {}", new Supplier[]{() -> this.getPrimaryLexicalState(lineIndex - 1)});
        AbstractLexer sActiveLexer = this.updateRulesStates(lineIndex);
        int offset = 0;
        int lineLen = line.length();
        try {
            Symbol symbol = this.pLexer.yylex();
            while (symbol != null && offset < lineLen) {
                boolean slt = false;
                if (this.rules != null) {
                    String tokenText = line.subSequence(offset, offset + symbol.getLength()).toString();
                    String trimmedTokenText = tokenText.trim();
                    if (!tokenText.isEmpty()) {
                        for (int i = 0; i < this.rules.length; ++i) {
                            this.rules[i].update(symbol.getTokenId(), tokenText, trimmedTokenText);
                            if (this.rules[i].getActivationState() == -2 || slt) continue;
                            slt = true;
                            sActiveLexer = this.sLexers[i];
                            this.parseSecondLevelTokenRegions(this.rules[i], symbol, tokenText, sActiveLexer);
                        }
                    } else {
                        logger.error("On line {} found zero length token. Line content: |{}|", (Object)lineIndex, (Object)line);
                        Symbol symbolLog = symbol;
                        int offsetLog = offset;
                        Supplier[] supplierArray = new Supplier[2];
                        supplierArray[0] = symbolLog::getTokenId;
                        supplierArray[1] = () -> offsetLog;
                        logger.error("Symbol {} found at offset: {}", supplierArray);
                    }
                    logger.debug("Adding token {}", (Object)tokenText);
                }
                offset += symbol.getLength();
                this.addToken(symbol.getLength(), symbol.getTokenId(), (byte)-1, null, slt ? (byte)1 : 0);
                if (!slt) {
                    this.resetSecondLevelLexersToInitialLexicalState();
                }
                symbol = this.pLexer.yylex();
            }
            this.setPrimaryLexicalState(lineIndex, this.pLexer.getLexicalState());
        }
        catch (IOException e) {
            logger.error("Should not get an IOException when marking tokens.");
            this.setPrimaryLexicalState(lineIndex, this.pLexer.getLexicalState());
            logger.debug(() -> "-----------------SAVING STATES ------------");
            logger.debug("--- Secondary Active lexer => {}", (Object)sActiveLexer);
            this.saveRulesRecognitionState(lineIndex);
            this.setSecondaryLexicalState(lineIndex, sActiveLexer != null ? sActiveLexer.getLexicalState() : this.pLexer.createLexicalState());
        }
        catch (LexerException le) {
            this.addToken(lineLen - offset, (byte)10, (byte)-1, null, (byte)0);
            sActiveLexer = null;
            this.setPrimaryLexicalState(lineIndex, this.pLexer.getLexicalState());
            {
                catch (Throwable throwable) {
                    this.setPrimaryLexicalState(lineIndex, this.pLexer.getLexicalState());
                    logger.debug(() -> "-----------------SAVING STATES ------------");
                    logger.debug("--- Secondary Active lexer => {}", (Object)sActiveLexer);
                    this.saveRulesRecognitionState(lineIndex);
                    this.setSecondaryLexicalState(lineIndex, sActiveLexer != null ? sActiveLexer.getLexicalState() : this.pLexer.createLexicalState());
                    throw throwable;
                }
            }
            logger.debug(() -> "-----------------SAVING STATES ------------");
            logger.debug("--- Secondary Active lexer => {}", (Object)sActiveLexer);
            this.saveRulesRecognitionState(lineIndex);
            this.setSecondaryLexicalState(lineIndex, sActiveLexer != null ? sActiveLexer.getLexicalState() : this.pLexer.createLexicalState());
        }
        logger.debug(() -> "-----------------SAVING STATES ------------");
        logger.debug("--- Secondary Active lexer => {}", (Object)sActiveLexer);
        this.saveRulesRecognitionState(lineIndex);
        this.setSecondaryLexicalState(lineIndex, sActiveLexer != null ? sActiveLexer.getLexicalState() : this.pLexer.createLexicalState());
    }

    private AbstractLexer updateRulesStates(int lineIndex) {
        AbstractLexer sActiveLexer = null;
        if (this.sLexers != null) {
            for (int i = 0; i < this.sLexers.length; ++i) {
                this.rules[i].setRuleState(this.getRuleState(lineIndex - 1, i), lineIndex);
                int activationState = this.rules[i].getActivationState();
                if (activationState != -2) {
                    this.sLexers[i].setLexicalState(this.getSecondaryLexicalState(lineIndex - 1));
                    sActiveLexer = this.sLexers[i];
                    continue;
                }
                this.sLexers[i].setLexicalState(this.sLexers[i].createLexicalState());
            }
        }
        return sActiveLexer;
    }

    private void parseSecondLevelTokenRegions(ActivationRule rule, Symbol symbol, String tokenText, AbstractLexer sActiveLexer) throws IOException {
        int ruleState = rule.getActivationState();
        ActivationRange[] ranges = rule.getRanges();
        if (ranges != null) {
            int lastEndIndex = 0;
            for (int r = 0; r < ranges.length; ++r) {
                int beginIndex = ranges[r].beginIndex;
                int endIndex = ranges[r].endIndex;
                int reminder = beginIndex - lastEndIndex;
                if (reminder > 0) {
                    logger.debug("Adding reminder '{}'", new Supplier[]{() -> tokenText.substring(0, beginIndex)});
                    this.addToken(reminder, symbol.getTokenId(), (byte)-1, null, (byte)2);
                }
                String tokenPart = tokenText.substring(beginIndex, endIndex);
                LexerTokenMarker.updateSLexerState(sActiveLexer, rule, ruleState);
                this.markSecondaryTokens(sActiveLexer, tokenPart, symbol.getTokenId());
                lastEndIndex = endIndex;
            }
            int reminder = tokenText.length() - lastEndIndex;
            if (reminder > 0) {
                logger.debug("Adding last reminder {}", (Object)tokenText);
                this.addToken(reminder, symbol.getTokenId(), (byte)-1, null, (byte)2);
            }
        } else {
            LexerTokenMarker.updateSLexerState(sActiveLexer, rule, ruleState);
            this.markSecondaryTokens(sActiveLexer, tokenText, symbol.getTokenId());
        }
    }

    private static void updateSLexerState(AbstractLexer sActiveLexer, ActivationRule rule, int ruleState) {
        if (rule.useSavedLexicalState()) {
            if (ruleState != -1) {
                sActiveLexer.yybegin(ruleState);
            }
        } else {
            sActiveLexer.yybegin(0);
        }
    }

    private void resetSecondLevelLexersToInitialLexicalState() {
        if (this.sLexers != null) {
            for (int i = 0; i < this.sLexers.length; ++i) {
                this.sLexers[i].setLexicalState(this.sLexers[i].createLexicalState());
            }
        }
    }

    private void saveRulesRecognitionState(int lineIndex) {
        if (this.rules != null) {
            for (int i = 0; i < this.rules.length; ++i) {
                int ii = i;
                logger.debug(() -> "--- Rule State " + ii + " => " + this.rules[ii].getRuleState());
                this.setRuleState(lineIndex, i, this.rules[i].getRuleState());
            }
        }
    }

    private static Reader createCharSequenceReader(CharSequence line) {
        Reader reader = line instanceof String ? new StringReader((String)line) : (line instanceof Segment ? new SegmentReader((Segment)line) : new CharSequenceReader(line));
        return reader;
    }

    private void markSecondaryTokens(AbstractLexer lexer, String text, byte primaryTokenId) throws IOException {
        int soffset;
        logger.debug("Mark secondary tokens: '{}' - {}", (Object)text, (Object)primaryTokenId);
        StringReader reader = new StringReader(text);
        LexicalState ls = lexer.getLexicalState().clone();
        lexer.reset(reader);
        lexer.setLexicalState(ls);
        int textLen = text.length();
        try {
            Symbol ssymbol = lexer.yylex();
            for (soffset = 0; ssymbol != null && soffset < textLen; soffset += ssymbol.getLength()) {
                int soffsetLog = soffset;
                Symbol ssymbolLog = ssymbol;
                logger.debug("Adding SL Token: '{}'", new Supplier[]{() -> text.substring(soffsetLog, soffsetLog + ssymbolLog.getLength())});
                if (ssymbol.getLength() != 0) {
                    this.addToken(ssymbol.getLength(), primaryTokenId, ssymbol.getTokenId(), lexer.getName(), (byte)2);
                    ssymbol = lexer.yylex();
                    continue;
                }
                break;
            }
        }
        catch (LexerException e) {
            this.addToken(textLen - soffset, primaryTokenId, (byte)10, lexer.getName(), (byte)2);
        }
    }

    private byte getRuleState(int lineIndex, int ruleNumber) {
        FullLexicalState fstate = this.getFullLexicalState(lineIndex);
        return fstate == null ? (byte)0 : fstate.getRuleStates()[ruleNumber];
    }

    private void setRuleState(int lineIndex, int ruleNumber, byte ruleState) {
        if (lineIndex < this.flLineInfo.length) {
            if (this.flLineInfo[lineIndex] == null) {
                this.flLineInfo[lineIndex] = this.createNewLineInfo(false);
            }
            ((LexicalLineInfo)this.flLineInfo[lineIndex]).getRuleStates()[ruleNumber] = ruleState;
        }
    }

    @Override
    public String getName() {
        return this.pLexer.getName();
    }

    private LexicalState getSecondaryLexicalState(int lineIndex) {
        FullLexicalState fstate = this.getFullLexicalState(lineIndex);
        return fstate == null ? this.pLexer.createLexicalState() : fstate.getSecondaryLexicalState();
    }

    private void setSecondaryLexicalState(int lineIndex, LexicalState lexicalState) {
        if (lineIndex < this.flLineInfo.length) {
            if (this.flLineInfo[lineIndex] == null) {
                this.flLineInfo[lineIndex] = this.createNewLineInfo(false);
            }
            ((LexicalLineInfo)this.flLineInfo[lineIndex]).setSecondaryLexicalState(lexicalState);
        }
    }

    private static boolean computeIsNextLineRequested(FullLexicalState state, FullLexicalState oldState) {
        boolean isNextLineRequested = state == null ? oldState != null : !state.equals(oldState);
        logger.debug("Next line requested: {}", (Object)isNextLineRequested);
        return isNextLineRequested;
    }

    protected void addToken(int length, byte id, byte sId, String sTokenMarkerName, byte level) {
        if (length == 0 && id != 127) {
            return;
        }
        if (level != 2) {
            this.addFirstLevelToken(length, id);
        }
        if (level != 1) {
            this.addSecondLevelToken(length, id, sId, sTokenMarkerName);
        }
        if (level != 2) {
            this.firstLevelOffsetInLine += length;
        }
        if (level != 1) {
            this.secondLevelOffsetInLine += length;
        }
    }

    private void addFirstLevelToken(int length, byte id) {
        if (this.firstLevelFirstToken == null) {
            this.firstLevelLastToken = this.firstLevelFirstToken = new Token(this.firstLevelOffsetInLine, length, id);
        } else if (this.firstLevelLastToken == null) {
            this.firstLevelLastToken = this.firstLevelFirstToken;
            this.firstLevelLastToken.offsetInLine = this.firstLevelOffsetInLine;
            this.firstLevelLastToken.length = length;
            this.firstLevelLastToken.id = id;
        } else if (this.firstLevelLastToken.next == null) {
            this.firstLevelLastToken = this.firstLevelLastToken.next = new Token(this.firstLevelOffsetInLine, length, id);
        } else {
            this.firstLevelLastToken = this.firstLevelLastToken.next;
            this.firstLevelLastToken.offsetInLine = this.firstLevelOffsetInLine;
            this.firstLevelLastToken.length = length;
            this.firstLevelLastToken.id = id;
        }
        ++this.firstLevelTokens;
    }

    private void addSecondLevelToken(int length, byte id, byte sId, String sTokenMarkerName) {
        if (this.secondLevelFirstToken == null) {
            this.secondLevelLastToken = this.secondLevelFirstToken = new Token(this.secondLevelOffsetInLine, length, id, sId, sTokenMarkerName);
        } else if (this.secondLevelLastToken == null) {
            this.secondLevelLastToken = this.secondLevelFirstToken;
            this.secondLevelLastToken.offsetInLine = this.secondLevelOffsetInLine;
            this.secondLevelLastToken.length = length;
            this.secondLevelLastToken.id = id;
            this.secondLevelLastToken.sId = sId;
            this.secondLevelLastToken.sTokenMarkerName = sTokenMarkerName;
        } else if (this.secondLevelLastToken.next == null) {
            this.secondLevelLastToken = this.secondLevelLastToken.next = new Token(this.secondLevelOffsetInLine, length, id, sId, sTokenMarkerName);
        } else {
            this.secondLevelLastToken = this.secondLevelLastToken.next;
            this.secondLevelLastToken.offsetInLine = this.secondLevelOffsetInLine;
            this.secondLevelLastToken.length = length;
            this.secondLevelLastToken.id = id;
            this.secondLevelLastToken.sId = sId;
            this.secondLevelLastToken.sTokenMarkerName = sTokenMarkerName;
        }
        ++this.secondLevelTokens;
        this.secondLevelActive = this.secondLevelActive || sTokenMarkerName != null;
    }

    @Override
    public void deleteLines(int index, int lines) {
        if (lines <= 0) {
            return;
        }
        int len = index + lines;
        this.length -= lines;
        System.arraycopy(this.flLineInfo, len, this.flLineInfo, index, this.flLineInfo.length - len);
        if (this.slLineInfo != null) {
            System.arraycopy(this.slLineInfo, len, this.slLineInfo, index, this.slLineInfo.length - len);
        }
    }

    private synchronized void ensureCapacity(int index) {
        if (this.flLineInfo == null) {
            this.flLineInfo = new LineInfoTokens[index + 1];
            if (this.sLexers != null && this.sLexers.length > 0) {
                this.slLineInfo = new LineInfoTokens[index + 1];
            }
        } else if (this.flLineInfo.length <= index) {
            int newCapacity = (int)((double)(index + 1) * 1.5 + 1.0);
            LineInfoTokens[] lineInfoN = new LineInfoTokens[newCapacity];
            System.arraycopy(this.flLineInfo, 0, lineInfoN, 0, this.flLineInfo.length);
            this.flLineInfo = lineInfoN;
            if (this.slLineInfo != null) {
                lineInfoN = new LineInfoTokens[newCapacity];
                System.arraycopy(this.slLineInfo, 0, lineInfoN, 0, this.slLineInfo.length);
                this.slLineInfo = lineInfoN;
            }
        }
    }

    @Override
    public final synchronized LineInfoTokens getFirstLevelLineTokens(int lineIndex) {
        return this.flLineInfo[lineIndex];
    }

    @Override
    public int getLineCount() {
        return this.length;
    }

    @Override
    public final synchronized LineInfoTokens getSecondLevelLineTokens(int lineIndex) {
        LineInfoTokens toReturn;
        LineInfoTokens lineInfoTokens = toReturn = this.slLineInfo != null && this.slLineInfo.length > lineIndex ? this.slLineInfo[lineIndex] : null;
        if (toReturn == null && this.flLineInfo.length > lineIndex) {
            toReturn = this.flLineInfo[lineIndex];
        }
        return toReturn;
    }

    @Override
    public void insertLines(int index, int numberOfLines) {
        if (numberOfLines <= 0) {
            return;
        }
        this.length += numberOfLines;
        this.ensureCapacity(this.length);
        int len = index + numberOfLines;
        System.arraycopy(this.flLineInfo, index, this.flLineInfo, len, this.flLineInfo.length - len);
        if (this.slLineInfo != null) {
            System.arraycopy(this.slLineInfo, index, this.slLineInfo, len, this.slLineInfo.length - len);
        }
        for (int i = 0; i < numberOfLines; ++i) {
            this.flLineInfo[i + index] = null;
            if (this.slLineInfo == null) continue;
            this.slLineInfo[i + index] = null;
        }
    }

    @Override
    public boolean isNextLineRequested() {
        return this.nextLineRequested;
    }

    @Override
    public final synchronized Token markTokens(CharSequence line, int lineIndex) {
        if (lineIndex >= this.length) {
            throw new IllegalArgumentException("Tokenizing invalid line: " + lineIndex);
        }
        this.resetAndStuff();
        FullLexicalState oldState = this.getFullLexicalState(lineIndex);
        if (oldState != null) {
            oldState = oldState.clone();
        }
        this.markTokensImpl(line, lineIndex);
        FullLexicalState state = this.getFullLexicalState(lineIndex);
        if (this.lastLine != lineIndex || !this.nextLineRequested) {
            this.nextLineRequested = LexerTokenMarker.computeIsNextLineRequested(state, oldState);
        }
        this.lastLine = lineIndex;
        this.addToken(0, (byte)127, (byte)-1, null, (byte)0);
        return this.firstLevelFirstToken;
    }

    private void resetAndStuff() {
        this.firstLevelOffsetInLine = 0;
        this.secondLevelOffsetInLine = 0;
        this.firstLevelFirstToken = null;
        this.firstLevelLastToken = null;
        this.secondLevelFirstToken = null;
        this.secondLevelLastToken = null;
        this.firstLevelTokens = 0;
        this.secondLevelTokens = 0;
        this.secondLevelActive = false;
    }

    @Override
    public final synchronized LineInfoTokens markTokensSync(CharSequence line, int lineIndex) {
        Token token = this.markTokens(line, lineIndex);
        if (this.flLineInfo[lineIndex] == null) {
            this.flLineInfo[lineIndex] = this.createNewLineInfo(false);
        }
        this.flLineInfo[lineIndex].initFromToken(this.firstLevelTokens, token);
        if (this.secondLevelActive) {
            if (this.slLineInfo[lineIndex] == null) {
                this.slLineInfo[lineIndex] = this.createNewLineInfo(true);
            }
            this.slLineInfo[lineIndex].initFromToken(this.secondLevelTokens, this.secondLevelFirstToken);
        } else if (this.slLineInfo != null) {
            this.slLineInfo[lineIndex] = null;
        }
        this.resetAndStuff();
        return this.flLineInfo[lineIndex];
    }

    @Override
    public synchronized void resetLineCache() {
        this.flLineInfo = new LineInfoTokens[1];
        this.flLineInfo[0] = this.createNewLineInfo(false);
        this.flLineInfo[0].setLineTokens(new TokenInfo[]{new TokenInfo(0, 0, 127)});
        this.slLineInfo = this.sLexers == null || this.sLexers.length == 0 ? null : new LineInfoTokens[1];
    }

    @Override
    public String[] getAllLexerNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(this.getName());
        if (this.sLexers != null && this.sLexers.length > 0) {
            for (AbstractLexer lexer : this.sLexers) {
                names.add(lexer.getName());
            }
        }
        return names.toArray(new String[0]);
    }

    private static final class LexicalLineInfo
    implements LineInfoTokens,
    FullLexicalState {
        private LexicalState primaryLexicalState;
        private LexicalState secondaryLexicalState;
        private byte[] ruleStates;
        private LineInfoTokens lineInfoTokens;
        private static final int HASH_CODE = 13;

        LexicalLineInfo(int rulesCount, LexicalState primaryLexicalState, LexicalState secondaryLexicalState, boolean includeSecondLevel) {
            if (rulesCount > 0) {
                this.ruleStates = new byte[rulesCount];
            }
            this.primaryLexicalState = primaryLexicalState;
            this.secondaryLexicalState = secondaryLexicalState;
            this.lineInfoTokens = includeSecondLevel ? new SecondaryLineInfoTokens() : new PrimaryLineInfoTokens();
        }

        public boolean equals(Object obj) {
            if (obj instanceof LexicalLineInfo) {
                LexicalLineInfo other = (LexicalLineInfo)obj;
                return LexicalLineInfo.areEquals(this.primaryLexicalState, other.primaryLexicalState) && LexicalLineInfo.areEquals(this.secondaryLexicalState, other.secondaryLexicalState) && Arrays.equals(this.ruleStates, other.ruleStates);
            }
            return false;
        }

        private static boolean areEquals(LexicalState l1, LexicalState l2) {
            return l1 == l2 || l1 != null && l2 != null && l1.equals(l2);
        }

        public int hashCode() {
            return 13;
        }

        public String toString() {
            return "{ pState = " + this.primaryLexicalState + ", sState = " + this.secondaryLexicalState + ", rState = " + Arrays.toString(this.ruleStates) + '}';
        }

        @Override
        public LexicalLineInfo clone() {
            LexicalLineInfo clone = null;
            try {
                clone = (LexicalLineInfo)super.clone();
                if (this.primaryLexicalState != null) {
                    clone.primaryLexicalState = this.primaryLexicalState.clone();
                }
                if (this.secondaryLexicalState != null) {
                    clone.secondaryLexicalState = this.secondaryLexicalState.clone();
                }
                if (this.ruleStates != null) {
                    clone.ruleStates = (byte[])this.ruleStates.clone();
                }
                clone.lineInfoTokens = this.lineInfoTokens.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return clone;
        }

        @Override
        public byte[] getRuleStates() {
            return this.ruleStates;
        }

        @Override
        public LexicalState getPrimaryLexicalState() {
            return this.primaryLexicalState == null ? null : this.primaryLexicalState.clone();
        }

        @Override
        public LexicalState getSecondaryLexicalState() {
            return this.secondaryLexicalState == null ? null : this.secondaryLexicalState.clone();
        }

        @Override
        public void setPrimaryLexicalState(LexicalState state) {
            this.primaryLexicalState = state;
        }

        @Override
        public void setSecondaryLexicalState(LexicalState state) {
            this.secondaryLexicalState = state;
        }

        @Override
        public int getSize() {
            return this.lineInfoTokens.getSize();
        }

        @Override
        public TokenInfo getTokenInfo(int position, TokenInfo toFill) {
            return this.lineInfoTokens.getTokenInfo(position, toFill);
        }

        @Override
        public void setLineTokens(TokenInfo[] lineTokens) {
            this.lineInfoTokens.setLineTokens(lineTokens);
        }

        @Override
        public void initFromToken(int tokensCount, Token token) {
            this.lineInfoTokens.initFromToken(tokensCount, token);
        }
    }
}

