/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker;

import java.io.Reader;

public class CharSequenceReader
extends Reader {
    private static final CharSequence EMPTY_CHAR_SEQUENCE = "";
    private final CharSequence charSequence;
    private int idx;
    private int mark;
    private final int cLen;

    public CharSequenceReader(CharSequence charSequence) {
        this.charSequence = charSequence != null ? charSequence : EMPTY_CHAR_SEQUENCE;
        this.cLen = this.charSequence.length();
    }

    @Override
    public void close() {
        this.idx = 0;
        this.mark = 0;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.idx;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        return this.idx >= this.cLen ? -1 : (int)this.charSequence.charAt(this.idx++);
    }

    @Override
    public int read(char[] array, int offset, int length) {
        int count = 0;
        if (this.idx >= this.cLen) {
            count = -1;
        } else {
            int c;
            if (array == null) {
                throw new IllegalArgumentException("Character array is missing");
            }
            if (offset < 0 || length < 0 || offset + length > array.length) {
                throw new IndexOutOfBoundsException("Array Size=" + array.length + ", offset=" + offset + ", length=" + length);
            }
            for (int i = 0; i < length && (c = this.read()) != -1; ++i) {
                array[offset + i] = (char)c;
                ++count;
            }
        }
        return count;
    }

    @Override
    public void reset() {
        this.idx = this.mark;
    }

    @Override
    public long skip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Number of characters to skip is less than zero: " + n);
        }
        if (this.idx >= this.cLen) {
            return -1L;
        }
        int dest = (int)Math.min((long)this.cLen, (long)this.idx + n);
        int count = dest - this.idx;
        this.idx = dest;
        return count;
    }
}

