/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.publishing.template;

import com.oxygenxml.publishing.template.PublishingTemplateLoadException;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PublishingTemplateUtil {
    public static final String DESCRIPTOR_EXTENSION = "opt";

    private PublishingTemplateUtil() {
    }

    public static String detectTemplateDescriptor(File templatePackageRoot) throws PublishingTemplateLoadException {
        String templateDescriptor = null;
        templateDescriptor = PublishingTemplateUtil.isZipArchive(templatePackageRoot) ? PublishingTemplateUtil.detectTemplateDescriptorFromZip(templatePackageRoot) : PublishingTemplateUtil.detectTemplateDescriptorFromFolder(templatePackageRoot);
        return templateDescriptor;
    }

    public static String detectTemplateDescriptorFromFolder(File templatePackageRoot) {
        File[] descriptors = templatePackageRoot.listFiles(file -> file.getName().endsWith(".opt"));
        String descriptorName = null;
        if (descriptors != null && descriptors.length > 0) {
            descriptorName = descriptors[0].getName();
        }
        return descriptorName;
    }

    public static String detectTemplateDescriptorFromZip(File templatePackageRoot) throws PublishingTemplateLoadException {
        String string;
        ZipFile zipFile = new ZipFile(templatePackageRoot);
        try {
            String[] dirNames;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            String descriptorName = null;
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntry.getName().endsWith(".opt")) continue;
                descriptorName = zipEntry.getName();
                break;
            }
            if (descriptorName != null && ((dirNames = descriptorName.split("/")) == null || dirNames.length != 1 && dirNames.length != 2)) {
                descriptorName = null;
            }
            string = descriptorName;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new PublishingTemplateLoadException("Cannot open the zip template package: " + templatePackageRoot.getAbsolutePath(), e);
            }
        }
        zipFile.close();
        return string;
    }

    public static boolean isZipArchive(File f) {
        boolean isArchive = false;
        try (ZipFile zipRes = new ZipFile(f);){
            isArchive = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isArchive;
    }
}

