/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.publishing.template;

import com.oxygenxml.publishing.template.ErrorPublishingTemplateType;
import com.oxygenxml.publishing.template.ITemplateValidationListener;
import com.oxygenxml.publishing.template.ProblemType;
import com.oxygenxml.publishing.template.PublishingTemplateLoadException;
import com.oxygenxml.publishing.template.PublishingTemplateUtil;
import com.oxygenxml.publishing.template.TemplateValidationEvent;
import com.oxygenxml.publishing.template.binding.FilePublishingTemplate;
import com.oxygenxml.publishing.template.binding.PublishingTemplate;
import com.oxygenxml.publishing.template.binding.ZIPPublishingTemplate;
import com.oxygenxml.publishing.template.i18n.MessagesBundleProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class PublishingTemplateBuilder {
    private static ResourceBundle messages = MessagesBundleProvider.getBundle();
    private Schema templateSchema;
    private ITemplateValidationListener templateValidationListener;

    public PublishingTemplateBuilder(ITemplateValidationListener validationListener) throws SAXException {
        this.templateValidationListener = validationListener;
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("schema/publishing-template-descriptor.xsd");
        InputSource is = new InputSource(resourceAsStream);
        this.templateSchema = sf.newSchema(new SAXSource(is));
    }

    public PublishingTemplate loadWebHelpPublishingTemplate(File templatePackage) throws PublishingTemplateLoadException {
        return this.loadWebHelpPublishingTemplate(templatePackage, null);
    }

    public PublishingTemplate loadWebHelpPublishingTemplate(File templatePackage, String descriptorName) throws PublishingTemplateLoadException {
        if (PublishingTemplateUtil.isZipArchive(templatePackage)) {
            return this.internalLoadZipWebHelpPublishingTemplate(templatePackage, descriptorName);
        }
        return this.internalLoadFileWebHelpPublishingTemplate(templatePackage, descriptorName);
    }

    private PublishingTemplate internalLoadFileWebHelpPublishingTemplate(File templateRoot, String descriptorName) throws PublishingTemplateLoadException {
        if (templateRoot.getName().endsWith(".opt")) {
            descriptorName = templateRoot.getName();
            templateRoot = templateRoot.getParentFile();
        }
        if (descriptorName == null || "".equals(descriptorName)) {
            descriptorName = PublishingTemplateUtil.detectTemplateDescriptor(templateRoot);
        }
        if (descriptorName == null) {
            String message = MessageFormat.format(messages.getString("Could_not_detect_the_template_descriptor"), templateRoot.getAbsolutePath());
            PublishingTemplateLoadException loadException = new PublishingTemplateLoadException(message);
            this.reportProblem(false, null, templateRoot.getAbsolutePath(), descriptorName, message, loadException, ErrorPublishingTemplateType.COMMON);
            throw loadException;
        }
        File templateDescriptorFile = new File(templateRoot, descriptorName);
        if (!templateDescriptorFile.exists()) {
            String message = MessageFormat.format(messages.getString("Could_not_find_template_descriptor"), templateDescriptorFile.getAbsolutePath());
            PublishingTemplateLoadException loadException = new PublishingTemplateLoadException(message);
            this.reportProblem(false, null, templateRoot.getAbsolutePath(), descriptorName, message, loadException, ErrorPublishingTemplateType.COMMON);
            throw loadException;
        }
        return this.internalLoadFileWebHelpPublishingTemplateDescriptor(new File(templateRoot, descriptorName));
    }

    private PublishingTemplate internalLoadFileWebHelpPublishingTemplateDescriptor(File whTemplateDescriptor) throws PublishingTemplateLoadException {
        File packageRoot = whTemplateDescriptor.getParentFile();
        String descriptorRelPath = whTemplateDescriptor.getName();
        try {
            JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{FilePublishingTemplate.class});
            Unmarshaller unmarshaller = contextObj.createUnmarshaller();
            unmarshaller.setSchema(this.templateSchema);
            JaxbValidationEventHandler jaxbValidationHandler = new JaxbValidationEventHandler(packageRoot.getAbsolutePath(), descriptorRelPath, this.templateValidationListener);
            unmarshaller.setEventHandler((ValidationEventHandler)jaxbValidationHandler);
            XMLReader xmlreader = XMLReaderFactory.createXMLReader();
            InputSource input = new InputSource(whTemplateDescriptor.toURI().toURL().toString());
            SAXSource source = new SAXSource(xmlreader, input);
            FilePublishingTemplate publishingTemplate = (FilePublishingTemplate)unmarshaller.unmarshal((Source)source);
            publishingTemplate.setPackageRoot(packageRoot);
            publishingTemplate.setDescriptorRelativePath(descriptorRelPath);
            publishingTemplate.validatePackageContent(this.templateValidationListener);
            return publishingTemplate;
        }
        catch (MalformedURLException | JAXBException | SAXException e) {
            String message = e.getMessage();
            this.reportProblem(false, null, packageRoot.getAbsolutePath(), descriptorRelPath, message, e, ErrorPublishingTemplateType.COMMON);
            throw new PublishingTemplateLoadException(message, e);
        }
    }

    private PublishingTemplate internalLoadZipWebHelpPublishingTemplate(File templateRoot, String descriptorName) throws PublishingTemplateLoadException {
        try {
            if (descriptorName == null) {
                String detectedDescriptorName = PublishingTemplateUtil.detectTemplateDescriptor(templateRoot);
                if (detectedDescriptorName != null) {
                    return this.internalLoadZipWebHelpPublishingTemplateDescriptor(templateRoot, detectedDescriptorName);
                }
                String message = MessageFormat.format(messages.getString("Could_not_detect_the_template_descriptor"), templateRoot.getAbsolutePath());
                PublishingTemplateLoadException ex = new PublishingTemplateLoadException(message);
                this.reportProblem(false, null, templateRoot.getAbsolutePath(), descriptorName, message, ex, ErrorPublishingTemplateType.COMMON);
                throw ex;
            }
            return this.internalLoadZipWebHelpPublishingTemplateDescriptor(templateRoot, descriptorName);
        }
        catch (JAXBException e) {
            Object message = MessageFormat.format(messages.getString("Could_not_load_template_descriptor"), templateRoot.getAbsolutePath());
            if (e.getMessage() != null) {
                message = (String)message + " " + e.getMessage();
            }
            this.reportProblem(false, null, templateRoot.getAbsolutePath(), descriptorName, (String)message, e, ErrorPublishingTemplateType.COMMON);
            throw new PublishingTemplateLoadException((String)message, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PublishingTemplate internalLoadZipWebHelpPublishingTemplateDescriptor(File templateRoot, String descriptorName) throws JAXBException, PublishingTemplateLoadException {
        JAXBContext contextObj = JAXBContext.newInstance((Class[])new Class[]{ZIPPublishingTemplate.class});
        Unmarshaller unmarshaller = contextObj.createUnmarshaller();
        unmarshaller.setSchema(this.templateSchema);
        JaxbValidationEventHandler jaxbValidationHandler = new JaxbValidationEventHandler(templateRoot.getAbsolutePath(), descriptorName, this.templateValidationListener);
        unmarshaller.setEventHandler((ValidationEventHandler)jaxbValidationHandler);
        try (ZipFile zipFile = new ZipFile(templateRoot);){
            ZipEntry entry = zipFile.getEntry(descriptorName);
            if (entry == null) throw new IOException(messages.getString("Could_not_find_template_descriptor"));
            try (InputStream inputStream = zipFile.getInputStream(entry);){
                ZIPPublishingTemplate publishingTemplate = (ZIPPublishingTemplate)unmarshaller.unmarshal(inputStream);
                publishingTemplate.setPackageRoot(templateRoot);
                publishingTemplate.setDescriptorRelativePath(descriptorName);
                publishingTemplate.validatePackageContent(this.templateValidationListener);
                ZIPPublishingTemplate zIPPublishingTemplate = publishingTemplate;
                return zIPPublishingTemplate;
            }
        }
        catch (IOException e) {
            String message = MessageFormat.format(messages.getString("Could_not_find_template_descriptor"), templateRoot.getAbsolutePath());
            this.reportProblem(false, null, templateRoot.getAbsolutePath(), descriptorName, message, e, ErrorPublishingTemplateType.COMMON);
            throw new PublishingTemplateLoadException(message, e);
        }
    }

    private void reportProblem(boolean isWarn, String templateName, String templatePackageRootPath, String templateDescriptorRelPath, String message, Throwable exception, ErrorPublishingTemplateType errorPublishingFormat) {
        if (this.templateValidationListener != null) {
            ProblemType type = isWarn ? ProblemType.WARNING : ProblemType.ERROR;
            TemplateValidationEvent templateValidationEv = new TemplateValidationEvent(templateName, templatePackageRootPath, templateDescriptorRelPath, null, null, null, null, type, errorPublishingFormat, message, exception);
            if (isWarn) {
                this.templateValidationListener.warning(templateValidationEv);
            } else {
                this.templateValidationListener.error(templateValidationEv);
            }
        }
    }

    private static class JaxbValidationEventHandler
    implements ValidationEventHandler {
        private String templatePackageRootPath;
        private String templateDescriptorRelPath;
        private ITemplateValidationListener templateValidationListener;

        public JaxbValidationEventHandler(String templatePackageRootPath, String templateDescriptorRelPath, ITemplateValidationListener templateValidationListener) {
            this.templatePackageRootPath = templatePackageRootPath;
            this.templateDescriptorRelPath = templateDescriptorRelPath;
            this.templateValidationListener = templateValidationListener;
        }

        public boolean handleEvent(ValidationEvent event) {
            if (this.templateValidationListener != null) {
                boolean isWarn = event.getSeverity() == 0;
                ProblemType type = isWarn ? ProblemType.WARNING : ProblemType.ERROR;
                TemplateValidationEvent templateValidationEv = new TemplateValidationEvent(null, this.templatePackageRootPath, this.templateDescriptorRelPath, null, null, null, null, type, ErrorPublishingTemplateType.COMMON, event.getMessage(), event.getLinkedException());
                if (isWarn) {
                    this.templateValidationListener.warning(templateValidationEv);
                } else {
                    this.templateValidationListener.error(templateValidationEv);
                }
            }
            return false;
        }
    }
}

