/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.FallbackElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class TraceExpression
extends Instruction {
    private final Operand baseOp;
    private HashMap<String, Object> properties = new HashMap(10);

    public TraceExpression(Expression child) {
        this.baseOp = new Operand(this, child, OperandRole.SAME_FOCUS_ACTION);
        this.adoptChildExpression(child);
        child.gatherProperties((k, v) -> this.properties.put((String)k, v));
    }

    public Expression getChild() {
        return this.baseOp.getChildExpression();
    }

    public Expression getBody() {
        return this.baseOp.getChildExpression();
    }

    @Override
    public Iterable<Operand> operands() {
        return this.baseOp;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Iterator<String> getProperties() {
        return this.properties.keySet().iterator();
    }

    @Override
    public String getExpressionName() {
        return "trace";
    }

    @Override
    public String getStreamerName() {
        return "TraceExpr";
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Expression child = this.getChild();
        Expression childCopy = child.copy(rebindings);
        Object extra = child.getExtraProperty("oxy-details");
        if (extra != null && childCopy.getExtraProperty("oxy-details") == null) {
            childCopy.setExtraProperty("oxy-details", extra);
        }
        TraceExpression t = new TraceExpression(childCopy);
        t.setLocation(this.getLocation());
        if (this.properties != null) {
            t.properties = new HashMap<String, Object>(this.properties);
        }
        return t;
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.getChild().isUpdatingExpression();
    }

    @Override
    public boolean isVacuousExpression() {
        return this.getChild().isVacuousExpression();
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        this.getChild().checkForUpdatingSubexpressions();
    }

    @Override
    public int getImplementationMethod() {
        return this.getChild().getImplementationMethod();
    }

    @Override
    public ItemType getItemType() {
        return this.getChild().getItemType();
    }

    @Override
    public int getCardinality() {
        return this.getChild().getCardinality();
    }

    @Override
    public int getDependencies() {
        return this.getChild().getDependencies();
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return !this.getChild().hasSpecialProperty(0x800000);
    }

    @Override
    public int getNetCost() {
        return 0;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(context);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public int getInstructionNameCode() {
        if (this.getChild() instanceof Instruction) {
            return ((Instruction)this.getChild()).getInstructionNameCode();
        }
        return -1;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression t = super.optimize(visitor, contextInfo);
        if (t != this) {
            return t;
        }
        if (this.getChild() instanceof TraceExpression) {
            return this.getChild();
        }
        return this;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        this.getChild().export(out);
    }

    @Override
    public String toShortString() {
        return this.getChild().toShortString();
    }

    @Override
    public Elaborator getElaborator() {
        return new TraceExpressionElaborator();
    }

    private static class TraceExpressionElaborator
    extends FallbackElaborator {
        private TraceExpressionElaborator() {
        }

        @Override
        public StringEvaluator elaborateForString(boolean zeroLengthWhenAbsent) {
            TraceExpression expr = (TraceExpression)this.getExpression();
            Expression body = expr.getBody();
            StringEvaluator baseEval = expr.getBody().makeElaborator().elaborateForString(zeroLengthWhenAbsent);
            return context -> {
                Controller controller = context.getController();
                assert (controller != null);
                if (controller.isTracing()) {
                    TraceListener listener = controller.getTraceListener();
                    listener.enter(body, expr.properties, context);
                    String result = baseEval.eval(context);
                    listener.leave(body);
                    return result;
                }
                return baseEval.eval(context);
            };
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            TraceExpression expr = (TraceExpression)this.getExpression();
            Expression body = expr.getBody();
            UpdateEvaluator baseEval = expr.getBody().makeElaborator().elaborateForUpdate();
            return (context, pul) -> {
                Controller controller = context.getController();
                assert (controller != null);
                if (controller.isTracing()) {
                    TraceListener listener = controller.getTraceListener();
                    listener.enter(body, expr.properties, context);
                    baseEval.registerUpdates(context, pul);
                    listener.leave(body);
                } else {
                    baseEval.registerUpdates(context, pul);
                }
            };
        }

        @Override
        public PullEvaluator elaborateForPull() {
            TraceExpression expr = (TraceExpression)this.getExpression();
            Expression body = expr.getBody();
            PullEvaluator baseEval = expr.getBody().makeElaborator().elaborateForPull();
            return context -> {
                Controller controller = context.getController();
                assert (controller != null);
                if (controller.isTracing()) {
                    TraceListener listener = controller.getTraceListener();
                    listener.enter(body, expr.properties, context);
                    SequenceIterator result = baseEval.iterate(context);
                    listener.leave(body);
                    return result;
                }
                return baseEval.iterate(context);
            };
        }

        @Override
        public PushEvaluator elaborateForPush() {
            TraceExpression expr = (TraceExpression)this.getExpression();
            Expression body = expr.getBody();
            PushEvaluator baseEval = body.makeElaborator().elaborateForPush();
            return (output, context) -> {
                Controller controller = context.getController();
                assert (controller != null);
                if (controller.isTracing()) {
                    TraceListener listener = controller.getTraceListener();
                    listener.enter(body, expr.properties, context);
                    TailCall tc = baseEval.processLeavingTail(output, context);
                    Expression.dispatchTailCall(tc);
                    listener.leave(body);
                } else {
                    Expression.dispatchTailCall(baseEval.processLeavingTail(output, context));
                }
                return null;
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            TraceExpression expr = (TraceExpression)this.getExpression();
            Expression body = expr.getBody();
            ItemEvaluator baseEval = expr.getBody().makeElaborator().elaborateForItem();
            return context -> {
                Controller controller = context.getController();
                assert (controller != null);
                if (controller.isTracing()) {
                    TraceListener listener = controller.getTraceListener();
                    listener.enter(body, expr.properties, context);
                    Item result = baseEval.eval(context);
                    listener.leave(body);
                    return result;
                }
                return baseEval.eval(context);
            };
        }

        @Override
        public BooleanEvaluator elaborateForBoolean() {
            TraceExpression expr = (TraceExpression)this.getExpression();
            Expression body = expr.getBody();
            BooleanEvaluator baseEval = expr.getBody().makeElaborator().elaborateForBoolean();
            return context -> {
                Controller controller = context.getController();
                assert (controller != null);
                if (controller.isTracing()) {
                    TraceListener listener = controller.getTraceListener();
                    listener.enter(body, expr.properties, context);
                    boolean result = baseEval.eval(context);
                    listener.leave(body);
                    return result;
                }
                return baseEval.eval(context);
            };
        }

        @Override
        public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
            TraceExpression expr = (TraceExpression)this.getExpression();
            Expression body = expr.getBody();
            UnicodeStringEvaluator baseEval = expr.getBody().makeElaborator().elaborateForUnicodeString(zeroLengthWhenAbsent);
            return context -> {
                Controller controller = context.getController();
                assert (controller != null);
                if (controller.isTracing()) {
                    TraceListener listener = controller.getTraceListener();
                    listener.enter(body, expr.properties, context);
                    UnicodeString result = baseEval.eval(context);
                    listener.leave(body);
                    return result;
                }
                return baseEval.eval(context);
            };
        }
    }
}

