/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Version;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.compat.TypeChecker10;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.ComponentTracer;
import net.sf.saxon.expr.instruct.Debugger;
import net.sf.saxon.expr.instruct.EvaluateInstr;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.MemoFunction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.SourceDocument;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionToolUtil;
import net.sf.saxon.expr.parser.ICompilerService;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.expr.sort.AlphanumericCollator;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.HTML5CaseBlindCollator;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.IntegratedFunctionLibrary;
import net.sf.saxon.functions.MathFunctionSet;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.functions.registry.ConstructorFunctionLibrary;
import net.sf.saxon.functions.registry.ExsltCommonFunctionSet;
import net.sf.saxon.functions.registry.UseWhen30FunctionSet;
import net.sf.saxon.functions.registry.VendorFunctionSetHE;
import net.sf.saxon.functions.registry.XPath20FunctionSet;
import net.sf.saxon.functions.registry.XPath30FunctionSet;
import net.sf.saxon.functions.registry.XPath31FunctionSet;
import net.sf.saxon.functions.registry.XSLT30FunctionSet;
import net.sf.saxon.java.CleanerProxy;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.CatalogResourceResolver;
import net.sf.saxon.lib.ChainedEntityResolver;
import net.sf.saxon.lib.CollationURIResolver;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.EntityResolverWrappingResourceResolver;
import net.sf.saxon.lib.EnvironmentVariableResolver;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.FeatureData;
import net.sf.saxon.lib.FeatureIndex;
import net.sf.saxon.lib.FunctionAnnotationHandler;
import net.sf.saxon.lib.IDynamicLoader;
import net.sf.saxon.lib.Initializer;
import net.sf.saxon.lib.InvalidityReportGenerator;
import net.sf.saxon.lib.LocalizerFactory;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.ProtocolRestrictor;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.lib.ResourceResolverWrappingURIResolver;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.SourceResolver;
import net.sf.saxon.lib.StandardCollationURIResolver;
import net.sf.saxon.lib.StandardEnvironmentVariableResolver;
import net.sf.saxon.lib.StandardErrorReporter;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.lib.StaticQueryContextFactory;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.lib.XQueryFunctionAnnotationHandler;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeSource;
import net.sf.saxon.om.NotationSet;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.oxygen.SaxonEEUtilFacade;
import net.sf.saxon.pattern.PatternParser;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.resource.ActiveSAXSource;
import net.sf.saxon.resource.BinaryResource;
import net.sf.saxon.resource.JSONResource;
import net.sf.saxon.resource.UnknownResource;
import net.sf.saxon.resource.UnparsedTextResource;
import net.sf.saxon.resource.XmlResource;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.serialize.charcode.CharacterSetFactory;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLEvaluate;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.TraceCodeInjector;
import net.sf.saxon.trace.TraceableComponent;
import net.sf.saxon.trace.XQueryTraceCodeInjector;
import net.sf.saxon.trace.XSLTTraceCodeInjector;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.ConfigurationReader;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.Maker;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.PackageLoaderHE;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.TypeAliasManager;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.trans.packages.IPackageLoader;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.tree.tiny.TreeStatistics;
import net.sf.saxon.tree.util.DocumentNumberAllocator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringToDouble11;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntPredicateLambda;
import net.sf.saxon.z.IntPredicateProxy;
import net.sf.saxon.z.IntSet;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;

public class Configuration
implements SourceResolver,
NotationSet {
    private transient Object transformationStopper;
    protected static IntSet booleanFeatures = new IntHashSet(40);
    protected static IntSet stringFeatures = new IntHashSet(40);
    private transient ApiProvider apiProcessor = null;
    private transient CharacterSetFactory characterSetFactory;
    private final Map<String, StringCollator> collationMap = new HashMap<String, StringCollator>(10);
    private CollationURIResolver collationResolver = new StandardCollationURIResolver();
    private String defaultCollationName = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private Map<String, ResourceCollection> registeredCollections = new HashMap<String, ResourceCollection>();
    private CollectionFinder collectionFinder;
    private EnvironmentVariableResolver environmentVariableResolver = new StandardEnvironmentVariableResolver();
    private String defaultCollection = null;
    private ParseOptions defaultParseOptions = new ParseOptions();
    protected transient StaticQueryContext defaultStaticQueryContext;
    private StaticQueryContextFactory staticQueryContextFactory = new StaticQueryContextFactory();
    protected OptimizerOptions optimizerOptions = OptimizerOptions.FULL_HE_OPTIMIZATION;
    protected CompilerInfo defaultXsltCompilerInfo;
    private Function<Configuration, ? extends ErrorReporter> errorReporterFactory;
    protected IndependentContext staticContextForSystemFunctions;
    private String label = null;
    private DocumentNumberAllocator documentNumberAllocator = new DocumentNumberAllocator();
    private transient Debugger debugger = null;
    private String defaultLanguage = Version.platform.getDefaultLanguage();
    private String defaultCountry = Version.platform.getDefaultCountry();
    private Properties defaultOutputProperties = new Properties();
    private transient IDynamicLoader dynamicLoader = Version.platform.getDefaultDynamicLoader();
    private final IntSet enabledProperties = new IntHashSet(64);
    private final IntHashMap<String> stringProperties = new IntHashMap();
    private List<ExternalObjectModel> externalObjectModels = new ArrayList<ExternalObjectModel>(4);
    private final DocumentPool globalDocumentPool = new DocumentPool();
    private final IntegratedFunctionLibrary integratedFunctionLibrary = new IntegratedFunctionLibrary();
    private transient LocalizerFactory localizerFactory;
    private NamePool namePool = new NamePool();
    protected Optimizer optimizer = null;
    private SerializerFactory serializerFactory;
    private volatile ConcurrentLinkedQueue<XMLReader> sourceParserPool = new ConcurrentLinkedQueue<XMLReader>(){

        @Override
        public boolean offer(XMLReader e) {
            return true;
        }
    };
    private volatile ConcurrentLinkedQueue<XMLReader> styleParserPool = new ConcurrentLinkedQueue();
    private String sourceParserClass;
    private transient SourceResolver sourceResolver;
    private transient Logger traceOutput = new StandardLogger();
    private ModuleURIResolver standardModuleURIResolver;
    private String styleParserClass;
    private UnparsedTextURIResolver unparsedTextURIResolver;
    private transient XPathContext theConversionContext = null;
    private ConversionRules theConversionRules = null;
    private transient TraceListener traceListener = null;
    private String traceListenerClass = null;
    private String traceListenerOutput = null;
    private String defaultRegexEngine = "S";
    protected transient TypeHierarchy typeHierarchy;
    private final TypeChecker typeChecker = new TypeChecker();
    private final TypeChecker10 typeChecker10 = new TypeChecker10();
    private transient ResourceResolver commonResolver;
    private ProtocolRestrictor protocolRestrictor = new ProtocolRestrictor("all");
    protected IntHashMap<FunctionLibraryList> builtInExtensionLibraryList = new IntHashMap(4);
    protected int xsdVersion = 11;
    private int xmlVersion = 10;
    private int xpathVersionForXsd = 20;
    private int xpathVersionForXslt = 31;
    private Comparator<String> mediaQueryEvaluator;
    private final Map<String, String> fileExtensions = new HashMap<String, String>();
    private final Map<String, ResourceFactory> resourceFactoryMapping = new HashMap<String, ResourceFactory>();
    private final Map<NamespaceUri, FunctionAnnotationHandler> functionAnnotationHandlers = new HashMap<NamespaceUri, FunctionAnnotationHandler>();
    private int regexBacktrackingLimit = 10000000;
    private final TreeStatistics treeStatistics = new TreeStatistics();
    private CleanerProxy cleaner = null;
    public static final int XML10 = 10;
    public static final int XML11 = 11;
    public static final int XSD10 = 10;
    public static final int XSD11 = 11;
    private static final LexicalHandler dummyLexicalHandler = new DefaultHandler2();

    public Configuration() {
        this.init();
    }

    public static Configuration newConfiguration() {
        try {
            Configuration config = Version.configurationClass.newInstance();
            SaxonEEUtilFacade.getSaxonEEUtil().supplySaxonLicenseAndSchemaResolver(config, true);
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot instantiate a Configuration", e);
        }
    }

    public static StreamSource locateResourceSource(String filename, List<String> messages, List<ClassLoader> loaders) {
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception err) {
            messages.add("Failed to getContextClassLoader() - continuing\n");
        }
        InputStream in = null;
        URL url = null;
        if (loader != null) {
            url = loader.getResource(filename);
            in = loader.getResourceAsStream(filename);
            if (in == null) {
                messages.add("Cannot read " + filename + " file located using ClassLoader " + loader + " - continuing\n");
            }
        }
        if (in == null && (loader = Configuration.class.getClassLoader()) != null && (in = loader.getResourceAsStream(filename)) == null) {
            messages.add("Cannot read " + filename + " file located using ClassLoader " + loader + " - continuing\n");
        }
        loaders.add(loader);
        return new StreamSource(in, url.toString());
    }

    public static Configuration newLicensedConfiguration() {
        return new Configuration();
    }

    public static Configuration readConfiguration(Source source) throws XPathException {
        Configuration tempConfig = Configuration.newConfiguration();
        return tempConfig.readConfigurationFile(source);
    }

    public static Configuration readConfiguration(Source source, Configuration baseConfiguration) throws XPathException {
        Configuration tempConfig = Configuration.newConfiguration();
        return tempConfig.readConfigurationFile(source, baseConfiguration);
    }

    public static Configuration instantiateConfiguration(String className, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> theClass;
        ClassLoader loader = classLoader;
        if (loader == null) {
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception err) {
                System.err.println("Failed to getContextClassLoader() - continuing");
            }
        }
        if (loader != null) {
            try {
                theClass = loader.loadClass(className);
            }
            catch (Exception ex) {
                theClass = Class.forName(className);
            }
        } else {
            theClass = Class.forName(className);
        }
        return (Configuration)theClass.newInstance();
    }

    public static boolean isAssertionsEnabled() {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertsEnabled;
    }

    protected Configuration readConfigurationFile(Source source) throws XPathException {
        return this.makeConfigurationReader().makeConfiguration(source);
    }

    protected Configuration readConfigurationFile(Source source, Configuration baseConfiguration) throws XPathException {
        ConfigurationReader reader = this.makeConfigurationReader();
        reader.setBaseConfiguration(baseConfiguration);
        return reader.makeConfiguration(source);
    }

    protected ConfigurationReader makeConfigurationReader() {
        return new ConfigurationReader();
    }

    protected void init() {
        this.commonResolver = new CatalogResourceResolver();
        this.defaultXsltCompilerInfo = this.makeCompilerInfo();
        this.standardModuleURIResolver = Version.platform.makeStandardModuleURIResolver(this);
        this.serializerFactory = new SerializerFactory(this);
        this.sourceResolver = this;
        this.unparsedTextURIResolver = new StandardUnparsedTextResolver();
        this.mediaQueryEvaluator = (o1, o2) -> 0;
        Version.platform.initialize(this);
        if (this.standardModuleURIResolver instanceof StandardModuleURIResolver) {
            ((StandardModuleURIResolver)this.standardModuleURIResolver).setConfiguration(this);
        }
        this.internalSetBooleanProperty(1, "http://saxon.sf.net/feature/allow-external-functions", true);
        this.internalSetBooleanProperty(22, "http://saxon.sf.net/feature/disableXslEvaluate", false);
        String initializationClass = System.getProperty("SAXON_INITIALIZER");
        if (initializationClass != null) {
            try {
                Initializer initializer = (Initializer)this.getInstance(initializationClass);
                initializer.initialize(this);
            }
            catch (TransformerException e) {
                System.err.println("Warning: Failed to invoke Saxon Initializer " + initializationClass + ": " + e.getMessage());
            }
        }
        try {
            this.setConfigurationProperty("http://saxon.sf.net/feature/allow-old-java-uri-format", (Object)true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.registerFileExtension("xml", "application/xml");
        this.registerFileExtension("html", "application/html");
        this.registerFileExtension("atom", "application/atom");
        this.registerFileExtension("xsl", "application/xml+xslt");
        this.registerFileExtension("xslt", "application/xml+xslt");
        this.registerFileExtension("xsd", "application/xml+xsd");
        this.registerFileExtension("txt", "text/plain");
        this.registerFileExtension("MF", "text/plain");
        this.registerFileExtension("class", "application/java");
        this.registerFileExtension("json", "application/json");
        this.registerFileExtension("", "application/unknown");
        this.registerMediaType("application/xml", XmlResource.FACTORY);
        this.registerMediaType("text/xml", XmlResource.FACTORY);
        this.registerMediaType("application/html", XmlResource.FACTORY);
        this.registerMediaType("text/html", XmlResource.FACTORY);
        this.registerMediaType("application/atom", XmlResource.FACTORY);
        this.registerMediaType("application/xml+xslt", XmlResource.FACTORY);
        this.registerMediaType("application/xml+xsd", XmlResource.FACTORY);
        this.registerMediaType("application/rdf+xml", XmlResource.FACTORY);
        this.registerMediaType("text/plain", UnparsedTextResource.FACTORY);
        this.registerMediaType("application/java", BinaryResource.FACTORY);
        this.registerMediaType("application/binary", BinaryResource.FACTORY);
        this.registerMediaType("application/json", JSONResource.FACTORY);
        this.registerMediaType("application/unknown", UnknownResource.FACTORY);
        this.registerFunctionAnnotationHandler(new XQueryFunctionAnnotationHandler());
    }

    public static Configuration makeLicensedConfiguration(ClassLoader classLoader, String className) throws RuntimeException {
        if (className == null) {
            className = "com.saxonica.config.ProfessionalConfiguration";
        }
        try {
            Configuration newInstance = Configuration.instantiateConfiguration(className, classLoader);
            SaxonEEUtilFacade.getSaxonEEUtil().supplySaxonLicenseAndSchemaResolver(newInstance, false);
            return newInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void importLicenseDetails(Configuration config) {
    }

    public String getEditionCode() {
        return "HE";
    }

    public void setProcessor(ApiProvider processor) {
        this.apiProcessor = processor;
    }

    public ApiProvider getProcessor() {
        return this.apiProcessor;
    }

    public String getProductTitle() {
        return "Saxon" + Version.platform.getPlatformSuffix() + "-" + this.getEditionCode() + " " + Version.getProductVersion() + " from Saxonica";
    }

    public void checkLicensedFeature(int feature, String name, int localLicenseId) throws LicenseException {
        String require = feature == 8 ? "PE" : "EE";
        String message = "Requested feature (" + name + ") requires Saxon-" + require;
        if (!Version.softwareEdition.equals("HE")) {
            String packageNs = Version.platform.isDotNet() ? "Saxon.Eej.config" : "com.saxonica.config";
            message = message + ". You are using Saxon-" + Version.softwareEdition + " software, but the Configuration is an instance of " + this.getClass() + "; to use this feature you need to create an instance of " + (feature == 8 ? packageNs + ".ProfessionalConfiguration" : packageNs + ".EnterpriseConfiguration");
        }
        throw new LicenseException(message, 6);
    }

    public void disableLicensing() {
    }

    public boolean isFeatureAllowedBySecondaryLicense(int localLicenseId, int feature) {
        return false;
    }

    public boolean isLicensedFeature(int feature) {
        return false;
    }

    public void requireProfessionalLicense(String featureName) throws LicenseException {
        if (!this.isLicensedFeature(8)) {
            throw new LicenseException("Use of " + featureName + " requires a license key for Saxon-PE or Saxon-EE", 3);
        }
    }

    public String getLicenseFeature(String name) {
        return null;
    }

    public Properties getLicenseFeatures() {
        return null;
    }

    public void displayLicenseMessage() {
    }

    public int registerLocalLicense(String dmk) {
        return -1;
    }

    public void setDynamicLoader(IDynamicLoader dynamicLoader) {
        this.dynamicLoader = dynamicLoader;
    }

    public IDynamicLoader getDynamicLoader() {
        return this.dynamicLoader;
    }

    public Class<?> getClass(String className, boolean tracing) throws XPathException {
        return this.dynamicLoader.getClass(className, tracing ? this.traceOutput : null, null);
    }

    public Object getInstance(String className) throws XPathException {
        return this.dynamicLoader.getInstance(className, this.isTiming() ? this.traceOutput : null, null);
    }

    public ResourceResolver getResourceResolver() {
        if (this.commonResolver == null) {
            this.setResourceResolver(new CatalogResourceResolver());
        }
        return this.commonResolver;
    }

    public void setResourceResolver(ResourceResolver resolver) {
        this.commonResolver = resolver;
    }

    @Deprecated
    public void setParameterizedURIResolver() {
        this.setBooleanProperty(Feature.RECOGNIZE_URI_QUERY_PARAMETERS, true);
    }

    public ProtocolRestrictor getProtocolRestrictor() {
        return this.protocolRestrictor;
    }

    public ResourceResolver makeResourceResolver(String className) throws XPathException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (obj instanceof URIResolver) {
            this.getLogger().warning("From Saxon 11.1, the value of the -r option should be a ResourceResolver, not a URIResolver");
            obj = new ResourceResolverWrappingURIResolver((URIResolver)obj);
        }
        if (obj instanceof ResourceResolver) {
            return (ResourceResolver)obj;
        }
        throw new XPathException("Class " + className + " is not a ResourceResolver");
    }

    public void setErrorReporterFactory(Function<Configuration, ? extends ErrorReporter> factory) {
        this.errorReporterFactory = factory;
    }

    public ErrorReporter makeErrorReporter() {
        if (this.errorReporterFactory == null) {
            this.errorReporterFactory = config -> {
                StandardErrorReporter reporter = new StandardErrorReporter();
                reporter.setLogger(config.getLogger());
                return reporter;
            };
        }
        return this.errorReporterFactory.apply(this);
    }

    public Logger getLogger() {
        return this.traceOutput;
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            this.makeErrorReporter().report(new XmlProcessingException(err));
            err.setHasBeenReported(true);
        }
    }

    public void setStandardErrorOutput(PrintStream out) {
        if (this.traceOutput instanceof StandardLogger) {
            ((StandardLogger)this.traceOutput).setPrintStream(out);
        }
    }

    public void setLogger(Logger logger) {
        this.traceOutput = logger;
    }

    public void setXMLVersion(int version) {
        this.xmlVersion = version;
        this.theConversionRules = null;
    }

    public int getXMLVersion() {
        return this.xmlVersion;
    }

    public ParseOptions getParseOptions() {
        return this.defaultParseOptions;
    }

    public void setParseOptions(ParseOptions options) {
        this.defaultParseOptions = options;
    }

    public void setMediaQueryEvaluator(Comparator<String> comparator) {
        this.mediaQueryEvaluator = comparator;
    }

    public Comparator<String> getMediaQueryEvaluator() {
        return this.mediaQueryEvaluator;
    }

    public void setConversionRules(ConversionRules rules) {
        this.theConversionRules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversionRules getConversionRules() {
        if (this.theConversionRules == null) {
            Configuration configuration = this;
            synchronized (configuration) {
                ConversionRules cv = new ConversionRules();
                cv.setTypeHierarchy(this.getTypeHierarchy());
                cv.setNotationSet(this);
                if (this.xsdVersion == 10) {
                    cv.setStringToDoubleConverter(StringToDouble.getInstance());
                    cv.setURIChecker(StandardURIChecker.getInstance());
                } else {
                    cv.setStringToDoubleConverter(StringToDouble11.getInstance());
                }
                cv.setAllowYearZero(this.xsdVersion != 10);
                this.theConversionRules = cv;
                return this.theConversionRules;
            }
        }
        return this.theConversionRules;
    }

    public int getXsdVersion() {
        return this.xsdVersion;
    }

    public XPathContext getConversionContext() {
        if (this.theConversionContext == null) {
            this.theConversionContext = new EarlyEvaluationContext(this);
        }
        return this.theConversionContext;
    }

    public IntPredicateProxy getValidCharacterChecker() {
        if (this.xmlVersion == 10) {
            return IntPredicateLambda.of(CSharp.staticRef(XMLCharacterData::isValid10));
        }
        return IntPredicateLambda.of(CSharp.staticRef(XMLCharacterData::isValid11));
    }

    public int getTreeModel() {
        return this.defaultParseOptions.getModel().getSymbolicValue();
    }

    public void setTreeModel(int treeModel) {
        this.defaultParseOptions = this.defaultParseOptions.withModel(TreeModel.getTreeModel(treeModel));
    }

    public boolean isLineNumbering() {
        return this.defaultParseOptions.isLineNumbering();
    }

    public void setLineNumbering(boolean lineNumbering) {
        this.defaultParseOptions = this.defaultParseOptions.withLineNumbering(lineNumbering);
    }

    public void setXIncludeAware(boolean state) {
        this.defaultParseOptions = this.defaultParseOptions.withXIncludeAware(state);
    }

    public boolean isXIncludeAware() {
        return this.defaultParseOptions.isXIncludeAware();
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public TraceListener makeTraceListener() throws XPathException {
        if (this.traceListener != null) {
            return this.traceListener;
        }
        if (this.traceListenerClass != null) {
            try {
                return this.makeTraceListener(this.traceListenerClass);
            }
            catch (ClassCastException e) {
                throw new XPathException(e);
            }
        }
        return null;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
        this.setCompileWithTracing(traceListener != null);
        this.internalSetBooleanProperty(2, "http://saxon.sf.net/feature/allow-multithreading", false);
    }

    public void setTraceListenerClass(String className) {
        if (className == null) {
            this.traceListenerClass = null;
            this.setCompileWithTracing(false);
        } else {
            try {
                this.makeTraceListener(className);
            }
            catch (XPathException err) {
                throw new IllegalArgumentException(className + ": " + err.getMessage());
            }
            this.traceListenerClass = className;
            this.setCompileWithTracing(true);
        }
    }

    public String getTraceListenerClass() {
        return this.traceListenerClass;
    }

    public void setTraceListenerOutputFile(String filename) {
        this.traceListenerOutput = filename;
    }

    public String getTraceListenerOutputFile() {
        return this.traceListenerOutput;
    }

    public boolean isCompileWithTracing() {
        return this.getBooleanProperty(Feature.COMPILE_WITH_TRACING);
    }

    public void setCompileWithTracing(boolean trace) {
        this.internalSetBooleanProperty(12, "http://saxon.sf.net/feature/compile-with-tracing", trace);
        if (this.defaultXsltCompilerInfo != null) {
            if (trace) {
                this.defaultXsltCompilerInfo.setCodeInjector(new XSLTTraceCodeInjector(){

                    @Override
                    protected boolean isApplicable(Expression exp) {
                        return exp instanceof FunctionCall || super.isApplicable(exp);
                    }
                });
            } else {
                this.defaultXsltCompilerInfo.setCodeInjector(null);
            }
        }
        if (this.defaultStaticQueryContext != null) {
            if (trace) {
                this.defaultStaticQueryContext.setCodeInjector(new TraceCodeInjector(){

                    @Override
                    protected boolean isApplicable(Expression exp) {
                        boolean appl = exp.isInstruction() || exp instanceof LetExpression || exp instanceof FixedAttribute || exp instanceof FixedElement || exp instanceof FunctionCall || exp instanceof Choose;
                        return appl;
                    }

                    @Override
                    public void process(TraceableComponent component) {
                        Expression newBody = ExpressionToolUtil.injectCodeXQuery(component.getBody(), this);
                        component.setBody(newBody);
                        ComponentTracer trace = new ComponentTracer(component);
                        component.setBody(trace);
                    }
                });
            } else {
                this.getDefaultStaticQueryContext().setCodeInjector(trace ? new XQueryTraceCodeInjector() : null);
            }
        }
    }

    public TraceListener makeTraceListener(String className) throws XPathException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (obj instanceof TraceListener) {
            String destination = this.getTraceListenerOutputFile();
            if (destination != null) {
                try {
                    ((TraceListener)obj).setOutputDestination(new StandardLogger(new PrintStream(destination)));
                }
                catch (FileNotFoundException e) {
                    throw new XPathException(e);
                }
            }
            return (TraceListener)obj;
        }
        throw new XPathException("Class " + className + " is not a TraceListener");
    }

    public BuiltInFunctionSet getXSLTFunctionSet(int version) {
        if (version == 20) {
            return XPath20FunctionSet.getInstance();
        }
        if (version == 30 || version == 31 || version == 305) {
            return XSLT30FunctionSet.getInstance();
        }
        if (version == 40) {
            throw new IllegalArgumentException("XSLT 4.0 requires Saxon-PE or higher");
        }
        throw new IllegalArgumentException("Unsupported function library version " + version + " (must be 20|30|31|40)");
    }

    public BuiltInFunctionSet getXPathFunctionSet(int version) {
        switch (version) {
            case 20: {
                return XPath20FunctionSet.getInstance();
            }
            case 30: 
            case 305: {
                return XPath30FunctionSet.getInstance();
            }
            case 31: {
                return XPath31FunctionSet.getInstance();
            }
            case 40: {
                throw new IllegalArgumentException("Version 4.0 requires Saxon-PE or higher");
            }
        }
        return XPath31FunctionSet.getInstance();
    }

    public BuiltInFunctionSet getXQueryUpdateFunctionSet() {
        return null;
    }

    public SystemFunction makeSystemFunction(String localName, int arity, int xpathVersion) {
        try {
            return this.getXSLTFunctionSet(xpathVersion == 31 ? 30 : xpathVersion).makeFunction(localName, arity);
        }
        catch (XPathException e) {
            return null;
        }
    }

    public SystemFunction makeSystemFunction40(String localName, int arity) {
        return this.makeSystemFunction(localName, arity, 40);
    }

    public void registerExtensionFunction(ExtensionFunctionDefinition function) {
        this.integratedFunctionLibrary.registerFunction(function);
    }

    public IntegratedFunctionLibrary getIntegratedFunctionLibrary() {
        return this.integratedFunctionLibrary;
    }

    public synchronized FunctionLibraryList getBuiltInExtensionLibraryList(int version) {
        FunctionLibraryList result;
        if (version != 40) {
            version = 31;
        }
        if ((result = this.builtInExtensionLibraryList.get(version)) == null) {
            result = this.makeBuiltInExtensionLibraryList(version);
            this.builtInExtensionLibraryList.put(version, result);
        }
        return result;
    }

    public synchronized UseWhen30FunctionSet getUseWhenFunctionLibrary(int version) {
        return UseWhen30FunctionSet.getInstance(version);
    }

    protected FunctionLibraryList makeBuiltInExtensionLibraryList(int version) {
        FunctionLibraryList result = new FunctionLibraryList();
        result.addFunctionLibrary(VendorFunctionSetHE.getInstance());
        result.addFunctionLibrary(MathFunctionSet.getInstance());
        result.addFunctionLibrary(MapFunctionSet.getInstance(version));
        result.addFunctionLibrary(ArrayFunctionSet.getInstance(version));
        result.addFunctionLibrary(ExsltCommonFunctionSet.getInstance());
        return result;
    }

    public BuiltInFunctionSet getVendorFunctionSet() {
        return VendorFunctionSetHE.getInstance();
    }

    public SystemFunction bindSaxonExtensionFunction(String localName, int arity) throws XPathException {
        throw new UnsupportedOperationException("The extension function saxon:" + localName + "#" + arity + " requires Saxon-PE or higher");
    }

    public void addExtensionBinders(FunctionLibraryList list) {
    }

    public FunctionLibrary loadStubFunctionLibrary(StreamSource jsonSignatures) throws XPathException {
        throw new UnsupportedOperationException();
    }

    public FunctionItem getSystemFunction(StructuredQName name, int arity) {
        try {
            FunctionLibrary lib;
            if (this.staticContextForSystemFunctions == null) {
                this.staticContextForSystemFunctions = new IndependentContext(this);
            }
            NamespaceUri ns = name.getNamespaceUri();
            int version = this.getDefaultStaticQueryContext().getLanguageVersion();
            if (ns.equals(NamespaceUri.FN)) {
                lib = this.getXPathFunctionSet(version);
            } else if (ns.equals(NamespaceUri.SCHEMA)) {
                lib = new ConstructorFunctionLibrary(this);
            } else if (ns.equals(NamespaceUri.MATH)) {
                lib = MathFunctionSet.getInstance();
            } else if (ns.equals(NamespaceUri.MAP_FUNCTIONS)) {
                lib = MapFunctionSet.getInstance(version);
            } else if (ns.equals(NamespaceUri.ARRAY_FUNCTIONS)) {
                lib = ArrayFunctionSet.getInstance(version);
            } else {
                FunctionLibraryList fll = new FunctionLibraryList();
                fll.addFunctionLibrary(this.getBuiltInExtensionLibraryList(31));
                fll.addFunctionLibrary(new ConstructorFunctionLibrary(this));
                fll.addFunctionLibrary(this.getIntegratedFunctionLibrary());
                lib = fll;
            }
            SymbolicName.F symbolicName = new SymbolicName.F(name, arity);
            return lib.getFunctionItem(symbolicName, this.staticContextForSystemFunctions);
        }
        catch (XPathException e) {
            return null;
        }
    }

    public UserFunction newUserFunction(boolean memoFunction, FunctionStreamability streamability) {
        if (memoFunction) {
            return new MemoFunction();
        }
        return new UserFunction();
    }

    public void registerCollation(String collationURI, StringCollator collator) {
        this.collationMap.put(collationURI, collator);
    }

    public void setCollationURIResolver(CollationURIResolver resolver) {
        this.collationResolver = resolver;
    }

    public CollationURIResolver getCollationURIResolver() {
        return this.collationResolver;
    }

    public StringCollator getCollation(String collationName) throws XPathException {
        if (collationName == null || collationName.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        if (collationName.equals("http://www.w3.org/2005/xpath-functions/collation/html-ascii-case-insensitive")) {
            return HTML5CaseBlindCollator.getInstance();
        }
        if (collationName.startsWith("http://saxon.sf.net/collation/alphaNumeric?base=")) {
            return new AlphanumericCollator(this.getCollation(collationName.substring("http://saxon.sf.net/collation/alphaNumeric?base=".length())));
        }
        StringCollator collator = this.collationMap.get(collationName);
        if (collator == null) {
            collator = this.getCollationURIResolver().resolve(collationName, this);
        }
        return collator;
    }

    public StringCollator getCollation(String collationURI, String baseURI) throws XPathException {
        if (collationURI.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        try {
            String absoluteURI = ResolveURI.makeAbsolute(collationURI, baseURI).toString();
            return this.getCollation(absoluteURI);
        }
        catch (URISyntaxException e) {
            throw new XPathException("Collation name is not a valid URI: " + collationURI + " (base = " + baseURI + ")", "FOCH0002");
        }
    }

    public StringCollator getCollation(String collationURI, String baseURI, String errorCode) throws XPathException {
        if (collationURI.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        try {
            StringCollator collator;
            String absoluteURI = collationURI;
            if (baseURI != null) {
                absoluteURI = ResolveURI.makeAbsolute(collationURI, baseURI).toString();
            }
            if ((collator = this.getCollation(absoluteURI)) == null) {
                throw new XPathException("Unknown collation " + absoluteURI, errorCode);
            }
            return collator;
        }
        catch (URISyntaxException e) {
            throw new XPathException("Collation name is not a valid URI: " + collationURI + " (base = " + baseURI + ")", errorCode);
        }
    }

    public String getDefaultCollationName() {
        return this.defaultCollationName;
    }

    public void setDefaultCollection(String uri) {
        this.defaultCollection = uri;
    }

    public String getDefaultCollection() {
        return this.defaultCollection;
    }

    public void setCollectionFinder(CollectionFinder cf) {
        this.collectionFinder = cf;
    }

    public CollectionFinder getCollectionFinder() {
        return this.collectionFinder;
    }

    public void registerCollection(String collectionURI, ResourceCollection collection) {
        this.registeredCollections.put(collectionURI, collection);
    }

    public ResourceCollection getRegisteredCollection(String uri) {
        return this.registeredCollections.get(uri);
    }

    public void registerFileExtension(String extension, String mediaType) {
        this.fileExtensions.put(extension, mediaType);
    }

    public void registerMediaType(String contentType, ResourceFactory factory) {
        this.resourceFactoryMapping.put(contentType, factory);
    }

    public String getMediaTypeForFileExtension(String extension) {
        String mediaType = this.fileExtensions.get(extension);
        if (mediaType == null) {
            mediaType = this.fileExtensions.get("");
        }
        return mediaType;
    }

    public ResourceFactory getResourceFactoryForMediaType(String mediaType) {
        return this.resourceFactoryMapping.get(mediaType);
    }

    public void setLocalizerFactory(LocalizerFactory factory) {
        this.localizerFactory = factory;
    }

    public LocalizerFactory getLocalizerFactory() {
        return this.localizerFactory;
    }

    public void setDefaultLanguage(String language) {
        ValidationFailure vf = StringConverter.StringToLanguage.INSTANCE.validate(StringView.of(language).tidy());
        if (vf != null) {
            throw new IllegalArgumentException("The default language must be a valid language code");
        }
        this.defaultLanguage = language;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultCountry(String country) {
        this.defaultCountry = country;
    }

    public String getDefaultCountry() {
        return this.defaultCountry;
    }

    public void setDefaultRegexEngine(String engine) {
        if (!("J".equals(engine) || "N".equals(engine) || "S".equals(engine))) {
            throw new IllegalArgumentException("Regex engine must be S|J|N");
        }
        this.defaultRegexEngine = engine;
    }

    public String getDefaultRegexEngine() {
        return this.defaultRegexEngine;
    }

    public RegularExpression compileRegularExpression(UnicodeString regex, String flags, String hostLanguage, List<String> warnings) throws XPathException {
        return Version.platform.compileRegularExpression(this, regex, flags, hostLanguage, warnings);
    }

    public Numberer makeNumberer(String language, String country) {
        if (this.localizerFactory == null) {
            Numberer_en numberer = new Numberer_en();
            if (language != null) {
                numberer.setLanguage(language);
            }
            if (country != null) {
                numberer.setCountry(country);
            }
            return numberer;
        }
        Numberer numberer = this.localizerFactory.getNumberer(language, country);
        if (numberer == null) {
            numberer = new Numberer_en();
        }
        return numberer;
    }

    public void setModuleURIResolver(ModuleURIResolver resolver) {
        this.getDefaultStaticQueryContext().setModuleURIResolver(resolver);
    }

    public void setModuleURIResolver(String className) throws TransformerException {
        Object obj = this.dynamicLoader.getInstance(className, null);
        if (obj instanceof ModuleURIResolver) {
            if (obj instanceof StandardModuleURIResolver) {
                ((StandardModuleURIResolver)obj).setConfiguration(this);
            }
        } else {
            throw new XPathException("Class " + className + " is not a ModuleURIResolver");
        }
        this.setModuleURIResolver((ModuleURIResolver)obj);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.getDefaultStaticQueryContext().getModuleURIResolver();
    }

    public ModuleURIResolver getStandardModuleURIResolver() {
        return this.standardModuleURIResolver;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.unparsedTextURIResolver;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver resolver) {
        this.unparsedTextURIResolver = resolver;
    }

    public CompilerInfo getDefaultXsltCompilerInfo() {
        return this.defaultXsltCompilerInfo;
    }

    public StaticQueryContext getDefaultStaticQueryContext() {
        if (this.defaultStaticQueryContext == null) {
            this.defaultStaticQueryContext = this.makeStaticQueryContext(false);
        }
        return this.defaultStaticQueryContext;
    }

    protected StaticQueryContext makeStaticQueryContext(boolean copyFromDefault) {
        return this.staticQueryContextFactory.newStaticQueryContext(this, copyFromDefault);
    }

    public void registerFunctionAnnotationHandler(FunctionAnnotationHandler handler) {
        this.functionAnnotationHandlers.put(handler.getAssertionNamespace(), handler);
    }

    public FunctionAnnotationHandler getFunctionAnnotationHandler(NamespaceUri namespace) {
        return this.functionAnnotationHandlers.get(namespace);
    }

    public boolean isStreamabilityEnabled() {
        return false;
    }

    public String getSourceParserClass() {
        return this.sourceParserClass;
    }

    public void setSourceParserClass(String sourceParserClass) {
        this.sourceParserClass = sourceParserClass;
    }

    public String getStyleParserClass() {
        return this.styleParserClass;
    }

    public void setStyleParserClass(String parser) {
        this.styleParserClass = parser;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.defaultXsltCompilerInfo.getOutputURIResolver();
    }

    @Deprecated
    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.defaultXsltCompilerInfo.setOutputURIResolver(outputURIResolver);
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this.serializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public CharacterSetFactory getCharacterSetFactory() {
        if (this.characterSetFactory == null) {
            this.characterSetFactory = new CharacterSetFactory();
        }
        return this.characterSetFactory;
    }

    public void setDefaultSerializationProperties(Properties props) {
        this.defaultOutputProperties = props;
    }

    public Properties getDefaultSerializationProperties() {
        return this.defaultOutputProperties;
    }

    public SerializationProperties obtainDefaultSerializationProperties() {
        return new SerializationProperties(this.defaultOutputProperties);
    }

    public void processResultDocument(ResultDocument instruction, PushEvaluator content, XPathContext context) throws XPathException {
        instruction.processInstruction(content, context);
    }

    public SequenceIterator getMultithreadedItemMappingIterator(SequenceIterator base, ItemMappingFunction action) throws XPathException {
        return new ItemMappingIterator(base, action);
    }

    public boolean isTiming() {
        return this.enabledProperties.contains(77);
    }

    public void setTiming(boolean timing) {
        if (timing) {
            this.enabledProperties.add(77);
        } else {
            this.enabledProperties.remove(77);
        }
    }

    @Deprecated
    public boolean isVersionWarning() {
        return false;
    }

    @Deprecated
    public void setVersionWarning(boolean warn) {
    }

    public boolean isValidation() {
        return this.defaultParseOptions.getDTDValidationMode() == 1 || this.defaultParseOptions.getDTDValidationMode() == 2;
    }

    public void setValidation(boolean validation) {
        this.defaultParseOptions = this.defaultParseOptions.withDTDValidationMode(validation ? 1 : 4);
    }

    public FilterFactory makeDocumentProjector(PathMap.PathMapRoot map) {
        throw new UnsupportedOperationException("Document projection requires Saxon-EE");
    }

    public FilterFactory makeDocumentProjector(XQueryExpression exp) {
        throw new UnsupportedOperationException("Document projection requires Saxon-EE");
    }

    public int getSchemaValidationMode() {
        return this.defaultParseOptions.getSchemaValidationMode();
    }

    public void setSchemaValidationMode(int validationMode) {
        this.defaultParseOptions = this.defaultParseOptions.withSchemaValidationMode(validationMode);
    }

    public void setValidationWarnings(boolean warn) {
        this.defaultParseOptions = this.defaultParseOptions.withContinueAfterValidationErrors(warn);
    }

    public boolean isValidationWarnings() {
        return this.defaultParseOptions.isContinueAfterValidationErrors();
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.defaultParseOptions = this.defaultParseOptions.withExpandAttributeDefaults(expand);
    }

    public boolean isExpandAttributeDefaults() {
        return this.defaultParseOptions.isExpandAttributeDefaults();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setNamePool(NamePool targetNamePool) {
        this.namePool = targetNamePool;
    }

    public TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new TypeHierarchy(this);
        }
        return this.typeHierarchy;
    }

    public TypeChecker getTypeChecker(boolean backwardsCompatible) {
        if (backwardsCompatible) {
            return this.typeChecker10;
        }
        return this.typeChecker;
    }

    public TypeAliasManager makeTypeAliasManager() {
        return new TypeAliasManager();
    }

    public DocumentNumberAllocator getDocumentNumberAllocator() {
        return this.documentNumberAllocator;
    }

    public void setDocumentNumberAllocator(DocumentNumberAllocator allocator) {
        this.documentNumberAllocator = allocator;
    }

    public boolean isCompatible(Configuration other) {
        return this.namePool == other.namePool && this.documentNumberAllocator == other.documentNumberAllocator;
    }

    public DocumentPool getGlobalDocumentPool() {
        return this.globalDocumentPool;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.defaultParseOptions.getSpaceStrippingRule() == AllElementsSpaceStrippingRule.getInstance();
    }

    public XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        XMLReader parser;
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ConcurrentLinkedQueue();
        }
        if ((parser = this.sourceParserPool.poll()) != null) {
            return parser;
        }
        if (this.getSourceParserClass() != null) {
            parser = this.makeParser(this.getSourceParserClass());
        } else {
            Maker<XMLReader> xmlReaderMaker = this.getParseOptions().getXMLReaderMaker();
            if (xmlReaderMaker != null) {
                try {
                    parser = xmlReaderMaker.make();
                }
                catch (XPathException xPathException) {
                    // empty catch block
                }
            }
            if (parser == null) {
                parser = Configuration.loadParser();
            }
        }
        EntityResolver2 resolver = new EntityResolverWrappingResourceResolver(this.getResourceResolver());
        if (parser.getEntityResolver() != null) {
            resolver = new ChainedEntityResolver(parser.getEntityResolver(), resolver);
        }
        parser.setEntityResolver(resolver);
        if (this.isTiming()) {
            this.reportParserDetails(parser);
        }
        try {
            ActiveSAXSource.configureParser(parser);
        }
        catch (XPathException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        try {
            parser.setFeature("http://xml.org/sax/features/validation", this.isValidation());
        }
        catch (SAXException err) {
            throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
        }
        return parser;
    }

    private void reportParserDetails(XMLReader reader) {
        String name = reader.getClass().getName();
        this.traceOutput.info("Using parser " + name);
    }

    public synchronized void reuseSourceParser(XMLReader parser) {
        if (this.sourceParserPool == null) {
            this.sourceParserPool = new ConcurrentLinkedQueue();
        }
        try {
            try {
                parser.setContentHandler(null);
                if (parser.getEntityResolver() == this.defaultParseOptions.getEntityResolver()) {
                    parser.setEntityResolver(null);
                }
                parser.setDTDHandler(null);
                parser.setErrorHandler(null);
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", dummyLexicalHandler);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
            this.sourceParserPool.offer(parser);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static XMLReader loadParser() {
        return Version.platform.loadParser();
    }

    public synchronized XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        XMLReader parser;
        if (this.styleParserPool == null) {
            this.styleParserPool = new ConcurrentLinkedQueue();
        }
        if ((parser = this.styleParserPool.poll()) != null) {
            return parser;
        }
        parser = this.getStyleParserClass() != null ? this.makeParser(this.getStyleParserClass()) : Configuration.loadParser();
        EntityResolver2 resolver = new EntityResolverWrappingResourceResolver(this.getResourceResolver());
        if (parser.getEntityResolver() != null) {
            resolver = new ChainedEntityResolver(resolver, parser.getEntityResolver());
        }
        parser.setEntityResolver(resolver);
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new TransformerFactoryConfigurationError(e);
        }
        return parser;
    }

    public synchronized void reuseStyleParser(XMLReader parser) {
        if (this.styleParserPool == null) {
            this.styleParserPool = new ConcurrentLinkedQueue();
        }
        try {
            try {
                parser.setContentHandler(null);
                parser.setDTDHandler(null);
                parser.setErrorHandler(null);
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", dummyLexicalHandler);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
            this.styleParserPool.offer(parser);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadSchema(String absoluteURI) throws SchemaException {
        this.readSchema(this.makePipelineConfiguration(), "", absoluteURI, null);
    }

    public NamespaceUri readSchema(PipelineConfiguration pipe, String baseURI, String schemaLocation, NamespaceUri expected) throws SchemaException {
        this.needEnterpriseEdition();
        return null;
    }

    public void readMultipleSchemas(PipelineConfiguration pipe, String baseURI, List<String> schemaLocations, NamespaceUri expected) throws SchemaException {
        this.needEnterpriseEdition();
    }

    public NamespaceUri readInlineSchema(NodeInfo root, NamespaceUri expected, ErrorReporter errorReporter) throws SchemaException {
        this.needEnterpriseEdition();
        return null;
    }

    protected void needEnterpriseEdition() {
        throw new UnsupportedOperationException("You need the Enterprise Edition of Saxon (with an EnterpriseConfiguration) for this operation");
    }

    public void addSchemaSource(Source schemaSource) throws SchemaException {
        this.addSchemaSource(schemaSource, this.makeErrorReporter());
    }

    public void addSchemaSource(Source schemaSource, ErrorReporter errorReporter) throws SchemaException {
        this.needEnterpriseEdition();
    }

    public void addSchemaForBuiltInNamespace(NamespaceUri namespace) {
    }

    public boolean isSchemaAvailable(NamespaceUri targetNamespace) {
        return false;
    }

    public void clearSchemaCache() {
    }

    public Set<NamespaceUri> getImportedNamespaces() {
        return Collections.emptySet();
    }

    public void sealNamespace(NamespaceUri namespace) {
    }

    public Collection<GlobalParam> getDeclaredSchemaParameters() {
        return null;
    }

    public Iterable<? extends SchemaType> getExtensionsOfType(SchemaType type) {
        return Collections.emptyList();
    }

    public void importComponents(Source source) throws XPathException {
        this.needEnterpriseEdition();
    }

    public void exportComponents(Receiver out) throws XPathException {
        this.needEnterpriseEdition();
    }

    public SchemaDeclaration getElementDeclaration(int fingerprint) {
        return null;
    }

    public SchemaDeclaration getElementDeclaration(StructuredQName qName) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(int fingerprint) {
        return null;
    }

    public SchemaDeclaration getAttributeDeclaration(StructuredQName attributeName) {
        return null;
    }

    public SchemaType getSchemaType(StructuredQName name) {
        if (name.hasURI(NamespaceUri.SCHEMA)) {
            return BuiltInType.getSchemaTypeByLocalName(name.getLocalPart());
        }
        return null;
    }

    public ItemType makeUserUnionType(List<AtomicType> memberTypes) {
        return null;
    }

    @Override
    public boolean isDeclaredNotation(NamespaceUri uri, String local) {
        return false;
    }

    public void checkTypeDerivationIsOK(SchemaType derived, SchemaType base, int block) throws SchemaException {
    }

    public void prepareValidationReporting(XPathContext context, ParseOptions options) {
    }

    public Receiver getDocumentValidator(Receiver receiver, String systemId, ParseOptions validationOptions, Location initiatingLocation) {
        return receiver;
    }

    public Receiver getElementValidator(Receiver receiver, ParseOptions validationOptions, Location locationId) throws XPathException {
        return receiver;
    }

    public SimpleType validateAttribute(StructuredQName nodeName, UnicodeString value, int validation) throws ValidationException, MissingComponentException {
        return BuiltInAtomicType.UNTYPED_ATOMIC;
    }

    public Receiver getAnnotationStripper(Receiver destination) {
        return destination;
    }

    public XMLReader makeParser(String className) throws TransformerFactoryConfigurationError {
        try {
            if (className.equals("#DEFAULT")) {
                return Version.platform.loadParserForXmlFragments();
            }
            Object obj = this.dynamicLoader.getInstance(className, null);
            if (obj instanceof XMLReader) {
                return (XMLReader)obj;
            }
            if (obj instanceof SAXParserFactory) {
                try {
                    SAXParser saxParser = ((SAXParserFactory)obj).newSAXParser();
                    return saxParser.getXMLReader();
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new XPathException(e);
                }
            }
        }
        catch (XPathException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        throw new TransformerFactoryConfigurationError("Class " + className + " is not a SAX2 XMLReader or SAXParserFactory");
    }

    public XPathParser newExpressionParser(String language, boolean updating, StaticContext env) throws XPathException {
        if ("XQ".equals(language)) {
            if (updating) {
                throw new XPathException("XQuery Update is supported only in Saxon-EE");
            }
            return new XQueryParser(env);
        }
        if ("XP".equals(language)) {
            return new XPathParser(env);
        }
        if ("PATTERN".equals(language)) {
            return new PatternParser(env);
        }
        throw new XPathException("Unknown expression language " + language);
    }

    public ExpressionPresenter newExpressionExporter(String target, OutputStream destination, StylesheetPackage rootPackage) throws XPathException {
        throw new XPathException("Exporting a stylesheet requires Saxon-EE");
    }

    public void setDebugger(Debugger debugger) {
        this.debugger = debugger;
    }

    public Debugger getDebugger() {
        return this.debugger;
    }

    public SlotManager makeSlotManager() {
        if (this.debugger == null) {
            return new SlotManager();
        }
        return this.debugger.makeSlotManager();
    }

    public Receiver makeStreamingTransformer(Mode mode, ParameterSet ordinaryParams, ParameterSet tunnelParams, Outputter output, XPathContext context) throws XPathException {
        throw new XPathException("Streaming is only available in Saxon-EE");
    }

    public Expression makeStreamInstruction(Expression hrefExp, Expression body, boolean streaming, ParseOptions options, PackageData packageData, Location location, RetainedStaticContext rsc) throws XPathException {
        SourceDocument si = new SourceDocument(hrefExp, body, options);
        si.setLocation(location);
        si.setRetainedStaticContext(rsc);
        return si;
    }

    public Function<SequenceIterator, FocusTrackingIterator> getFocusTrackerFactory(Executable exec, boolean multithreaded) {
        return CSharp.constructorRef(FocusTrackingIterator::new, 1);
    }

    public void checkStrictStreamability(XSLTemplate template, Expression body) throws XPathException {
    }

    public boolean isStreamedNode(NodeInfo node) {
        return false;
    }

    public OptimizerOptions getOptimizerOptions() {
        return this.optimizerOptions.intersect(OptimizerOptions.FULL_HE_OPTIMIZATION);
    }

    public OptimizerOptions getPermittedOptimizerOptions() {
        return OptimizerOptions.FULL_HE_OPTIMIZATION;
    }

    public Optimizer obtainOptimizer() {
        if (this.optimizer == null) {
            this.optimizer = new Optimizer(this);
            this.optimizer.setOptimizerOptions(this.optimizerOptions.intersect(OptimizerOptions.FULL_HE_OPTIMIZATION));
            return this.optimizer;
        }
        return this.optimizer;
    }

    public Optimizer obtainOptimizer(OptimizerOptions options) {
        Optimizer optimizer = new Optimizer(this);
        optimizer.setOptimizerOptions(options.intersect(OptimizerOptions.FULL_HE_OPTIMIZATION));
        return optimizer;
    }

    public ContextItemStaticInfo makeContextItemStaticInfo(ItemType itemType, boolean maybeUndefined) {
        return new ContextItemStaticInfo(itemType, maybeUndefined);
    }

    public ContextItemStaticInfo getDefaultContextItemStaticInfo() {
        return ContextItemStaticInfo.DEFAULT;
    }

    public XQueryExpression makeXQueryExpression(Expression exp, QueryModule mainModule, boolean streaming) throws XPathException {
        XQueryExpression xqe = new XQueryExpression(exp, mainModule, false);
        if (mainModule.getCodeInjector() != null) {
            mainModule.getCodeInjector().process(xqe);
        }
        return xqe;
    }

    public GroundedValue makeSequenceExtent(Expression expression, int ref, XPathContext context) throws XPathException {
        try {
            return SequenceTool.toGroundedValue(expression.iterate(context));
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }

    public StyleNodeFactory makeStyleNodeFactory(Compilation compilation) {
        return new StyleNodeFactory(this, compilation);
    }

    public Expression makeEvaluateInstruction(XSLEvaluate source, ComponentDeclaration decl) throws XPathException {
        Expression xpath = source.getTargetExpression();
        SequenceType requiredType = source.getRequiredType();
        Expression contextItem = source.getContextItemExpression();
        Expression baseUri = source.getBaseUriExpression();
        Expression namespaceContext = source.getNamespaceContextExpression();
        Expression schemaAware = source.getSchemaAwareExpression();
        Expression withParams = source.getWithParamsExpression();
        EvaluateInstr inst = new EvaluateInstr(xpath, requiredType, contextItem, baseUri, namespaceContext, schemaAware);
        WithParam[] params = source.getWithParamInstructions(inst, source.getCompilation(), decl, false);
        inst.setActualParams(params);
        inst.setDynamicParams(withParams);
        inst.setDefaultXPathNamespace(source.getDefaultXPathNamespace());
        inst.setOptionsExpression(source.getOptionsExpression());
        return inst;
    }

    public StylesheetPackage makeStylesheetPackage() {
        return new StylesheetPackage(this);
    }

    public AccumulatorRegistry makeAccumulatorRegistry() {
        return new AccumulatorRegistry();
    }

    public void registerExternalObjectModel(ExternalObjectModel model) {
        if (this.externalObjectModels == null) {
            this.externalObjectModels = new ArrayList<ExternalObjectModel>(4);
        }
        if (!this.externalObjectModels.contains(model)) {
            this.externalObjectModels.add(model);
        }
    }

    public void deregisterExternalObjectModel(ExternalObjectModel model) {
        ArrayList<ExternalObjectModel> newList = new ArrayList<ExternalObjectModel>(this.externalObjectModels.size());
        for (ExternalObjectModel existing : this.externalObjectModels) {
            if (existing == model) continue;
            newList.add(existing);
        }
        this.externalObjectModels = newList;
    }

    public void clearExternalObjectModels() {
        this.externalObjectModels = new ArrayList<ExternalObjectModel>();
    }

    public ExternalObjectModel getExternalObjectModel(String uri) {
        for (ExternalObjectModel model : this.externalObjectModels) {
            if (!model.getIdentifyingURI().equals(uri)) continue;
            return model;
        }
        return null;
    }

    public ExternalObjectModel getExternalObjectModel(Class<?> nodeClass) {
        for (ExternalObjectModel model : this.externalObjectModels) {
            PJConverter converter = model.getPJConverter(nodeClass);
            if (converter == null) continue;
            return model;
        }
        return null;
    }

    public List<ExternalObjectModel> getExternalObjectModels() {
        return this.externalObjectModels;
    }

    public Map<String, FunctionItem> makeMethodMap(Class<?> javaClass, String required) {
        throw new UnsupportedOperationException();
    }

    public MapItem externalObjectAsMap(ObjectValue<?> value, String required) {
        throw new UnsupportedOperationException();
    }

    public Expression makeObjectLookupExpression(Expression lhs, Expression rhs) {
        throw new UnsupportedOperationException();
    }

    public NodeInfo unravel(Source source) {
        List<ExternalObjectModel> externalObjectModels = this.getExternalObjectModels();
        if (!(source instanceof NodeInfo)) {
            for (ExternalObjectModel model : externalObjectModels) {
                NodeInfo node = model.unravel(source, this);
                if (node == null) continue;
                if (!node.getConfiguration().isCompatible(this)) {
                    throw new IllegalArgumentException("Externally supplied Node belongs to the wrong Configuration");
                }
                return node;
            }
        }
        NodeInfo suppliedNode = null;
        if (source instanceof NodeInfo) {
            suppliedNode = (NodeInfo)source;
        }
        if (source instanceof NodeSource) {
            suppliedNode = ((NodeSource)source).getNode();
        }
        if (suppliedNode != null) {
            if (!suppliedNode.getConfiguration().isCompatible(this)) {
                throw new IllegalArgumentException("Externally supplied NodeInfo belongs to the wrong Configuration");
            }
            return suppliedNode;
        }
        throw new IllegalArgumentException("A source of class " + source.getClass() + " is not recognized by any registered object model");
    }

    public boolean isExtensionElementAvailable(StructuredQName qName) {
        return false;
    }

    public void setStaticQueryContextFactory(StaticQueryContextFactory factory) {
        this.staticQueryContextFactory = factory;
    }

    public StaticQueryContext newStaticQueryContext() {
        return this.makeStaticQueryContext(true);
    }

    public PendingUpdateList newPendingUpdateList() {
        throw new UnsupportedOperationException("XQuery update is supported only in Saxon-EE");
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipe = new PipelineConfiguration(this, this.defaultParseOptions);
        pipe.setErrorReporter(this.makeErrorReporter());
        return pipe;
    }

    public SchemaURIResolver makeSchemaURIResolver(ResourceResolver resolver) {
        return null;
    }

    public static Configuration getConfiguration(XPathContext context) {
        return context.getConfiguration();
    }

    public void setSourceResolver(SourceResolver resolver) {
        this.sourceResolver = resolver;
    }

    public SourceResolver getSourceResolver() {
        return this.sourceResolver;
    }

    @Override
    public ActiveSource resolveSource(final Source source, final Configuration config) throws XPathException {
        if (source instanceof ActiveSource) {
            return (ActiveSource)source;
        }
        if (source instanceof AugmentedSource) {
            return new ActiveSource(){

                @Override
                public void deliver(Receiver receiver, ParseOptions options) throws XPathException {
                    options = options.merge(((AugmentedSource)source).getParseOptions());
                    Configuration.this.resolveSource(((AugmentedSource)source).getContainedSource(), config).deliver(receiver, options);
                }

                @Override
                public void setSystemId(String systemId) {
                    source.setSystemId(systemId);
                }

                @Override
                public String getSystemId() {
                    return source.getSystemId();
                }
            };
        }
        ActiveSource activeSource = Version.platform.resolveSource(source, config);
        if (activeSource != null) {
            return activeSource;
        }
        List<ExternalObjectModel> externalObjectModels = config.getExternalObjectModels();
        for (ExternalObjectModel model : externalObjectModels) {
            ActiveSource a = model.getActiveSource(source);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public TreeInfo buildDocumentTree(Source source) throws XPathException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (source instanceof AugmentedSource) {
            return this.buildDocumentTree(((AugmentedSource)source).getContainedSource(), ((AugmentedSource)source).getParseOptions());
        }
        return this.buildDocumentTree(source, this.defaultParseOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeInfo buildDocumentTree(Source source, ParseOptions parseOptions) throws XPathException {
        if (source == null) {
            throw new NullPointerException("source");
        }
        boolean finallyClose = false;
        try {
            ParseOptions options = parseOptions;
            ActiveSource src2 = this.resolveSource(source, this);
            if (src2 == null) {
                throw new XPathException("Unknown source class " + source.getClass().getName());
            }
            source = src2;
            if (source instanceof AugmentedSource) {
                options = options.merge(((AugmentedSource)source).getParseOptions());
            }
            options = options.applyDefaults(this);
            finallyClose = options.isPleaseCloseAfterUse();
            TreeModel treeModel = options.getModel();
            boolean lineNumbering = options.isLineNumbering();
            PipelineConfiguration pipe = this.makePipelineConfiguration();
            pipe.setParseOptions(options);
            Builder builder = treeModel.makeBuilder(pipe);
            builder.setTiming(this.isTiming());
            builder.setLineNumbering(lineNumbering);
            builder.setPipelineConfiguration(pipe);
            builder.setSystemId(source.getSystemId());
            Sender.send(source, builder, options);
            NodeInfo newdoc = builder.getCurrentRoot();
            if (newdoc.getNodeKind() != 9) {
                throw new XPathException("Source object represents a node other than a document node");
            }
            builder.reset();
            TreeInfo treeInfo = newdoc.getTreeInfo();
            return treeInfo;
        }
        finally {
            if (finallyClose) {
                ParseOptions.close(source);
            }
        }
    }

    public TreeStatistics getTreeStatistics() {
        return this.treeStatistics;
    }

    public Receiver makeEmitter(String eqName, Properties props) throws XPathException {
        Object handler;
        StructuredQName sqName = StructuredQName.fromEQName(eqName);
        String className = sqName.getLocalPart();
        try {
            handler = this.dynamicLoader.getInstance(className, null);
        }
        catch (XPathException e) {
            throw new XPathException("Cannot create user-supplied output method. " + e.getMessage(), "SXCH0004");
        }
        if (handler instanceof Receiver) {
            return (Receiver)handler;
        }
        if (handler instanceof ContentHandler) {
            return ContentHandlerProxy.makeInstance((ContentHandler)handler, props);
        }
        throw new XPathException("Output method " + className + " is neither a Receiver nor a SAX2 ContentHandler");
    }

    public void setConfigurationProperty(String name, Object value) {
        if (FeatureIndex.exists(name)) {
            this.setFeature(FeatureIndex.getData(name), value);
        } else if (name.startsWith("http://saxon.sf.net/feature/parserFeature?uri=")) {
            String uri = name.substring("http://saxon.sf.net/feature/parserFeature?uri=".length());
            try {
                uri = URLDecoder.decode(uri, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
            this.defaultParseOptions = this.defaultParseOptions.withParserFeature(uri, Configuration.requireBoolean(name, value));
        } else if (name.startsWith("http://saxon.sf.net/feature/parserProperty?uri=")) {
            String uri = name.substring("http://saxon.sf.net/feature/parserProperty?uri=".length());
            try {
                uri = URLDecoder.decode(uri, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(e);
            }
            this.defaultParseOptions = this.defaultParseOptions.withParserProperty(uri, value);
        } else if (name.equals("STOP_HANDLER")) {
            this.transformationStopper = value;
        } else {
            throw new IllegalArgumentException("Unrecognized configuration feature: " + name);
        }
    }

    public <T> void setConfigurationProperty(Feature<T> feature, T value) {
        this.setFeature(FeatureIndex.getData(feature.code), value);
    }

    protected void setFeature(FeatureData feature, Object value) {
        String name = feature.uri;
        int code = feature.code;
        if (booleanFeatures.contains(code)) {
            if (code == 12) {
                boolean b = Configuration.requireBoolean(name, value);
                this.setCompileWithTracing(b);
            } else if (code == 24) {
                boolean b = Configuration.requireBoolean(name, value);
                this.setValidation(b);
            } else if (code == 31) {
                boolean b = Configuration.requireBoolean(name, value);
                this.setExpandAttributeDefaults(b);
            } else if (code == 4) {
                boolean b = Configuration.requireBoolean(name, value);
                this.defaultXsltCompilerInfo.setXsltVersion(b ? 40 : 30);
                this.getDefaultStaticQueryContext().setLanguageVersion(b ? 40 : 30);
            }
            this.internalSetBooleanProperty(code, name, value);
        } else if (stringFeatures.contains(code)) {
            this.stringProperties.put(code, this.requireString(name, value));
        } else {
            block2 : switch (code) {
                case 124: {
                    this.protocolRestrictor = new ProtocolRestrictor((String)value);
                    throw new IllegalArgumentException("ALLOWED_PROTOCOLS feature is not supported");
                }
                case 6: {
                    if (!(value instanceof CollationURIResolver)) {
                        throw new IllegalArgumentException("COLLATION_URI_RESOLVER value must be an instance of net.sf.saxon.lib.CollationURIResolver");
                    }
                    this.setCollationURIResolver((CollationURIResolver)value);
                    break;
                }
                case 7: {
                    this.setCollationURIResolver((CollationURIResolver)this.instantiateClassName(name, value, CollationURIResolver.class));
                    break;
                }
                case 8: {
                    if (!(value instanceof CollectionFinder)) {
                        throw new IllegalArgumentException("COLLECTION_FINDER value must be an instance of net.sf.saxon.lib.ICollectionFinder");
                    }
                    this.setCollectionFinder((CollectionFinder)value);
                    break;
                }
                case 9: {
                    this.setCollectionFinder((CollectionFinder)this.instantiateClassName(name, value, CollectionFinder.class));
                    break;
                }
                case 17: {
                    this.defaultCollationName = value.toString();
                    break;
                }
                case 18: {
                    this.setDefaultCollection(value.toString());
                    break;
                }
                case 19: {
                    this.setDefaultCountry(value.toString());
                    break;
                }
                case 20: {
                    this.setDefaultLanguage(value.toString());
                    break;
                }
                case 21: {
                    this.setDefaultRegexEngine(value.toString());
                    break;
                }
                case 25: {
                    boolean b = Configuration.requireBoolean(name, value);
                    this.defaultParseOptions = b ? this.defaultParseOptions.withDTDValidationMode(2) : this.defaultParseOptions.withDTDValidationMode(this.isValidation() ? 1 : 4);
                    this.internalSetBooleanProperty(code, name, b);
                    break;
                }
                case 27: {
                    if ("".equals(value)) {
                        this.defaultParseOptions = this.defaultParseOptions.withEntityResolver(null);
                        break;
                    }
                    this.defaultParseOptions = this.defaultParseOptions.withEntityResolver((EntityResolver)this.instantiateClassName(name, value, EntityResolver.class));
                    break;
                }
                case 28: {
                    if (!(value instanceof EnvironmentVariableResolver)) {
                        throw new IllegalArgumentException("ENVIRONMENT_VARIABLE_RESOLVER value must be an instance of net.sf.saxon.lib.EnvironmentVariableResolver");
                    }
                    this.environmentVariableResolver = (EnvironmentVariableResolver)value;
                    break;
                }
                case 29: {
                    this.environmentVariableResolver = (EnvironmentVariableResolver)this.instantiateClassName(name, value, EnvironmentVariableResolver.class);
                    break;
                }
                case 30: {
                    break;
                }
                case 38: {
                    boolean b = Configuration.requireBoolean(name, value);
                    this.setLineNumbering(b);
                    break;
                }
                case 41: {
                    break;
                }
                case 42: {
                    if (!(value instanceof ModuleURIResolver)) {
                        throw new IllegalArgumentException("MODULE_URI_RESOLVER value must be an instance of net.sf.saxon.lib.ModuleURIResolver");
                    }
                    this.setModuleURIResolver((ModuleURIResolver)value);
                    break;
                }
                case 43: {
                    ModuleURIResolver resolver = (ModuleURIResolver)this.instantiateClassName(name, value, ModuleURIResolver.class);
                    if (resolver instanceof StandardModuleURIResolver) {
                        ((StandardModuleURIResolver)resolver).setConfiguration(this);
                    }
                    this.setModuleURIResolver(resolver);
                    break;
                }
                case 46: {
                    if (!(value instanceof NamePool)) {
                        throw new IllegalArgumentException("NAME_POOL value must be an instance of net.sf.saxon.om.NamePool");
                    }
                    this.setNamePool((NamePool)value);
                    break;
                }
                case 48: {
                    String s;
                    int v;
                    this.optimizerOptions = value instanceof Integer ? ((v = ((Integer)value).intValue()) == 0 ? new OptimizerOptions(0) : OptimizerOptions.FULL_EE_OPTIMIZATION.intersect(this.getPermittedOptimizerOptions())) : ((s = this.requireString(name, value)).matches("[0-9]+") ? ("0".equals(s) ? new OptimizerOptions(0) : OptimizerOptions.FULL_EE_OPTIMIZATION.intersect(this.getPermittedOptimizerOptions())) : new OptimizerOptions(s).intersect(this.getPermittedOptimizerOptions()));
                    if (this.optimizer != null) {
                        this.optimizer.setOptimizerOptions(this.optimizerOptions);
                    }
                    this.defaultXsltCompilerInfo.setOptimizerOptions(this.optimizerOptions);
                    break;
                }
                case 49: {
                    if (!(value instanceof OutputURIResolver)) {
                        throw new IllegalArgumentException("OUTPUT_URI_RESOLVER value must be an instance of net.sf.saxon.lib.OutputURIResolver");
                    }
                    this.setOutputURIResolver((OutputURIResolver)value);
                    break;
                }
                case 50: {
                    this.setOutputURIResolver((OutputURIResolver)this.instantiateClassName(name, value, OutputURIResolver.class));
                    break;
                }
                case 54: {
                    break;
                }
                case 55: {
                    break;
                }
                case 119: {
                    this.regexBacktrackingLimit = this.requireInteger(name, value);
                    break;
                }
                case 62: {
                    this.setSerializerFactory((SerializerFactory)this.instantiateClassName(name, value, SerializerFactory.class));
                    break;
                }
                case 60: {
                    this.setSchemaValidationMode(this.requireInteger(name, value));
                    break;
                }
                case 61: {
                    String mode = this.requireString(name, value);
                    this.setSchemaValidationMode(Validation.getCode(mode));
                    break;
                }
                case 63: {
                    this.setSourceParserClass(this.requireString(name, value));
                    break;
                }
                case 64: {
                    this.setSourceResolver((SourceResolver)this.instantiateClassName(name, value, SourceResolver.class));
                    break;
                }
                case 67: {
                    try {
                        boolean append = true;
                        boolean autoFlush = true;
                        this.setStandardErrorOutput(new PrintStream(new FileOutputStream((String)value, append), autoFlush));
                        break;
                    }
                    catch (FileNotFoundException fnf) {
                        throw new IllegalArgumentException(fnf);
                    }
                }
                case 71: {
                    SpaceStrippingRule rule;
                    String s;
                    switch (s = this.requireString(name, value)) {
                        case "all": {
                            rule = AllElementsSpaceStrippingRule.getInstance();
                            break;
                        }
                        case "none": {
                            rule = NoElementsSpaceStrippingRule.getInstance();
                            break;
                        }
                        case "ignorable": {
                            rule = IgnorableSpaceStrippingRule.getInstance();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unrecognized value STRIP_WHITESPACE = '" + value + "': must be 'all', 'none', or 'ignorable'");
                        }
                    }
                    this.defaultParseOptions = this.defaultParseOptions.withSpaceStrippingRule(rule);
                    break;
                }
                case 72: {
                    this.setStyleParserClass(this.requireString(name, value));
                    break;
                }
                case 77: {
                    this.setTiming(Configuration.requireBoolean(name, value));
                    break;
                }
                case 79: {
                    if (!(value instanceof TraceListener)) {
                        throw new IllegalArgumentException("TRACE_LISTENER is of wrong class");
                    }
                    this.setTraceListener((TraceListener)value);
                    break;
                }
                case 80: {
                    this.setTraceListenerClass(this.requireString(name, value));
                    break;
                }
                case 81: {
                    this.setTraceListenerOutputFile(this.requireString(name, value));
                    break;
                }
                case 83: {
                    this.setTreeModel(this.requireInteger(name, value));
                    break;
                }
                case 84: {
                    String s;
                    switch (s = this.requireString(name, value)) {
                        case "tinyTree": {
                            this.setTreeModel(1);
                            break block2;
                        }
                        case "tinyTreeCondensed": {
                            this.setTreeModel(2);
                            break block2;
                        }
                        case "linkedTree": {
                            this.setTreeModel(0);
                            break block2;
                        }
                        case "jdom": {
                            this.setTreeModel(3);
                            break block2;
                        }
                        case "jdom2": {
                            this.setTreeModel(4);
                            break block2;
                        }
                    }
                    throw new IllegalArgumentException("Unrecognized value TREE_MODEL_NAME = '" + value + "': must be linkedTree|tinyTree|tinyTreeCondensed");
                }
                case 85: {
                    this.setUnparsedTextURIResolver((UnparsedTextURIResolver)value);
                    break;
                }
                case 86: {
                    this.setUnparsedTextURIResolver((UnparsedTextURIResolver)this.instantiateClassName(name, value, UnparsedTextURIResolver.class));
                    break;
                }
                case 87: {
                    URIResolver u = (URIResolver)this.instantiateClassName(name, value, URIResolver.class);
                    this.setResourceResolver(new ResourceResolverWrappingURIResolver(u));
                    break;
                }
                case 90: {
                    this.defaultParseOptions = this.defaultParseOptions.withUseXsiSchemaLocation(Configuration.requireBoolean(name, value));
                    break;
                }
                case 91: {
                    this.defaultParseOptions = this.defaultParseOptions.withAddCommentsAfterValidationErrors(Configuration.requireBoolean(name, value));
                    break;
                }
                case 92: {
                    this.setValidationWarnings(Configuration.requireBoolean(name, value));
                    break;
                }
                case 93: {
                    break;
                }
                case 94: {
                    this.setXIncludeAware(Configuration.requireBoolean(name, value));
                    break;
                }
                case 120: {
                    int val = this.requireInteger(name, value);
                    if (val != 20 && val != 30 && val != 31) {
                        throw new IllegalArgumentException("XPath version for XSD must be 20 (XPath 2.0), 30 (XPath 3.0), or 31 (XPath 3.1)");
                    }
                    this.xpathVersionForXsd = val;
                    break;
                }
                case 121: {
                    int val = this.requireInteger(name, value);
                    if (val != 20 && val != 30 && val != 305 && val != 31 && val != 40) {
                        throw new IllegalArgumentException("XPath version for XSLT must be 20 (XPath 2.0), 30 (XPath 3.0), 31 (XPath 3.1), or 305 (XPath 3.0 with XSLT-defined extensions), or 40 (XPath 4.0 proposal)");
                    }
                    this.xpathVersionForXslt = val;
                    break;
                }
                case 98: {
                    this.getDefaultStaticQueryContext().setUpdatingEnabled(Configuration.requireBoolean(name, value));
                    break;
                }
                case 99: {
                    this.getDefaultStaticQueryContext().setConstructionMode(Validation.getCode(value.toString()));
                    break;
                }
                case 100: {
                    this.getDefaultStaticQueryContext().setDefaultElementNamespace(NamespaceUri.of(value.toString()));
                    break;
                }
                case 101: {
                    this.getDefaultStaticQueryContext().setDefaultFunctionNamespace(NamespaceUri.of(value.toString()));
                    break;
                }
                case 102: {
                    this.getDefaultStaticQueryContext().setEmptyLeast(Configuration.requireBoolean(name, value));
                    break;
                }
                case 103: {
                    this.getDefaultStaticQueryContext().setInheritNamespaces(Configuration.requireBoolean(name, value));
                    break;
                }
                case 105: {
                    this.getDefaultStaticQueryContext().setPreserveBoundarySpace(Configuration.requireBoolean(name, value));
                    break;
                }
                case 106: {
                    this.getDefaultStaticQueryContext().setPreserveNamespaces(Configuration.requireBoolean(name, value));
                    break;
                }
                case 107: {
                    IndependentContext env = new IndependentContext(this);
                    XPathParser parser = new XPathParser(env);
                    env.setXPathLanguageLevel(31);
                    try {
                        SequenceType type = parser.parseSequenceType(value.toString(), env);
                        if (type.getCardinality() != 16384) {
                            throw new IllegalArgumentException("Context item type must have no occurrence indicator");
                        }
                        this.getDefaultStaticQueryContext().setRequiredContextItemType(type.getPrimaryType());
                        break;
                    }
                    catch (XPathException err) {
                        throw new IllegalArgumentException(err);
                    }
                }
                case 108: {
                    this.getDefaultStaticQueryContext().setSchemaAware(Configuration.requireBoolean(name, value));
                    break;
                }
                case 109: {
                    this.getDefaultStaticQueryContext().setErrorListener((ErrorListener)this.instantiateClassName(name, value, ErrorListener.class));
                    break;
                }
                case 110: {
                    int qvn;
                    switch (value.toString()) {
                        case "3.1": {
                            qvn = 31;
                            break;
                        }
                        case "4.0": {
                            qvn = 40;
                            break;
                        }
                        default: {
                            this.makeErrorReporter().report(new XmlProcessingIncident("XQuery version ignored: only \"3.1\" and \"4.0\" are recognized", "SXWN9049").asWarning());
                            qvn = 40;
                        }
                    }
                    this.getDefaultStaticQueryContext().setLanguageVersion(qvn);
                    break;
                }
                case 95: {
                    String xv = this.requireString(name, value);
                    if (!xv.equals("1.0") && !xv.equals("1.1")) {
                        throw new IllegalArgumentException("XML_VERSION value must be \"1.0\" or \"1.1\" as a String");
                    }
                    this.setXMLVersion(xv.equals("1.0") ? 10 : 11);
                    break;
                }
                case 111: {
                    String xsdVn = this.requireString(name, value);
                    if (!xsdVn.equals("1.0") && !xsdVn.equals("1.1")) {
                        throw new IllegalArgumentException("XSD_VERSION value must be \"1.0\" or \"1.1\" as a String");
                    }
                    this.xsdVersion = xsdVn.equals("1.0") ? 10 : 11;
                    this.theConversionRules = null;
                    break;
                }
                case 112: {
                    this.getDefaultXsltCompilerInfo().setAssertionsEnabled(Configuration.requireBoolean(name, value));
                    break;
                }
                case 113: {
                    String s = this.requireString(name, value);
                    this.getDefaultXsltCompilerInfo().setDefaultInitialMode(StructuredQName.fromClarkName(s));
                    break;
                }
                case 114: {
                    String s = this.requireString(name, value);
                    this.getDefaultXsltCompilerInfo().setDefaultInitialTemplate(StructuredQName.fromClarkName(s));
                    break;
                }
                case 115: {
                    this.getDefaultXsltCompilerInfo().setSchemaAware(Configuration.requireBoolean(name, value));
                    break;
                }
                case 116: {
                    this.getDefaultXsltCompilerInfo().setErrorListener((ErrorListener)this.instantiateClassName(name, value, ErrorListener.class));
                    break;
                }
                case 117: {
                    this.getDefaultXsltCompilerInfo().setURIResolver((URIResolver)this.instantiateClassName(name, value, URIResolver.class));
                    break;
                }
                case 118: {
                    int xsltVersion;
                    switch (value.toString()) {
                        case "3.0": {
                            xsltVersion = 30;
                            break;
                        }
                        case "4.0": {
                            xsltVersion = 40;
                            break;
                        }
                        default: {
                            this.makeErrorReporter().report(new XmlProcessingIncident("XSLT version ignored: only \"3.0\" and \"4.0\" are recognized", "SXWN9020").asWarning());
                            xsltVersion = 30;
                        }
                    }
                    this.getDefaultXsltCompilerInfo().setXsltVersion(xsltVersion);
                    break;
                }
                case 128: {
                    if (!(value instanceof ResourceResolver)) {
                        throw new IllegalArgumentException("RESOURCE_RESOLVER value must be an instance of net.sf.saxon.lib.ResourceResolver");
                    }
                    this.setResourceResolver((ResourceResolver)value);
                    break;
                }
                case 129: {
                    ResourceResolver rresolver = (ResourceResolver)this.instantiateClassName(name, value, ResourceResolver.class);
                    this.setResourceResolver(rresolver);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown configuration property " + name);
                }
            }
        }
    }

    public static boolean requireBoolean(String propertyName, Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if ("true".equals(value = ((String)value).trim()) || "on".equals(value) || "yes".equals(value) || "1".equals(value)) {
                return true;
            }
            if ("false".equals(value) || "off".equals(value) || "no".equals(value) || "0".equals(value)) {
                return false;
            }
            throw new IllegalArgumentException(propertyName + " must be 'true' or 'false' (or on|off, yes|no, 1|0)");
        }
        throw new IllegalArgumentException(propertyName + " must be a boolean (or a string representing a boolean)");
    }

    protected int requireInteger(String propertyName, Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(propertyName + " must be an integer");
            }
        }
        throw new IllegalArgumentException(propertyName + " must be an integer (or a string representing an integer)");
    }

    protected void internalSetBooleanProperty(int code, String name, Object value) {
        boolean b = Configuration.requireBoolean(name, value);
        if (b) {
            this.enabledProperties.add(code);
        } else {
            this.enabledProperties.remove(code);
        }
    }

    public boolean getBooleanProperty(Feature<Boolean> feature) {
        return this.enabledProperties.contains(feature.code);
    }

    public void setBooleanProperty(String propertyName, boolean value) {
        this.setConfigurationProperty(propertyName, (Object)value);
    }

    public void setBooleanProperty(Feature<Boolean> feature, boolean value) {
        this.setConfigurationProperty(feature, value);
    }

    protected String requireString(String propertyName, Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new IllegalArgumentException("The value of " + propertyName + " must be a string");
    }

    protected Object instantiateClassName(String propertyName, Object value, Class<?> requiredClass) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException(propertyName + " must be a String");
        }
        try {
            Object obj = this.getInstance((String)value);
            if (!requiredClass.isAssignableFrom(obj.getClass())) {
                throw new IllegalArgumentException("Error in " + propertyName + ": Class " + value + " does not implement " + requiredClass.getName());
            }
            return obj;
        }
        catch (XPathException err) {
            throw new IllegalArgumentException("Cannot use " + value + " as the value of " + propertyName + ". " + err.getMessage());
        }
    }

    public Object getConfigurationProperty(String name) {
        if (name.equals("STOP_HANDLER")) {
            return this.transformationStopper;
        }
        if (FeatureIndex.exists(name)) {
            return this.getFeature(FeatureIndex.getData(name));
        }
        throw new IllegalArgumentException("Unknown configuration property " + name);
    }

    public <T> T getConfigurationProperty(Feature<T> feature) {
        FeatureData data = FeatureIndex.getData(feature.code);
        return (T)this.getFeature(data);
    }

    protected Object getFeature(FeatureData feature) {
        int code = feature.code;
        if (booleanFeatures.contains(code)) {
            return this.enabledProperties.contains(code);
        }
        if (stringFeatures.contains(code)) {
            String value = this.stringProperties.get(code);
            if (value == null) {
                return feature.defaultValue;
            }
            return value;
        }
        switch (code) {
            case 124: {
                return this.protocolRestrictor.toString();
            }
            case 6: {
                return this.getCollationURIResolver();
            }
            case 7: {
                return this.getCollationURIResolver().getClass().getName();
            }
            case 13: {
                return this;
            }
            case 17: {
                return this.defaultCollationName;
            }
            case 18: {
                return this.getDefaultCollection();
            }
            case 19: {
                return this.getDefaultCountry();
            }
            case 20: {
                return this.getDefaultLanguage();
            }
            case 24: {
                return this.isValidation();
            }
            case 25: {
                return this.defaultParseOptions.getDTDValidationMode() == 2;
            }
            case 30: {
                return null;
            }
            case 27: {
                EntityResolver er = this.defaultParseOptions.getEntityResolver();
                if (er == null) {
                    return "";
                }
                return er.getClass().getName();
            }
            case 28: {
                return this.environmentVariableResolver;
            }
            case 29: {
                return this.environmentVariableResolver.getClass().getName();
            }
            case 31: {
                return this.isExpandAttributeDefaults();
            }
            case 38: {
                return this.isLineNumbering();
            }
            case 41: {
                return null;
            }
            case 42: {
                return this.getModuleURIResolver();
            }
            case 43: {
                return this.getModuleURIResolver().getClass().getName();
            }
            case 46: {
                return this.getNamePool();
            }
            case 48: {
                return this.optimizerOptions.toString();
            }
            case 49: {
                return this.getOutputURIResolver();
            }
            case 50: {
                return this.getOutputURIResolver().getClass().getName();
            }
            case 54: {
                return 0;
            }
            case 55: {
                return "recoverWithWarnings";
            }
            case 119: {
                return this.regexBacktrackingLimit;
            }
            case 60: {
                return this.getSchemaValidationMode();
            }
            case 61: {
                return Validation.describe(this.getSchemaValidationMode());
            }
            case 62: {
                return this.getSerializerFactory().getClass().getName();
            }
            case 63: {
                return this.getSourceParserClass();
            }
            case 64: {
                return this.getSourceResolver().getClass().getName();
            }
            case 71: {
                SpaceStrippingRule rule = this.getParseOptions().getSpaceStrippingRule();
                if (rule == AllElementsSpaceStrippingRule.getInstance()) {
                    return "all";
                }
                if (rule == null || rule == IgnorableSpaceStrippingRule.getInstance()) {
                    return "ignorable";
                }
                return "none";
            }
            case 72: {
                return this.getStyleParserClass();
            }
            case 77: {
                return this.isTiming();
            }
            case 79: {
                return this.traceListener;
            }
            case 80: {
                return this.traceListenerClass;
            }
            case 81: {
                return this.traceListenerOutput;
            }
            case 83: {
                return this.getTreeModel();
            }
            case 84: {
                switch (this.getTreeModel()) {
                    default: {
                        return "tinyTree";
                    }
                    case 2: {
                        return "tinyTreeCondensed";
                    }
                    case 0: 
                }
                return "linkedTree";
            }
            case 85: {
                return this.getUnparsedTextURIResolver();
            }
            case 86: {
                return this.getUnparsedTextURIResolver().getClass().getName();
            }
            case 87: {
                if (this.getResourceResolver() instanceof ResourceResolverWrappingURIResolver) {
                    return ((ResourceResolverWrappingURIResolver)this.getResourceResolver()).getClass().getName();
                }
                return null;
            }
            case 90: {
                return this.defaultParseOptions.isUseXsiSchemaLocation();
            }
            case 91: {
                return this.defaultParseOptions.isAddCommentsAfterValidationErrors();
            }
            case 92: {
                return this.isValidationWarnings();
            }
            case 93: {
                return false;
            }
            case 94: {
                return this.isXIncludeAware();
            }
            case 95: {
                return this.getXMLVersion() == 10 ? "1.0" : "1.1";
            }
            case 98: {
                return this.getDefaultStaticQueryContext().isUpdatingEnabled();
            }
            case 99: {
                return this.getDefaultStaticQueryContext().getConstructionMode();
            }
            case 100: {
                return this.getDefaultStaticQueryContext().getDefaultElementNamespace();
            }
            case 101: {
                return this.getDefaultStaticQueryContext().getDefaultFunctionNamespace();
            }
            case 102: {
                return this.getDefaultStaticQueryContext().isEmptyLeast();
            }
            case 103: {
                return this.getDefaultStaticQueryContext().isInheritNamespaces();
            }
            case 105: {
                return this.getDefaultStaticQueryContext().isPreserveBoundarySpace();
            }
            case 106: {
                return this.getDefaultStaticQueryContext().isPreserveNamespaces();
            }
            case 107: {
                return this.getDefaultStaticQueryContext().getRequiredContextItemType();
            }
            case 108: {
                return this.getDefaultStaticQueryContext().isSchemaAware();
            }
            case 109: {
                return this.getDefaultStaticQueryContext().getErrorListener().getClass().getName();
            }
            case 110: {
                return this.getDefaultStaticQueryContext().getLanguageVersion() == 40 ? "4.0" : "3.1";
            }
            case 120: {
                return this.xpathVersionForXsd;
            }
            case 121: {
                return this.xpathVersionForXslt;
            }
            case 111: {
                return this.xsdVersion == 10 ? "1.0" : "1.1";
            }
            case 112: {
                return this.getDefaultXsltCompilerInfo().isAssertionsEnabled();
            }
            case 113: {
                return this.getDefaultXsltCompilerInfo().getDefaultInitialMode().getClarkName();
            }
            case 114: {
                return this.getDefaultXsltCompilerInfo().getDefaultInitialTemplate().getClarkName();
            }
            case 115: {
                return this.getDefaultXsltCompilerInfo().isSchemaAware();
            }
            case 116: {
                return this.getDefaultXsltCompilerInfo().getErrorListener().getClass().getName();
            }
            case 117: {
                return null;
            }
            case 118: {
                int vn = this.getDefaultXsltCompilerInfo().getXsltVersion();
                return vn == 40 ? "4.0" : "3.0";
            }
            case 128: {
                return this.getResourceResolver();
            }
            case 129: {
                return this.getResourceResolver().getClass().getName();
            }
        }
        throw new IllegalArgumentException("Unknown configuration property ");
    }

    public boolean isJITEnabled() {
        return false;
    }

    public void close() {
        if (this.traceOutput != null) {
            this.traceOutput.close();
        }
        this.cleaner = null;
    }

    public IPackageLoader makePackageLoader() {
        return new PackageLoaderHE(this);
    }

    public InvalidityReportGenerator createValidityReporter() {
        throw new UnsupportedOperationException("Schema validation requires Saxon-EE");
    }

    public SimpleMode makeMode(StructuredQName modeName, CompilerInfo compilerInfo) {
        return new SimpleMode(modeName);
    }

    public TemplateRule makeTemplateRule() {
        return new TemplateRule();
    }

    public XPathContextMajor.ThreadManager makeThreadManager() {
        return null;
    }

    public CompilerInfo makeCompilerInfo() {
        return new CompilerInfo(this);
    }

    public ICompilerService makeCompilerService(HostLanguage hostLanguage) {
        return null;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    private CleanerProxy getCleaner() {
        if (this.cleaner == null) {
            this.cleaner = CleanerProxy.makeCleanerProxy(this);
        }
        return this.cleaner;
    }

    public CleanerProxy.CleanableProxy registerCleanupAction(Object obj, Runnable action) {
        return this.getCleaner().registerCleanupAction(obj, action);
    }

    static {
        booleanFeatures.add(1);
        booleanFeatures.add(2);
        booleanFeatures.add(4);
        booleanFeatures.add(5);
        booleanFeatures.add(12);
        booleanFeatures.add(15);
        booleanFeatures.add(22);
        booleanFeatures.add(23);
        booleanFeatures.add(24);
        booleanFeatures.add(26);
        booleanFeatures.add(31);
        booleanFeatures.add(32);
        booleanFeatures.add(33);
        booleanFeatures.add(34);
        booleanFeatures.add(35);
        booleanFeatures.add(39);
        booleanFeatures.add(44);
        booleanFeatures.add(45);
        booleanFeatures.add(51);
        booleanFeatures.add(53);
        booleanFeatures.add(57);
        booleanFeatures.add(65);
        booleanFeatures.add(66);
        booleanFeatures.add(70);
        booleanFeatures.add(69);
        booleanFeatures.add(73);
        booleanFeatures.add(74);
        booleanFeatures.add(75);
        booleanFeatures.add(78);
        booleanFeatures.add(82);
        booleanFeatures.add(88);
        booleanFeatures.add(89);
        booleanFeatures.add(104);
        booleanFeatures.add(125);
        booleanFeatures.add(126);
        stringFeatures.add(127);
    }

    public static interface ApiProvider {
    }

    public static class LicenseFeature {
        public static final int SCHEMA_VALIDATION = 1;
        public static final int ENTERPRISE_XSLT = 2;
        public static final int ENTERPRISE_XQUERY = 4;
        public static final int PROFESSIONAL_EDITION = 8;
    }
}

